<?php

/************************************************************************/
/* Bookmark4U: Web-based personal bookmarking environment               */
/* ======================================================               */
/* Please read LICENSE.txt                                              */
/************************************************************************/

include("inc/common.php");

if ($env[register_global_off]) {  # register get/post variables as global
  if ($HTTP_SERVER_VARS[REQUEST_METHOD] == 'GET') {
    $which_list = array('exp', 'dispurl', 'urlcheck',
       'history_layer_show', 'hlpx', 'hlpy', 'sort', 'close_control');
    ExtractVars($HTTP_GET_VARS, $which_list);
  } elseif ($HTTP_SERVER_VARS[REQUEST_METHOD] == 'POST') {
  }
}

function Head1() {
  global $env, $lang;

  $attrf = " class='pageheadline'";

  echo("<script language`\"javascript\" type=\"text/javascript\">
iconTreeCollapseSrc = '$env[icon_tree_collapse]';
iconTreeExpandSrc = '$env[icon_tree_expand]';
titleCollapse = '$lang[collapse]';
titleExpand = '$lang[expand]';
</script>\n");

  echo("<table border='0' width='100%' cellpadding='0' cellspacing='0'>
<tr><td$attrf>
<table border='0' width='100%' cellpadding='4' cellspacing='0'>
<tr><td>\n");
}

function Tail1() {
  global $env;
  echo("</td></tr></table>");
  echo("</td></tr></table>");
  echo("<img src='$env[icon_trdot]' height='7' width='1' border='0'><br>\n");
}

function Buttons1($row) {
  global $env, $lang;
  global $urlcheck, $sort, $dispurl;

  if ($env[guest]) {
    $ronly_str = ($env[show_icon_name]) ? "$lang[list_6]" : "";
    echo("<a href=guestlogout.php><img src=$env[icon_stop] align=top alt='$ronly_str' width=$env[icon_size_x] height=$env[icon_size_y] border=0>$ronly_str</a> ");
  }

  # on/off buttons
  $imgattr = "  width='$env[icon_size_x]' height='$env[icon_size_y]' align='top' border='0'";
  $urlorig = "list.php?root=$row[id]&exp=$env[exp]&sort=$sort%s%s";
  $arg1 = "&dispurl=$dispurl";
  $arg2 = "&urlcheck=$urlcheck";

  if ($env[enable_swap_dispurl]) { # On/Off bookmark URL
    $str = ($env[show_icon_name]) ? $lang[url] : "";
    if ($dispurl) $str = "<b>$str</b>";
    $arg1c = ($dispurl) ? "&dispurl=0" : "&dispurl=1";
    $url = sprintf($urlorig, $arg1c, $arg2);
    $temp = "<a href='$url'><img src='$env[icon_p_dispurl]'$imgattr>$str</a>";
    $env[dispurl] = ($dispurl) ? 1 : 0;
    echo("$temp ");
  }

  if ($env[enable_urlcheck]) {
    $str = ($env[show_icon_name]) ? $lang[list_4] : "";
    if ($urlcheck) $str = "<b>$str</b>";
    $arg2c = ($urlcheck) ? "&urlcheck=0" : "&urlcheck=1";
    $url = sprintf($urlorig, $arg1, $arg2c);
    $temp = "<a href='$url'><img src='$env[icon_urlcheck]'$imgattr>$str</a>";
    echo("$temp ");
  }

  $str = ($env[show_icon_name]) ? $lang[back] : "";
  echo("<a href=\"javascript:history.go(-1);\"><img
  src='$env[icon_back]' width='$env[icon_size_x]' height='$env[icon_size_y]'
  border='0' align='top'>$str</a>\n");

  $up_str = ($env[show_icon_name]) ? $lang[up] : "";
  if ($env[root] > 0) {
    echo("<a href=list.php?root=$row[parent]&exp=$env[exp]&sort=$sort><img src=$env[icon_up] width=$env[icon_size_x] height=$env[icon_size_y] align=top alt='[UP]' border=0>$up_str</a>\n");
  }
}

function TreeStructure(&$lti, &$indent, &$cnt, &$total) {
  global $env;

  $attr = " class=\"icon\"";

  if ($env[tree_view] != 'flat') {   # display in tree form
    for ($i = 1; $i < $indent; $i++) {
      if ($lti[$i] == 'i') {         # |
        echo("<img src=$env[icon_tree_vertline]$attr>");
      } else if ($lti[$i] == 'l') {  # L
        echo("<img src=$env[icon_tree_end]$attr>");
      } else if ($lti[$i] == 't') {  # |-
        echo("<img src=$env[icon_tree_split]$attr>");
      } else if ($lti[$i] == 's') {  #
        echo("<img src=$env[icon_trdot]$attr>");
      }
    }
    if ($cnt == $total) echo("<img src='$env[icon_tree_space]'$attr>");
    else echo("<img src='$env[icon_tree_vertline]'$attr>");
    echo("<img src='$env[icon_tree_space]'$attr>");
  } else {
    echo("<img src='$env[icon_tree_space]'$attr>");
  }
}

# display the path of current folder
# $indent is zero at the first call, increases by one in every recursive call.
function PrintPath1 ($id, $indent = 0) {
  global $env, $lang, $mgr;
  global $urlcheck, $sort, $dispurl;
  global $tgt_modify;

  $exp_parm = (($env[tree_view] != 'flat') && $env[exp]) ? "&exp=$env[exp]" : "";
  $top_folder_name = sprintf($env[top_folder_name], $env[user]);

  if ($id == 0) { # if this is root folder
    # if current folder is root folder, don't make a link
    if ($indent == 0) { # if this is first call

      Head1();
      echo("<img src='$env[icon_fo]' width='$env[icon_size_x]'"
          ." height='$env[icon_size_y]' align='top'>");
      echo(" <b>$top_folder_name</b>");
      echo("</td><td align='right'>");
      $row = array(id=>0);
      Buttons1($row);
      echo("</td>");
      Tail1();
    } else { # if this is not the first call and reaches the root
      echo("<a href='list.php?root=0&sort=$sort$exp_parm'><b>$top_folder_name</b></a>");
    }
    return;
  }

  $row = $mgr->findItemById($id);

  PrintPath1($row[parent], $indent+1); # print the path of parent folder first

  # and then print the path of itself
  if ($indent == 0) { # finally returned to the first call
    echo(" / ");

    Head1();
    $icon = ($row[public]) ? $env[icon_fo] : $env[icon_hfo];
    $img_str = GetIconString($row, $icon);
    if ($env[guest]) {
      echo("<a name=$row[id]><a href='guestimport.php?id=$row[id]$exp_parm' title=\"$lang[import]\"$tgt_modify>$img_str</a>");
    } else {
      echo("<a name=$row[id]><a href='modifyform.php?id=$row[id]$exp_parm' title=\"$lang[modifyform_0]\"$tgt_modify>$img_str</a>");
    }

    # mark the cliped icon
    if (in_array($row[id], $env[clipitems])) {
      echo("<a href='clipboard.php'><img src='$env[icon_clipboard]'"
          ." width='$env[icon_size_x]' height='$env[icon_size_y]' border='0'"
          ." align='top'></a>");
    }

    echo(" <b>$row[title]</b>");
    if ($row[comment]) echo(" : $row[comment]");
    echo("</td><td align='right'>");
    Buttons1($row);
    Tail1();
  } else { # intermediate folders
    echo(" / ");
    echo("<a href='list.php?root=$id&sort=$sort$exp_parm'><b>$row[title]</b></a>");
  }
}

# display bookmarks in a parent folder
# recursive function
function ListBookmark($parent, $indent) {
  global $env, $lang, $mgr;
  global $cnt_c, $cnt_b, $nrows;
  global $sort, $urlcheck;
  global $expand;
  global $lti, $sql_order;
  global $now;
  global $edit_mode; # session variable
  global $show_all;

  $exp_parm = (($env[tree_view] != 'flat') && $env[exp]) ? "&exp=$env[exp]" : "";

  # target string such as " target=something"
  $tgt_linkto = $env[main_target];
  $tgt_modify = $env[aid_target];

  $total = sizeof($parent[children]);

  $cnt = 0;
  $lti[$indent] = 't';
  while ( list($key, $row) = each($parent[children]) ) {
    # hide bookmark in folder-only mode
    if ($env[only_folder] && $row[type] == 'b') continue;

    # hide symbolic link in guest mode
    if ($env[guest] && $row[type] == 'l') { $cnt++; continue; }

    $cnt++;

    list($new_img, $v_new_img) = GetNewString($row);

    $title = $row[title];
    $title = ereg_replace("<", "&lt;", $title); # strip tags
    $url = $row[url];

    # comment
    $comment_str = ($row[comment]) ? ": $row[comment]" : "";

    if ($env[line_gap]) { # insert a small gap between rows
     $line_height = $env[line_gap] * 2;
      echo("<tr><td>");
      if ($env[tree_view] != 'flat') {   # display in tree form
        $img_name = "icon_tree_gap$env[line_gap]";
        $img = $env[$img_name];
        for ($i = 1; $i <= $indent; $i++) {
          if ($lti[$i] == 'i' || $lti[$i] == 't') {
            echo("<img border=0 src='$img' width=$env[icon_size_x]>");
          } else {
            echo("<img src=$env[icon_trdot] width=16 height=1 align=top>");
          }
        }
      } else {
        echo("<img src=$env[icon_trdot] width=1 height=$line_height>");
      }
      echo("</td></tr>\n");
    }

    echo("<tr><td>");

    # display tree structure
    $attr = " class='icon'";
    if ($env[tree_view] != 'flat') {   # display in tree form
      if ($cnt == $total) { $lti[$indent] = 'l'; }
      for ($i = 1; $i <= $indent; $i++) {
        if ($lti[$i] == 'i') {
          echo("<img src=$env[icon_tree_vertline]$attr>");
        } else if ($lti[$i] == 'l') {
          echo("<img src=$env[icon_tree_end]$attr>");
        } else if ($lti[$i] == 't') {
          echo("<img src=$env[icon_tree_split]$attr>");
        } else if ($lti[$i] == 's') {
          echo("<img src=$env[icon_trdot]$attr>");
        }
      }
    }

    # visit information
    $lastvisit = substr($row[lastvisit], 0, 10); # get only the date
    $visit = " <font color=$env[blur]>($row[visit], $lastvisit)</font>";

    if ($edit_mode) {
      $edit_mode_str = " <a href='clipboard.php?mode=switch&id=$row[id]$exp_parm'><img src='$env[icon_pick]' border='0' align='top'></a>";
    } else $edit_mode_str = "";


    ###### folder ######
    if ($row[type] == 'c') {
      $cnt_c++; $nrows++;

      $subtotal = $row[total];
      $subtotal_str = (!$env[guest]) ? " ($subtotal)" : "";

      # tree structure 
      if ($env[tree_view] != 'flat') {
        $exptmp = $expand;
        $expparam = "";
        while (list($key, $val) = each($exptmp)) {
          if (($exptmp[$key] && $key != $row[id]) ||
              (!$exptmp[$key] && $key == $row[id]) )
            if (!$expparam) $expparam .= "$key";
            else $expparam .= "|$key";
        }
        if (!$expand[$row[id]]) {
          if (!$expparam) $expparam .= "$row[id]";
          else $expparam .= "|$row[id]";
        }
        # tree structure
        if ($env[tree_view] == 'dynamic') {
          if ($expand[$row[id]] || $env[exp] == '*') {
            $iconTreeSrc = "src=\"$env[icon_tree_collapse]\" title=\"$lang[collapse]\"";
            if ($row[public]) {
              $icon = $env[icon_ofo];
              $imgArgs = $env[icon_ofo] . "', '" . $env[icon_fo];
            } else {
              $icon = $env[icon_hofo];
              $imgArgs = $env[icon_hofo] . "', '" . $env[icon_hfo];
            }
          } else {
            $iconTreeSrc = "src=\"$env[icon_tree_expand]\" title=\"$lang[expand]\"";
            if ($row[public]) {
              $icon = $env[icon_fo];
              $imgArgs = $env[icon_ofo] . "', '" . $env[icon_fo];
            } else {
              $icon = $env[icon_hfo];
              $imgArgs = $env[icon_hofo] . "', '" . $env[icon_hfo];
            }
          }

          if (isset($row[children]) && sizeof($row[children]) > 0) {
            $plusIcon = "<a href=\"javascript:ToggleChildDiv($row[id], '$imgArgs')\">";
            $plusIcon .= "<img id=\"iconTree_$row[id]\"$iconTreeSrc$attr/></a>";
          } else {
            $plusIcon = "<img src=\"$env[icon_tree_empty]\"$attr/>";
          }
        } else {
          if ($expand[$row[id]] || $env[exp] == '*') { # if expanded folder
            if (isset($row[children]) && sizeof($row[children]) > 0)
              $plusIcon = "<a title=\"$lang[collapse]\" href='list.php?root=$env[root]&sort=$sort&exp=$expparam#$row[id]'><img src='$env[icon_tree_collapse]'$attr/></a>";
            else
              $plusIcon = "<img src=\"$env[icon_tree_empty]\"$attr/>";
            $icon = ($row[public]) ? $env[icon_ofo] : $env[icon_hofo];
          } else {
            $plusIcon = "<a title=\"$lang[expand]\" href='list.php?root=$env[root]&sort=$sort&exp=$expparam#$row[id]'><img src='$env[icon_tree_expand]'$attr/></a>";
            $icon = ($row[public]) ? $env[icon_fo] : $env[icon_hfo];
          }
        }
      } else {
        $icon = ($row[public]) ? $env[icon_fo] : $env[icon_hfo];
      }

      echo($plusIcon);

      $img_str = GetIconString($row, $icon);

      if ($env[guest])
        echo("<a name=$row[id]><a href='guestimport.php?id=$row[id]$exp_parm' title=\"$lang[import]\"$tgt_modify>$img_str</a>");
      else
        echo("<a name=$row[id]><a href='modifyform.php?id=$row[id]$exp_parm' title=\"$lang[modifyform_0]\"$tgt_modify>$img_str</a>");

      # items in the clipboard
      if (in_array($row[id], $env[clipitems])) {
        echo("<a href=clipboard.php title=\"$lang[clipboard]\"><img src=$env[icon_clipboard]$attr></a>");
      }

      # title
      echo(" <a href=list.php?root=$row[id]&sort=$sort&$exp_parm title=\"$row[url]\">$title</a>");

      if ($sort == 'rate') {
        $sort_str = "";
        for ($i = $row[rate]; $i > 0; $i--) {
          $sort_str .= "<img src='$env[icon_rate]' align='top'>";
        }
      } else $sort_str = "";

      if ($row[url] != "") {
        $folder_url_str = " <a href=\"$row[url]\"$tgt_linkto><img src=$env[icon_url] border=0 alt='$row[url]' width=$env[icon_size_x] height=$env[icon_size_y] align=top></a>";
      } else $folder_url_str = "";

      echo("$folder_url_str");
      echo("$subtotal_str");
      echo("$new_img");
      echo($v_new_img);
      echo("$sort_str");
      echo("$edit_mode_str");
      echo("$comment_str");

      if ($env[tree_view] != 'flat') {   # display in tree form
        if ($expand[$row[id]] || $show_all) { # if expanded folder
          if ($cnt == $total) $lti[$indent] = 's';
          else $lti[$indent] = 'i';
          if ($env[tree_view] == 'dynamic') {
            echo("<div id=\"child_div_$row[id]\" style=\"display: ");
            if ( $expand[$row[id]] || $env[exp] == '*') echo "";
            else echo("none");
            echo(";\"><table class=\"noborder\">");
          }
          ListBookmark($row, $indent+1);  # recursive call
          if ($env[tree_view] == 'dynamic') echo("</table></div>");
          $lti[$indent] = 't';
        }
      }

    ###### bookmark ######
    } else if ($row[type] == 'b') {
      $cnt_b++; $nrows++;

      $icon = "";
      $img_str = GetIconString($row, $icon);

      if ($env[guest])
        echo("<a name='$row[id]'><a href='guestimport.php?id=$row[id]$exp_parm' title=\"$lang[import]\"$tgt_modify>$img_str</a>");
      else
        echo("<a name='$row[id]'><a href='modifyform.php?id=$row[id]$exp_parm' title=\"$lang[modifyform_0]\"$tgt_modify>$img_str</a>");


      # items in the clipboard
      if (in_array($row[id], $env[clipitems])) {
        echo("<a href='clipboard.php'><img src=$env[icon_clipboard]$attr></a>");
      }

      # title
      $title_str = GetTitleString($row, "$tgt_linkto");
      echo(" $title_str");

      # sorting
      if ($sort == 'rdate') {
        $rdate = DateStringToArray($row[rdate]);
        $diffdays = DiffDateArray($now, $rdate);
        $sort_str = "($diffdays $lang[days])";
        $sort_str = " <font color='$env[blur]'>$sort_str</font>";
      } elseif ($sort == 'visit') {
        $sort_str = "($row[visit] $lang[visits])";
        $sort_str = " <font color='$env[blur]'>$sort_str</font>";
      } elseif ($sort == 'lastvisit') {
        if ($row[lastvisit] != '0000-00-00 00:00:00') {
          $lastvisit = DateStringToArray($row[lastvisit]);
          $diffdays = DiffDateArray($now, $lastvisit);
          $sort_str = " <font color=$env[blur]>($diffdays $lang[days])</font>";
        } else $sort_str = " <font color=$env[blur]>($lang[list_7])</font>";
      } elseif ($sort == 'rate') {
        $sort_str = "";
        for ($i = $row[rate]; $i > 0; $i--) {
          $sort_str .= "<img src='$env[icon_rate]' align='top'>";
        }
        $sort_str = " <font color='$env[blur]'>$sort_str</font>";
      } else $sort_str = "";

      # URL check results
      if ($urlcheck) {
        if ($env[enable_urlcheck]) {
          $ret = LinkAlive($row[url], $msg);
          if ($ret == 'alive') $alive = " ... Alive $msg";
          elseif ($ret == 'dead') $alive = " ... Dead $msg";
          elseif ($ret == 'unknown') $alive = " ... $msg";
          $alive = "<font color=$env[blur]>$alive</font>";
        } else $alive = "";
      }

      echo("$new_img");
      echo("$v_new_img");
      echo("$edit_mode_str");
      echo("$sort_str");

      if ($env[long_description] > 0
         && strlen($row[comment]) > $env[long_description]) $desc_next_line = 1;
      else $desc_next_line = 0;

      if ($row[comment]) {
        if ($desc_next_line) {
          if ($env[show_visit_info]) echo("$visit");
          if ($urlcheck) echo("$alive");
          echo("<br>");
          TreeStructure($lti, $indent, $cnt, $total);
          echo(" $row[comment]");
        } else {
          echo(" : $row[comment]");
          if ($env[show_visit_info]) echo("$visit");
          if ($urlcheck) echo("$alive");
        }
      } else {
        if ($env[show_visit_info]) echo("$visit");
        if ($urlcheck) echo("$alive");
      }

      # display URL
      if ($env[dispurl]) {
        echo("<br>\n");
        TreeStructure($lti, $indent, $cnt, $total);
        if ($env[cut_url]) {
          $url = $row[url];
          CutString($url, $env[cut_url]);
        }
        if ($env[usecount] && !$env[url_direct_link]) {
          echo(" <a href='linkto.php?id=$row[id]'$tgt_linkto><font color=$env[blur]>$url</font></a>");
        } else {
          echo(" <a href=\"$row[url]\"$tgt_linkto><font color=$env[blur]>$url</font></a>");
        }
      }

    ##### symbolic link #####
    } else if ($row[type] == 'l') {
      $icon = ($row[public]) ? $env[icon_ln] : $env[icon_ln];
      $img_str = GetIconString($row, $icon);

      list($new_img, $v_new_img) = GetNewString($row);

      # items in the clipboard
      if (in_array($row[id], $env[clipitems])) {
        $clipboard_str = "<a href='clipboard.php'><img src=$env[icon_clipboard]$attr></a>";
      } else $clipboard_str = "";

      # sort
      if ($sort == 'rate') {
        $sort_str = "";
        for ($i = $row[rate]; $i > 0; $i--) {
          $sort_str .= "<img src='$env[icon_rate]' align='top'>";
        }
      } else $sort_str = "";

      $row2 = $mgr->findItemById($row[lnid]);
      if ($row2) {

        if ($row2[type] == 'b') {
          $icon = ($row2[public]) ? $env[icon_bk] : $env[icon_hbk];
        } elseif ($row2[type] == 'c') {
          $icon = ($row2[public]) ? $env[icon_fo] : $env[icon_hfo];
        }

        # title
        $title = $row[title];
        if ($row2[type] == 'b') {
          if ($env[usecount]) {
            $title_str = " <a href='linkto.php?id=$row2[id]'$tgt_linkto>$title</a>";
          } else {
            $title_str = " <a href=\"$row2[url]\"$tgt_linkto>$title</a>";
          }
        } elseif ($row2[type] == 'c') {
          $title_str = " <a href='list.php?root=$row2[id]&sort=$sort&$exp_parm'>$title</a>";
        }

        echo("<a href='modifyform.php?id=$row[id]&foid=$env[root]'>$img_str</a>");
        echo("$clipboard_str");
        echo(" $title_str");
        echo("$edit_mode_str");
        echo("$sort_str");
        echo($comment_str);
        echo($new_img);
        echo($v_new_img);
        echo(" <img src='$env[icon_next]' align='top'> ");

        # icon
        $img_str = "<img src='$icon'$attr>";
        if (!$env[guest]) {
          $img_str = "<a name=$row2[id]><a href='modifyform.php?id=$row2[id]&foid=$env[root]'$exp_parm$tgt_modify>$img_str</a>";
        }
        echo("$img_str ");
        PrintPath($row2, 0);
      } else {
        # title
        $title = $row[title];
        $title_str = " $title";

        echo("<a href='modifyform.php?id=$row[id]&foid=$env[root]'>$img_str</a>");
        echo("$clipboard_str");
        echo(" $title_str");
        echo("$edit_mode_str");
        echo("$sort_str");
        echo(" <img src='$env[icon_next]' align='top'> ");
        echo("link is broken");
      }
    }
    echo("</td></tr>\n");

    # split a long table
    if ($nrows % 30 == 0 || $urlcheck) {
      echo("</table>\n");
    # echo("<table border=0 width=100% cellpadding=0 cellspacing=0>\n");
      echo("<table class=\"noborder\">\n");
    }
  }
  return $cnt;
}

# get id's of all sub-folders of $top
# the 'id' entry of array 'sum_arr' is set to 1
# sum_arr is used for passing by reference
function GetSubFolders($top, &$sum_arr) {
  global $env, $mgr;

  $result = $mgr->findFolders($top);
  while ($row = $result->fetchRow() ) {
    $sum_arr[$row[id]] = 1;
    GetSubFolders($row[id], $sum_arr);
  }
}

# edit mode on/off
session_register('edit_mode');
if ($editmode != "") {
  if ($editmode == 1) $edit_mode = 1;
  else if ($editmode == 0) $edit_mode = 0;
}
if ($env[guest]) $edit_mode = 0;
if ($env[tree_view] == 'dynamic') $show_all = true;


# get information from cookies - $env[root], $root
$root = $HTTP_GET_VARS[root];
if ($root != '') {  # if root changes
  # update the visit information of folder
  $mgr->incItemVisitNumber($root);
  PutCookie("ROOT", "$root"); # set ROOT cookie
  $env[root] = $root;
} else {
  $root = GetCookie("ROOT");
  if ($root == '') $root = '0';
}
CheckAuth('read');

$env[page_focus] = ($env[search_focus] || $close_control) ? 1 : 0;

# current time
$now = CurrentTime();

if ($history_layer_show != "") {
  PutCookie("H_LAYER_SHOW", $history_layer_show);
  if ($history_layer_show == 1) {
    PutCookie("H_LAYER_PX", $hlpx);
    PutCookie("H_LAYER_PY", $hlpy);
  }
  $env[history_layer_show] = $history_layer_show;
  if ($hlpx != "") $env[history_layer_px] = $hlpx;
  if ($hlpy != "") $env[history_layer_py] = $hlpy;
} else {
  $history_layer_show = GetCookie("H_LAYER_SHOW");
  if ($history_layer_show != "") {
    $env[history_layer_show] = $history_layer_show;
    $env[history_layer_px] = GetCookie("H_LAYER_PX");
    $env[history_layer_py] = GetCookie("H_LAYER_PY");
  }
}

# remember sorting order
$lsort = GetCookie("LIST_SORT"); # read a cookie value
if (!$sort) {
  if ($lsort) $sort = $lsort; # use the cookie value
  else $sort = $env[default_list_sort];  # default value
} elseif ($sort != $lsort) PutCookie("LIST_SORT", $sort); # save in cookie

if ($env[root]) {
  $row = $mgr->findItemById($env[root]);
  if (!isset($row) || $row[type]!='c' || ($env[guest] && $row[public]!='1') ) {
    ErrorRedir("$env[root] is not a folder or you can't access it. Goes to the root", "list.php?root=0");
  } else {
    PageHead($row[title]);
  }
} else {
  PageHead();
}

# display in tree form
if ($env[tree_view] != 'flat') {
  # parse the wild card character '*'
  if ($env[exp] == '*') {
    $show_all = true;
  # $env[exp_parsed] = '';
  # $sum_arr = array();
  # GetSubFolders($env[root], $sum_arr);
  # while (list($key, $val) = each($sum_arr)) {
  #   $env[exp_parsed] .= "|$key";
  # }
  } else $env[exp_parsed] = $env[exp];
}

# get folder id's to expand
if ($env[exp] != "") $explevels = explode("|", $env[exp_parsed]);
for ($i = 0; $i < sizeof($explevels); $i++) {
  $expand[$explevels[$i]] = 1;
}
if (!isset($expand)) $expand = array();

PrintPath1($env[root], 0);  # print the current folder path
ButtonSet();

if (!$env[hide_searchform]) {
  echo("<table class=\"noborder\">
<form action='search.php' name='searchform1'>
<tr><td align='right' valign='center' width='10%'>\n");
  SearchOptions('searchform1', 1);
  echo("</td></tr></form></table>\n");
}

# sorting order (order by clause in the sql query)
if ($sort=='type')      $sql_order = "type DESC, title ASC";
elseif ($sort=='title') $sql_order = "title ASC";
elseif ($sort=='url')   $sql_order = "type DESC, url ASC, title ASC";
elseif ($sort=='rdate') $sql_order = "type DESC, rdate DESC, title ASC";
elseif ($sort=='visit') $sql_order = "type DESC, visit DESC";
elseif ($sort=='lastvisit') $sql_order = "type DESC, lastvisit DESC";
elseif ($sort=='rate')  $sql_order = "rate DESC, type DESC, title";

# bookmark list heading
if ($env[list_heading]) {

  $head1 = "$lang[type]";
  $head2 = "$lang[title]";
  $head3 = "$lang[url]";
  $head4 = "$lang[date]";
  $head5 = "$lang[visit]";
  $head6 = "$lang[lastvisit]";
  $head7 = "$lang[rate]";
  $head1 = ($sort=='type')  ? "<b>$head1</b>" : "$head1";
  $head2 = ($sort=='title') ? "<b>$head2</b>" : "$head2";
  $head3 = ($sort=='url')   ? "<b>$head3</b>" : "$head3";
  $head4 = ($sort=='rdate') ? "<b>$head4</b>" : "$head4";
  $head5 = ($sort=='visit') ? "<b>$head5</b>" : "$head5";
  $head6 = ($sort=='lastvisit') ? "<b>$head6</b>" : "$head6";
  $head7 = ($sort=='rate')  ? "<b>$head7</b>" : "$head7";

  $parm = "&root=$env[root]&exp=$exp&dispurl=$dispurl&urlcheck=$urlcheck";
  $head1 = "<a href='list.php?sort=type$parm' title=\"$lang[list_8] $head1\">$head1</a>";
  $head2 = "<a href='list.php?sort=title$parm' title=\"$lang[list_8] $head2\">$head2</a>";
  $head3 = "<a href='list.php?sort=url$parm' title=\"$lang[list_8] $head3\">$head3</a>";
  $head4 = "<a href='list.php?sort=rdate$parm' title=\"$lang[list_8] $head4\">$head4</a>";
  $head5 = "<a href='list.php?sort=visit$parm' title=\"$lang[list_8] $head5\">$head5</a>";
  $head6 = "<a href='list.php?sort=lastvisit$parm' title=\"$lang[list_8] $head6\">$head6</a>";
  $head7 = "<a href='list.php?sort=rate$parm' title=\"$lang[list_8] $head7\">$head7</a>";

  $attr_a = " class='headline'";
  $attr_b = " class='tabselect'";

  $attr1 = ($sort=='type')      ? $attr_b : $attr_a;
  $attr2 = ($sort=='title')     ? $attr_b : $attr_a;
  $attr3 = ($sort=='url')       ? $attr_b : $attr_a;
  $attr4 = ($sort=='rdate')     ? $attr_b : $attr_a;
  $attr5 = ($sort=='visit')     ? $attr_b : $attr_a;
  $attr6 = ($sort=='lastvisit') ? $attr_b : $attr_a;
  $attr7 = ($sort=='rate')      ? $attr_b : $attr_a;

  echo("<table border='0' width='100%' cellpadding='3' cellspacing='1'>\n");
  echo("<tr bgcolor='$env[th]' align='center'>
  <td$attr1 width='16%'>$head1</td>
  <td$attr2 width='14%'>$head2</td>
  <td$attr3 width='14%'>$head3</td>
  <td$attr4 width='14%'>$head4</td>
  <td$attr5 width='14%'>$head5</td>
  <td$attr6 width='14%'>$head6</td>
  <td$attr7 width='14%'>$head7</td>
  </tr>\n");
  echo("</table>\n");
}

# get the total number folders and bookmarks
$total_c = $mgr->getFoldersNumber();
$total_b = $mgr->getBookmarksNumber();

# main part
echo("<table class=\"noborder\">\n");
$cnt_c = $cnt_b = 0;

if ($env[guest]) $only_public = true;
else $only_public = false;

if ( $show_all ) {
  $result = $mgr->findAllItems($type=null, $sql_order, $only_public);
  $rootTree = CreateTree($result, $root);
  $total = ListBookmark($rootTree, 1);
} else {
  $selection = $expand;
  #PrintArray($selection);
  $selection[$root] = 1;
  $result = $mgr->findItemsBySelection($selection, $sql_order, $only_public);
  $rootTree = CreateTree($result, $root);
  $total = ListBookmark($rootTree, 1);
}
echo("</table>\n");

# endings
echo("<table border='0' width='100%' bgcolor='$env[th]' cellpadding='4'
 cellspacing='0'>
<form action='search.php' name='searchform2'>
<tr><td align='left' valign='center' width='90%'>\n");
if (!$env[guest]) {
  echo("$lang[list_1]/$lang[list_3] ");
  echo("<nobr><img src='$env[icon_fo]' width='$env[icon_size_x]'
  height='$env[icon_size_y]' align='top' alt='[$lang[folder]]'>
  $cnt_c/${total_c}</nobr>
  <nobr><img src='$env[icon_bk]' width='$env[icon_size_x]'
  height='$env[icon_size_y]'
  align='top' alt='[$lang[bookmark]]'> $cnt_b/${total_b}</nobr>\n");
} else { # if guest, do not print the total number of bookmarks
  echo("$lang[list_1] ");
  echo("<img src='$env[icon_fo]' width='$env[icon_size_x]'
  height='$env[icon_size_y]' align='top' alt='[$lang[folder]]'> $cnt_c
  <img src='$env[icon_bk]' width='$env[icon_size_x]' height='$env[icon_size_y]'
  align='top' alt='[$lang[bookmark]]'> $cnt_b\n");
}
echo("</td><td align='right' nowrap>");
if ($close_control) {
  echo("<input type='text' name='second' size='3' value='$env[time_to_close]'>
  <a href=\"javascript:window.close();\">$lang[close]</a>");
} else {
  if ($edit_mode) { # edit mode is on
    echo("<a href='list.php?editmode=0'>[[$lang[edit] $lang[off]]]</a>");
  } else { # edit mode is off
    echo("<img src='$env[icon_pick]'> ");
    echo("<a href='list.php?editmode=1'>[[$lang[edit] $lang[on]]]</a>");
  }
}
echo("</td></tr></form></table>\n");

# auto focus to a search form
if ($env[search_focus] || $close_control) {
  echo("<script>
function CloseControl() {
  setTimeout('CloseControl()', 1000);
  if (document.searchform2.second.value > 1) {
    document.searchform2.second.value--;
  } else {
    window.close();
  }
}
function PageFocus() {\n");
  if (!$env[hide_searchform]) {
    echo("  document.searchform1.k.focus();\n"
        ."  document.searchform1.k.select();\n");
  }
  if ($close_control) {
    echo("  document.searchform2.second.value=$env[time_to_close];\n"
        ."  setTimeout('CloseControl()', 1000);\n");
  }
  echo("}\n</script>\n");
}

PageTail();
exit;

?>
