<?php

/************************************************************************/
/* Bookmark4U: Web-based personal bookmarking environment               */
/* ======================================================               */
/* Please read LICENSE.txt                                              */
/************************************************************************/

include("inc/common.php");

if ($env[register_global_off]) {  # register get/post variables as global
  if ($HTTP_SERVER_VARS[REQUEST_METHOD] == 'GET') {
    $which_list = array('id', 'mode');
    ExtractVars($HTTP_GET_VARS, $which_list);
  } elseif ($HTTP_SERVER_VARS[REQUEST_METHOD] == 'POST') {
  }
}

session_register('hide_conneting_page');

CheckAuth('read');

if (!$id) Error("Missing id!");

# get the visit counter and url
$row = $mgr->findItemById($id);
$visit = $row[visit];
$href = $row[url];

if ($mode == 'hide') {
  $hide_conneting_page = 1;
  header("Location: $href");
  exit;
}

$visit++; # increase visit couter

# save visit counter, visit time, and IP
$mgr->incItemVisitNumber($id, $HTTP_SERVER_VARS[REMOTE_ADDR]);

if ($env[print_linkto_page] && !$hide_conneting_page) {
  if ($env[use_refresh_header]) {
    header("Refresh: $env[refresh_time]; URL=$href");
  }
  $env[page_focus] = 1;
  PageHead($lang[linkto_0] . " - $row[title]");
  ButtonSet();

  $form = "<input type='text' name='second' size=3 value='$env[refresh_time]'>";
  $str = sprintf("$lang[linkto_1]", $form);

  echo("<table border='0' width='500' align='center'>
  <form name='form'>
  <tr><td align='center'>
  $str<br>\n");

  echo("$lang[location] : ");
  PrintPath($row);
  echo("<br><br>\n");

  echo("<a href='modifyform.php?id=$row[id]'><img
  src='$env[icon_bk]' align='top' border='0'></a> $row[title]<br><br>

<a href=\"$href\">
$lang[title]: $row[title]<br>
$lang[url]: <b>$href</b><br>
$lang[description]: $row[comment]<br>
$lang[visited_4] : $row[lastvisit]<br>
$lang[visited_3] : $row[visit]<br>
</a>
<br><br>
<a href='javascript:window.close()'>[[$lang[close]]]</a>
<a href='linkto.php?mode=hide&id=$id'>[[$lang[linkto_2]]]</a>
</td></tr>
</form></table>
<script>
var firstcall = 1;
function PageFocus() {
  if (firstcall) { document.form.second.value=$env[refresh_time]; }
  if (document.form.second.value > 0) {
    setTimeout('PageFocus()', 1000);
    if (firstcall) { firstcall = 0; }
    else { document.form.second.value--; }
  } else {
    document.location = \"$href\";
  }
}
</script>\n");
  PageTail();
  exit;

} else {
  header("Location: $href");
}

?>
