<?php

/************************************************************************/
/* Bookmark4U: Web-based personal bookmarking environment               */
/* ======================================================               */
/*                                                                      */
/* Written by Sangwan Kim (sangwan@hpcnet.ne.kr)                        */
/* http://bookmark4u.sourceforge.net                                    */
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/*                                                                      */
/* Please read LICENSE.txt                                              */
/************************************************************************/

$env[pass_without_login] = 1;
include("inc/common.php");

if ($env[register_global_off]) {  # register get/post variables as global
  if ($HTTP_SERVER_VARS[REQUEST_METHOD] == 'GET') {
    $userid   = $HTTP_GET_VARS[userid];
  } elseif ($HTTP_SERVER_VARS[REQUEST_METHOD] == 'POST') {
  }
}

# already logined
if ($env[logined] || $env[guest]) {
# header("Location: list.php");
  header("Location: $env[start_script].php");
  exit;
}

# set TARGET cookie
if ($target) {
  PutCookie("TARGET", "$target");
}

echo("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">\n");
echo("<html>
<head>
<style type='text/css'>
a:link    { text-decoration:none; }
a:visited { text-decoration:none; }
a:hover   { text-decoration:underline; }
td,body   {
  color: black;
  font-family: Verdana,Arial,Helvetica;
  font-size: x-small;
}
input,select,textarea {
  border:1 solid black;
  background-color: #eeeeee;
  color:black;
}
</style>
<title>$conf[meta_title]</title>
<meta name=\"description\" content=\"$conf[meta_description]\">
<meta name=\"keywords\" content=\"$conf[meta_keywords]\">
<meta name=\"author\" content=\"$conf[meta_author]\">
</head>
<body bgcolor=white text=black link=#aa4444 alink=#aa4444 vlink=#aa4444");
if ($userid != '') {
  echo(" onLoad='javascript:document.loginform.passwd.focus()'>\n");
} else {
  echo(" onLoad='javascript:document.loginform.userid.focus()'>\n");
}

echo("<center>
<img src='img/bookmark4u.gif' alt='Bookmark4U'>
</center>\n");

include("lang/$env[lang]/welcome.$env[lang].html");

$userid_val = ($userid != '') ? $userid : ''; 
$passwd_val = ($passwd != '') ? $passwd : ''; 
echo("<table border=0 align=center>
<form action=login.php method=post name=loginform>
<tr>
 <td align=right><b>$lang[index_1]</b>:</td>
 <td><input type='text' name='userid' value='$userid_val'><br></td>
</tr><tr>
 <td align=right><b>$lang[index_2]</b>:</td>
 <td><input type='password' name='passwd' value='$passwd_val'><br></td>
</tr><tr>
 <td align=right><b>$lang[index_10]</b>:</td>
 <td>
   <input type='checkbox' name='remember'>
   <select name='duration'>
   <option value='86400'>$lang[index_11]</option>
   <option value='2592000'>$lang[index_12]</option>
   <option value='31536000'>$lang[index_13]</option>
   </select>
 </td>
</tr><tr>
 <td></td>
 <td>

<input type=submit value='$lang[index_3]'><br>
 <a href=httpauth.php>$lang[index_5]</a><br>\n");
 echo("<br>\n");

 echo("<a href=lostpasswd.php>$lang[index_9]</a><br>\n");
 echo("<a href='register.php'>$lang[index_4]</a><br>\n");
 echo("<a href='admin/'>[[$lang[index_14]]]</a><br>\n");

 if ($env[enable_frame_mode]) {
   if ($env[frame_mode]) echo("<a href=index.php?noframe=1 target=_top>$lang[index_7]</a>");
   else echo("<a href=frame.php target=_top>$lang[index_6]</a>");
   echo("<br>");
 }
 echo("<script>
function add_favorites(url) {
  window.external.AddFavorite(url, \"$env[site_title]\");
}
</script>
 <a href=\"javascript:add_favorites('$env[sitehome]/')\">$lang[index_8]</a>");
 echo("<br>
 <a href=http://bookmark4u.sourceforge.net>[[Bookmark4U.sourceforge.net]]</a><br>
 <br>
 Bookmark4U Ver $env[version]<br>
 <a href='README.txt'>README.txt</a>,
 <a href='CHANGES.txt'>CHANGES.txt</a>

 </td></tr></form></table>
<br>\n");

echo("<center>
<a href='http://www.netscape.com/' target=_blank><img
 src=img/netscape.gif border=0></a>
<a href='http://www.microsoft.com/windows/ie/' target=_blank><img
 src=img/iexplorer.gif border=0></a>
<a href='http://www.opera.com/' target=_blank><img
 src=img/opera.gif border=0></a>
</center>\n");

echo("</body></html>\n");

exit;

?>
