<?php

/************************************************************************/
/* Bookmark4U: Web-based personal bookmarking environment               */
/* ======================================================               */
/* Please read LICENSE.txt                                              */
/************************************************************************/

# for debugging
define(DEBUG_XML_IMPORT, 0);

function startElement($parser, $name, $attribs) {
  global $env, $lang;
  global $depth, $stack, $top, $current;
  global $rowdata, $key;
  global $exist_id;
  global $bkcnt, $focnt;
  global $start_import;

 if (DEBUG_XML_IMPORT) echo("&lt;$name&gt;");

  if ($name == 'BOOKMARK4U') {
    if ($attribs['VERSION'] != '1.0') Error($lang[import_e4]);
    else $start_import = 1;
    return;
  }

  if (!$start_import) return;

  if ($name == 'FOLDER') {
    $depth++;

    if ($rowdata[type] == 'c') {
      # add this folder under the current folder, and change current folder.

      $row = array();
      $row[parent] 	= $current;
      $row[type] 	= 'c';
      $row[title] 	= $rowdata[title];
      $row[url] 	= '';
      $row[comment] = $rowdata[comment];
      $row[rdate] 	= $rowdata[rdate];
      $row[public] 	= $rowdata[public];
      $row[visit] 	= $rowdata[visit];
      $row[lastvisit] = $rowdata[lastvisit];
      $row[lastwhere] = $rowdata[lastwhere];

      $ret = InsertDB($row);
      echo("<li><img src=$env[icon_fo] align='top'>");
      if (!$ret) echo("<font color=$env[blur]>$rowdata[title]... skip</font>");
      else echo("$rowdata[title]");
      echo("</li>\n<ul>\n");

      if (!$ret) { # the same folder is exist.
        $current = $exist_id;
      } else {
        $current = $ret;
        $focnt++;
      }
    }

    # push this folder name into stack
    $stack[$top++] = $current;
   if (DEBUG_XML_IMPORT) echo("<b>debug push $current</b>");

    $rowdata = array();
    $rowdata[type] = 'c';

  } elseif ($name == 'BOOKMARK') {
    if ($rowdata[type] == 'c') {
      # add this folder under the current folder, and change current folder.
      
      $row = array();
      $row[parent] 	= $current;
      $row[type] 	= 'c';
      $row[title] 	= $rowdata[title];
      $row[url] 	= '';
      $row[comment] = $rowdata[comment];
      $row[rdate] 	= $rowdata[rdate];
      $row[public] 	= $rowdata[public];
      $row[visit] 	= $rowdata[visit];
      $row[lastvisit] = $rowdata[lastvisit];
      $row[lastwhere] = $rowdata[lastwhere];

      $ret = InsertDB($row);
      echo("<li><img src=$env[icon_fo] align='top'>");
      if (!$ret) echo("<font color=$env[blur]>$rowdata[title]... skip</font>");
      else echo("$rowdata[title]");
      echo("</li>\n<ul>\n");

      if (!$ret) { # the same folder is exist.
      	$current = $exist_id;
      } else {
      	$current = $ret;
        $focnt++;
      }
    }

    $rowdata = array();
    $rowdata[type] = 'b';

  } elseif ($name == 'TITLE') {
    $key = 'title';
  } elseif ($name == 'DESC') {
    $key = 'comment';
  } elseif ($name == 'URL') {
    $key = 'url';
  } elseif ($name == 'PUBLIC') {
    $key = 'public';
  } elseif ($name == 'RDATE') {
    $key = 'rdate';
  } elseif ($name == 'VISIT') {
    $key = 'visit';
  } elseif ($name == 'VDATE') {
    $key = 'lastvisit';
  } elseif ($name == 'VISITIP') {
    $key = 'lastwhere';
  }
}

function endElement($parser, $name) {
  global $env, $lang;
  global $depth, $stack, $top, $current;
  global $rowdata, $key;
  global $exist_id, $maxid;
  global $bkcnt, $focnt;
  global $dontchange;
  global $start_import;

 if (DEBUG_XML_IMPORT) echo("&lt;/$name&gt;");
  if (!$start_import) return;

  if ($name == 'FOLDER') {
    echo("</ul>\n");
    if (!$dontchange) UpdateTotalLeaf($current);
    $depth--;
    $current = $stack[--$top];
   if (DEBUG_XML_IMPORT) echo("<b>debug pop $current</b>");
  } elseif ($name == 'BOOKMARK') {

    # add this bookmark under the current folder
    $row = array();
    $row[parent] 	= $current;
    $row[type] 		= 'b';
    $row[title] 	= $rowdata[title];
    $row[url] 		= $rowdata[url]; 
    $row[comment] 	= $rowdata[comment];
    $row[rdate] 	= $rowdata[rdate];
    $row[visit] 	= $rowdata[visit];
    $row[lastvisit] = $rowdata[lastvisit];
    $row[lastwhere] = $rowdata[lastwhere];

    $ret = InsertDB($row);
    echo("<li><img src=$env[icon_bk] align='top'>");
    if (!$ret) echo("<font color=$env[blur]>$rowdata[title]... skip</font>");
    else echo("$rowdata[title]");
    echo("</li>\n");

    if (!$ret) { # the same bookmark exists
    } else {
      $bkcnt++;
    }
  }
}

function characterData($parser, $data) {
  global $depth, $stack, $top, $current;
  global $rowdata, $key;

  $data = trim($data);
  if ($data != "") {
   if (DEBUG_XML_IMPORT) echo("$key = $data<br>");
    $rowdata[$key] .= $data;
  }
}

function new_xml_parser($file) {
  global $parser_file;

  $xml_parser = xml_parser_create();
  xml_parser_set_option($xml_parser, XML_OPTION_CASE_FOLDING, 1);
  xml_set_element_handler($xml_parser, "startElement", "endElement");
  xml_set_character_data_handler($xml_parser, "characterData");

  if (!($fp = @fopen($file, "r"))) {
    return false;
  }
  if (!is_array($parser_file)) {
    settype($parser_file, "array");
  }
  $parser_file[$xml_parser] = $file;
  return array($xml_parser, $fp);
}


# import a bookmark file in XML format into user's DB
function XmlImportBookmark ($userfile, $id) {
  global $env, $lang;
  global $dontchange, $exist_id;
  global $bkcnt, $focnt;
  global $current, $depth, $top, $stack;
  global $start_import;

  global $userfile;
  global $userfile_name;
  global $userfile_size;
  global $userfile_type;

# if ($userfile == "none") Error($lang[import_e1]);
# if ($userfile_size == 0) Error($lang[import_e2]);

  $bkcnt = $focnt = 0;
  $depth = 0;
  $current = $id;
  $top = 0;
  $start_import = 0;

  if (!(list($xml_parser, $fp) = new_xml_parser($userfile))) {
    Error("Cound not open XML input");
  }

  while ($data = fread($fp, 4096)) {
    if (!xml_parse($xml_parser, $data, feof($fp))) {
      $errcode = xml_get_error_code($xml_parser);
      echo("error = " . xml_error_string($errcode) . "<br>");

      Error(sprintf("XML error: %s at line %d\n",
        xml_error_string(xml_get_error_code($xml_parser)),
        xml_get_current_line_number($xml_parser)));
    }
  }
  xml_parser_free($xml_parser);
}

?>
