<?php

/************************************************************************/
/* Bookmark4U: Web-based personal bookmarking environment               */
/* ======================================================               */
/* Please read LICENSE.txt                                              */
/************************************************************************/

#
# This class embeds Bookmark specific functionality. From the application
# Bookmakr4U point of view, a Bookmark and a folder are the same, except for
# The fact that a folder can have children and a Bookmark itself cannot,
# and their graphical representation is different.
#
# From an Object-oriented point of view, it would have been better to use
# parameters like 'name' with the accoring set- and get-functions (setName 
# and getName), but this is less flexible and scalable 
#
class Bookmark
{
  var $properties;

  # Constructor with a type, which is either 'Folder' or 'Bookmark'
  function Bookmark ($aType)
  {
    $this->properies=array();
    $this->setProperty("Type", $aType);
  }

  # Sets a property of this bookmark (typically something like 'Name'
  # or 'URL' or 'Description'
  function setProperty ($aProperty, $aValue)
  {
    $this -> properties [$aProperty] = $aValue;
  }

  # Retrieves a property of this Bookmark
  function getProperty ($aProperty)
  {
    return $this->properties[$aProperty];
  }
}


#
# Returns whether the inputString starts with the string indicated by
# the parameter 'startsWith'
#
function startsWith ($inputString, $startsWith)
{
  return (substr ($inputString, 0, strlen($startsWith)) == $startsWith);
}

#
# Returns the property of the inputString. This assumes that the inputString
# is in the format of
#
# property=value.
#
# The function will take the length of the property + 1 (for the '=' sign)
# and returns the inputString without the first characters, found by the length
#
# Calling the function getProperty ("property=value", "property") will return
# "value"
#
function getProperty ($inputString, $property)
{
  return (substr ($inputString, strlen($property), strlen($inputString)));
}

# import a bookmark file into user's DB
function OperaImportBookmark ($userfile, $id) {
  $current = $stack[$top];
  $currentBM = new Bookmark ("");

  global $lang;
  global $env;
  global $dontchange;
  global $bkcnt, $focnt;
  
  global $userfile;
  global $userfile_name;
  global $userfile_size;
  global $userfile_type;

# if ($userfile == "none") Error($lang[import_e1]);
# if ($userfile_size == 0) Error($lang[import_e2]);

  $name = "NAME=";
  $url = "URL=";
  $description = "DESCRIPTION=";
  $typeIndicator = "Opera Hotlist";

  $bkcnt = 0;
  $focnt = 0;
  $top = 0;
  $current = $id;
  $fp = fopen($userfile, "r");

  # compare the first line. It should indicate that we are
  # processing a bookmark file of the Opera browser
  $firstLine = fgets($fp, 4096);
  if (!startsWith ($firstLine, $typeIndicator)) Error($lang[import_e3]); 
  $processing = false;

  # process the file
  while (!feof($fp)) {
    $currentLine = trim (fgets($fp, 4096));

    # #FOLDER starts a (sub)folder
    if ($currentLine == "#FOLDER") {
      $currentBM = new Bookmark("Folder");
      $focnt++;
      $processing = true;
    }
    # #URL starts a bookmark
    else if ($currentLine == "#URL") {
      $currentBM = new Bookmark("Bookmark");
      $bkcnt++;
      $processing = true;
    }
    # - ends a folder
    else if ($currentLine == "-") {
      if (!$dontchange) { UpdateTotalLeaf($current); }
      $current = $stack[--$top]; # pop current folder from stack
      $processing = false;
    }
    else if ($currentLine == "" && $processing) {
      # Ok, we found an empty line, this means that we have 
      # either found a folder or bookmark
      #
      # Attention! We will find an empty line just before a
      # folder seperator and just after! Make sure that we
      # are not processing the same bookmark twice (this is
      # why the boolean 'processing' is used.
      if ($currentBM->getProperty("Type") == "Folder") {
        # place the current folder on the stack
        $stack [$top++] = $current;
        if (!$dontchange) {

           $row = array();
           $row[parent] = $current;
           $row[type] = 'c';
           $row[title] = $currentBM->getProperty("Name");
           $row[url] = '';
           $row[comment] = $currentBM->getProperty("Description");
           $ret = InsertDB($row);
        }
        echo("<li><img src=$env[icon_fo] align='top'>");
      	if (!$ret) echo("<font color=$env[blur]>$row[title]... skip</font>");
      	else echo("$row[title]");
      	echo("</li>\n<ul>\n");

        $current = $ret;
      }
      else {
        if (!$dontchange) {
          $row = array();
          $row[parent] = $current;
          $row[type] = 'b';
          $row[title] = $currentBM->getProperty("Name");
          $row[url] = $currentBM->getProperty("URL");
          $row[comment] = $currentBM->getProperty("Description");
          $ret = InsertDB($row);
        }
    	echo("<li><img src=$env[icon_bk] align='top'>");
    	if (!$ret) echo("<font color=$env[blur]>$row[title]... skip</font>");
    	else echo("$row[title]");
    	echo("</li>\n");
      }
      $processing = false;
    }
    # Parse the actual bookmark content. Note that the 'processing'
    # boolean is not needed here, but hey.... it cannot hurt
    else if ($currentLine != "" && $processing) {
      # Parse for the string 'NAME='
      if (startsWith ($currentLine, $name)) {
        $currentName= getProperty ($currentLine, $name);
        $currentBM->setProperty("Name", $currentName);
      }
      # Parse for the string 'DESCRIPTION='
      else if (startsWith ($currentLine, $description)) {
        $currentDescription = getProperty ($currentLine, $description);
        $currentBM->setProperty("Description", $currentDescription);
      }
      # Parse for the string 'URL='
      else if (startsWith ($currentLine, $url)) {
        $currentURL = getProperty ($currentLine, $url);
        $currentBM->setProperty("URL", $currentURL);
      }
      else {
        # Ignore the rest.
      }
    }
  }
  fclose($fp);
}

?>
