<?php

/************************************************************************/
/* Bookmark4U: Web-based personal bookmarking environment               */
/* ======================================================               */
/* Please read LICENSE.txt                                              */
/************************************************************************/

class UserMgr {

  var $user;
  var $db;
  var $table_name;
  
  function UserMgr($user = null, $db = null) {
    global $conf, $env, $mgr;
    
    if ( !isset($db) ) 
      $this->db = $mgr->db;
    else 
      $this->db = $db;
    
    if ( !isset($user) )
      $this->user = $mgr->user;
    else   
      $this->user = $user;
    
    $this->table_name = $env[dbtblpasswd];
  }
  
  function setUser($user) {
    $this->user = $user;
  }
  
  function useTemporaryTable($statut) {
    global $env;
    if ( $statut )
      $this->table_name = $env[dbtblpasswdtmp];
    else
      $this->table_name = $env[dbtblpasswd];
  }
  
  

  //////////////////////////////////
  // Configuration methods
  /////////////////////////////////
  
  function findUserConfig($uid = null) {
    global $env;
    if ( !isset($uid) )
      $uid = $env[uid];
    $qry = "SELECT * FROM " . $env[dbtblconfig] . " WHERE uid='$uid'";
    $result = $this->db->query( $qry );
    $row = $result->fetchRow();
    return $row;
  }
  
  function updateUserConfig($configtext) {
    global $env;
    $qry = "UPDATE $env[dbtblconfig]
        SET config='$configtext' WHERE uid='" . $env[uid] . "'";
    $ret = $this->db->query($qry);
  }
  
  function findUserByUid($uid = null) {
    global $env;
    if ($uid == null)
      $uid = $env[uid];
    
    $qry = "SELECT * FROM " . $this->table_name . " WHERE uid='$uid'";
    $result = $this->db->query( $qry );
    $row = $result->fetchRow();
    return $row;
  }
  
  function findUserByLogin($user = null) {
    global $env;
    if ($user == null)
      $user = $this->user;
    
    $qry = "SELECT * FROM " . $this->table_name . " WHERE user='$user'";
    $result = $this->db->query( $qry );
    $row = $result->fetchRow();
    return $row;
  }
  
  function findAllUsers($order = null) {
    global $env;
    if (isset($order))
          $orderQuery = " ORDER BY $order";
    $qry = "SELECT * FROM " . $this->table_name . " WHERE user!='admin'" . $orderQuery;
    $result = $this->db->query( $qry );
    return $result;
  }
  
  function updateUserLoginInfos() {
    global $env, $HTTP_SERVER_VARS;
    $qry = "UPDATE " . $this->table_name
         ." SET lastlogin=NOW(),lastip='$HTTP_SERVER_VARS[REMOTE_ADDR]',logincnt=logincnt+1"
         ." WHERE user='" . $this->user . "'";
    $result = $this->db->query( $qry );
  }
  
  function updateUser($row) {
    global $env;
    if ( !isset($row[user]) )
      $row[user] = $this->user;
      
    $qry = "UPDATE " . $this->table_name
         ." SET lastlogin = '$row[lastlogin]', lastip = '$row[lastip]', logincnt = '$row[logincnt]', passwd=PASSWORD('$row[passwd]')"
         ." WHERE user='$row[user]'";
    $result = $this->db->query( $qry );
  }
  
  function deleteUser($uid = null) {
    global $env;
    
    if ($uid == null) {      
      $uid = $env[uid];
      $user = $this->user;
    }
    else {
      $row = $this->findUserByUid($uid);
      $user = $row[user];
    }
    
    # delete a record from passwd table
    $qry = "DELETE FROM " . $this->table_name . " WHERE uid=" . $uid;
    $this->db->query( $qry );
    DBError();
  
    if ( !strcmp( $this->table_name, $env[dbtblpasswdtmp] ))
      return;
      
    # delete a record from config table
    $qry = "DELETE FROM $env[dbtblconfig] WHERE uid=" . $uid;
    $this->db->query( $qry );
    DBError();
  
    # drop user table
    $userbm = $env[userdb_prefix].$user;    
    $qry = "DROP TABLE " . $userbm;
    $this->db->query( $qry );
    DBError();
  
    # delete records from trash table
    $trashMgr = createTrashManager($user);
    $trashMgr->deleteAllItems();
    DBError();
  
    # delete records from memo table
    $memoMgr = createMemoManager($user);
    $memoMgr->deleteAllMemos();
    DBError();
  
    # delete records from calendar table
    $trashMgr = createCalendarManager($user);
    $trashMgr->deleteAllEvents();
    DBError();
  
    # delete records from address table
    $addMgr = createAddressManager($user);
    $addMgr->deleteAllAddresses();
    DBError();
  }
  
  function addUser($rowCreate) {
    global $env, $sql_cmds, $conf;
    if ($env[registration_verify]) $qry = "INSERT INTO $env[dbtblpasswdtmp]";
    else $qry = "INSERT INTO $env[dbtblpasswd]";
    $qry .= " SET user='$rowCreate[user]',passwd=PASSWORD('$rowCreate[passwd]'),name='$rowCreate[name]',email='$rowCreate[email]',lastlogin='',lastip='',logincnt=0,rdate=NOW()";
    $this->db->query($qry);  
    DBError();
      
    $userbm = $conf[userdb_prefix].$rowCreate[user];    
    
    if (!$env[registration_verify]) {
      # get the uid value from PASSWD    
      $row = $this->findUserByLogin($rowCreate[user]); 
      DBError();
    
      # insert into CONFIG
      $qry = "INSERT INTO $env[dbtblconfig]
              SET uid=$row[uid], memo='', config=''";
      $this->db->query($qry);
      DBError();
  
      # create user bookmark table database
      $qry = ereg_replace("%NAME%", $userbm, $sql_cmds[table_user]);
      $this->db->query($qry);
      DBError();
  
    }
  }
  
  function checkAccess($passwd, $user = null) {
    global $env;
    
    if ($user == null) $user = $this->user;
    $qry = "SELECT * FROM ". $this->table_name . "
            WHERE user='$user' AND passwd=PASSWORD('$passwd')";
    $result = $this->db->query($qry);
    if ($result == null) return null;
    $row = $result->fetchRow();
    return $row;
  }

}

?>
