<?php

/************************************************************************/
/* Bookmark4U: Web-based personal bookmarking environment               */
/* ======================================================               */
/* Please read LICENSE.txt                                              */
/************************************************************************/

class TrashMgr {

  var $user;
  var $db;
  var $table_name;

  function TrashMgr($user = null, $db = null) {
    global $conf, $env, $mgr;

    if ( !isset($db) ) $this->db = $mgr->db;
    else $this->db = $db;

    if ( !isset($user) )
      $this->user = $mgr->user;
    else
      $this->user = $user;

    $this->table_name = $env[dbtbltrash];
  }


  //////////////////////////////////
  // Finders methods
  /////////////////////////////////


  //// Items /////

  function findItems($parentId, $order, $only_public) {
    return $this->findSpecificItems($parentId, null, $order, $only_public);
  }

  function findItemById($id) {
    $qry = "SELECT * FROM " . $this->table_name . " WHERE user='" . $this->user . "' AND id='$id'";
    $result = $this->db->query( $qry );
    $row = $result->fetchRow();
    return $row;
  }

  function findItemsByCriteria($row) {
    if(isset($row[id]))
      $whereqry .= "id=$row[id]";
    if(isset($row[user]))
      $whereqry .= ((isset($whereqry))? " AND " : " ") . "user='$row[user]'";
    if(isset($row[type]))
      $whereqry .= ((isset($whereqry))? " AND " : " ") . "type='$row[type]'";
    if(isset($row[parent]))
      $whereqry .= ((isset($whereqry))? " AND " : " ") . "parent='$row[parent]'";
    if(isset($row[title]))
      $whereqry .= ((isset($whereqry))? " AND " : " ") . "title='" . addslashes($row[title]) . "'";
    if(isset($row[url]))
      $whereqry .= ((isset($whereqry))? " AND " : " ") . "url='$row[url]'";
    if(isset($row[public]))
      $whereqry .= ((isset($whereqry))? " AND " : " ") . "public='$row[public]'";
    if(isset($whereqry))
      $whereqry = " WHERE " . $whereqry;

    $qry = "SELECT * FROM " . $this->table_name . $whereqry;
    $result = $this->db->query( $qry );
    return $result;
  }

  function findAllItems($type = null, $order = null, $only_public = false) {
    if (isset($type))
          $typeQuery = " AND type='" . $type . "'";
    if (isset($order))
          $orderQuery = " ORDER BY $order";
    if ($only_public)
          $publicQuery = " AND public='1' AND type<>'l'";

    $qry = "SELECT * FROM " . $this->table_name . " WHERE user='" . $this->user . "'" . $typeQuery . $publicQuery . $orderQuery;
    $result = $this->db->query( $qry );
    return $result;
  }

  function findSpecificItems($parentId, $type, $order = null, $only_public = false) {
    if (isset($type))
          $typeQuery = " AND type='" . $type . "'";
    if (isset($order))
          $orderQuery = " ORDER BY $order";
    if ($only_public)
          $publicQuery = " AND public='1' AND type<>'l'";

    $qry = "SELECT * FROM " . $this->table_name . " WHERE user='" . $this->user . "' AND parent='$parentId' " . $typeQuery . $publicQuery . $orderQuery;
    $result = $this->db->query( $qry );
    return $result;
  }

  //// Bookmarks /////

  function findBookmarks($parentId, $order, $only_public) {
    return $this->findSpecificItems($parentId, 'b', $order, $only_public);
  }

  function findAllBookmarks($order, $only_public) {
    return $this->findAllItems($userid, 'b', $order, $only_public);
  }

  function findBookmarksByUrl($url) {
    $qry = "SELECT * FROM " . $this->table_name . " WHERE user='" . $this->user . "' AND url=$url AND type='b'";
    $result = $this->db->query($qry);
    return $result;
  }

  /*function findQuickLinks() {
    $qry = "SELECT * FROM " . $this->table_name . " WHERE user='" . $this->user . "' AND rate='5' AND type='b' ORDER BY type,title";
    $result = $this->db->query($qry);
    return $result;
  }*/


  //// Folders /////

  function findFolders($parentId, $order, $only_public) {
    return $this->findSpecificItems($parentId, 'c', $order, $only_public);
  }

  function findAllFolders($order, $only_public) {
    return $this->findAllItems($userid, 'c', $order, $only_public);
  }


  //////////////////////////////////
  // Items modification methods
  /////////////////////////////////

  /*function incItemVisitNumber($itemId, $lastWhere = null) {
    if (!isset($lastWhere))
      $lastWhere = $HTTP_SERVER_VARS[REMOTE_ADDR];
    $qry = "UPDATE " . $this->table_name . " SET visit=visit+1, lastvisit=NOW(), lastwhere='$lastWhere' WHERE user='" . $this->user . "' AND id = '$itemId'";
    $result = $this->db->query($qry);
    return $result;
  }*/

  function deleteItem($id) {
    $qry = "DELETE FROM " . $this->table_name . " WHERE user='" . $this->user . "' AND id=$id";
    $ret = $this->db->query($qry);
  }

  function deleteAllItems() {
    $qry = "DELETE FROM " . $this->table_name . " WHERE user='" . $this->user . "'";
    $ret = $this->db->query($qry);
  }

  /*

  function moveItem($id, $parentId) {
    $qry = "UPDATE " . $this->table_name . " SET parent='$parentId',rdate=NOW() WHERE user='" . $this->user . "' AND id=$id";
    $ret = $this->db->query($qry);
  }

  function updateItem($row) {
    $qry = "UPDATE " . $this->table_name .
      " SET type='$row[type]',parent=$row[parent],
      title='$title',url='$url',comment='$comment',
      rdate='$row[rdate]', visit=$row[visit], public='$row[public]',
      lastvisit='$row[lastvisit]', lastwhere='$row[lastwhere]', total='$row[total]',
      icon='$row[icon]', rate=NOW(), lnid =$row[lnid], uid=$row[uid],
      rtime='$row[rtime]', chkdate='$row[chkdate]'
      WHERE user='" . $this->user . "' AND id=$row[id]";
    $ret = $this->db->query($qry);
  }
  */
  function addItem($row) {
    $qryMax = "SELECT MAX(id) AS id FROM " . $this->table_name;
    $result = $this->db->query($qryMax);
    $rowMax = $result->fetchRow();
    $maxid = $rowMax[id] + 1;

    $title_sql = addslashes($row[title]);
    $url_sql = addslashes($row[url]);
    $comment_sql = addslashes($row[comment]);

    $qry = "INSERT INTO " . $this->table_name . " SET user='" . $this->user . "', id='$maxid',
      type='$row[type]', parent='$row[parent]', title='$title_sql', url='$url_sql',
      comment='$comment_sql', rdate=NOW(), visit=$row[visit], public='$row[public]',
      lastvisit='$row[lastvisit]', lastwhere='$row[lastwhere]', ddate=NOW()";
    $result = $this->db->query($qry);

  }

  //////////////////////////////////
  // Business methods
  /////////////////////////////////

  function getBookmarksNumber() {
    $qry = "SELECT COUNT(*) AS count FROM " . $this->table_name . " WHERE user='" . $this->user . "' AND type='b'";
    $result = $this->db->query($qry);
    $row = $result->fetchRow();
    $total = $row[count];
    return $total;
  }

  function getFoldersNumber() {
    $qry = "SELECT COUNT(*) AS count FROM " . $this->table_name . " WHERE user='" . $this->user . "' AND type='c'";
    $result = $this->db->query($qry);
    $row = $result->fetchRow();
    $total = $row[count];
    return $total;
  }

  function getChildrenTotalNumber($id) {
    $qry = "SELECT SUM(total) AS sum FROM " . $this->table_name . " WHERE user='" . $this->user . "' AND parent=$id";
    $result = $this->db->query($qry);
    $row = $result->fetchRow();
    $total = ($row[sum]) ? $row[sum] : 0;
    return $total;
  }

  function getBookmarksTotalVisit() {
    $qry = "SELECT SUM(visit) AS count FROM " . $this->table_name . " WHERE user='" . $this->user . "' AND type='b'";
    $result = $this->db->query($qry);
    $row = $result->fetchRow();
    $total = $row[count];
    return $total;
  }

  function getFoldersTotalVisit() {
    $qry = "SELECT SUM(visit) AS count FROM " . $this->table_name . " WHERE user='" . $this->user . "' AND type='c'";
    $result = $this->db->query($qry);
    $row = $result->fetchRow();
    $total = $row[count];
    return $total;
  }



}

?>
