<?php

/************************************************************************/
/* Bookmark4U: Web-based personal bookmarking environment               */
/* ======================================================               */
/* Please read LICENSE.txt                                              */
/************************************************************************/


class CalendarMgr {

  var $user;
  var $db;
  var $table_name;
  
  function CalendarMgr($user = null, $db = null) {
    global $conf, $env, $mgr;
    
    if ( !isset($db) ) 
      $this->db = $mgr->db;
    else 
      $this->db = $db;
    
    if ( !isset($user) )
      $this->user = $mgr->user;
    else   
      $this->user = $user;
    
    $this->table_name = $env[dbtblcalendar];
  }
  
  function findNonPeriodicSchedules($year,$month, $day = null, $ndays = null) {
    global $env;
    
    $qry = "SELECT * FROM " . $this->table_name
        ." WHERE periodic=0"   # non-periodic
        ." AND (uid='$env[uid]' OR public=1)";  # my own or public schedules
     
    if ( $ndays == null ) {
      if ( $day == null ) {
        $qry .= " AND DATE_FORMAT(sdate, '%Y-%c') = '$year-$month'";         
      }
    }
    else {
      $qry .= " AND sdate > '$year-$month-$day'"
             ." AND sdate < DATE_ADD('$year-$month-$day', INTERVAL $ndays DAY)";
    }
    return $this->db->query($qry);
  }
  
  function findPeriodicSchedules($yearBegin,$monthBegin, $dayBegin, $yearEnd, $monthEnd, $dayEnd) {
    global $env;
    # periodic schedules
    $qry = "SELECT * FROM " . $this->table_name
        ." WHERE periodic=1"  # periodic schedules
        ." AND (uid='$env[uid]' OR public=1)"  # my own or public schedules
        ." AND (NOT (edate<'$yearBegin-$monthBegin-$dayBegin' OR sdate>'$yearEnd-$monthEnd-$dayEnd'))";
        #   sdate .... edate < start ...... lastday <  sdate .... edate 
    return $this->db->query($qry);
  }
  
  function findEventById($id) {
    global $env;
    $qry = "SELECT * FROM " . $this->table_name . " WHERE uid='$env[uid]' AND id=$id";
    $result = $this->db->query($qry);
    return $result->fetchRow();
  }
  
  function findEvents($orderQry = null) {
    global $env;
    if ( isset($orderQry) )
      $orderQry = " ORDER BY " . $orderQry;
      
    $qry = "SELECT * FROM " . $this->table_name . " WHERE uid='$env[uid]'" . $orderQry;
    return $this->db->query($qry);
  }
  
  function deleteEvent($id) {
    global $env;
    $qry = "DELETE FROM " . $this->table_name . " WHERE uid='$env[uid]' AND id=$id";  
    $this->db->query($qry);
  }
  
  function deleteAllEvents() {
    global $env;
    $qry = "DELETE FROM " . $this->table_name . " WHERE uid='$env[uid]'";  
    $this->db->query($qry);
  }
  
  function addEvent($row) {
    global $env;
    $row[title] = addslashes($row[title]);
    $row[comment] = addslashes($row[comment]);
    $qry = "INSERT INTO " . $this->table_name .
      " SET uid='$env[uid]', rdate=NOW(), title='$row[title]',
       sdate='$row[sdate]', edate='$row[edate]',
       public='$row[public]', periodic='$row[periodic]', period='$row[period]', bkid=$row[bkid],
       url='$row[url]', comment='$row[comment]', disabled='$row[disabled]', priority='$row[priority]'";    
    $this->db->query($qry);
  }
  
  function updateEvent($row) {
    global $env;
    $row[title] = addslashes($row[title]);
    $row[comment] = addslashes($row[comment]);
    $qry = "UPDATE " . $this->table_name .
        " SET rdate=NOW(), title='$row[title]',
         sdate='$row[sdate]', edate='$row[edate]',
         public='$row[public]', periodic='$row[periodic]', period='$row[period]',
         url='$row[url]', comment='$row[comment]', disabled='$row[disabled]', priority='$row[priority]'
         WHERE uid='$env[uid]' AND id='$row[id]'";
    $this->db->query($qry);
  }
  
}

?>
