<?php

/************************************************************************/
/* Bookmark4U: Web-based personal bookmarking environment               */
/* ======================================================               */
/* Please read LICENSE.txt                                              */
/************************************************************************/

class BookmarkMgr {

  var $user;
  var $userbm;
  var $db;
  
  function BookmarkMgr($user, $db) {
    $this->setUser($user);
    $this->db = $db;
  }
  
  function setUser($user) {
    global $conf;
    
    $this->userbm = $conf[userdb_prefix].$user;
    $this->user = $user;    
  }

  //////////////////////////////////
  // Finders methods
  /////////////////////////////////
  
  //// Items /////
  
  function findItems($parentId, $order = null, $only_public = false) {
    return $this->findSpecificItems($parentId, null, $order, $only_public);
  }
  
  function findItemById($id) {
    $qry = "SELECT * FROM " . $this->userbm . " WHERE id='$id'";
    $result = $this->db->query($qry);
    $row = $result->fetchRow();
    return $row;
  }
  
  function findItemsByCriteria($row) {
    $whereqry = "";
    if (isset($row[id])) {
      if ($whereqry != "") $whereqry .= " AND";
      $whereqry .= "id=$row[id]";
    }
    if (isset($row[type])) {
      if ($whereqry != "") $whereqry .= " AND";
      $whereqry .= "type='$row[type]'";
    }
    if (isset($row[parent])) {
      if ($whereqry != "") $whereqry .= " AND";
      $whereqry .= "parent='$row[parent]'";
    }
    if (isset($row[title])) {
      if ($whereqry != "") $whereqry .= " AND";
      $whereqry .= "title='$row[title]'";
    # $whereqry .= "title='".addslashes($row[title])."'";
    }
    if (isset($row[url])) {
      if ($whereqry != "") $whereqry .= " AND";
      $whereqry .= "url='$row[url]'";
    }
    if (isset($row[public])) {
      if ($whereqry != "") $whereqry .= " AND";
      $whereqry .= "public='$row[public]'";
    }
    if (isset($whereqry)) {
      $whereqry = " WHERE " . $whereqry;
    }
    
    $qry = "SELECT * FROM " . $this->userbm . $whereqry;
    $result = $this->db->query($qry);
    return $result;
  }
  
  function findAllItems($type = null, $order = null, $only_public = false) {
    if (isset($type)) $typeQuery = "type='$type'";
    if (isset($order)) $orderQuery = " ORDER BY $order";
    if ($only_public) $publicQuery = "public='1' AND type<>'l'";
          
    if (isset($typeQuery) || $only_public ) {
      $whereQuery = " WHERE $typeQuery";
      if (isset($typeQuery) && $only_public) $whereQuery .= " AND ";
      $whereQuery .= $only_public;
    }
          
    $qry = "SELECT * FROM " . $this->userbm . $whereQuery . $orderQuery;
    $result = $this->db->query($qry);
    return $result;
  }
  
  function findSpecificItems($parentId, $type, $order = null, $only_public = false) {
    if (isset($type))
          $typeQuery = " AND type='" . $type . "'";
    if (isset($order))
          $orderQuery = " ORDER BY $order";
    if ($only_public)
          $publicQuery = " AND public='1' AND type<>'l'";
          
    $qry = "SELECT * FROM " . $this->userbm . " WHERE parent='$parentId' " . $typeQuery . $publicQuery . $orderQuery;
    $result = $this->db->query( $qry );
    return $result;
  }
  
  function searchItems($whereQry, $order = null) {
    if (isset($order)) $orderQuery = " ORDER BY " . $order;
      
    $qry = "SELECT * FROM " . $this->userbm
          ." WHERE " . $whereQry . $orderQuery;
    $result = $this->db->query( $qry );
    return $result;
  
  }
  
  # select items which is a child of any id in $ids_array
  # SELECT ... WHERE id IN (id1, ..., ids) or parent IN (id1, ..., ids) ...
  function findItemsBySelection($ids_array, $order=null, $only_public=false) {
    if ($ids_array == null) return null;      
    if (isset($order)) $orderQuery = " ORDER BY " . $order;
    if ($only_public) $publicQuery = " AND public='1' AND type<>'l'";
    
    $idQuery = "";
    while ( list($id, $value) = each($ids_array) ) {
      if ($idsQuery != "") $idsQuery .= ", $id";
      else $idsQuery = $id;
    }
    
    $qry = "SELECT * FROM " . $this->userbm
          ." WHERE id IN ( $idsQuery ) OR parent IN ( $idsQuery ) "
          . $publicQuery . $orderQuery;
  # echo $qry;
    $result = $this->db->query($qry);
    return $result;
  }
  
  //// Bookmarks /////
  
  function findBookmarks($parentId, $order = null, $only_public = false) {
    return $this->findSpecificItems($parentId, 'b', $order, $only_public);
  }
  
  function findAllBookmarks($order = null, $only_public = false) {
    return $this->findAllItems('b', $order, $only_public);
  }
  
  function findBookmarksByUrl($url) {
    $qry = "SELECT * FROM " . $this->userbm . " WHERE url='$url' AND type='b'";
    $result = $this->db->query($qry);
    return $result;
  }
  
  function findQuickLinks() {
    $qry = "SELECT * FROM " . $this->userbm . " WHERE rate='5' ORDER BY type,title";  
    $result = $this->db->query($qry);
    return $result;
  }
  
  
  //// Folders /////
  
  function findFolders($parentId, $order = null, $only_public = false) {
    return $this->findSpecificItems($parentId, 'c', $order, $only_public);
  }
  
  function findAllFolders($order = null, $only_public = false) {
    return $this->findAllItems('c', $order, $only_public);
  }
  
  
  //////////////////////////////////
  // Items modification methods
  /////////////////////////////////
  
  function incItemVisitNumber($itemId, $lastWhere = null) {    
    $qry = "UPDATE " . $this->userbm . " SET visit=visit+1, lastvisit=NOW(), lastwhere='$lastWhere' WHERE id = '$itemId'";
    $result = $this->db->query($qry);
    return $result;
  }
  
  function deleteItem($id) {
    $qry = "DELETE FROM " . $this->userbm . " WHERE id=$id";
    $ret = $this->db->query($qry);
  }
  
  function deleteAllItems() {
    $qry = "DELETE FROM " . $this->userbm;
    $ret = $this->db->query($qry);
  }
  
  function moveItem($id, $parentId) {
    $qry = "UPDATE " . $this->userbm . " SET parent='$parentId',rdate=NOW() WHERE id=$id";
    $ret = $this->db->query($qry);
  }
  
  function updateItem($row) {
    global $env;
    
    if (!isset($row[uid]))
      $row[uid] = $env[uid];
      
    $row[title] = addslashes($row[title]);
    $row[url] = addslashes($row[url]);
    $row[comment] = addslashes($row[comment]);  
    
    $qry = "UPDATE " . $this->userbm
         . " SET type='$row[type]', parent=$row[parent], title='$row[title]',"
         . " url='$row[url]', comment='$row[comment]', rdate=NOW(),"
         . " visit='$row[visit]', public='$row[public]',"
         . " lastvisit='$row[lastvisit]', lastwhere='$row[lastwhere]',"
         . " total='$row[total]', icon='$row[icon]', rate='$row[rate]',"
         . " lnid ='$row[lnid]', uid=$row[uid], rtime='$row[rtime]',"
         . " chkdate='$row[chkdate]' WHERE id=$row[id]";
    $ret = $this->db->query($qry);
  }
  
  function addItem($row) {
    $qryMax = "SELECT MAX(id) AS id FROM " . $this->userbm;
    $result = $this->db->query($qryMax);
    $rowMax = $result->fetchRow();
    $maxid = $rowMax[id] + 1;
    
    $title_sql = addslashes($row[title]);
    $url_sql = addslashes($row[url]);
    $comment_sql = addslashes($row[comment]);
  
    if (!isset($row[total])) {
      if ( $row[type] == 'b') $row[total] = 1;
      else $row[total] = 0;
    }
    if ( !isset($row[visit]) ) $row[visit] = 0;
      
    $qry = "INSERT INTO " . $this->userbm
          ." SET id='$maxid', type='$row[type]', parent='$row[parent]',"
          ." title='$title_sql', url='$url_sql', comment='$comment_sql',";
    if ($row[rdate]!='') $qry .= " rdate='$row[rdate]',";
    else $qry .= " rdate=NOW(),";
    $qry .= " visit=$row[visit], public='$row[public]',"
           ." lastvisit='$row[lastvisit]', lastwhere='$row[lastwhere]',"
           ." total='$row[total]', icon='$row[icon]', rate='$row[rate]',"
           ." lnid ='$row[lnid]', uid='$row[uid]'";
    $result = $this->db->query($qry);
    return $maxid;
  }
  
  //////////////////////////////////
  // Business methods
  /////////////////////////////////
  
  function getBookmarksNumber($filter = null, $only_public = false) {
    if (isset($filter))
      $filter = " AND " . $filter;
    if ($only_public)
          $publicQuery = " AND public='1' AND type<>'l'";
    $qry = "SELECT COUNT(*) AS count FROM " . $this->userbm . " WHERE type='b'" . $filter . $publicQuery;
    $result = $this->db->query($qry);
    $row = $result->fetchRow();
    $total = $row[count];
    return $total;
  }
  
  function getFoldersNumber($filter = null) {
    if (isset($filter))
      $filter = " AND " . $filter;
    $qry = "SELECT COUNT(*) AS count FROM " . $this->userbm . " WHERE type='c'" . $filter;
    $result = $this->db->query($qry);
    $row = $result->fetchRow();
    $total = $row[count];
    return $total;
  }
  
  function getChildrenTotalNumber($id) {
    $qry = "SELECT SUM(total) AS sum FROM " . $this->userbm . " WHERE parent=$id";
    $result = $this->db->query($qry);
    $row = $result->fetchRow();
    $total = ($row[sum]) ? $row[sum] : 0;
    return $total;
  }
  
  function getBookmarksTotalVisit() {
    $qry = "SELECT SUM(visit) AS count FROM " . $this->userbm . " WHERE type='b'";
    $result = $this->db->query($qry);
    $row = $result->fetchRow();
    $total = $row[count];
    return $total;
  }
  
  function getFoldersTotalVisit() {
    $qry = "SELECT SUM(visit) AS count FROM " . $this->userbm . " WHERE type='c'";
    $result = $this->db->query($qry);
    $row = $result->fetchRow();
    $total = $row[count];
    return $total;
  }

}



?>
