<?php

/************************************************************************/
/* Bookmark4U: Web-based personal bookmarking environment               */
/* ======================================================               */
/* Please read LICENSE.txt                                              */
/************************************************************************/

class AdminMgr {

  var $user;
  var $db;
  
  function AdminMgr($user = null, $db = null) {
    global $conf, $env, $mgr;
    
    $this->db = $db;    
    $this->user = "admin";    
  }
  
  function executeMiscQuery($qry) {
    $this->db->query( $qry );
  }
  
  function setDB($db) {
    $this->db = $db;
  }
  
  function testDBConnection() {
    global $conf;
    
    if ($conf[dbtype] == "mysql")
      return mysql_connect($conf[dbhost], $conf[dbuser], $conf[dbpasswd]);
    else if ($conf[dbtype] == "pgsql")
      return pg_connect("host=$env[dbhost] user=$env[dbuser] password=$env[dbpasswd] dbname=$env[dbname]");
    else
      return null;
  }
  
  function testDBSelection($connect) {
    global $conf, $env;
    
    if ($conf[dbtype] == "mysql") {
      $ret = mysql_select_db($env[dbname], $connect);
      if ( !$ret )
        return false;
      $this->db = new Mysql_DB(false);
      $env[connect] = $ret;
      return true;
    }
    else if ($conf[dbtype] == "pgsql") {
      $env[connect] = $ret;
      return true;
    }
    else
      return false;
  }
  
  function findTables() {
    global $env;
    
    $qry = "SHOW TABLE STATUS FROM $env[dbname]";  # query existing tables
    $result = $this->db->query( $qry );
    return $result;
  }
  
  function findFields($table) {
    global $env;
    
    if ( ! strcmp($env[dbtype], "mysql" ) ) {
      $tableName = strtolower($table);
    }
    else
      $tableName = $table;
    
    $qry = "SHOW FIELDS FROM $tableName"; # fetch all fields in the table
    $result = $this->db->query( $qry );
    return $result;
  }
  
  
  
}

?>
