<?php

/************************************************************************/
/* Bookmark4U: Web-based personal bookmarking environment               */
/* ======================================================               */
/* Please read LICENSE.txt                                              */
/************************************************************************/

# insert a bookmark into DB
# insert a child of $parent
function InsertDB($row) {
  global $env, $lang, $mgr;
  global $exist_id;
  global $dontchange;

  # check if the same bookmark/folder is exists
  $crit = array();
  $crit[parent] = $row[parent];
  $crit[title]  = $row[title];
  $crit[type]   = $row[type];
  $crit[url]    = $row[url];

  $result = $mgr->findItemsByCriteria($crit);
  DBError();

  if ($result->numRows() > 0) {  # if the same bookmark or folder exists
    $exist_id = $row[id];
    return 0;
  } else {
    if (!$dontchange) {  # do not change database

      if (!isset($row[public])) {
        if ($env[default_public_import] == 'private') $row[public]='0';
        else $row[public]='1'; # default value
      }

      $lastid = $mgr->addItem($row);

      DBError();
    }
    return $lastid;
  }
}

# import a bookmark file into user's DB
function NetscapeImportBookmark($userfile, $id) {
  global $env, $lang;
  global $dontchange, $maxid, $exist_id;
  global $bkcnt, $focnt;

  global $userfile;
  global $userfile_name;
  global $userfile_size;
  global $userfile_type;

# if ($userfile == "none") Error($lang[import_e1]);
# if ($userfile_size == 0) Error($lang[import_e2]);

  $bkcnt = 0;
  $focnt = 0;
  $depth = 0;
  $current = $id;
  $top = 0;

  $fp = fopen($userfile, "r");

  # compare the first line
  $buffer = fgets($fp, 4096);
  $token = "<!DOCTYPE NETSCAPE-Bookmark-file-1>";
  if (substr($buffer, 0, strlen($token)) != $token) Error($lang[import_e3]);

  echo("<ul>\n");
  # process each line
  while (!feof($fp)) {
    $buffer = fgets($fp, 4096);

    if (ereg("^[ ]*<DL", $buffer)) {  # <DL> starts a subfolder
      $depth++;
    } else if (ereg("^[ ]*<\/DL", $buffer)) {  # </DL> ends a subfolder
      echo("</ul>\n");
      if (!$dontchange) UpdateTotalLeaf($current);
      $depth--;
      $top--;
      $current = $stack[$top]; # pop current folder from stack
    } else if (ereg("^[ ]*<DT", $buffer)) { # ..<DT> defines a bookmark
      if (ereg("<A", $buffer)) {  # this is a bookmark

        $href = ereg_replace("([^H]*HREF=\")([^\"]*)(\".*)", "\\2", $buffer);
        $bktitle = ereg_replace("^( *<DT><[^>]*>)([^<]*)(.*)", "\\2", $buffer);

        # add this bookmark under the current folder
        $row = array();
        $row[parent] = $current;
        $row[type] = 'b';
        $row[title] = $bktitle;
        $row[url] = $href;
        $row[comment] = '';
        $ret = InsertDB($row);
        echo("<li><img src=$env[icon_bk]> <!--$current,$ret-->");
        if (!$ret) echo("<font color=$env[blur]>$bktitle... skip</font>"); 
        else echo("$bktitle");

        if (!$ret) { # the same bookmark exists
        } else {
          $bkcnt++;
        }
      } else { # folder <DT><H3 FOLDED...>title</H3>
        $temp = $buffer;

        $folder = ereg_replace("^( *<DT><[^>]*>)([^<]*)(.*)", "\\2", $buffer);

        # push this folder name into stack
        $stack[$top] = $current;
        $top++;

        # add this folder under the current folder, and change current folder.
        $row = array();
        $row[parent] = $current;
        $row[type] = 'c';
        $row[title] = $folder;
        $row[url] = '';
        $row[comment] = '';
        $ret = InsertDB($row);
        echo("<li><img src=$env[icon_fo]> <!--$current,$ret-->");
        if (!$ret) echo("<font color=$env[blur]>$folder... skip</font>"); 
        else echo("$folder");
        echo("\n<ul>\n");

        if (!$ret) { # the same folder is exist.
          $current = $exist_id;
        } else {
          $current = $ret;
          $focnt++;
        }

      }
    }
  }

  if (!$dontchange) UpdateTotalLeaf($current);
  fclose($fp);
  echo("</ul>\n");
}

function HtmlImportBookmark($userfile, $id) {
  global $env, $lang;
  global $dontchange, $maxid, $exist_id;
  global $bkcnt, $focnt;

  global $userfile;
  global $userfile_name;
  global $userfile_size;
  global $userfile_type;

# if ($userfile == "none") Error($lang[import_e1]);
# if ($userfile_size == 0) Error($lang[import_e2]);

  $bkcnt = 0;
  $focnt = 0;
  $depth = 0;
  $current = $id;
  $top = 0;

  $fp = fopen($userfile, "r");

  # compare the first line
  $buffer = fgets($fp, 4096);

  while (!feof($fp)) {
    $buffer = fgets($fp, 4096);
  }

  fclose($fp);
}

?>
