<?php

/************************************************************************/
/* Bookmark4U: Web-based personal bookmarking environment               */
/* ======================================================               */
/* Please read LICENSE.txt                                              */
/************************************************************************/

# generate a Netscape bookmark file for bookmarks under the parent folder
function NetscapeExportBookmarks ($parent, $indent) {
  global $env;
  global $eol;
  global $cnt_b, $cnt_c;
  global $exp_private;

  while ( list($key, $row) = each($parent[children]) ) {

    # skip if 'do not export private items' and 'this is private'
    if (!$exp_private && !$row[public]) continue;

    if ($row[type] == 'c') {  # folder
      $cnt_c++;
      for ($j = 0; $j < $indent; $j++) { echo("    "); }
      echo("<DT><H3 FOLDED ADD_DATE=\"000000000\">$row[title]</H3>$eol");
      for ($j = 0; $j < $indent; $j++) { echo("    "); }
      echo("<DL><p>$eol");
      NetscapeExportBookmarks($row, $indent+1);
      for ($j = 0; $j < $indent; $j++) { echo("    "); }
      echo("</DL><p>$eol");
    } else if ($row[type] == 'b') { # bookmark
      $cnt_b++;
      for ($j = 0; $j < $indent; $j++) { echo("    "); }
      echo("<DT><A HREF=\"$row[url]\" ADD_DATE=\"000000000\""
    ." LAST_VISIT=\"000000000\" LAST_MODIFIED=\"000000000\">$row[title]</A>$eol");
    }
  }
}

# generate a Opera browser bookmark file for bookmarks under the parent folder
function OperaExportBookmarks ($parent, $indent) {
  global $env;
  global $eol;
  global $exp_private;

  while ( list($key, $row) = each($parent[children]) ) {

    # skip if 'do not export private items' and 'this is private'
    if (!$exp_private && !$row[public]) continue;

    if ($row[type] == 'c') { # folder
      $cnt_c++;
      echo("#FOLDER$eol");
      echo("\tNAME=$row[title]$eol");
      echo("\tCREATED=990574321$eol");
      echo("\tVISITED=0$eol");
      echo("\tORDER=$cnt_c$eol");
      echo("\tEXPANDED=YES$eol");
      echo("\tDESCRIPTION=$eol");
      echo("$eol");

      OperaExportBookmarks($row, $indent+1);

      echo("$eol-$eol");
    } else if ($row[type] == 'b') { # bookmark
      $cnt_b++;
      echo("#URL$eol");
      echo("\tNAME=$row[title]$eol");
      echo("\tURL=$row[url]$eol");
      echo("\tCREATED=990574321$eol");
      echo("\tVISITED=0$eol");
      echo("\tORDER=$cnt_b$eol");
      echo ("$eol");
    }
  }
}

# generate a XML file for bookmarks under the parent folder
function XmlExportBookmarks($parent, $indent) {
  global $env;
  global $eol;
  global $cnt_b, $cnt_c;
  global $exp_private;

  $indentstr = "  ";
  $sp = "";
  for ($j = 0; $j <= $indent; $j++) { $sp .= $indentstr; }

  while ( list($key, $row) = each($parent[children]) ) {

    # skip if 'do not export private items' and 'this is private'
    if (!$exp_private && !$row[public]) continue;

    $title   = ereg_replace("&", "&amp;", $row[title]);
    $url     = ereg_replace("&", "&amp;", $row[url]);
    $comment = ereg_replace("&", "&amp;", $row[comment]);

    $title   = ereg_replace("<", "&lt;", $title);
    $url     = ereg_replace("<", "&lt;", $url);
    $comment = ereg_replace("<", "&lt;", $comment);

    $title   = ereg_replace(">", "&gt;", $title);
    $url     = ereg_replace(">", "&gt;", $url);
    $comment = ereg_replace(">", "&gt;", $comment);

    $title   = ereg_replace("\"", "&quot;", $title);
    $url     = ereg_replace("\"", "&quot;", $url);
    $comment = ereg_replace("\"", "&quot;", $comment);

    if ($row[type] == 'c') {  # folder
      $cnt_c++;
      echo("$sp<folder>$eol");
      echo("$sp$indentstr<title>$title</title>$eol");
      if ($row[comment]) echo("$sp$indentstr<desc>$comment</desc>$eol");
      echo("$sp$indentstr<public>$row[public]</public>$eol");
      echo("$sp$indentstr<rdate>$row[rdate]</rdate>$eol");
      XmlExportBookmarks($row, $indent+1);
      echo("$sp</folder>$eol");
    } else if ($row[type] == 'b') { # bookmark
      $cnt_b++;
      echo("$sp$indentstr<bookmark>$eol");
      echo("$sp$indentstr$indentstr<title>$title</title>$eol");
      echo("$sp$indentstr$indentstr<url>$url</url>$eol");
      if ($row[comment]) echo("$sp$indentstr$indentstr<desc>$comment</desc>$eol");
      echo("$sp$indentstr$indentstr<public>$row[public]</public>$eol");
      echo("$sp$indentstr$indentstr<rdate>$row[rdate]</rdate>$eol");
      echo("$sp$indentstr$indentstr<visit>$row[visit]</visit>$eol");
      echo("$sp$indentstr$indentstr<vdate>$row[lastvisit]</vdate>$eol");
      if ($row[lastwhere]) echo("$sp$indentstr$indentstr<visitip>$row[lastwhere]</visitip>$eol");
      echo("$sp$indentstr</bookmark>$eol");
    }
  }
}

?>
