<?php

/************************************************************************/
/* Bookmark4U: Web-based personal bookmarking environment               */
/* ======================================================               */
/* Please read LICENSE.txt                                              */
/************************************************************************/

# get the current time of day in usec
function TimeStampUsec() {
  $now =  gettimeofday();
  $usec = $now[sec] * 1000000 + $now[usec];
  return $usec;
}

function SimplePageHead($title="") {
  global $env, $lang;

  if ($title != "") { $title_str = " -  $title"; }

  echo("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">\n");
  echo("<html>
<head>
<title>$env[site_title]$title_str</title>
<meta name=\"description\" content=\"$env[meta_description]\">
<meta name=\"keywords\" content=\"$env[meta_keywords]\">
<meta name=\"author\" content=\"$env[meta_author]\">
<meta http-equiv=\"content-type\" content=\"text/html; charset=$env[doc_encoding]\">
<link rel=\"icon\" href=\"$env[icon_fo]\" type=\"image/gif\">\n");
  if ($env[stylesheet]) StyleHeader();
  echo("</head>\n");

  # body tag
  $bgimg = $env[bgimg];
  if ($bgimg) {
    if (!ereg("^http://", $bgimg)) $bgimg = "$env[bgimg_dir]/$bgimg";
    $bgimg_tag = ($bgimg) ? " background='$bgimg'" : "";
  }
  echo("<body");
# echo(" bgcolor='$env[bg]' text='$env[text]' link='$env[link]' vlink='$env[vlink]' alink='$env[vlink]'");
# echo(" marginheight='4' marginwidth='4' topmargin='4' leftmargin='4'");
  echo("$bgimg_tag>\n");  # end of <body>

  echo("<table border=0 cellpadding=0 cellspacing=0 width=100%><tr>
<td><b>$env[site_title]</b>");
  echo("<td align=right>\n");
  echo("<a href='logout.php'>$lang[logout]</a>\n");
  echo("</td></tr></table>\n");
  echo("<img src='$env[icon_trdot]' height='2' width='1' border='0'><br>\n");

  # head line
  if ($env[headline] && $env[script_name] != "list") {
    if ($env[title_icon]) $title_icon = "<img src='$env[title_icon]' width='$env[icon_size_x]' height='$env[icon_size_y]' align='top'>";

    echo("<table border=0 cellpadding=4 cellspacing=0 width=100%><tr>
<tr><td bgcolor=$env[th]>$title_icon <b>$title</b></td>
<td align=right bgcolor=$env[th]></td>
</tr></table>\n");
    echo("<img src=$env[icon_trdot] height=7 width=1 border=0><br>\n");
  }
  echo("<!------ end of head ------------>\n");
}

# print page ending
function SimplePageTail() {
  global $env, $lang;
  echo("</body></html>");
}

# display an error message and terminate program
function Error($msg, $go_back=1) {
  global $env, $lang;

  if ($env[errmsg_method] == 'script') {
    $msg = ereg_replace("\n", "\\n", $msg);
    echo("<script>\n");
    echo("alert(\"$msg\")\n");
    if ($go_back) echo("history.go(-1)");
    echo("</script>\n");
  } else if ($env[errmsg_method] == 'onpage') {
    $msg = ereg_replace("\n", "<br>", $msg);
    SimplePageHead("Error");
    echo("<center><h2>$msg</h2>");
    if ($go_back) {
      echo("<img src='$env[icon_back]' align='top'><a href=\"javascript:history.go(-1)\">[[$lang[back]]]</a>");
    }
    echo("</center>");
    SimplePageTail();
  }
  exit;
}

# display an error message and redirect to url
function ErrorRedir($msg, $url) {
  global $env;
  if ($env[errmsg_method] == 'script') {
    $msg = ereg_replace("\n", "\\n", $msg);
    echo("<script>\n");
    echo("alert(\"$msg\");\n");
    echo("window.location='$url';\n");
    echo("</script>\n");
  } else {
    $msg = ereg_replace("\n", "<br>", $msg);
    SimplePageHead("Error");
    echo("<center><h2>$msg</h2>");
    echo("<a href=\"$url\">[[Continue]]</a><img src='$env[icon_next]' align='top'>");
    echo("</center>");
    SimplePageTail();
  }
  exit;
}

# get the time stamp of date
function GetTimeStamp($date) {
  $d[y] = substr($date,0,4);
  $d[m] = substr($date,5,2);
  $d[d] = substr($date,8,2);
  $d[h] = substr($date,11,2);
  $d[n] = substr($date,14,2);
  $d[s] = substr($date,17,2);
  $t = mktime($d[h],$d[n],$d[s], $d[m],$d[d],$d[y]);
  return $t;
}

# print the content of an array
function PrintArray($array, $name='array') {
  $keys = array_keys($array);
  $len = sizeof($keys);
  for ($i = 0; $i < $len; $i++) {
    $key = $keys[$i];
    echo("$name.$key='$array[$key]'<br>\n");
  }
}
# print the content of an array recursively
function PrintArrayR($array, $name='array') {
  $keys = array_keys($array);
  $len = sizeof($keys);
  for ($i = 0; $i < $len; $i++) {
    $key = $keys[$i];
    if (is_array($array[$key])) PrintArrayR($array[$key], "$name.$key");
    else echo("$name.$key='$array[$key]'<br>\n");
  }
}

# set a cookie value
function PutCookie($key, $value, $time=0) {
  global $conf;
  $key = $conf[cookie_prefix] . $key;
  # use $conf[sitehome] instead of "/" if problem
  setcookie($key, $value, $time, "/");
}

# get cookie value from array $HTTP_COOKIE_VARS
function GetCookie($key) {
  global $conf;
  global $HTTP_COOKIE_VARS;
  $key = $conf[cookie_prefix] . $key;
  return $HTTP_COOKIE_VARS[$key];
}

# print page ending
function PageTail() {
  global $env, $lang;
  global $REMOTE_ADDR;

  if ($env[inc_headtail]) include("html/tail.html");

  $ip_str = ($env[disp_ip]) ? "$REMOTE_ADDR" : "";

  if ($env[disp_time]) {
    $date_str = FormatDateAndTime(date("Y-m-d H:i:s"), $lang[dateformat]);
  } else $date_str = "";

  $env[checktime2] = SecondsFrom();
  $elapsed = $env[checktime2] - $env[checktime1];

  $elapsed = ($elapsed / 1000000);
  $elapsed_str = ($env[disp_ctime]) ?
    "[$env[num_of_query] $lang[query], $elapsed $lang[sec]" : "";

  # output bytes calculation
  if ($env[need_to_flush_output]) {
    # flush the output buffer and turn off output buffering
    ob_end_flush();
    list($num, $unit) = FormatByteDown($env[total_output_bytes],3,1);
    $elapsed_str .= ", $num $unit";
  }

  if ($env[disp_ctime]) $elapsed_str = "$elapsed_str]";

  if ($env[page_tail]) {
    echo("<table border='0' width='100%' cellpadding='0' cellspacing='0'><tr><td>\n");
    echo("$ip_str");
    echo(" $date_str");
    echo(" <font color=$env[blur]>$elapsed_str</font>");
    echo("</td></tr></table>\n");
  }

  #### for debugging
  if ($env[debug_cookie]) {
    # print HTTP_COOKIE_VARS, HTTP_GET_VARS arries and QUERY_STRING variable
    global $HTTP_COOKIE_VARS;
    global $QUERY_STRING;
    global $HTTP_GET_VARS;
    echo("QUERY_STRING = $QUERY_STRING<br>");
    PrintArray($HTTP_GET_VARS, 'HTTP_GET_VARS');
    PrintArray($HTTP_COOKIE_VARS , 'HTTP_COOKIE_VARS');
  }

  ksort($env);
  if ($env[debug_env]) PrintArray($env, 'env'); # print env array
  ksort($lang);
  if ($env[debug_lang]) PrintArray($lang, 'lang'); # print lang array

  if ($env[alert_msg]) echo("<script>alert(\"$env[alert_msg]\");</script>\n");

  echo("</body></html>");
}

# print the style sheet
function StyleHeader() {
  global $env, $lang;

  $style_font = ($env[style_font]) ? $env[style_font] : $lang[style_font];

  echo("<style type='text/css'>
a:link    { text-decoration:none; color:$env[text]; }
a:visited { text-decoration:none; color:$env[vlink]; }
a:hover   { text-decoration:underline; color:$env[vlink]; }
body,td,pre {
  color: $env[text];
  font-family: $style_font;
  font-size: $env[font_size];
}
body {
  margin-top:$env[page_margin]px;
  margin-left:$env[page_margin]px;
  margin-right:$env[page_margin]px;
  background-color:$env[bg];
}
body {
  scrollbar-face-color: $env[bg];
  scrollbar-shadow-color: $env[shadow];
  scrollbar-highlight-color: $env[shadow];
  scrollbar-3dlight-color: $env[bg];
  scrollbar-darkshadow-color: $env[bg];
  scrollbar-track-color: $env[bg];
  scrollbar-arrow-color: $env[shadow];
}
.highlight { background-color: $env[th]; }
.transtextinput { background-color: $env[td]; }
.transtextinput_bg { background-color: $env[bg]; border=0; solid $env[bg]; }
.headline { background-color: $env[td]; }
.pageheadline {
  background-color: $env[th];\n");
  if ($env[table_header_gradient]) {
    echo("  FILTER: progid:DXImageTransform.Microsoft.Gradient(GradientType=1, StartColorStr='$env[th]', EndColorStr='$env[bg]');\n");
  }
  echo("}
.tabselect {
  background-color: $env[th];\n");
  if ($env[table_header_gradient]) {
    echo("  FILTER: progid:DXImageTransform.Microsoft.Gradient(GradientType=0, StartColorStr='$env[bg]', EndColorStr='$env[th]');\n");
  }
  echo("}\n");
  if ($env[enable_form_style]) {
    echo("input,select,textarea {
  border:1 solid $env[td];
  color:$env[text];
  background-color:$env[th];
  font-size: $env[font_size];
}\n");
  }
  echo("ul, ol { margin-top: 5px; margin-bottom: 5px; }\n");
  if ($env[show_search_icon] && !$env[adv_search_button]) {
    echo("#Drag {\n");
    echo("  position:absolute;
  width:$env[history_layer_w];
  left:$env[history_layer_px];
  top:$env[history_layer_py];
  background-color:$env[td];\n");
    if ($env[script_name] != 'list' || !$env[history_layer_show]) {
      echo("  visibility:hidden;\n");
    }
    echo("}\n");
  }
  echo("
  img.icon {
    width:$env[icon_size_x];
    height:$env[icon_size_y];
    vertical-align: top;
    border:0;
  }
  table.noborder {
    border:0px;
    border-spacing:0px;
    padding:0;
    margin:0;
    width=100%;
    border-collapse:collapse;
  }
  table.noborder tr td {
    padding:0;
    margin:0;
  }
  \n");
  echo("</style>\n");
}

# Check access authorization
# access is 'read' or 'write'
function CheckAuth($access, $msg='') {
  global $env, $lang;

  if (!$msg) $msg = $lang[msg_auth_fail];
  if ($env[logined] && !$env[guest]) return;
  else if ($env[guest] && $access == 'read') return;
  else Error($msg);
}

# check password of user. if correct return 1
function CheckPassword($user, $passwd) {
  global $env;
  global $userMgr;

  $row = $userMgr->checkAccess($passwd, $user);
  if ($row[user] == $user) return 1;
  return 0;
}

# script for dragging history layer
function DragScript() {
  global $env;

  echo("<script language=\"javascript\" type=\"text/javascript\">\n");

  echo("function endDrag() {"
      ."  dragThis = null;\n");
  if ($env[search_focus]) {
  echo("  if (history_layer_on) {\n"
      ."    document.searchform3.k.focus();\n"
      ."  }\n");
  }
  echo("}\n");

  echo("function PageFocus2() {"
      ."  setDrag('$env[history_layer_px]', '$env[history_layer_py]');\n");
  if ($env[page_focus]) echo("  PageFocus();\n");
  echo("}\n");

  echo("</script>\n");
}

# Page Heading
function PageHead($title="") {
  global $env, $lang;
  global $mgr, $uconf;

  if ($env[guest]) $env[top_folder_name] = $uconf[top_folder_name];

  if ($env[top_folder_name_in_title]) {
    $top_folder_name = sprintf($env[top_folder_name], $env[user]);
    if ($title != "") $title_str = " -  $title";
  } else {
    $top_folder_name = "";
    if ($title != "") $title_str = $title;
    else $title_str = $env[site_title];
  }

  echo("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">\n");
  echo("<html>
<head>\n");
  if ($env[page_refreshing]) {
    $refresh_time = $env[page_refresh_time];
    if ($refresh_time < $env[min_page_refresh_time]) {
      $refresh_time = $env[min_page_refresh_time];
    }
    echo("<meta http-equiv=refresh content='$refresh_time'>\n");
  }

  echo("<title>$top_folder_name$title_str</title>\n");
  if ($env[stylesheet]) StyleHeader();
  echo("<script language=\"javascript\" type=\"text/javascript\" src=\"common.js\"></script>\n");
  if ($env[script]) {
    echo("<script>\n$env[script]\n</script>\n");
  }
  echo("<meta name=\"description\" content=\"$env[meta_description]\">
<meta name=\"keywords\" content=\"$env[meta_keywords]\">
<meta name=\"author\" content=\"$env[meta_author]\">
<meta http-equiv=\"content-type\" content=\"text/html; charset=$env[doc_encoding]\">
<link rel=\"icon\" href=\"$env[icon_fo]\" type=\"image/gif\">\n");

  if ($env[show_search_icon] && !$env[adv_search_button]) DragScript();
  echo("</head>\n");

  $bgimg = $env[bgimg];
  if ($bgimg) {
    if (!ereg("^http://", $bgimg)) $bgimg = "$env[bgimg_dir]/$bgimg";
    $bgimg_tag = ($bgimg) ? " background='$bgimg'" : "";
  }
  # body tag
  echo("<body");
# echo(" bgcolor='$env[bg]' text='$env[text]' link='$env[link]' vlink='$env[vlink]' alink='$env[vlink]'");
# echo(" marginheight='4' marginwidth='4' topmargin='4' leftmargin='4'");
  echo("$bgimg_tag");
  if ($env[show_search_icon] && !$env[adv_search_button]) {
    echo(" onLoad='PageFocus2()'");
  } else if ($env[page_focus]) echo(" onLoad='PageFocus()'");
  if ($env[page_unload]) echo(" onUnLoad='PageUnLoad()'");
  echo(">\n");  # end of <body>

  if ($env[show_search_icon] && !$env[adv_search_button]) HistoryLayer();

  $exp_parm = ($env[tree_view]) ? "&exp=$env[exp]" : "";

  $user_str = "<b>$env[site_title]</b>";
  $top_str = "<a href=list.php?dummy=$env[dummy]$exp_parm>$user_str</a>";

  echo("<table border=0 cellpadding=0 cellspacing=0 width=100%><tr>
  <td>$top_str");
  echo("<td align='right'>\n");
  if ($env[script_name] != "selimage") {
    echo("<a href='listuser.php'>$lang[users]</a>\n");
    echo("| <a href='help.php'>$lang[help]</a>\n");
    echo("| <a href='logout.php'>$lang[logout]</a>\n");
  }
  echo("</td></tr></table>\n");

  echo("<img src=$env[icon_trdot] height=2 width=1 border=0><br>\n");

  if ($env[inc_headtail]) include("html/head.html");

  # display the path of current folder
  if ($env[disp_current_path] && $env[script_name] != 'list'
      && $env[script_name] != "selimage") {
    $row = $mgr->findItemById($env[root]);
    PrintPath($row);
  }

  # head line
  if ($env[headline] && $env[script_name] != "list") {

    $str = ($env[show_icon_name]) ? $lang[list_6] : "";
    if ($env[guest]) $guest_exit = "<a href=guestlogout.php><img src=$env[icon_stop] width=$env[icon_size_x] height=$env[icon_size_y] border=0>$str</a>";

    $back_str = ($env[show_icon_name]) ? $lang[back] : "";

    if ($env[title_icon]) $title_icon = "<img src=$env[title_icon] width=$env[icon_size_x] height=$env[icon_size_y] align=top>";

    $attrf = " class='pageheadline'";
    echo("<table border='0' cellpadding='0' cellspacing='0' width='100%'>
<tr><td$attrf>
<table border='0' cellpadding='4' cellspacing='0' width='100%'><tr>
<tr><td>$title_icon <b>$title</b></td>
<td align='right'>$guest_exit
 $env[headline_right]
 <a href=\"javascript:history.go(-1);\"><img
 src='$env[icon_back]' width='$env[icon_size_x]' height='$env[icon_size_y]'
 border='0' align='top'>$back_str</a>
</td>
</tr></table></td></tr></table>\n");
    echo("<img src=$env[icon_trdot] height=7 width=1 border=0><br>\n");
  }

  echo("<!------ end of head ------------>\n");
}


function ListFolder($parent, $indent, $file, $options, $current) {
  global $env, $lang;
  global $mgr;
  global $HTTP_GET_VARS;
  global $HTTP_SERVER_VARS;
  global $listfolder;

  if (!$listfolder) $listfolder = $env[folder_list_default];
# if (!$listfolder) $listfolder = "recent";

  $color1 = ($listfolder=='recent') ? $env[th] : $env[td];
  $color2 = ($listfolder=='all') ? $env[th] : $env[td];
  $title1 = ($listfolder=='recent') ? "<b>$lang[recent]</b>" : "$lang[recent]";
  $title2 = ($listfolder=='all') ? "<b>$lang[all]</b>" : "$lang[all]";

  $query_string = ($HTTP_SERVER_VARS['QUERY_STRING'])
           ? $HTTP_SERVER_VARS['QUERY_STRING'] : "dummy=$env[dummy]";
  $url = "$HTTP_SERVER_VARS[PHP_SELF]?$query_string";

  $pos = strpos($url, "&listfolder=");
  if ( $pos != 0 )
    $url = substr($url, 0, $pos);

  echo("<table border=0 cellpadding=3 cellspacing=1 width=100%>
<tr>
<td bgcolor=$color1 align=center width=20%><a href=$url&listfolder=recent>
$title1</a></td>
<td bgcolor=$color2 align=center width=20%><a href=$url&listfolder=all>
$title2</a></td>
<td bgcolor=$env[td] align=center width=60%></td>
</tr>
</table>\n");

  if ($listfolder == 'all') {
    $result = $mgr->findAllFolders('title ASC');
    $rootTree = CreateTree($result, 0);
    ListSubFolder($rootTree, $indent, $file, $options, $current);
  } else if ($listfolder == 'recent')
    ListRecentFolder($file, $options);
}

# display all folder under $parent
# indent is set to 0 if first call
# options is attatched to url ex) $options = "&which=this&when=now"
function ListSubFolder($parent, $indent, $file, $options, $current) {
  global $env, $lang;
  global $mgr;
  global $lstyle;
  global $cnt_c;

  $depth = 1;
  if ($indent == 0) { # first call
    $depth = 0;
    $cnt_c = 0;
    echo("<table border=0 cellpadding=0 cellspacing=0 width=100%>\n");
    echo("<tr>");
    if ($current == 0) { echo("<td bgcolor=$env[td]><a name='current'>"); }
    else { echo("<td>"); }
    if ($env[guest]) $userName = GetCookie('USER');
    else $userName = $env[user];
    $userName = sprintf($env[top_folder_name], $userName);
    echo("<a href=$file.php?id=0$options><img src=$env[icon_fo] width=$env[icon_size_x] height=$env[icon_size_y] border=0 align=top>$userName</a>");
    if ($current == 0) { echo $lang[current_fld]; }
    echo("</td>\n");
    $indent = 1;
  }

  $total = sizeof($parent[children]);
  $j = 0;
  $lstyle[$indent] = 't';

  while (list($key, $row) = each($parent[children])) {

    $j++;
    $cnt_c++;
    if ($j == $total) { $lstyle[$indent] = 'l'; }

    if ($env[line_gap]) {
      echo("<tr><td>");
      $img_name = "icon_tree_gap$env[line_gap]";  # icon_tree_gap[1|2|3]
      $img = $env[$img_name];
      $height = $env[line_gap] * 2;
      for ($i = 1; $i <= $indent; $i++) {
        if ($lstyle[$i] == 'i' || $lstyle[$i] == 'l' || $lstyle[$i] == 't') {
          echo("<img src='$img' border=0 width=16 height=$height>");
        } else {
          echo("<img src=$env[icon_trdot] width=16 height=1 align=top>");
        }
      }
      echo("</td></tr>\n");
    }

    echo("<tr>");
    if ($row[id] == $current) { echo("<td bgcolor=$env[td]><a name=current>"); }
    else { echo("<td>"); }

    for ($i = 1; $i <= $indent; $i++) {
      if ($lstyle[$i] == 'l') {
        echo("<img border=0 src=$env[icon_tree_end] align=top>");
      } else if ($lstyle[$i] == 't') {
        echo("<img border=0 src=$env[icon_tree_split] align=top>");
      } else if ($lstyle[$i] == 'i') {
        echo("<img border=0 src=$env[icon_tree_vertline] align=top>");
      } else if ($lstyle[$i] == 's') {
        echo("<img border=0 src=$env[icon_tree_space] align=top>");
      }
    }

    $comment = ($row[comment]) ? $row[comment] : "";
    $icon = ($row[public]=='0') ? $env[icon_hfo] : $env[icon_fo];

    # new_img
    $t1 = GetTimeStamp($row[rdate]);
    $t2 = time();
    $diff = $t2 - $t1;
    $new_img = ($diff < $env[newtime]) ?  " <img src=$env[icon_new] alt='$lang[list_2]'>" : "";


    echo("<img src=$icon width=$env[icon_size_x] height=$env[icon_size_y] border=0 align=top>");

    # items in the clipboard
    if (in_array($row[id], $env[clipitems])) {
      echo("<a href=clipboard.php><img src=$env[icon_clipboard] width=$env[icon_size_x] height=$env[icon_size_y] border=0 align=top alt='cliped in clipboard'></a>");
    }

    echo(" <a href=$file.php?id=$row[id]$options>$row[title]</a>$new_img");
    if ($row[id] == $current) { echo $lang[current_fld]; }
    echo(" $comment<br>");
    echo("</td></tr>\n");

    if ($cnt_c % 20 == 0) { # separate long table
      echo("</table><table border=0 cellpadding=0 cellspacing=0 width=100%>\n");
    }

    if ($j == $total) { $lstyle[$indent] = 's'; }
    else $lstyle[$indent] = 'i';
    ListSubFolder($row, $indent+1, $file, $options, $current); # recursive call
    $lstyle[$indent] = 't';
  }
  if ($depth == 0) { # first call
    echo("</table>\n");

    echo("<table border=0 cellpadding=2 cellspacing=0 width=100%>\n");
    echo("<tr><td bgcolor=$env[th]><img src=$env[icon_fo] width=$env[icon_size_x] height=$env[icon_size_y]>$lang[list_3] : $cnt_c</td>\n");
    echo("</tr></table>\n");
  }
}

# print a button
function ButtonPrint($btn_str, &$btns_row) {
  global $env;

  # print icon
  if (!$btns_row) echo("&nbsp;");
  echo("$btn_str\n");
  $btns_row++;

  # move to next line
  if ($env[buttons_in_a_row] && $btns_row >= $env[buttons_in_a_row]) {
    $btns_row = 0; echo("<br>\n");
  }
}

# display button group
function ButtonSet() {
  global $env, $lang;

  $btn_gap = 5;
  $attr = " class=\"icon\"";
  $target_str = $env[aid_target];

  $separator = "<img src='$env[icon_trdot]' width='$btn_gap' height='1'>";
  $btns_row = 0;

  echo("<table border='0' width='100%' cellpadding='0' cellspacing='0'>
<tr><td align='$env[buttons_align]'>\n");

  if ($env[show_resize_icon]) {
    echo("<script>
var wsize = 0;
function Resize2() {
  if (wsize == 0) ResizeWindow('$env[resize_wx]', '$env[resize_wy]');
  else if (wsize == 1) ResizeWindow('$env[resize_wx2]', '$env[resize_wy2]');
  wsize = (wsize + 1) % 2;
}
</script>\n");
  }

  # list buttons
  $icon_name = ($env[show_icon_name]) ? $lang['list'] : "";
  if ($env[script_name] == 'list') $icon_name = "<b>$icon_name</b>";
  $icon_alt = $lang[btnset_15];
  $btn_str = "<a href='list.php'><img src='$env[icon_bk]' alt='$icon_alt'$attr>$icon_name</a>";
  ButtonPrint($btn_str, &$btns_row);

  if ($env[tree_view] && $env[script_name]=='list' && $env[show_expand_icon]) {
    # expand/collapse buttons
    if ($env[exp] != '*') {
      $icon_name = ($env[show_icon_name]) ? $lang[expand] : "";
      $icon_alt = $lang[btnset_5];
      $gif = $env[icon_expand];
      $url = 'list.php?exp=*';
    } else {
      $icon_name = ($env[show_icon_name]) ? $lang[collapse] : "";
      $icon_alt = $lang[btnset_6];
      $gif = $env[icon_collapse];
      $url = 'list.php';
    }
    $btn_str = $separator."<a href='$url' title='$icon_alt'><img src=$gif alt='$icon_alt'$attr>$icon_name</a>";
    ButtonPrint($btn_str, &$btns_row);
  }

  if ($env[script_name] == 'list' && $env[show_onlyfolder_icon]) {
    # folder/bookmark buttons
    if ($env[only_folder]) {
      $url = urlencode("list.php?exp=$env[exp]");
      $url = "setenv.php?key=FOLDERONLY&val=0&url=$url";
      $gif = $env[icon_bk];
      $icon_alt = $lang[btnset_11];
      $icon_name = ($env[show_icon_name]) ? $lang[bookmark] : "";
    } else {
      $url = urlencode("list.php?exp=$env[exp]");
      $url = "setenv.php?key=FOLDERONLY&val=1&url=$url";
      $gif = $env[icon_fo];
      $icon_alt = $lang[btnset_12];
      $icon_name = ($env[show_icon_name]) ? $lang[folder] : "";
    }
    $btn_str = $separator."<a href='$url'$target_str title='$icon_alt'><img src=$gif alt='$icon_alt'$attr>$icon_name</a>";
    ButtonPrint($btn_str, &$btns_row);
  }

  # paste buttons
  if ($env[script_name]=='list' # appear only in list.php
      && $env[show_paste_icon] # paste icon is on in preference
      && !$env[guest] # guests can not paste
      && GetCookie("CLIPBRD")) { # clipboard is not empty
    $url = "clipboard.php?mode=move&id=$env[root]";
    $gif = $env[icon_clipboard];
    $icon_alt = sprintf($lang[btnset_13], sizeof($env[clipitems]));
    $icon_name = ($env[show_icon_name]) ? $lang[paste] : "";
    $btn_str = $separator."<a href='$url'$target_str title='$icon_alt'><img src=$gif alt='$icon_alt'$attr>$icon_name</a>";
    ButtonPrint($btn_str, &$btns_row);
  }

  # add buttons
  if (!$env[guest]) {
    $exp_parm = ($env[tree_view]) ? "&exp=$env[exp]" : "";
    $icon_name = ($env[show_icon_name]) ? $lang[add] : "";
    if ($env[script_name] == 'addform') $icon_name = "<b>$icon_name</b>";
    $icon_alt = $lang[btnset_2];
    $btn_str = $separator."<a href='addform.php?id=$env[root]$exp_parm'$target_str title='$icon_alt'><img src=$env[icon_add] alt='$icon_alt'$attr>$icon_name</a>";
    ButtonPrint($btn_str, &$btns_row);
  }

  # visited buttons
  if (!$env[guest] && $env[show_visited_icon]) {
    $exp_parm = ($env[tree_view]) ? "&exp=$env[exp]" : "";
    $icon_name = ($env[show_icon_name]) ? $lang[visited] : "";
    if ($env[script_name] == 'visited') $icon_name = "<b>$icon_name</b>";
    $icon_alt = $lang[btnset_3];
    $btn_str = $separator."<a href='visited.php?id=$env[root]$exp_parm'$target_str title='$icon_alt'><img src=$env[icon_visited] alt='$icon_alt'$attr>$icon_name</a>";
    ButtonPrint($btn_str, &$btns_row);
  }

  # clipboard buttons
  if ($env[show_clipbrd_icon] && !$env[guest]) {
    $url = 'clipboard.php';
    $gif = $env[icon_clipboard];
    $icon_alt = sprintf($lang[btnset_10], sizeof($env[clipitems]));
    $icon_name = ($env[show_icon_name]) ? $lang[clipboard] : "";
    if ($env[script_name] == 'clipboard') $icon_name = "<b>$icon_name</b>";
    $btn_str = $separator."<a href='$url'$target_str title='$icon_alt'><img src=$gif alt='$icon_alt'$attr>$icon_name</a>";
    ButtonPrint($btn_str, &$btns_row);
  }

  # preference buttons
  if (!$env[guest] && $env[use_user_config]) {
    $icon_name = ($env[show_icon_name]) ? $lang[preference] : "";
    if ($env[script_name] == 'preference') $icon_name = "<b>$icon_name</b>";
    $icon_alt = $lang[btnset_7];
    $btn_str = $separator."<a href='preference.php'$target_str title='$icon_alt'><img src=$env[icon_config] alt='$icon_alt'$attr>$icon_name</a>";
    ButtonPrint($btn_str, &$btns_row);
  }

  # memo buttons
  if (!$env[guest] && $env[show_memo_icon]) {
    $icon_name = ($env[show_icon_name]) ? $lang[memo] : "";
    if ($env[script_name] == 'memo') $icon_name = "<b>$icon_name</b>";
    $icon_alt = $lang[btnset_8];
    $btn_str = $separator."<a href='memo.php'$target_str title='$icon_alt'><img src=$env[icon_memo] alt='$icon_alt'$attr>$icon_name</a>";
    ButtonPrint($btn_str, &$btns_row);
  }

  # calendar buttons
  if (!$env[guest] && $env[show_calendar_icon]) {
    $icon_name = ($env[show_icon_name]) ? $lang[calendar] : "";
    if ($env[script_name] == 'calendar') $icon_name = "<b>$icon_name</b>";
    $icon_alt = $lang[btnset_16];
    $btn_str = $separator."<a href='calendar.php'$target_str title='$icon_alt'><img src=$env[icon_calendar] alt='$icon_alt'$attr>$icon_name</a>";
    ButtonPrint($btn_str, &$btns_row);
  }

  # address book buttons
  if (!$env[guest] && $env[show_address_icon]) {
    $icon_name = ($env[show_icon_name]) ? $lang[address_0] : "";
    if ($env[script_name] == 'address') $icon_name = "<b>$icon_name</b>";
    $btn_str = $separator."<a href='address.php'$target_str><img src='$env[icon_address]'$attr>$icon_name</a>";
    ButtonPrint($btn_str, &$btns_row);
  }

  # trash buttons
  if (!$env[guest] && $env[show_trash_icon]) {
    $icon_name = ($env[show_icon_name]) ? $lang[trash] : "";
    if ($env[script_name] == 'trash') $icon_name = "<b>$icon_name</b>";
    $icon_alt = $lang[btnset_14];
    $btn_str = $separator."<a href='trash.php'$target_str title='$icon_alt'><img src=$env[icon_delete] alt='$icon_alt'$attr>$icon_name</a>";
    ButtonPrint($btn_str, &$btns_row);
  }

  # resize buttons
  if ($env[show_resize_icon]) {
    $icon_name = ($env[show_icon_name]) ? $lang[resize] : "";
    $icon_alt = "";
    $href = "javascript:Resize2()";
    $btn_str = $separator."<a href=\"$href\"><img src='$env[icon_resize]' alt='$icon_alt'$attr>$icon_name</a>";
    ButtonPrint($btn_str, &$btns_row);
  }

  # reload buttons
  if ($env[show_reload_icon]) {
    $icon_name = ($env[show_icon_name]) ? $lang['reload'] : "";
    $icon_alt = $lang[reload];
    $href = "javascript:window.location.reload()";
    $btn_str = $separator."<a href=\"$href\"><img src='$env[icon_reload]'$attr>$icon_name</a>";
    ButtonPrint($btn_str, &$btns_row);
  }

  # search buttons
  if ($env[show_search_icon]) {
    $icon_name = ($env[show_icon_name]) ? $lang[search] : "";
    if ($env[script_name] == 'searchform') $icon_name = "<b>$icon_name</b>";
    $icon_alt = $lang[btnset_17];
    if ($env[adv_search_button]) $href = "searchform.php";
    else {
      $fading = ($env[h_layer_fading]) ? '1' : '0';
      $href = "javascript:ShowHistoryLayer('$env[search_focus]', $fading)";
    }
    $btn_str = $separator."<a href=\"$href\" title='$icon_alt'><img src=$env[icon_search] alt='$icon_alt'$attr>$icon_name</a>";
    ButtonPrint($btn_str, &$btns_row);
  }

  # new window buttons
  if ($env[show_window_icon]) {
    $icon_name = ($env[show_icon_name]) ? $lang[btnset_18] : "";
    $icon_alt = $lang[btnset_18];
    $href = "javascript:void(window.open('list.php','bm4u_remote','width=600,height=300,scrollbars=1,resizable=1,status=1'))";
    $btn_str = $separator."<a href=\"$href\" title='$icon_alt'><img
  src='$env[icon_weather]'$attr>$icon_name</a>";
    ButtonPrint($btn_str, &$btns_row);
  }

  # import buttons
  if (!$env[guest] && $env[show_import_icon]) {
    $icon_name = ($env[show_icon_name]) ? $lang[import] : "";
    if ($env[script_name] == 'import') $icon_name = "<b>$icon_name</b>";
    $icon_alt = $lang[import];
    $btn_str = $separator."<a href='import.php'$target_str title='$icon_alt'><img src='$env[icon_import]' alt='$icon_alt'$attr>$icon_name</a>";
    ButtonPrint($btn_str, &$btns_row);
  }

  # export buttons
  if (!$env[guest] && $env[show_export_icon]) {
    $icon_name = ($env[show_icon_name]) ? $lang[export] : "";
    if ($env[script_name] == 'export') $icon_name = "<b>$icon_name</b>";
    $icon_alt = $lang[export];
    $btn_str = $separator."<a href='export.php'$target_str title='$icon_alt'><img src='$env[icon_export]' alt='$icon_alt'$attr>$icon_name</a>";
    ButtonPrint($btn_str, &$btns_row);
  }

  # etc buttons
  if (!$env[guest]) {
    $icon_name = ($env[show_icon_name]) ? $lang[etc] : "";
    if ($env[script_name] == 'etc') $icon_name = "<b>$icon_name</b>";
    $icon_alt = $lang[btnset_4];
    $btn_str = $separator."<a href='etc.php'$target_str title='$icon_alt'><img src='$env[icon_etc]' alt='$icon_alt'$attr>$icon_name</a>";
    ButtonPrint($btn_str, &$btns_row);
  }

  echo("</td></tr></table>\n");

  if (!$env[guest] && $env[quick_links]) {
    echo("<table border='0' width='100%' cellpadding='0' cellspacing='0'>
<tr><td align='$env[buttons_align]'>\n");
    QuickLinks();
    echo("</td></tr></table>\n");
  }

}

# display quick links
function QuickLinks() {
  global $env, $lang;
  global $mgr;

  $btn_gap = 5;
  $attr = " class=\"icon\"";
  $target_str = $env[aid_target];

  $sep = "<img src='$env[icon_trdot]' width='$btn_gap' height='1'>";
  $btns_row = 0;

  $return = $mgr->findQuickLinks();

  $cnt = 0;
  while ($row = $return->fetchRow()) {

    $icon = "";
    $img_str = GetIconString($row, $icon);

    $row3 = $row;
    if ($row[type] == 'l') {
      $row2 = $mgr->findItemById($row[lnid]);
      $row3 = $row2;
      $row3[title] = $row[title];
    }

    if ($row3[type] == 'b') {
      $title_str = GetTitleString($row3, " target='_blank'");
    } elseif ($row3[type] == 'c') {
      $title_str = "<a href='list.php?root=$row3[id]'>$row3[title]</a>";
    }

    if ($cnt) echo(" ");
    echo("<nobr><a
 href='modifyform.php?id=$row[id]'>$img_str</a>$title_str</nobr> \n");
    $cnt++;
  }
}

function HistoryLayer() {
  global $env, $lang;
  global $mgr;
  global $HTTP_SERVER_VARS;

  if ($env[h_layer_fading]) $style = " style=\"filter:revealTrans(transition=23,duration=0.5) blendTrans(duration=0.5);\""; else $style = "";
# echo("<div id='Drag' onmousedown='javascript:beginDrag()'$style>\n");
  echo("<div id='Drag' onmousedown='javascript:beginDrag(event)'$style>\n");

  # history layer border
  echo("<table width=100% border=0 cellspacing=0 cellpadding=2>
<tr><td bgcolor=$env[th]>\n");

  $query_string = ($HTTP_SERVER_VARS['QUERY_STRING'])
           ? $HTTP_SERVER_VARS['QUERY_STRING'] : "dummy=$env[dummy]";
  $url = "$HTTP_SERVER_VARS[PHP_SELF]?$query_string";

  # title bar
  echo("<table width=100% border=0 cellspacing=0 cellpadding=3>
 <tr>
 <td bgcolor=$env[td] align=center width=100% onmouseover=\"javascript:if (document.all) {this.style.cursor='hand';} else {this.style.cursor='pointer';}\">
 <b>$lang[historylayer_0]</b></td>
 <td align=right bgcolor=$env[td] width=$env[icon_size_x]><nobr>");
  if ($env[history_layer_show]) {
  # echo("<a href=\"javascript:HL_Fix()\"><img
  # src=$env[icon_fix] align=top border=0></a>");
    echo("<img src=$env[icon_fix] align=top border=0>");
    echo("<a href=\"javascript:HL_Float('$url')\"><img
    src='$env[icon_close]' border=0></a>");
  } else {
    echo("<a href=\"javascript:HL_Fix('$url')\"><img
    src=$env[icon_float] align=top border=0></a>");
    $fading = ($env[h_layer_fading]) ? '1' : '0';
    echo("<a href=\"javascript:HideHistoryLayer($fading)\"><img
    src='$env[icon_close]' border=0></a>");
  }
  echo("</nobr></td></tr>\n");

  # search history title
  echo("<tr><td colspan=2 bgcolor=$env[th] align=center>\n");
  echo("<img src=$env[icon_search] align=top>
  <b>$lang[historylayer_1]</b>
  (<a href='search.php?mode=edit_history'><img src=$env[icon_clear]
  align=top border=0></a>)\n");
# (<a href='setenv.php?key=SEARCHES&val='><img src=$env[icon_clear]
  echo("</td></tr>\n");

  # search keywords list
  echo("<tr><td colspan='2' bgcolor='$env[td]'>\n");
  for ($i = 0; $i < sizeof($env[searchwords]); $i++) {
    $key = $env[searchwords][$i];
    echo("<a href='search.php?k=$key'>$key</a><br>\n");
  }
  echo("</td></tr>\n");

  # search form
  echo("<form action=search.php name=searchform3>
  <tr><td bgcolor=$env[th] colspan='2' align='center'>\n");
  echo("<a href=\"javascript:document.searchform3.k.select()\">
  <b>$lang[search]:</b></a>
  <input type=text name=k size=10");
  if ($env[autoselect])
    echo(" onclick=\"javascript:document.searchform3.k.select();\"");
  echo(">");
  echo("<a href=\"javascript:document.searchform3.submit();\"><img
  src='$env[icon_search]' align='top' border='0'></a><br>");
  echo("<img src='$env[icon_search]' align='top' border='0'>
  <a href='searchform.php'>$lang[search_2]</a></td></tr></form>\n");

  # recent folders / bookmarks
  if (!$env[guest] && $env[h_layer_folist]) { # guest can't see recent folders
    echo("<tr><td align=center colspan=2><img src=$env[icon_fo] align=top>
    <b>$lang[historylayer_2]</b></td></tr>\n");

    echo("<tr><td bgcolor=$env[td] colspan=2>\n");
    $order = "lastvisit DESC LIMIT $env[history_max]";
 # if ($env[guest]) $only_public = true;  # skip private folder if guest
 # else
    $only_public = false;
    $return = $mgr->findAllFolders($order, $only_public);
    while( $row = $return->fetchRow() ) {
      # skip private folder if in guest mode
      if ($env[guest] && IsPrivate($row[id])) continue;
      else echo("<a href=list.php?root=$row[id]>$row[title]</a><br>\n");
    }
    echo("</td></tr>\n");
  }

  if (!$env[guest] && $env[h_layer_bklist]) { # guest can't see recent folders
    echo("<tr><td align=center colspan=2 nowrap><img src=$env[icon_bk]
    align=top> <b>$lang[historylayer_3]</b></td></tr>\n");

    echo("<tr><td bgcolor=$env[td] colspan='2'>\n");
    $order = "lastvisit DESC LIMIT $env[history_max]";
 # if ($env[guest]) $only_public = true;  # skip private folder if guest
 # else
    $only_public = false;
    $return = $mgr->findAllBookmarks($order, $only_public);
    while( $row = $return->fetchRow() ) {
      # skip private folder if in guest mode
      if ($env[guest] && IsPrivate($row[id])) continue;
      $target = "$env[main_target]";
      if ($env[usecount]) {
        $str = "<a href='linkto.php?id=$row[id]'$target>$row[title]</a>";
      } else {
        $str = "<a href=\"$row[url]\"$target>$row[title]</a>";
      }
      echo("$str<br>\n");
    }
    echo("</td></tr>\n");
  }

  echo("</table>\n");
  echo("</td></tr></table>\n"); # history layer border
  echo("</div>\n");
}

# search options
function SearchOptions($form) {
  global $env, $lang;
  global $mgr;
  global $k;

  echo("<a href=\"javascript:document.$form.k.select()\">$lang[search]</a>:
 <input type='text' name='k' size='10' value=\"$k\"");
  if ($env[autoselect])
    echo(" onclick=\"javascript:document.$form.k.select();\"");
  echo(">");

  if (!$env[hide_searchform]) {
    if ($env[search_history]) {
      echo("<select name=history onchange=\"SelectHistory(document.$form);\">\n");
      echo("<option value=''>-- $lang[historylayer_1] --\n");
      for ($i = 0; $i < sizeof($env[searchwords]); $i++) {
        $key = $env[searchwords][$i];
        echo("<option value='s:$key'>$key</option>\n");
      }

      echo("<option value=''>-- $lang[historylayer_2] --\n");
      $result = $mgr->findAllFolders("lastvisit DESC LIMIT $env[history_max]");
      while ($row = $result->fetchRow() ) {
        echo("<option value='f:$row[id]'>$row[title]</option>\n");
      }
      echo("</select>\n");
    }
  }

  echo("<input type=hidden name=w value='a'>");
  echo("<a href=\"javascript:document.$form.submit();\"");
  echo("><img
 src=$env[icon_zoom] border=0 alt='Search' width=$env[icon_size_x] height=$env[icon_size_y]></a>\n");
}

# get the parent of the child
function Parent($child) {
  global $env;
  global $mgr;

  $row = $mgr->findItemById($child);
  return $row[parent];
}

# Check if child is one of children under parent
# Visit from child to root
function IsChildFolder($parent, $child) {
  global $user;

  # if reaches to root then return 0(false)
  if ($child == '0') return 0;
  # get the parent of child
  $p = Parent($child);
  # if p is parent then return 1(true)
  if ($p == $parent) return 1;
  # otherwise continue until root
  if (IsChildFolder($parent, $p)) return 1;
  else return 0;
}

# return true if id is private
function IsPrivate($id) {
  global $env;
  global $mgr;

  while ($id > 0) {
    $row = $mgr->findItemById($id);
    if (!$row[public]) return 1; # is private
    $id = $row[parent];
  }
  return $env[default_public_import]; # is public default
}

# cut a long string to specified length
# return true $str has been cut, return false if $str has not been changed
function CutString(&$str, $length) {
  if (strlen($str) <= $length) return $str;
  $str = substr($str, 0, $length);
  $str = "$str...";
  return 1;
}

# The 'total' field in a user bookmark table is the number of
# included bookmarks in a folder, for a bookmark, this value is set to 1.
# Update 'total' value of folders visiting from a folder in which bookmark
# was added (or deleted) to the root folder.
function UpdateTotalLeaf($id) {
  global $env, $mgr;

  while ($id != '') {
    $row = $mgr->findItemById($id);

    # calculate the sum of 'total' of children of id
    if ($row[type] == 'b') $total = 1;
    else $total = $mgr->getChildrenTotalNumber($id);

    # update the total value of id
    $row[total] = $total;

    $mgr->updateItem($row);

    # get the parent of id
    $parent = $row[parent];

    # if parent is root, then break
    if ($parent == 0) break;

    # otherwise set id to parent and continue
    $id = $parent;

#   $qry = "SELECT SUM(total) AS sum FROM $env[userbm] WHERE parent=$id";
#   $row = DBQueryAndFetchRow($qry);
#   $total = ($row[sum]) ? $row[sum] : 0;

#   # update the total value of id
#   $qry = "UPDATE $env[userbm] SET total=$total WHERE id=$id";
#   $result = DBQuery($qry);

#   # get the parent of id
#   $qry = "SELECT parent FROM $env[userbm] WHERE id=$id";
#   $row = DBQueryAndFetchRow($qry);
#   $parent = $row[parent];

#   # if parent is root, then break
#   if ($parent == 0) break;

#   # otherwise set id to parent and continue
#   $id = $parent;
  }
}

# load user configuration from config table in the database
function LoadUserConfig($uid=0, $prefix="") {
  global $env, $userMgr;
  global $conf;

  if (!$uid) $uid = $env[uid];
  if (!$uid) return;

  $row = $userMgr->findUserConfig($uid);
  DBError();
  $config_arr = explode("\r\n", $row[config]);
# echo sizeof($config_arr);

  $ret = array();
  for ($i = 0; $i < sizeof($config_arr); $i++) {
    $line = trim($config_arr[$i]);
    if (substr($line,0,1) == "#") continue;  # skip comment line

    list($key, $val) = split("=", $line, 2);
    $pos = strpos($val, "#");  # remve comment at the end of line
    if ($pos) $val = substr($val, 0, $pos);
    $key = trim($key);
    $val = trim($val);

    if (!$key) continue;
    if (!ereg("[^\.]*\..*", $key)) {  # keys not including '.'
      if ($val != "") $ret[$key] = $val;
    # echo("'$key' = '$val'<br>\n");
    }
  }
  $ret = array_merge($ret, $conf);

  # No user can override these variables
  unset($ret[user]);
  unset($ret[uid]);
  unset($ret[logined]);
  unset($ret[dbhost]);
  unset($ret[dbname]);
  unset($ret[dbuser]);
  unset($ret[dbpasswd]);
  unset($ret[dbtype]);
  unset($ret[dbtbladdress]);
  unset($ret[dbtblcalendar]);
  unset($ret[dbtblconfig]);
  unset($ret[dbtblmemo]);
  unset($ret[dbtbltrash]);
  unset($ret[dbtblpasswd]);
  unset($ret[dbtblpasswdtmp]);
  unset($ret[userdb_prefix]);
  unset($ret[mysql_version_before_3_22_5]);
  unset($ret[sitehome]);
  unset($ret[myicon_dir]);
  unset($ret[bgimg_dir]);
  unset($ret[registration_verify]);
  unset($ret[register_global_off]);
  unset($ret[allow_guest_login]);
  unset($ret[admin_email]);
  unset($ret[meta_author]);
  unset($ret[meta_title]);
  unset($ret[meta_description]);
  unset($ret[meta_keywords]);
  unset($ret[cookie_prefix]);
  return $ret;
}

# fetch a user record from passwd table
# return the resulting row
function FetchUserRecord($user) {
  global $userMgr;
  $row = $userMgr->findUserByLogin($user);

  if (!$row) Error("User '$user' does not exist.");
  return $row;
}

# check if url is a URL string prefixed with http://, ftp://, mailto: or etc.
# $url is called by reference
# return 0 if success
function ToURLString(&$url) {
  $reg1 = "(http|https|ftp|telnet|news|file):\/\/";
  $reg2 = "(mailto):";
  if (ereg("$reg1", $url) || ereg("$reg2", $url)) return 1;
  $url = "http://$url";
  return 0;
}

# check if string $url is a valid URL address
# return 'alive' if the server is alive, return 'dead' if the server is dead
# reporting message is returned in the $msg
# contributed by Eric Meddaugh
function LinkAlive($url, &$msg) {
  global $env, $lang;

  $msg = "";  # return message
  # parse url string
  $url_arr = parse_url($url);

  $server = $url_arr[host]; # server host
  $path = $url_arr[path]; # path
  if ($url_arr[port]) { # if port number is specified
    $port = $url_arr[port];
  }
  # known protocol port numbers (port number is not specified)
  else if ($url_arr[scheme] == 'http')  $port = 80;
  else if ($url_arr[scheme] == 'ftp')   $port = 21;
  else if ($url_arr[scheme] == 'https') $port = 443;

  $ipaddr = gethostbyname($server);  # get server's IP address
  if ($ipaddr == $server) $msg .= "IP unknown";
  else $msg .= "$ipaddr";
  if ($env[url_check_only_ip]) {
    return 'unknown';  # server stat is unknown
  }

  $time1 = TimeStampUsec(); # start checking time
  $timeout = (int)$env[urlcheck_timeout];
  $fp = fsockopen($server, $port, $errno, $errstr, $timeout);

  if (!$fp) {
    $time2 = TimeStampUsec();
    $diff = ($time2 - $time1) / 1000;
    $msg .= " $diff msec";
    return 'dead'; # link is *not* valid
  } else {
    if ($url_arr[scheme] == 'http') {
      fputs($fp, "HEAD http://$server$path HTTP/1.0\r\n\r\n");
      $tmpmsg = "";
      while (!feof($fp)) {
        $line = fgets($fp, 128);
        $tmpmsg .= $line;
      }
    }
    fclose ($fp);
    $tmpmsg = strip_tags($tmpmsg);
    $tmp_arr = preg_split("/ /", $tmpmsg);
    # Need to try again for other vhosts....
    if ($tmp_arr[1] == 400 || $tmp_arr[1] == 404 || $tmp_arr[1] == 403) { 
      $tmpmsg = "";
      $fp = fsockopen($server, $port, $errno, $errstr, $timeout);
      fputs ($fp, "HEAD $path HTTP/1.0\r\nHost: $server\r\n\r\n");
      while (!feof($fp)) {
        $line = fgets($fp, 128);
        $tmpmsg .= $line;
      }
      fclose($fp);
      $tmpmsg = strip_tags($tmpmsg);
      $tmp_arr = preg_split("/ /", $tmpmsg);
    }

    if ($tmp_arr[1] == 200) { $msg .= " VALID"; }
    elseif ($tmp_arr[1] == 404) { $msg .= " <b>NOT FOUND</b>"; }
    elseif ($tmp_arr[1] == 301) { $msg .= " <b>MOVED PERMANTLY</b>"; }
    elseif ($tmp_arr[1] == 302) { $msg .= " <b>MOVED TEMPORARILY</b>"; }
    elseif ($tmp_arr[1] == 401) { $msg .= " <b>UNAUTHORIZED</b>"; }
    elseif ($tmp_arr[1] == 403) { $msg .= " <b>FORBIDDEN</b>"; }
    elseif ($tmp_arr[1] == 500) { $msg .= " <b>INTERNAL SERVER ERROR</b>"; }
    elseif ($tmp_arr[1] == 501) { $msg .= " <b>NOT IMPLEMENTED</b>"; }
    elseif ($tmp_arr[1] == 503) { $msg .= " <b>SERVICE UNAVAILABLE</b>"; }

    $time2 = TimeStampUsec();
    $diff = (int)(($time2 - $time1) / 1000);
    $msg .= " $diff msec";
    return 'alive'; # link is valid
  }
}

# set cookies while login
function SetLoginCookies($user, $uid, $time, $persist=0) {
  global $env;

  if ($user == 'admin') Error("admin cannot login as a normal user");

  if ($persist) $ptime = time() + (int)$env[persist_duration];

  PutCookie("USER", $user, $ptime);
  PutCookie("UID", $uid, $ptime);
  PutCookie("TIME", $time, $ptime);
  PutCookie("GUEST_MODE", "", $ptime);
  if ($env[secure_cookie]) { # use hashed cookie
    $token = md5("$user:$uid:$time:$env[static_cookie]:$env[dbname]");
  } else { # use a unhashed cookie
    $token = $env[static_cookie];
  }
  PutCookie("TOKEN", $token, $ptime);
}

# clear all cookies
function ClearCookies($time=0) {
  global $HTTP_COOKIE_VARS, $conf;

  $keys = array_keys($HTTP_COOKIE_VARS);
  $len = sizeof($keys);
  for ($i = 0; $i < $len; $i++) {
    $key = $keys[$i];
    setcookie($key, "", $time, "/"); # use $conf[sitehome] instead of "/" if problem
    setcookie($key, "", $time); # for updating from 1.8.3 to 1.8.4 
  }    
}


# check password and update login information of database
function LoginAndUpdate($user, $passwd, $skip_chk_pw=0) {
  global $env, $lang;
  global $userMgr, $mgr;
  global $HTTP_SERVER_VARS;

  if (!$skip_chk_pw) {
    # check if password is correct
    $row = $userMgr->checkAccess($passwd, $user);
    if ($row[user] != $user) Error($lang[msg_wrong_pw]);
  } else {
    $row = $userMgr->findUserByLogin($user);
    if ($row == null || DB::isError()) Error($lang[msg_auth_fail]);
  }

  # set $env[user] and $env[uid]
  $env[user] = $user;
  $env[uid] = $row[uid];

  # update managers
  $userMgr->setUser($user);
  $mgr->setUser($user);

  # set global variables for displaying while login
  global $lastlogin, $lastip;
  $lastlogin = $row[lastlogin];
  $lastip = $row[lastip];

  # update the last login time and IP of this user
  $userMgr->updateUserLoginInfos();
}

# move an item with id=$which under $where, change parent field
# return 0 if success, return 1 if fail
function MoveItem($which, $where) {
  global $env, $mgr;

  if ($which == $where || IsChildFolder($which, $where)) {
    return 1;  # can't move
  }

  $row = $mgr->findItemById($which);

  # move 'which' under 'id'
  $mgr->moveItem($which, $where);

  UpdateTotalLeaf($row[parent]);
  UpdateTotalLeaf($where);
  return 0; # success
}

# delete a bookmark or folder including children folders
function MoveItemToTrash($id, $notrash=0) {
  global $env, $mgr;

  if (!$notrash) {
    # select one to be moved into trash
    $row = $mgr->findItemById($id);

    # insert into trash
    $trashMgr = createTrashManager();
    $trashMgr->addItem($row);
    DBError();
  }

  # delete it
  $mgr->deleteItem($id);
  DBError();
}
function DeleteItem($id, $notrash=0) {
  global $env, $mgr;

  # delete children
  $result = $mgr->findItems($id);
  while ($row = $result->fetchRow()) {
    if ($row[type] == 'c') {
      DeleteItem($row[id], $notrash); # recursive calls
    } else if ($row[type] == 'b') {
      MoveItemToTrash($row[id], $notrash);
    }
  }

  # delete itself
  MoveItemToTrash($id, $notrash);
}

# display recently opened folder
# options is attatched to url ex) $options = "&which=this&when=now"
# compatable to ListFolder()
function ListRecentFolder($file, $options) {
  global $env, $mgr;
  global $lang;

  # select folders visited lately or modified lately
  if ($env[mysql_version_before_3_22_5]) $qryOrder .= "MAX(lastvisit)";
  else $qryOrder .= "GREATEST(lastvisit,rdate)";
  $qryOrder .= " DESC LIMIT $env[ipp]";
  $result = $mgr->findAllFolders($qryOrder);
  DBError();

  if ($env[line_gap]) {
    $img = $env[icon_trdot];
    $height = $env[line_gap] * 2;
    $gap_str = "<tr><td>"
              ."<img border=0 src='$img' width=16 height=$height>"
              ."</td></tr>\n";
  } else $gap_str = "";

  echo("<table border=0 cellpadding=0 cellspacing=0 width=100%>\n");

  while ($row = $result->fetchRow()) {
    echo $gap_str;
    echo("<tr><td>
<a href=$file.php?id=$row[id]$options><img src=$env[icon_fo] width=$env[icon_size_x] height=$env[icon_size_y] align=top border=0> $row[title]</a>
</td></tr>");
  }

  echo("</table>\n");
}

# display the path of an item in the bookmark tree
function PrintPath($row, $bold=1, $self=1) {
  global $env, $mgr;

  $str = "";
  $parent = $row[parent];

  # private items in blured text
  if (!$row[public]) $title = "<font color=$env[blur]>$row[title]</font>";
  else $title = $row[title];

  if ($self) {
    if ($row[type]=='c') {
      $str = " / <a href='list.php?root=$row[id]'>$title</a>" . $str;
    } else if ($row[type]=='b') {
      $str = " / <a href='linkto.php?id=$row[id]'$env[main_target]>$title</a>" . $str;
    }
  }
  while ($parent > 0) {
    $row = $mgr->findItemById($parent);

    # private items in blured text
    if (!$row[public]) $title = "<font color=$env[blur]>$row[title]</font>";
    else $title = $row[title];

    if (!$row) {
      $str = " / ($parent)NULL" . $str;
    } else {
      $str = " / <a href=list.php?root=$row[id]>$row[title]</a>" . $str;
    }
    $parent = $row[parent];
  }
  $top_folder_name = sprintf($env[top_folder_name], $env[user]);
  $str = "<a href=list.php?root=0>$top_folder_name</a>" . $str;

  if ($bold) echo("<b>$str</b>\n");
  else echo("$str\n");
}

# read a directory to get a list of available subdirectories
# $dirname is 'theme' or 'lang'
function GetSubDirs($dirname) {
  global $env;

  unset($ret);
  # $path = "$env[script_path]/$dirname";
  # $env[script_path] : script path in file system  e.g. "/www/html/bookmark4u"

  ####RHe: script_path ends with /preference.php on Win32
  ##         remove the filename part of the url to get basedir.

  #--echo("ScriptPath: <b>$env[script_path]</b><br />\n");
  #--echo("   DirName: <b>$dirname</b><br />\n");

  ##
  $sTmp = $env[script_path];
  $sTmp = ereg_replace("/[^/]*\.php", "", $sTmp); # strip php filename
  #--echo("      sTmp: <b>$sTmp</b><br />\n");

  #$path = "$env[script_path]/$dirname";
  $path = "$sTmp/$dirname";
  ####:RHe.

  $handle = opendir("$path");
  $cnt = 0;
  while ($dir = readdir($handle)) {
    if (ereg("^\.", $dir)) continue;
    if (is_dir("$path/$dir")) {
      $ret[$cnt] = $dir;
      $cnt++;
    }
  }
  closedir($handle);
  sort($ret);
  return $ret;
}

# print links to switch between pages of item list
# $url is a base URL to link, make anchors such as <a href='$url&page=#'>#</a>
# $page is current page number
# $total is total number of items of the list
# display $env[ipp] items in a pages
function Pager($url, $page, $total) {
  global $env, $lang;
  if ($env[pager_type] == '1') {
    PagerType1($url, $page, $total);
  } else {
    PagerType2($url, $page, $total);
  }
}
function PagerType1($url, $page, $total) {
  global $env, $lang;

  $prevpage = $page - 1;
  $nextpage = $page + 1;

  # previous link
  if ($prevpage > 0) {
    echo("<a href='$url&page=$prevpage'>&lt;&lt;$lang[prev]</a>");
  } else echo("&lt;&lt;$lang[prev]");

  echo(" | ");
  $start = ($page > 5) ? $page - 4 : 1;
  $end = ceil($total/$env[ipp]);
  if ($end - $start + 1 > 10) $end = $start + 10 - 1;
  if ($end - $start + 1 < 10) $start = $end - 10 + 1;
  if ($start < 1) $start = 1;
  for ($i = $start; $i <= $end; $i++) {
    if ($i != $page) {
      echo("<a href='$url&page=$i'> $i </a>\n");
    } else {
      echo("<b><font class=highlight> $i </font></b>\n");
    }
    echo("|");
  }

  # next link
  if ($nextpage <= $end) {
    echo(" <a href='$url&page=$nextpage'>$lang[next]&gt;&gt;</a>");
  } else echo(" $lang[next]&gt;&gt;");
}
function PagerType2($url, $page, $total) {
  global $env, $lang;

  $last = ceil($total/$env[ipp]);

  $start = floor(($page - 1) / 10) * 10 + 1;
  $end = $start + 9;

  # previous link
  if ($start > 1) {
    $prevpage = $start - 1;
    echo("<a href='$url&page=$prevpage'>&lt;&lt;$lang[prev]</a>");
  } else echo("&lt;&lt;$lang[prev]");

  if ($end > $last) $end = $last;
  echo(" |");
  for ($i = $start; $i <= $end; $i++) {
    if ($i != $page) {
      echo("<a href='$url&page=$i'> $i </a>\n");
    } else {
      echo("<b><font class=highlight> $i </font></b>\n");
    }
    echo("|");
  }

  # next link
  if ($end < $last) {
    $nextpage = $end + 1;
    echo(" <a href='$url&page=$nextpage'>$lang[next]&gt;&gt;</a>");
  } else echo(" $lang[next]&gt;&gt;");
}

# detect the used protocol (contributed by Eric)
function GetProtocol() {
  global $HTTP_SERVER_VARS;
  if ((isset($HTTP_SERVER_VARS['HTTPS']) && $HTTP_SERVER_VARS['HTTPS'] == 'on')
    || getenv('SSL_PROTOCOL_VERSION')) $protocol ="https";
  else $protocol ="http";
  return $protocol;
}

function LoginPage($redirect, $lastlogin, $lastip) {
  global $env, $lang;

  if ($env[use_refresh_header]) {
    header("Refresh: $env[refresh_time]; URL=$redirect");
  }
  $env[page_focus] = 1;
  PageHead(sprintf($lang[login_0], $env[user]));
  ButtonSet();
  echo("<center><br>\n");
  printf($lang[login_1], $lastlogin, $lastip);
  echo("<br><br><form name=form>\n");
  $formtext = "<input type=text name=second id=second size=3 value='$env[refresh_time]' class='transtextinput_bg'>";
  printf($lang[login_2], $formtext);
  echo("<br><br><a href='$redirect'>$lang[login_3]</a></form></center>
  <script language=\"javascript\" type=\"text/javascript\">
  var firstcall = 1;
  //window.onload(PageFocus());
  function PageFocus() {
    if (firstcall) { document.form.second.value=$env[refresh_time]; }
    if (document.form.second.value > 0) {
      setTimeout('PageFocus()', 1000);
      if (firstcall) { firstcall = 0; }
      else { document.form.second.value--; }
    } else {
      window.location = \"$redirect\";
    }
  }
  </script>\n");

  if ($env[login_page_schedules]) {
    # schedule of this week
    $date = date("Y-m-d H:i:s");
    $year  = (int)substr($date, 0, 4);
    $month = (int)substr($date, 5, 2);
    $day = (int)substr($date, 8, 2);
    $sch_list = array();
    # fetch schedules in some days from today
    FetchSchedules2($year, $month, $day, $env[remind_schedules_days], $sch_list);

    echo("<table border='0' width='90%' align='center' cellpadding='3'
 cellspacing='0'>
<tr>
<td bgcolor='$env[th]' align='center'><b>"
.sprintf($lang[calendar_13], $env[remind_schedules_days])."</b></td>
</tr>\n");

    $pre_str = "<tr><td bgcolor='$env[td]'>";
    $post_str = "</td></tr>";
    PrintSchedules($year, $month, $sch_list, $pre_str, $post_str);

    echo("</table>\n");
  }

  PageTail();
}

# print <option>...</option> tags
# $len is the number of options to print
# $values, $disps arrays are values and displaying string
# $selected is the value of selected item
function FormOptions($len, $values, $disps, $selected) {
  for ($i = 0; $i < $len; $i++) {
    $sel = ($values[$i] == $selected) ? " selected" : "";
    echo("<option value='$values[$i]'$sel>$disps[$i]</option>\n");
  }
}
# print <input type=radio> tags
function FormRadios($len, $name, $values, $disps, $checked, $onclicks="") {
  for ($i = 0; $i < $len; $i++) {
    $chk = ($values[$i] == $checked) ? " checked" : "";
    $onclick = ($onclicks[$i]) ? " onclick=\"$onclicks[$i]\"" : "";
    echo("<nobr><input type='radio' name='$name'"
        ." value='$values[$i]'$chk$onclick> $disps[$i]</nobr>\n");
  }
}
function FormText($name, $value, $size, $disable=0) {
  $dis = ($disable) ? " disabled" : "";
  echo("<input type='text' size='$size' name='$name' value=\"$value\"$dis>");
}
function FormCheckbox($name, $value, $checked) {
  if ($checked) $chk = " checked";
  echo("<input type='checkbox' name='$name' value='$value'$chk>");
}

# return true if 'rdate' is not too old from now
function IsNew($rdate) {
  global $env;
  $t1 = GetTimeStamp($rdate);
  $diff = time() - $t1;
  return ($diff < $env[newtime]);
}


# set file downloading header
function DownloadHeader($filename) {
  header("Content-disposition: attachment; filename=\"$filename\" ");
  header("Content-type: application/octetstream");
  header("Pragma: no-cache");
  header("Expires: 0");
# header("Content-Length: ".$unknown_size);

# header("Content-length: $size");
# header("Content-type: application/octet-stream");
# header("Content-Disposition: attachment; filename=\"$filename\" ");
# header("Content-Description: PHP Generated Data" );
# header("Content-Transfer-Encoding: binary");
}

# format byte data (reused from phpMyAdmin)
function FormatByteDown($value, $limes=6, $comma=0) {
  $dh           = pow(10, $comma);
  $li           = pow(10, $limes);
  $return_value = $value;

  $byteUnits    = array('Bytes', 'KB', 'MB', 'GB');
  $unit         = $byteUnits[0];

  if ($value >= $li*1000000) {
    $value = round($value/(1073741824/$dh))/$dh;
    $unit  = $byteUnits[3];
  } else if ($value >= $li*1000) {
    $value = round($value/(1048576/$dh))/$dh;
    $unit  = $byteUnits[2];
  } else if ($value >= $li) {
    $value = round($value/(1024/$dh))/$dh;
    $unit  = $byteUnits[1];
  }

  if ($unit != $byteUnits[0]) {
    $return_value = number_format($value, $comma, '.', ',');
  } else {
    $return_value = number_format($value, 0, '.', ',');
  }

  return array($return_value, $unit);
}

# traverse bookmark tree
# 'callback_func' is the name of callback function
# 'args' is an argument array passed to the callback function
function TraverseTree($root, $callback_func, $args) {
  global $env, $lang, $mgr;
  $result = $mgr->findItems($root, "type DESC,title");
  while ($row = $result->fetchRow()) {
    $callback_func($row, $args);
    if ($row[type]=='c') TraverseTree($row[id], $callback_func, $args);
  }
}


# get information of files in the path directory
function DirInfo($path) {
  $ret = array();
  if (!is_dir($path)) return $ret;

  $handle = opendir($path);
  $cnt = 0;
  $totsize = 0;
  while ($file = readdir($handle)) {
    if (is_file("$path/$file")) {
      $stat = stat("$path/$file");
      $d = getdate($stat[10]); # file modification time
      $totsize += $stat[7];
      $ret[$cnt][type] = 'f'; # file
      $ret[$cnt][name] = $file;
      $ret[$cnt][size] = $stat[7];
      $ret[$cnt][date] = sprintf("%4d-%02d-%02d %02d:%02d:%02d",
         $d[year], $d[mon], $d[mday], $d[hours], $d[minutes], $d[seconds]);
      $cnt++;
    } elseif (is_dir("$path/$file")) {
      $stat = stat("$path/$file");
      $d = getdate($stat[10]); # file modification time
      $totsize += $stat[7];
      $ret[$cnt][type] = 'd'; # directory
      $ret[$cnt][name] = $file;
      $ret[$cnt][size] = $stat[7];
      $ret[$cnt][date] = sprintf("%4d-%02d-%02d %02d:%02d:%02d",
         $d[year], $d[mon], $d[mday], $d[hours], $d[minutes], $d[seconds]);
      $cnt++;
    }
  }
  closedir($handle);

  return $ret;
}

# get information of files in the path directory
function DirInfoFilenameOnly($path) {
  $ret = array();
  if (!is_dir($path)) return $ret;

  $handle = opendir($path);
  $cnt = 0;
  while ($file = readdir($handle)) {
    if (is_file("$path/$file")) {
      array_push($ret, $file);
      #$ret[$cnt] = $file;
      #$cnt++;
    }
  }
  closedir($handle);

  usort($ret, "strcmp"); 
  return $ret;
}

# extract 'which_list' variables into global from array 
function ExtractVars($array, $which_list) {
  while (list($key, $val) = @each($which_list)) {
    if (get_magic_quotes_gpc())
      $GLOBALS[$val] = stripslashes($array[$val]);
    else
      $GLOBALS[$val] = $array[$val];
  }
}

# return a string of icon image
# the type of $row is bookmark or folder
function GetIconString($row, &$icon) {
  global $env, $lang;

  if (!$icon) { # icon is not given
    if ($row[type] == 'b') {
      $icon = ($row[public]) ? $env[icon_bk] : $env[icon_hbk];
    } elseif ($row[type] == 'c') {
      $icon = ($row[public]) ? $env[icon_fo] : $env[icon_hfo];
    } elseif ($row[type] == 'l') {
      $icon = $env[icon_ln];
    }
  }

  $attr = " class=\"icon\" id=\"folderIcon_$row[id]\"";
  if( $env[guest] )
    $attr .= " title=\"$lang[import]\"";
  else
    $attr .= " title=\"$lang[modifyform_0]\"";

  if ($env[myicon_as_default] && $row[icon]) { # use a custom icon
    $icon = "$env[myicon_dir]/$row[icon]";
  }
  $img_str = "<img src='$icon'$attr";
  if ($row[type] == 'b') {
    if ($env[show_alt_url] && $row[url]) $img_str .= " alt='". htmlentities($row[url]) ."'";
  } elseif ($row[type] == 'c') {
    $img_str .= " alt='$lang[folder]'";
  }
  $img_str .= ">";

  if ($row[icon] && !$env[myicon_as_default]) {
    $img_str .= "<img src='$env[myicon_dir]/$row[icon]'$attr>";
  }
  return $img_str;
}

function GetNewString($row) {
  global $env, $lang;
  $mnew = ""; # modified recently 
  if (IsNew($row[rdate])) $mnew = "<img src='$env[icon_new]' align='top'>";
  $vnew = ""; # visited recently
  if (IsNew($row[lastvisit])) $vnew = "<img src='$env[icon_vnew]' align='top'>";
  return array($mnew, $vnew);
}

# return a string to link a bookmark
# $row must be a bookmark not a folder or something else
function GetTitleString($row, $attr="") {
  global $env, $lang;

  $title = $row[title];
  $title = ereg_replace("<", "&lt;", $title); # strip tags

  if ($env[show_alt_url]) { $attr .= " title=\"$row[url]\""; }
  if (!$row[public]) $title = "<font color='$env[blur]'>$title</font>";
  if ($env[usecount]) {
    $title_str = "<a href=\"linkto.php?id=$row[id]\"$attr>$title</a>";
  } else {
    $title_str = "<a href=\"$row[url]\"$attr>$title</a>";
  }

  return $title_str;
}

function DateInput($prefix, $year=0, $month=0, $day=0, $onchange="",
 $sel_year=1, $disp_dow=1) {
  global $env, $lang;

  $now = CurrentTime();
  $s_year = (int)$now[year] - $env[year_before];
  $e_year = (int)$now[year] + $env[year_after];

  $dow = DayOfWeek($year, $month, $day);
  $dows = explode(":", $lang[dayofweek]);
  $dow = $dows[$dow];

  if ($onchange != "") $onchange = " onchange=\"$onchange\"";

  if ($sel_year) {
    echo("<select name='${prefix}_year'$onchange>");
    for ($y = $s_year; $y < $e_year; $y++) {
      $sel = ($y == $year) ? " selected" : "";
      echo("<option value='$y'$sel>$y</option>\n");
    }
    echo("</select>");
  } else {
    echo("<input type='text' name='${prefix}_year' size='5' value=\"$year\">");
  }
  echo("$lang[year]&nbsp;&nbsp;");

  echo("<select name='${prefix}_month'$onchange>");
  for ($m = 1; $m <= 12; $m++) {
    $sel = ($m == $month) ? " selected" : "";
    echo("<option value='$m'$sel>$m</option>\n");
  }
  echo("</select>");
  echo("$lang[month]&nbsp;&nbsp;");

  echo("<select name='${prefix}_day'$onchange>");
  for ($d = 1; $d <= 31; $d++) {
    $sel = ($d == $day) ? " selected" : "";
    echo("<option value='$d'$sel>$d</option>\n");
  }
  echo("</select>\n");
  echo("$lang[day]&nbsp;&nbsp;");
  if ($disp_dow) {
    echo("<input type='text' name='${prefix}_dow' size='3' value='$dow'>\n");
  }
}

# save configuration in database
function SaveConfiguration($config_array) {
  global $env, $userMgr;

  # load previous environment
  $uenv = LoadUserConfig($env[uid], "");
  $save = array();
  $save = array_merge($save, $uenv);

  # add changed variables to exist environment
  $save = array_merge($save, $config_array);
  ksort($save);
# PrintArray($save, 'save');

  $configtext = "";
  reset($save);
  while (list($key, $val) = each($save)) {
    $val = stripslashes($val);  # strip "\'" to "'" escaped by the browser
    $val = addslashes($val);
    $configtext .= "$key = $val\r\n";
  }

  # update database
  $userMgr->updateUserConfig($configtext);
  DBError();

}

// ------------------------------------------------------------
// DB Error
// ------------------------------------------------------------
function DBError($debug_msg='') {
  global $mgr;

  if ( DB::isError($result) ) {
    if ($debug_msg) { echo("$debug_msg"); }
    echo("Query = '<font color='red'>" . $result->getMessage() . "</font>'<br>");
    if ($env[user] == 'admin')
      echo("<i><b><a href='admin/config.php'>You have an error in the database. Check here to debug it.</a></b></i>");
    else
      echo("There is a Database connexion error. Contact the administrator or come back later.");
  }
}

# url can be array or single value (e.g. 'file.php?a=va&b=vb&')
# keyvar is a name of variable (e.g. 'file.php?a=va&b=vb&keyvar=values')
# len is the number of tabs
# values is array, which are the values of keyvar
# disps is array of string
function SelectionTabs($url, $keyvar, $len, $values, $disps,
    $attr='', $attrsel='', $bg='', $bgsel='') {
  global $env;
  $key = $GLOBALS[$keyvar]; # get the value of keyvar in the global context

  for ($i = 0; $i < $len; $i++) {
    if (is_array($url)) $baseurl = $url[$i];
    else $baseurl = $url;
    if ($key == $values[$i]) { # the selected tab
      $bg_str = ($bgsel) ? " bgcolor='$bgsel'" : "";
      $str = "<b>$disps[$i]</b>";
      if ($values[$i]) $str = "<a href='$baseurl$keyvar=$values[$i]'>$str</a>";
      $str = "<td$attrsel$bg_str>$str</td>\n";
      echo($str);
    } else {
      $bg_str = ($bg) ? " bgcolor='$bg'" : "";
      $str = "$disps[$i]";
      if ($values[$i]) $str = "<a href='$baseurl$keyvar=$values[$i]'>$str</a>";
      $str = "<td$attr$bg_str>$str</td>\n";
      echo($str);
    }
  }
}

# recursive function
function CreateTreeSub($tree_array, &$root) {
  while (list($id, $row) = each($tree_array)) {  # for every rows in tree_array
    if ($row[parent] == $root[id]) { # if the parent of row is root
      unset($tree_array[$id]); # delete this row from tree_array
      if ($row[type] == 'c') { # if row is a folder
        CreateTreeSub($tree_array, $row); # call self with row as root
      }
      array_push($root[children], $row); # add this row as a child of root
    }
  }
}

# create bookmark tree from database query result
function CreateTree($result, $rootId) {

  $tree_array = array();

  # create root array and 'children' array
  $root = array();
  $root[id] = $rootId;
  $root[title] = "root";
  $root[children] = array();
  #$tree_array[$rootId] = $root;

  # create 'children' array for each folder item
  # register all items into 'tree_array' array
  while ( $row = $result->fetchRow() ) {
    if ( $row[type] == 'c' ) $row[children] = array();
    $tree_array[$row[id]] = $row;
  }

  CreateTreeSub($tree_array, $root);

  #print_r($root);
  #PrintArrayR($root);
  return $root;

}

# Get PHP Version
function GetPhpVersion($format) {
  $string = phpversion();
  if ($format == 'string') return $string;
  else if ($format == 'array') {
    $ret = explode(".", $string);
    $ret[major] = $ret[0];
    $ret[minor] = $ret[1];
    $ret[patch] = $ret[2];
    return $ret;
  }
}

# connect to Database
function connectDB() {
  global $env, $conf, $mgr, $userMgr;

  $dsn = "$env[dbtype]://$env[dbuser]:$env[dbpasswd]@$env[dbhost]/$env[dbname]";
  $db  = DB::connect($dsn);
  DBError();

  return $db;
}

function SumOutputBytes($buffer) {
  global $env;
  $env[total_output_bytes] = strlen($buffer);
  return $buffer;
}

?>
