<?php

/************************************************************************/
/* Bookmark4U: Web-based personal bookmarking environment               */
/* ======================================================               */
/* Please read LICENSE.txt                                              */
/************************************************************************/


include("$env[include_prefix]/inc/dbase.pear.php");

# MySQL DB Interface
include("$env[include_prefix]/inc/dbase.pear.mysql.php");

# PostgresSQL DB Interface
include("$env[include_prefix]/inc/dbase.pear.pgsql.php");

# dao access objects
include("$env[include_prefix]/inc/mgr.bookmark.php");
include("$env[include_prefix]/inc/mgr.user.php");
include("$env[include_prefix]/inc/mgr.trash.php");
include("$env[include_prefix]/inc/mgr.memo.php");
include("$env[include_prefix]/inc/mgr.calendar.php");
include("$env[include_prefix]/inc/mgr.address.php");
include("$env[include_prefix]/inc/mgr.admin.php");

# these factories method can be used to declare a personalized
# subclass of standard managers class

function createBookmarkManager($user, $db) {
  return new BookmarkMgr($user, $db);
}

function createUserManager($user = null, $db = null) {
  return new UserMgr($user, $db);
}

function createTrashManager($user = null, $db = null) {
  return new TrashMgr($user, $db);
}

function createMemoManager($user = null, $db = null) {
  return new MemoMgr($user, $db);
}

function createCalendarManager($user = null, $db = null) {
  return new CalendarMgr($user, $db);
}

function createAddressManager($user = null, $db = null) {
  return new AddressMgr($user, $db);
}

function createAdminManager($user = null, $db = null) {
  return new AdminMgr($user, $db);
}

?>
