<?

/************************************************************************/
/* Bookmark4U: Web-based personal bookmarking environment               */
/* ======================================================               */
/* Please read LICENSE.txt                                              */
/************************************************************************/

# for debugging
define(DBASE_ECHO_QUERY, 0);

# INPUT
#  env[dbhost]
#  env[dbuser]
#  env[dbpasswd]
#  env[dbname]
#
# STATE
#  env[connect]
#  env[num_of_query]

class Pgsql_DB extends DB {

  var $lastQuery;

  function Pgsql_DB($connect = true) {
    parent::DB();

    global $env;

    if( $connect) {
      // must use dsn insteed of global var.

      $env[connect] = pg_connect("host=$env[dbhost] user=$env[dbuser] password=$env[dbpasswd] dbname=$env[dbname]");
    # if (!$env[connect]) { DBError("Can't connect to DB server"); }
      if (!$env[connect]) return 1;
      $env[num_of_query] = 0;
      return 0;
    }

  }


  // ------------------------------------------------------------
  // DB Disconnection
  // ------------------------------------------------------------
  function disconnect() {
    global $env;

    $env[connect] = !pg_close($env[connect]);
    $env[num_of_query]++;
    return $env[connect];
  }

  // ------------------------------------------------------------
  // DB Query
  // ------------------------------------------------------------
  function query($query) {
    global $env;

    $this->lastQuery = $query;
    if (DBASE_ECHO_QUERY) echo("$query<br>");
    $result = pg_exec($query);
    $env[num_of_query]++;
    return new Pgsql_DB_Result($result);
  }

  function isError(&$result) {
    global $env;

    $err = pg_errormessage($env[connect]);
    if ($err) {
      $result = new DB_Error($err . " - Query : " . $this->lastQuery);
      return true;
    }
    else
      return false;
  }
}

class Pgsql_DB_Result extends DB_Result {

    var $result;

    function Pgsql_DB_Result($result) {
      parent::DB_Result($result);
      $this->result = $result;
    }

    function fetchRow() {
      if ( $this->result == null)
        return null;
      return pg_fetch_array($this->result);
    }

    function numRows() {
      if ( $this->result == null)
        return 0;
      return pg_numrows($result);
    }
}



?>
