<?php

/************************************************************************/
/* Bookmark4U: Web-based personal bookmarking environment               */
/* ======================================================               */
/* Please read LICENSE.txt                                              */
/************************************************************************/

#
# inc/config.dist.php : Bookmark4U configuration file
# The file inc/config.php includes this file. If you want to change some
# variables, then change config.php not this file. This separation of config
# files makes it convenient to upgrade software.
# Refer CONFIG.txt for more information.
#
# In this file, we define two arrayes $conf, $uconf
# Each one is used for different purpose. Some rules are:
#
# Rule 1: (common for all users)
#   Any user can *NOT* override $conf array.
# Rule 2: (preference setting)
#   Users can override $uconf using their preference setting.
#
# These arrayes are merged into $env in the start of script in order.
#

###########################################################################
# On the installation, set following five variables to your values.
###########################################################################
# path and location
$conf[sitehome] = "http://host.domain/bookmark4u";  # bookmark4u home URL
                                                    # the base of quickmark
# database access
$conf[dbhost]   = "localhost";  # database server
$conf[dbuser]   = "root";       # database user
$conf[dbpasswd] = "";           # database user's password
$conf[dbname]   = "bookmark4u"; # database name
$conf[dbtype]   = "mysql";      # database type - possible : mysql , pgsql

# administration
$conf[registration_verify] = 0; # if true, admin can allow/deny a registration
                                # if true, requires PASSWD_TEMP table
                                # read UPGRADE.txt (ver 1.7.2)
$conf[admin_email] = "";        # administrator's email address
# e.g. "Name<who@where>"        # if blank, do not send any email
$conf[generate_user_passwd] = 0;# if true, generate user password and email it
###########################################################################

###########################################################################
## Notice!
## If you are a beginner, I recommend you don't go over this line
###########################################################################

# Bookmark4U version number
$conf[version] = "1.8.4";

# database tables (from sql/db.mysql.sql)
$conf[dbtblpasswd]    = "PASSWD";      # password table name
$conf[dbtblpasswdtmp] = "PASSWD_TEMP"; # temporary password table name
$conf[dbtblconfig]    = "CONFIG";      # user config/memo table name
$conf[dbtblcalendar]  = "CALENDAR";    # bookmark calendar
$conf[dbtbltrash]     = "TRASH";       # trash to be deleted
$conf[dbtbladdress]   = "ADDRESS";     # address book
$conf[dbtblmemo]      = "MEMO";        # memo

# cookies configuration
$conf[cookie_prefix] = "BM4U_";     # prefix of cookie variables
$conf[secure_cookie] = 1;           # use hashed token cookie
$conf[static_cookie] = "MY_COOKIE"; # mixed with other variables
                                    # to generate a secure cookie
$conf[userdb_prefix] = "BM4U_";     # prefix of user bookmark table name
#$conf[userdb_prefix] = "";         # read UPGRADE.txt (ver 1.6.2)

# site options
$conf[use_user_config] = 1;     # user can override the default configuration
$conf[allow_guest_login] = 1;   # non-registered users can be a guest
#$conf[inc_headtail] = 1;       # to override uconf un-comment it
$conf[enable_manual_config] = 1;# if false, can't edit configuration text
$conf[demo_mode] = 0;           # if true, user registration is not allowed
$conf[register_global_off] = 1; # if true, register get/post variables as global
$conf[bgimg_dir] = "img/bg";    # background images directory
$conf[myicon_dir] = "myicon";   # icon image directory

$conf[mysql_version_before_3_22_5] = 0; # set to 1 if MySQL < 3.22.5
                                        # but MySQL upgrade is recommended

$conf[site_title]   = "Bookmark4U"; # web site informations for title
$conf[meta_author]  = "Bookmark4U Webmaster"; # meta informations for author
$conf[meta_title]   = $conf[site_title];      # meta informations for title
$conf[meta_description] = "Bookmark4U is an web-based personal bookmarking software and provides you a comfortable bookmarking environment"; # meta informations for description
$conf[meta_keywords]= "bookmark, bookmark4u, manage, gpl, free, php, favorites, ie, mozilla, netscape, opera, calendar, address, memo";  # meta informations for keyword (for search engine like google)

#####################
# $uconf array
#####################

# bookmark icons
$uconf[icon_bk]       = "icon/bk.gif";    # bookmark
$uconf[icon_hbk]      = "icon/hbk.gif";   # hidden(private) bookmark
$uconf[icon_fo]       = "icon/fo.gif";    # folder
$uconf[icon_hfo]      = "icon/hfo.gif";   # hidden(private) folder
$uconf[icon_ofo]      = "icon/ofo.gif";   # open folder
$uconf[icon_hofo]     = "icon/hofo.gif";  # hidden(private) open folder
$uconf[icon_trdot]    = "icon/trdot.gif"; # transparent dot
# tree icons
$uconf[icon_tree_collapse] = "icon/tree/tree_collapse.gif";
$uconf[icon_tree_end]      = "icon/tree/tree_end.gif";
$uconf[icon_tree_expand]   = "icon/tree/tree_expand.gif";
$uconf[icon_tree_gap1]     = "icon/tree/tree_gap1.gif";
$uconf[icon_tree_gap2]     = "icon/tree/tree_gap2.gif";
$uconf[icon_tree_gap3]     = "icon/tree/tree_gap3.gif";
$uconf[icon_tree_space]    = "icon/tree/tree_space.gif";
$uconf[icon_tree_split]    = "icon/tree/tree_split.gif";
$uconf[icon_tree_vertline] = "icon/tree/tree_vertline.gif";
$uconf[icon_tree_empty]    = "icon/tree/tree_empty.gif";
# misc. icons
$uconf[icon_add]        = "icon/add.gif";
$uconf[icon_address]    = "icon/addressbook.gif";
$uconf[icon_alert]      = "icon/stop.gif";
$uconf[icon_back]       = "icon/back.gif";
$uconf[icon_bgimg]      = "icon/weather.gif";
$uconf[icon_bksort]     = "icon/bksort.gif";
$uconf[icon_calendar]   = "icon/calendar.gif";
$uconf[icon_change]     = "icon/change.gif";
$uconf[icon_clear]      = "icon/clear.gif";
$uconf[icon_clipboard]  = "icon/clipboard.gif";
$uconf[icon_close]      = "icon/close.gif";
$uconf[icon_collapse]   = "icon/collapse.gif";
$uconf[icon_comment]    = "icon/comment.gif";
$uconf[icon_config]     = "icon/config.gif";
$uconf[icon_delete]     = "icon/trash.gif";
$uconf[icon_error]      = "icon/expression.gif";
$uconf[icon_etc]        = "icon/etc.gif";
$uconf[icon_exit]       = "icon/exit.gif";
$uconf[icon_expand]     = "icon/expand.gif";
$uconf[icon_export]     = "icon/export.gif";
$uconf[icon_fix]        = "icon/fix.gif";
$uconf[icon_float]      = "icon/float.gif";
$uconf[icon_frame]      = "icon/frame.gif";
$uconf[icon_gradient]   = "icon/gradient.gif";
$uconf[icon_help]       = "icon/help.gif";
$uconf[icon_h_layer]    = "icon/history_layer.gif";
$uconf[icon_icon_size]  = "icon/icon_size.gif";
$uconf[icon_icon_align] = "icon/iconalign.gif";
$uconf[icon_inc_head]   = "icon/inc_head.gif";
$uconf[icon_key]        = "icon/key.gif";
$uconf[icon_import]     = "icon/import.gif";
$uconf[icon_linkpage]   = "icon/linkpage.gif";
$uconf[icon_ln]         = "icon/url.gif";
$uconf[icon_memo]       = "icon/memo.gif";
$uconf[icon_move]       = "icon/move.gif";
$uconf[icon_myinfo]     = "icon/myinfo.gif";
$uconf[icon_msie]       = "icon/explorer.gif";
$uconf[icon_myicon]     = "icon/weather.gif";
$uconf[icon_netscape]   = "icon/netscape.gif";
$uconf[icon_new]        = "icon/new.gif";
$uconf[icon_next]       = "icon/next.gif";
$uconf[icon_opera]      = "icon/opera.gif";
$uconf[icon_p_bkgap]    = "icon/bk_gap.gif";
$uconf[icon_p_delconfrm]= "icon/question.gif";
$uconf[icon_p_desc_cut] = "icon/desc_length.gif";
$uconf[icon_p_dispurl]  = "icon/dispurl.gif";
$uconf[icon_p_focus]    = "icon/auto_focus.gif";
$uconf[icon_p_fonttype] = "icon/fontfamily.gif";
$uconf[icon_p_fontsize] = "icon/fontsize.gif";
$uconf[icon_p_fogap]    = "icon/fo_gap.gif";
$uconf[icon_p_frame_w]  = "icon/frame_width.gif";
$uconf[icon_p_iconname] = "icon/icon_name.gif";
$uconf[icon_p_lang]     = "icon/char_a.gif";
$uconf[icon_p_logininfo]= "icon/expression.gif";
$uconf[icon_p_root_name]= "icon/root_name.gif";
$uconf[icon_p_sturl]    = "icon/home_url.gif";
$uconf[icon_p_theme]    = "icon/theme.gif";
$uconf[icon_p_tree_on]  = "icon/mode_tree.gif";
$uconf[icon_p_tree_off] = "icon/mode_desc.gif";
$uconf[icon_p_url_cut]  = "icon/url_length.gif";
$uconf[icon_p_usecount] = "icon/linkto.gif";
$uconf[icon_pick]       = "icon/red_cross.gif";
$uconf[icon_prio2]      = "icon/prio2.gif";
$uconf[icon_prio3]      = "icon/prio3.gif";
$uconf[icon_prio4]      = "icon/prio4.gif";
$uconf[icon_prio5]      = "icon/prio5.gif";
$uconf[icon_quickmark]  = "icon/footprint.gif";
$uconf[icon_quicklink]  = "icon/toright.gif";
$uconf[icon_rate]       = "icon/star.gif";
$uconf[icon_resize]     = "icon/resize.gif";
$uconf[icon_reload]     = "icon/refresh2.gif";
$uconf[icon_repeat]     = "icon/rotate.gif";
$uconf[icon_row]        = "icon/icon_row.gif";
$uconf[icon_s_path]     = "icon/search_path.gif";
$uconf[icon_search]     = "icon/zoom.gif";
$uconf[icon_start_page] = "icon/home_url.gif";
$uconf[icon_stop]       = "icon/stop.gif";
$uconf[icon_timer]      = "icon/timer.gif";
$uconf[icon_today]      = "icon/today.gif";
$uconf[icon_trash]      = "icon/trash.gif";
$uconf[icon_up]         = "icon/up.gif";
$uconf[icon_url]        = "icon/url.gif";
$uconf[icon_urlcheck]   = "icon/urlcheck.gif";
$uconf[icon_visited]    = "icon/book.gif";
$uconf[icon_v_path]     = "icon/visited_path.gif";
$uconf[icon_visit_info] = "icon/visit_info.gif";
$uconf[icon_vnew]       = "icon/visit.gif";
$uconf[icon_xclipboard] = "icon/xclipboard.gif";
$uconf[icon_xmlexp]     = "icon/xmlexp.gif";
$uconf[icon_version]    = "icon/global.gif";
$uconf[icon_weather]    = "icon/weather.gif";
$uconf[icon_zoom]       = "icon/zoom.gif";

# user configurations (users can override these)
$uconf[autoselect] = 1;         # select all if clicked in the search form
$uconf[buttons_in_a_row] = 7;   # the number of buttons in a row, ButtonSet()
$uconf[cut_title] = 30;         # cut a long url string displayed in length
$uconf[cut_url] = 80;           # cut a long url string displayed in length
$uconf[delconfirm] = 0;         # if true, question before deletion
$uconf[delallconfirm] = 1;      # if true, question before deletion of all users's bookmarks
$uconf[disp_ctime] = 1;         # display elapsed time
$uconf[disp_time] = 1;          # display current time in the page tail
$uconf[disp_ip] = 0;            # display IP address in the page tail
$uconf[dispurl] = 0;            # if true display bookmark URL
$uconf[enable_frame_mode] = 0;  # if false, frame mode is not available
$uconf[font_size] = 'x-small';  # font size
$uconf[headline] = 1;           # if true display a headline
$uconf[history_layer] = 1;      # use history layer
$uconf[history_layer_show] = 0; # show history layer always
$uconf[history_layer_w] = 180;  # history layer width
$uconf[history_layer_px] = 20;  # history layer x position
$uconf[history_layer_py] = 20;  # history layer y position
$uconf[history_max] = 10;       # the number of items in the history list
$uconf[latest_items] = 10;      # the number of latest items to display
$uconf[inc_headtail] = 0;       # include head.html and tail.html
$uconf[ipp] = 15;               # items per page
$uconf[lang] = 'English';       # language
$uconf[line_gap] = 2;           # gap in pixels table rows (0-3)
$uconf[login_info] = 1;         # show the last login infomation during login
$uconf[long_description] = 30;  # display a long description in an another line
$uconf[netscape_sidebar] = 0;   # embeded in the Netscape sidebar
$uconf[newtime] = 3600*24;      # displayed as new for newtime in seconds
$uconf[newwin] = 1;             # open link in a new browser windows
$uconf[refresh_time] = 3;       # waiting time to refresh page after login(secs)
$uconf[search_disp_path] = 1;   # display paths of bookmark in a search result
$uconf[search_focus] = 1;       # move focus to the search form automatically
$uconf[search_history] = 1;     # display search history
$uconf[show_clipbrd_icon] = 0;  # show clipboard icon in the button sets
$uconf[show_exit_icon] = 0;     # display exit icon in the button set
$uconf[show_onlyfolder_icon] =0;# display folder icon for excluding bookmarks
$uconf[show_paste_icon] = 1;    # show paste icon in the button group
$uconf[show_trash_icon] = 0;    # show trash icon in the button group
$uconf[show_frame_icon] = 0;    # show frame icon in the button group
$uconf[show_memo_icon] = 1;     # show memo icon in the button group
$uconf[show_calendar_icon] = 1; # show calendar icon in the button group
$uconf[show_visited_icon] = 1;  # show visited icon in the button group
$uconf[show_expand_icon] = 0;   # show expand/collapse icon in the button group
$uconf[show_search_icon] = 1;   # show search icon in the button group
$uconf[show_resize_icon] = 1;   # show resize icon in the button group
$uconf[show_reload_icon] = 0;   # show reload icon in the button group
$uconf[show_address_icon] = 1;  # show address book icon in the button group
$uconf[show_window_icon] = 1;   # show new window icon
$uconf[show_import_icon] = 1;   # show import icon in the button group
$uconf[show_export_icon] = 1;   # show export icon in the button group
$uconf[show_icon_name] = 1;     # display icon name
$uconf[show_visit_info] = 0;    # print the visit information in bookmark list
$uconf[stylesheet] = 1;         # use style sheet
$uconf[textarea_cols] = 60;     # the number of columns of textarea
$uconf[textarea_full_width] = 1;# fit the width of textarea with window size
$uconf[textarea_rows] = 20;     # the number of rows of textarea
$uconf[theme] = 'White';        # a set of colors and images used for display
$uconf[tree_view] = 'static';   # display bookmarks in tree form
$uconf[usecount] = 1;           # use visit counter
$uconf[icon_size_x] = 16;       # icon size
$uconf[icon_size_y] = 16;       # icon size
$uconf[list_heading] = 1;       # if true, display list heading
$uconf[enable_form_style] = 1;  # if false, disables the text form style
$uconf[disp_current_path] = 1;  # if true, display current path at top of page
$uconf[top_folder_name] = "%s's bookmark"; # top folder name
$uconf[hide_searchform] = 1;    # if true, hide search form into history layer
$uconf[page_tail] = 1;          # if false, do not display the tail of page
$uconf[show_alt_url] = 1;       # if true, bookmark URL is shown at alt attr.
$uconf[resize_wx] = 700;        # window resizing width
$uconf[resize_wy] = 600;        # window resizing height
$uconf[resize_wx2] = 700;       # window resizing width
$uconf[resize_wy2] = 300;       # window resizing height
$uconf[print_linkto_page] = 1;  # if true, print a bookmark linking page
$uconf[disp_visitd_bk_path] = 1;# if true, display pathes of visited bookmarks
$uconf[urlcheck_timeout] = 3;   # url checking timeout in second
$uconf[enable_swap_dispurl] = 1;# enabling dispurl button
$uconf[enable_swap_bkpath] = 1; # enable on/off pathes in the visit history
$uconf[enable_urlcheck] = 1;    # enabling url checking
$uconf[history_in_tail] = 1;    # if true, display history in the tail of page
$uconf[start_script] = "list";  # if true, display history in the tail of page
$uconf[persist_duration] = 3600*24; # persist for one day
$uconf[time_to_close] = 5;      # after quickmarking, windows is closed.
$uconf[errmsg_method]= 'script';# error message reporting method (script|onpage)
$uconf[folder_list_default]= "all";# default folder listing form
$uconf[bgimg] = "";    # background image
$uconf[buttons_align]= "center";# button set alignment (left|enter|right)
$uconf[default_list_sort]="type"; # default bookmarks sorting method
$uconf[h_layer_folist] = 0;     # show recent folder list in history layer
$uconf[h_layer_bklist] = 0;     # show recent bookmark list in history layer
$uconf[pager_type] = '2';       # pager type
$uconf[row_highlight] = 1;      # if true, highlighted row follow mouse pointer
$uconf[adv_search_button] = 0;  # if true, use advanced search for search icon
$uconf[myicon_as_default] = 1;  # if true, use myicon as the default icon
$uconf[h_layer_fading] = 1;     # fade in/out history layer
$uconf[use_refresh_header] = 1; # if true, use refresh header
$uconf[top_folder_name_in_title]=0;# if true, show top folder in title bar
$uconf[quick_links] = 1;        # display quick links
$uconf[calendar_year_per_page]=0;# if true, display 12 monthes in a page
$uconf[store_search_cookie] = 1;# store search keywords in cookie
$uconf[page_refreshing] = 1;    # refresh pages periodically
$uconf[page_refresh_time] = 600;# refresh pages period
$conf[min_page_refresh_time]=60;# minimum refresh pages period (for admin)
$uconf[page_margin] = 4;        # margin-top, margin-left, margin-right
$uconf[table_header_gradient]=0;# if true, use gradient table heading
$uconf[address_fields_default] = "email:mobile"; # list of fields to display
$uconf[login_page_schedules]=0; # if true, print some schedules after login
$uconf[url_direct_link] = 1;    # if true, don't use connecting page for URLs
$uconf[remind_schedules_days]=7;# days from today to fetch schedules
$uconf[show_public_schedules]=1;# if true, display public schedules of others
$uconf[doc_encoding] = "";      # encoding of html and xml pages.
$uconf[list_user_default_sort]='uid'; # default sort of the list of users
$uconf[list_user_show_nb_bk] = 1; # if true, show the number of public bookmarks in users list page
$uconf[year_before] = 5; # calendar year range from (current year-year_before)
$uconf[year_after] = 5;  # calendar year range to (current year+year_after)
$uconf[url_check_only_ip] = 0;  # if true, show only IP address checking URL

?>
