<?php

/************************************************************************/
/* Bookmark4U: Web-based personal bookmarking environment               */
/* ======================================================               */
/* Please read LICENSE.txt                                              */
/************************************************************************/

if ($env[include_prefix] == "") $env[include_prefix] = ".";
include("$env[include_prefix]/inc/config.php");   # default configurations
include("$env[include_prefix]/inc/function.php"); # functions
include("$env[include_prefix]/inc/dbase.php");    # database interface routines
include("$env[include_prefix]/inc/caldate.php");  # date calculation functions

# record the start time(usec) of script
$env[checktime1] = TimeStampUsec();

# the number of database accesses
$env[num_of_query] = 0;

# set a dummy variable to current time
$env[dummy] = time();

# env value of $PHP_SELF
$env[php_self] = $HTTP_SERVER_VARS[PHP_SELF];

# current script's name without .php extension
$env[script_name] = ereg_replace("^.*\/(.*)\.php$", "\\1", $env[php_self]);

# prefix of script path
$env[script_prefix] = ereg_replace("(\/.+\/).*$", "\\1", $env[php_self]);
# $env[script_prefix] = ereg_replace("^[^:]*://[^\/]*(/.*)$", "\\1/",
#   $conf[sitehome]);

# script path in file system
$env[script_path] = ereg_replace("(^\/.*)\/.*$", "\\1",
  $HTTP_SERVER_VARS[SCRIPT_FILENAME]);

# set $env[logined], $env[user] and $env[uid]
include("$env[include_prefix]/inc/common.user.php");
$guest_mode = GetCookie('GUEST_MODE');
if ($guest_mode == '1') { # guest mode access
  # set $env[guest], $env[user] and $env[uid]
  include("$env[include_prefix]/inc/common.guest.php");
}

# redirect to login page
if (!$env[pass_without_login] && !$env[logined] && !$env[guest]) {
  header("Location: index.php");
  exit;
}

# merge array conf and uconf to array env
$env = array_merge($env, $uconf); # add default config
$env = array_merge($env, $conf);  # add conf

if (!$env[pass_without_dbconnect]) {
  $db = connectDB();

  $mgr      = createBookmarkManager($env[user], $db);
  $userMgr  = createUserManager($env[user], $db);

  # load configuration, language, and theme
  include("$env[include_prefix]/inc/common.load.php");
}

# add some http_get_vars to env
$env[exp] = $exp;   # expand string for tree view mode
$env[version] = "1.8.4"; # Bookmark4U version number

# bookmark target
# main_target
if ($env[newwin]) { $env[main_target] = " target=_blank"; }
else if ($env[link_target]) { $env[main_target] = " target=$env[link_target]"; }
else { $env[main_target] = ""; }
$cookie_target = GetCookie('TARGET');
if ($cookie_target) $env[main_target] = " target=$cookie_target";
# aid_target
if ($env[frame_mode] || $cookie_target) $env[aid_target] = $env[main_target];
else $env[aid_target] = "";

# start output observation
$version = GetPhpVersion($format='array');
if ($version[major] >= 4) {
  ob_start('SumOutputBytes');
  $env[need_to_flush_output] = 1;
}

# get root folder from cookie
$root = GetCookie('ROOT'); # use cookie value
if ($root == '') $root = 0;
$env[root] = $root;

# clipboard
$clipbrd = GetCookie("CLIPBRD");
if ($clipbrd) $env[clipitems] = explode(":", $clipbrd);
else $env[clipitems] = array();

# only_folder 
$only_folder = GetCookie("FOLDERONLY");
$env[only_folder] = ($only_folder) ? 1 : 0;

# previously searched keywords
$search = GetCookie("SEARCHES");
if ($search) $env[searchwords] = explode("::", $search);
else $env[searchwords] = array();
sort($env[searchwords]);

# PHP session
# session_start();
# echo session_encode();

# for debugging
#$env[debug_cookie] = 1;
#$env[debug_env] = 1;
#$env[debug_lang] = 1;

?>
