<?php

/************************************************************************/
/* Bookmark4U: Web-based personal bookmarking environment               */
/* ======================================================               */
/* Please read LICENSE.txt                                              */
/************************************************************************/

###### load user configuration
# Override $env array with user's configuration
if ($env[logined] && $env[use_user_config]) {
  if ($env[guest]) {
    $temp = LoadUserConfig($env[self_uid]);
  } else {
    $temp = LoadUserConfig($env[uid]);
  }
  $env = array_merge($env, $temp);  # add user's config
}

###### load a language module
$lang = GetCookie('LANG');
if ($lang) $env[lang] = $lang;
unset($lang);
# load the default(English) language first
if ($env[lang] != 'English') include("$env[include_prefix]/lang/English/English.php");
if (!file_exists("$env[include_prefix]/lang/$env[lang]/$env[lang].php")) {
  $env[alert_msg] = "'$env[lang]' is unknown language, use English";
  $env[lang] = 'English';
}
# and then load other language
include("$env[include_prefix]/lang/$env[lang]/$env[lang].php");

# document encoding
if ($lang[encoding] != '' && $env[doc_encoding] == '') {
  # user preference value override language default encoding
  $env[doc_encoding] = $lang[encoding];
}

###### load a theme
if (!file_exists("$env[include_prefix]/theme/$env[theme]")) {
  $env[alert_msg] = "'$env[theme]' is unknown theme, use White";
  $env[theme] = 'White';
}
$env[theme_path] = "$env[include_prefix]/theme/$env[theme]";
include("$env[theme_path]/theme.php");

$env = array_merge($env, $conf);  # add conf finally

# user's bookmark table name
$env[userbm] = $conf[userdb_prefix].$env[user];

?>
