<?php

/************************************************************************/
/* Bookmark4U: Web-based personal bookmarking environment               */
/* ======================================================               */
/* Please read LICENSE.txt                                              */
/************************************************************************/

$calMgr = createCalendarManager();


# Fetch schedules from database in a given period
# from a date($year, $month, $day) and until $ndays
# add schedules into $sch_list array
function FetchSchedules2($year, $month, $day, $ndays, &$sch_list) {
  global $env, $lang, $calMgr;

  $ret = $calMgr->findNonPeriodicSchedules($year,$month, $day, $ndays);

  while ($row = $ret->fetchRow()) {
    $key = substr($row[sdate], 0, 10);  # e.g. key = 2002-12-25
    if (!$sch_list[$key]) {
      $sch_list[$key] = array();  # make a new array sch_list['2002-12-25']
    }
    array_push($sch_list[$key], $row);  # sch_list['date'] = (row1, ..., rowN)
  }

  $lastday = AddDate($year, $month, $day, $ndays-1);
  $n_mstart = DaysFrom($year, $month, 1);
  $n_mend   = DaysFrom($lastday[year], $lastday[month], $lastday[day]);
  # 1900-01-01 ................... n_mstart ..... n_mend

  # periodic schedules
  $ret = $calMgr->findPeriodicSchedules($year,$month, $day, $lastday[year], $lastday[month], $lastday[day]);
  DBError();

  while ($row = $ret->fetchRow()) {

    $sdate = DateStringToArray($row[sdate]);
    $edate = DateStringToArray($row[edate]);
    $n_sdate = DaysFrom($sdate[year], $sdate[month], $sdate[day]);
    $n_edate = DaysFrom($edate[year], $edate[month], $edate[day]);
    # 1900-01-01 ................... n_sdate ..... n_edate

    # schedules only appear between range_s and range_e
    $range_s = ($n_mstart > $n_sdate) ? $n_mstart : $n_sdate; # get maximum
    $range_e = ($n_mend   < $n_edate) ? $n_mend   : $n_edate; # get minimum
    # past <....n_mstart ...................... n_mend ........> future
    # past <........... n_sdate ..... n_edate .................> future
    # past <........... range_s ..... range_e .................> future
    #   range_s = min(n_mstart, n_sdate), range_e = max(n_mend, n_edate)

    if ($row[period] == 'd') { # daily

      for ($n = $range_s; $n <= $range_e; $n++) { # every day, increment by 1
        $date = DateFromInv($n);
        $key = sprintf("%4d-%02d-%02d", $date[year], $date[month], $date[day]);
        if (!$sch_list[$key]) $sch_list[$key] = array();
        array_push($sch_list[$key], $row);
      }

    } elseif ($row[period] == 'e') { # weekly

      $dow1 = DayOfWeek($sdate[year], $sdate[month], $sdate[day]);
      $temp = DateFromInv($range_s);
      $dow2 = DayOfWeek($temp[year], $temp[month], $temp[day]);
      $diff = ($dow1 > $dow2) ? $dow1 - $dow2 : $dow1 - $dow2 + 7;
      $diff %= 7;
      #   sdate ....... range_s ------>........... range_e .........
      #  (Monday)       (Friday)   (Monday)
      $range_s += $diff;

      for ($n = $range_s; $n <= $range_e; $n+=7) { # increment by 7
        $date = DateFromInv($n);
        $key = sprintf("%4d-%02d-%02d", $date[year], $date[month], $date[day]);
        if (!$sch_list[$key]) $sch_list[$key] = array();
        array_push($sch_list[$key], $row);
      }

    } elseif ($row[period] == 'm') { # monthly

      # monthly schedule appears only once in a month
      $key = sprintf("%4d-%02d-%02d",$year,$month,$sdate[day]);
      if (!$sch_list[$key]) $sch_list[$key] = array();
      array_push($sch_list[$key], $row);

    } elseif ($row[period] == 'y') { # yearly

      $key = sprintf("%4d-%02d-%02d",$year, $sdate[month], $sdate[day]);
      if ($month == $sdate[month]) {
        if (!$sch_list[$key]) $sch_list[$key] = array();
        array_push($sch_list[$key], $row);
      }

    }
  }
}

function FetchSchedules($year, $month, &$sch_list) {
  global $env, $lang, $calMgr;

  # non-periodic schedules
  $ret = $calMgr->findNonPeriodicSchedules($year, $month);

  while ($row = $ret->fetchRow()) {
    $key = substr($row[sdate], 0, 10);  # e.g. key = 2002-12-25
    if (!$sch_list[$key]) {
      $sch_list[$key] = array();  # make a new array sch_list['2002-12-25']
    }
    array_push($sch_list[$key], $row);  # sch_list['date'] = (row1, ..., rowN)
  }

  $lastday  = DaysPerMonth($year, $month);
  $n_mstart = DaysFrom($year, $month, 1);
  $n_mend   = DaysFrom($year, $month, $lastday);
  # 1900-01-01 ................... n_mstart ..... n_mend

  # periodic schedules
               #   sdate .... edate < y-m-1 .... y-m-30 <  sdate .... edate 
  $ret = $calMgr->findPeriodicSchedules($year, $month, 1, $year, $month, $lastDay);
  DBError();
  while ($row = $ret->fetchRow()) {

    $sdate = DateStringToArray($row[sdate]);
    $edate = DateStringToArray($row[edate]);
    $n_sdate = DaysFrom($sdate[year], $sdate[month], $sdate[day]);
    $n_edate = DaysFrom($edate[year], $edate[month], $edate[day]);
    # 1900-01-01 ................... n_sdate ..... n_edate

    # schedules only appear between range_s and range_e
    $range_s = ($n_mstart > $n_sdate) ? $n_mstart : $n_sdate; # get maximum
    $range_e = ($n_mend   < $n_edate) ? $n_mend   : $n_edate; # get minimum
    # past <....n_mstart ...................... n_mend ........> future
    # past <........... n_sdate ..... n_edate .................> future
    # past <........... range_s ..... range_e .................> future
    #   range_s = min(n_mstart, n_sdate), range_e = max(n_mend, n_edate)

    if ($row[period] == 'd') { # daily

      for ($n = $range_s; $n <= $range_e; $n++) { # every day, increment by 1
        $date = DateFromInv($n);
        $key = sprintf("%4d-%02d-%02d", $date[year], $date[month], $date[day]);
        if (!$sch_list[$key]) $sch_list[$key] = array();
        array_push($sch_list[$key], $row);
      }

    } elseif ($row[period] == 'e') { # weekly

      $dow1 = DayOfWeek($sdate[year], $sdate[month], $sdate[day]);
      $temp = DateFromInv($range_s);
      $dow2 = DayOfWeek($temp[year], $temp[month], $temp[day]);
      $diff = ($dow1 > $dow2) ? $dow1 - $dow2 : $dow1 - $dow2 + 7;
      $diff %= 7;
      #   sdate ....... range_s ------>........... range_e .........
      #  (Monday)       (Friday)   (Monday)
      $range_s += $diff;

      for ($n = $range_s; $n <= $range_e; $n+=7) { # increment by 7
        $date = DateFromInv($n);
        $key = sprintf("%4d-%02d-%02d", $date[year], $date[month], $date[day]);
        if (!$sch_list[$key]) $sch_list[$key] = array();
        array_push($sch_list[$key], $row);
      }

    } elseif ($row[period] == 'm') { # monthly

      # monthly schedule appears only once in a month
      $key = sprintf("%4d-%02d-%02d",$year,$month,$sdate[day]);
      if (!$sch_list[$key]) $sch_list[$key] = array();
      array_push($sch_list[$key], $row);

    } elseif ($row[period] == 'y') { # yearly

      $key = sprintf("%4d-%02d-%02d",$year, $sdate[month], $sdate[day]);
      if ($month == $sdate[month]) {
        if (!$sch_list[$key]) $sch_list[$key] = array();
        array_push($sch_list[$key], $row);
      }

    }
  }
}


function GetSchedulePrinting($row, $rmode='basic') {
  global $lang, $env;

  $extra = $alt = $url = $new = "";

  # ($str)
  $str = $row[title];
  if ($row[public]) $str = "<b>$str</b>";

  # ($extra)
  if ($row[priority] > 1) {
    $prioicon = $env["icon_prio$row[priority]"];
    $extra .= "<img src='$prioicon' align='top'>";
  }
  if ($row[periodic]) $extra .= "<img src='$env[icon_repeat]' align='top' alt='$lang[calendar_12]'>";
  if ($row[comment]) $extra .= "<img src='$env[icon_comment]' align='top' alt=\"$row[comment]\">";

  # ($alt)
  $alt = " title=\"$row[comment]\"";

  # URL string ($url)
  if ($row[url]) {
    $url = "<a href='$row[url]' target='_blank'><img"
          ." src='$env[icon_bk]' border='0' align='top'></a>";
  } else $url = "";

  # new_img ($new)
  if (IsNew($row[rdate])) {
    $new = " <img src='$env[icon_new]' align='top'>";
  }

  $str = "<a href='calendar.php?mode=edit&id=$row[id]&rmode=$rmode'$alt>$str</a>$url$new$extra";

  return $str;
}

function PrintMonth($year, $month, &$sch_list) {
  global $env, $lang;
  global $mode;

  $now = CurrentTime();
  $months = explode(":", $lang[months]);
  $dow_str = explode(":", $lang[dayofweek]);

  $dow = DayOfWeek($year, $month, 1);
  $dpm = DaysPerMonth($year, $month);

  $month_str = $months[$month-1];
  echo("<center><b>$year $month_str</b></center>\n");

  echo("<table border='1' cellpadding='3' cellspacing='1' width='100%'
 bordercolordark='$env[th]' bordercolorlight='$env[td]'>
<tr bgcolor='$env[th]' align='center'>
<td width='16%'>$dow_str[0]</td>
<td width='14%'>$dow_str[1]</td>
<td width='14%'>$dow_str[2]</td>
<td width='14%'>$dow_str[3]</td>
<td width='14%'>$dow_str[4]</td>
<td width='14%'>$dow_str[5]</td>
<td width='14%'>$dow_str[6]</td>
</tr>\n");

  echo("<tr>");

  # blank days preceed
  if ($dow >= 1 && $dow <= 6) {
    for ($i = 0; $i < $dow; $i++) {
      echo("<td><br></td>\n");
    }
  }

  # days in a month
  for ($i = 1; $i <= $dpm; $i++) {
    $tdbgcol = " bgcolor=$env[td]";
    $tdborder = "";
    $day_str = "$i";
    if ($year==$now[year] && $month==$now[month] && $i==$now[day]) { # today
      $tdborder .= " bordercolor=$env[blur]";
      $day_str = "<font class='highlight'><b><u>$i</u></b></font> "
          ." <img src=$env[icon_today] border=0 align=top alt='$lang[today]'>";
    }
    if ($dow == 0 || $dow == 6) { # Sunday and Saturday
      $tdbgcol = " bgcolor='$env[th]'";
    }

    echo("<td valign='top'$tdbgcol$tdborder>");
    $key = sprintf("%d-%02d-%02d", $year, $month, $i);
    echo("<a href='calendar.php?mode=add&year=$year&month=$month&day=$i'>$day_str</a>");
    if ($sch_list[$key]) {
      $n_sch = sizeof($sch_list[$key]);
      echo("<br>");

      $disabled_item_str = "";
      for ($j = 0; $j < $n_sch; $j++) {
        $row = $sch_list[$key][$j];

        if (!$row[disabled]) {
          $str = GetSchedulePrinting($row, $mode);
          echo("$str<br>");
        } else { # disabled schedules
          $str = "<font color='$env[blur]'>*</font>";
          $alt = " title=\"$row[title]\"";
          $str = "<a href='calendar.php?mode=edit&id=$row[id]&rmode=$mode'$alt>$str</a>";
          $disabled_item_str .= $str;
        }
      }
      echo("$disabled_item_str"); # print disabled items at the end
    }
    echo("</td>\n");

    if ($dow % 7 == 6) echo("</tr><tr>\n");
    $dow++;
    $dow %= 7;
  }

  # blank days follow
  $dow %= 7;
  if ($dow) {
    for ($i = $dow; $i <= 6; $i++) {
      echo("<td><br></td>\n");
    }
  }
  echo("</tr></table>\n");
}

function PrintSchedules($year, $month, &$sch_list, $pre_str='', $post_str='') {
  global $env, $lang;

# $now = CurrentTime();

  $dpm = DaysPerMonth($year, $month);
  for ($day = 1; $day <= $dpm; $day++) {
    $key = sprintf("%d-%02d-%02d", $year, $month, $day);
    if ($sch_list[$key]) {
      $n_sch = sizeof($sch_list[$key]);
      for ($j = 0; $j < $n_sch; $j++) {
        $row = $sch_list[$key][$j];

        $date = sprintf("%4d-%02d-%02d 00:00:00", $year, $month, $day);
        $date = FormatDateAndTime($date, $lang[dateformat2]);
        $str = GetSchedulePrinting($row, $mode);
        echo($pre_str);
        echo("$str (<a href='calendar.php'>$date</a>)<br>\n");
        echo($post_str);

      }
    }
  }
}

?>
