<?php

/************************************************************************/
/* Bookmark4U: Web-based personal bookmarking environment               */
/* ======================================================               */
/* Please read LICENSE.txt                                              */
/************************************************************************/

#############################################################################
# Date Calculation Library. Ver 1.0
# Sangwan Kim
# 2000.04.04
#############################################################################

# Get the current date and time.
# Return an associative array, keys of the array are
# {year, month, day, hour, min, sec}.
# ex) $now = CurrentTime();
#     to get $now[year],$now[mon],$now[day],$now[hour],$now[min],$now[sec]
function CurrentTime() {
  $d = date("Y-m-d H:i:s");
  $date[year]  = (int)substr($d, 0, 4);
  $date[month] = (int)substr($d, 5, 2);
  $date[day]   = (int)substr($d, 8, 2);
  $date[hour]  = (int)substr($d, 11, 2);
  $date[min]   = (int)substr($d, 14, 2);
  $date[sec]   = (int)substr($d, 17, 2);
  return $date;
}

# Return the time after the midnight of 1-Jan-1970 in micro seconds.
function SecondsFrom() {
  $now =  gettimeofday();
  $usec = $now[sec] * 1000000 + $now[usec];
  return $usec;
}

# datetime is a string with format "yyyy-mm-dd hh:mm:ss"
# format is a string including formating sequences.
#   %a   abbreviated weekly name (Sun..Sat)
#   %b   abbreviated month name (Jan..Dec)
#   %d   day of month (01..31)
#   %e   day of month, blank padded ( 1..31)
#   %H   hour (00..23)
#   %I   hour (01..12)
#   %k   hour ( 0..23)
#   %l   hour ( 1..12)
#   %m   month (01..12)
#   %M   minute (00..59)
#   %p   AM or PM
#   %S   second (00..60)
#   %T   time, 24-hour (hh:mm:ss)
#   %w   day of week (0..6); 0 represents Sunday
#   %Y   year (1970...)
#   %y   last two digits of year (00..99)
function FormatDateAndTime($datetime, $format) {
  global $lang;

  if ($datetime == "0000-00-00 00:00:00") return "NULL";
  $ampm = explode(":", $lang[ampm]);
  $dows = explode(":", $lang[dayofweek]);
  $months = explode(":", $lang[months]);

  $d = substr($datetime,8,2);        # day of month (01..31)
  $e = ereg_replace("^0", " ", $d);  # day of month (1..31)
  $H = substr($datetime,11,2);       # hour (00..23)
  $k = ereg_replace("^0", "", $H);   # hour (0..23)
  $l = ($k > 12) ? $k - 12 : $k;     # hour (1..12)
  $I = sprintf("%02d", $l);          # hour (01..12)
  $m = substr($datetime,5,2);        # month (01..12)
  $M = substr($datetime,14,2);       # minute (00..59)
  $p = ($k < 12) ? $ampm[0] : $ampm[1]; # AM or PM
  $S = substr($datetime,17,2);       # second (00..60)
  $T = substr($datetime,11,8);       # time, 24-hour (hh:mm:ss)
  $y = substr($datetime,2,2);        # last two digits of year (00..99)
  $Y = substr($datetime,0,4);        # year (1970...)
  $month = (int)$m;
  $w = DayOfWeek($y, $month, $e);    # day of week (0..6)
  $a = $dows[$w];                    # abbreviated weekly name (Sun..Sat)
  $b = $months[$month-1];            # abbreviated month name (Jan..Dec)

  $ret = $format;
  $ret = ereg_replace("%a", $a, $ret);
  $ret = ereg_replace("%b", $b, $ret);
  $ret = ereg_replace("%d", $d, $ret);
  $ret = ereg_replace("%e", $e, $ret);
  $ret = ereg_replace("%H", $H, $ret);
  $ret = ereg_replace("%I", $I, $ret);
  $ret = ereg_replace("%k", $k, $ret);
  $ret = ereg_replace("%l", $l, $ret);
  $ret = ereg_replace("%m", $m, $ret);
  $ret = ereg_replace("%M", $M, $ret);
  $ret = ereg_replace("%p", $p, $ret);
  $ret = ereg_replace("%S", $S, $ret);
  $ret = ereg_replace("%T", $T, $ret);
  $ret = ereg_replace("%w", $w, $ret);
  $ret = ereg_replace("%Y", $Y, $ret);
  $ret = ereg_replace("%y", $y, $ret);

  return $ret;
}


function PreviousMonth($year, $month) {
  if ($month > 1) return array(year=>$year, month=>$month-1);
  else return array(year=>$year-1, month=>12);
}
function NextMonth($year, $month) {
  if ($month < 12) return array(year=>$year, month=>$month+1);
  else return array(year=>$year+1, month=>1);
}

# Return the number of days of a given month and year.
# ex) $days = DaysPerMonth($year, $month);
function DaysPerMonth($year, $month) {
  if ($month == 1) $days = 31;
  else if ($month == 2) {
    if ($year % 400 == 0) $days = 29;
    else if ($year % 100 == 0) $days = 28;
    else if ($year % 4 == 0) $days = 29;
    else $days = 28;
  }
  else if ($month == 3) $days = 31;
  else if ($month == 4) $days = 30;
  else if ($month == 5) $days = 31;
  else if ($month == 6) $days = 30;
  else if ($month == 7) $days = 31;
  else if ($month == 8) $days = 31;
  else if ($month == 9) $days = 30;
  else if ($month == 10) $days = 31;
  else if ($month == 11) $days = 30;
  else if ($month == 12) $days = 31;
  return $days;
}

# Return the number of days of a given year.
# ex) $days = DaysPerYear($year);
function DaysPerYear($year) {
  if ($year % 400 == 0) $days = 366;
  else if ($year % 100 == 0) $days = 365;
  else if ($year % 4 == 0) $days = 366;
  else $days = 365;
  return $days;
}

# Return the number of days from Jan-1-1900.
# ex) $days = DaysFrom($year, $month, $day);
function DaysFrom($year, $month, $day) {
  $days = 0;
  for ($i = 1900; $i < $year; $i++) $days += DaysPerYear($i);
  for ($i = 1; $i < $month; $i++) $days += DaysPerMonth($year, $i);
  for ($i = 1; $i <= $day; $i++) $days++;
  return $days;
}

# Return an array of the date which is $days'th days from Jan-1-1900.
# Inverse of DaysFrom().
# ex) ($year, $moneh, $day) = DaysFromInv($days);
function DateFromInv($days) {
  $year = 1900;
  while ($days > 0) {
    $temp = DaysPerYear($year);
    if ($days - $temp > 0) { $days -= $temp; $year++; }
    else break;
  }
  $month = 1;
  while ($days > 0) {
    $temp = DaysPerMonth($year, $month);
    if ($days - $temp > 0) { $days -= $temp; $month++; }
    else break;
  }
  $day = $days;

  $ret = array();
  $ret[year] = $year;
  $ret[month] = $month;
  $ret[day] = $day;
  return $ret;
}

function AddDate($year, $month, $day, $days) {
  $day = DaysFrom($year, $month, $day);
  $day += $days;
  $ret = DateFromInv($day);
  return $ret;
}

# Return the day of week of a given date.
# Return the day of week of a given date.
# Return 0 for Sunday, 1 for Monday, ..., 6 for Saturday.
# ex) $dow = DayOfWeek($year, $month, $day);
function DayOfWeek($year, $month, $day) {
  if ($month < 3) { $year--; $month += 12; }
  $dow = ($year + (int)($year / 4) - (int)($year / 100) 
        + (int)($year / 400) + (int)((13 * $month + 8) / 5) + $day) % 7;
  return $dow;
}

# Convert a date-and-time string to an array
# str is a string with format "yyyy-mm-dd hh:mm:ss"
function DateStringToArray($str) {
  $ret = array();
  $ret[year]  = (int)substr($str, 0, 4);
  $ret[month] = (int)substr($str, 5, 2);
  $ret[day]   = (int)substr($str, 8, 2);
  $ret[hour]  = (int)substr($str, 11, 2);
  $ret[min]   = (int)substr($str, 14, 2);
  $ret[sec]   = (int)substr($str, 17, 2);
  return $ret;
}

/*
# Return the day of week of a given date.
# Return a string of the day of week.
# ex) $dow = DayOfWeekWord($year, $month, $day);
function DayOfWeekWord($year, $month, $day) {
  global $lang;
# $list = array("Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat");
  $list = explode(":", $lang[dayofweek]);
  $dow = DayOfWeek($year, $month, $day);
  return $list[$dow];
}

# Return the name of month of year.
function MonthWord($month) {
  if ($month < 1 || $month > 12) return "";
  $list = array('', 'Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun',
                'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec');
  return $list[$month];
}
*/

# Return the number of days beteen two give dates plus one.
# ex) $diff = DiffDate($y1, $m1, $d1, $y2, $m2, $d2);
function DiffDate($y1, $m1, $d1, $y2, $m2, $d2) {
  $result = DaysFrom($y1,$m1,$d1) - DaysFrom($y2,$m2,$d2);
  return $result; 
}
function DiffDateArray($date1, $date2) {
  $result = DaysFrom($date1[year], $date1[month], $date1[day])
          - DaysFrom($date2[year], $date2[month], $date2[day]);
  return $result; 
}

#############################################################################
# IF YOU WANT TEST THIS CODE
# To test this code uncomment the following code block and load this file
# in your web-browser. If required, the file extension should be changed
# to .php from .ph.
/*
$date = CurrentTime();
printf("Current Date(yyyy-mm-dd): <b>%s-%s-%s</b><br>",
 $date[year], $date[month], $date[day]);
echo("Current Time(hh:mm:ss): <b>$date[hour]:$date[min]:$date[sec]</b><br>");
$dow = DayOfWeek($date[year], $date[month], $date[day]);
$dow_str = DayOfWeekWord($date[year], $date[month], $date[day]);
printf("The day of week of today is <b>%d(%s)</b><br>\n",
 $dow, $dow_str);
printf("The number of seconds from midnight of 1-Jan-1970 are <b>%d</b><br>\n",
 SecondsFrom()/1000000);

for ($i = 1; $i <= 12; $i++) {
  printf("The number of days in %s, %d is <b>%d</b><br>\n",
    MonthWord($i), $date[year],
    DaysPerMonth($date[year], $i));
}
for ($i = 1999; $i <= 2010; $i++) {
  printf("The number of days in %d is <b>%d</b><br>\n",
    $i, DaysPerYear($i));
}
printf("The number of days between Jan-1-1900 and Dec-31-1999 is <b>%d</b>"
 ." inclusively.<br>", DaysFrom(1999, 12, 31));
printf("The day, 31-Dec-1999 is <b>%d</b>th day from 1-Jan-1900.<br>\n",
 DaysFrom(1999, 12, 31));
printf("The day, 1-Jan-2000 is <b>%d</b>th day from 1-Jan-1900.<br>\n",
 DaysFrom(2000, 1, 1));
printf("31-Dec-2000 minus 1-Jan-2000 equals <b>%d</b>.<br>\n",
 DiffDate(2000,12,31,2000,1,1));
printf("Today minus 1-Jan-2000 equals <b>%d</b>.<br>\n",
 DiffDate($date[year],$date[month],$date[day],2000,1,1));
printf("31-Dec of this year minus today equals <b>%d</b>.<br>\n",
 DiffDate($date[year],12,31,$date[year],$date[month],$date[day]));
*/
#############################################################################

?>
