<?php

/************************************************************************/
/* Bookmark4U: Web-based personal bookmarking environment               */
/* ======================================================               */
/* Please read LICENSE.txt                                              */
/************************************************************************/

# functions
#   AddForm($row)
#   ModifyForm($row)
#   MoveForm($row)
#   DeleteForm ($row)
#   ClipboardForm($row)
#   PrintDuplicatedBookmarks($url, $ret=0)
#   AddLinkForm($row)

# local values for this file
$lv[w0] = 70;  # leftmost title
$lv[w1] = 75;  # title field width
$lv[sz1] = 40; # three values
$lv[sz2] = 40;
$lv[sz3] = 40;
$lv[text_style] = ($env[stylesheet]) ? " style='width:335'" : "";
$lv[tw]  = "500"; # width tw = 350 + w1 + w0 + some margin

function AddForm($row) {
  global $env, $lang;
  global $lv;
  global $url, $pagetitle;  # for quick-bookmarking
  global $comment;
  global $type;

  # if title is too long, cut it
  $title_short = $row[title];
  CutString($title_short, $length=$env[cut_title]);

  # default values
  $title_value = $pagetitle;
  $url_value = $url;

  # for a link to change parent folder
  $title_enc = urlencode($pagetitle);
  $url_enc = urlencode($url);

  # common tag attribute
  $attr1 = " bgcolor='$env[th]' align='center'";

  echo("<table border='0' cellspacing='1' cellpadding='2' width='$lv[tw]' align='center'>
<form name='addform' method='post' action='add.php'>\n");

  # left-side main title
  echo("<tr><td align='center' rowspan='9' bgcolor='$env[td]' width='$lv[w0]'>
<img src='$env[icon_trdot]' width='$lv[w0]' height='1' border='0'><br>
<img src='$env[icon_add]'><br><b>$lang[add]</b></td>\n");

  # title
  $str = sprintf($lang[addmodify_1], $title_short);
  echo("<td$attr1 height='30' colspan='2'>");
  echo("$str<br>
<a href=\"bookmark.php?mode=chfolder&url=$url_enc&pagetitle=$title_enc#current\">$lang[bookmark_3]</a></td></tr>\n");
  
  # type
  $bkimg = "<img src='$env[icon_bk]' align='top' alt=''>";
  $foimg = "<img src='$env[icon_fo]' align='top' alt=''>";
  $lnimg = "<img src='$env[icon_ln]' align='top' alt=''>";
  $chk_bk = ($type != 'l') ? " checked" : "";
  $chk_ln = ($type == 'l') ? " checked" : "";
  echo("<tr>
  <td$attr1 width='$lv[w1]'>
    <img src='$env[icon_trdot]' width='$lv[w1]' height='1' border='0'><br>
    <nobr>$lang[type]</nobr>
  </td>
  <td bgcolor=$env[td]>
    <input type='radio' name='type' value='b'$chk_bk>$bkimg$lang[bookmark]
    &nbsp;&nbsp;&nbsp;
    <input type='radio' name='type' value='c'>$foimg$lang[folder]
  </td>
  </tr>\n");

  # title
  echo("<tr>
  <td$attr1>
  <nobr><a href=\"javascript:document.addform.title.select();\">$lang[title]</a></nobr>
  </td><td bgcolor='$env[td]'>
  <input type='text' name='title' size='$lv[sz1]' maxlengthth='50'$lv[text_style] value=\"$title_value\" tabindex=\"1\">
  </td></tr>\n");

  # url
  echo("<tr>
  <td$attr1>
  <nobr><a href=\"javascript:document.addform.url.select();\">$lang[url]</a></nobr>
  </td><td bgcolor=$env[td]>
  <input type='text' name='url' size='$lv[sz2]' maxlength='255' value=\"$url_value\"$lv[text_style] tabindex=\"2\">
  </td></tr>\n");

  # description
  echo("<tr>
  <td$attr1>
  <nobr><a href=\"javascript:document.addform.comment.select();\">$lang[description]</a></nobr>
  </td><td bgcolor='$env[td]'>
  <input type='text' name='comment' size='$lv[sz3]' maxlength='255' value=\"$comment\" tabindex=\"3\"$lv[text_style]></td>
  </tr>\n");
  
  # public/private
  if (IsPrivate($env[root])) $chk2 = " checked"; # private is default
  else $chk1 = " checked"; # public is default
  echo("<tr>
  <td$attr1><nobr>$lang[public]</nobr></td>
  <td bgcolor='$env[td]'>
    <input type='radio' name='public' value='1'$chk1> $lang[public]
    <input type='radio' name='public' value='0'$chk2>$lang[private]
  </td>
  </tr>\n");

  # icon
  echo("<script language=\"javascript\" type=\"text/javascript\">
function ResetIcon1() {
  document.addform.icon.value = '';
  document['sample1'].src = '$env[icon_trdot]';
}
function ChangeImg1(form) {
  filename = form.icon.value;
  document['sample1'].src = '$env[myicon_dir]/'+filename;
}
</script>
  <tr>
  <td bgcolor='$env[th]' align='center'><nobr>$lang[icon]</nobr></td>
  <td bgcolor='$env[td]'>
  <img src='$env[icon_trdot]' border='1' width='16' height='16'
   name='sample1' align='top'><input type='text' name='icon' value='' size='10'
   onblur=\"javascript:ChangeImg1(document.addform)\">
  <a href=\"javascript:void(iconselwin=open('selicon.php?form=addform&imgname=sample1','','width=300,height=400,scrollbas=1,resizable=1'))\">[[$lang[list]]]</a>
  <a href='javascript:ResetIcon1();'>[[$lang[delete]]]</a>
  </td>
  </tr>\n");

  # rate
  echo("<tr>
  <td$attr1><nobr>$lang[rate]</nobr></td>
  <td bgcolor='$env[td]'>");
  $values = array(0, 1, 2, 3, 4, 5);
  $img = "<img src='$env[icon_quicklink]' align='top'>";
  $disps = array(0, 1, 2, 3, 4, "$img$lang[quicklinks]");
  FormRadios(sizeof($values), 'rate', $values, $disps, 0);
  echo("</td></tr>\n");

  # for closing the remote window after quick-bookmarking
  if ($env[script_name] == 'bookmark') {
    $close_control = "<input type='hidden' name='close_control' value='1'>";
  } else $close_control = "";

  echo("<tr>
<td colspan='2' align='center' bgcolor='$env[td]'>
<a href=\"javascript:document.addform.submit();\" tabindex=\"6\">[[$lang[add]]]</a>
<input type='checkbox' name='addmore' value='1'> $lang[addform_1]
<input type='checkbox' name='intoclipboard' value='1'> $lang[addform_2]
<input type='hidden' name='parent' value='$row[id]'>
<input type='hidden' name='exp' value='$env[exp]'>
<input type='hidden' name='nochkdup' value='$row[nochkdup]'>
$close_control
<input type='image' src='$env[icon_trdot]' border='0'>
</td></form></table>\n");
}

function ModifyForm($row) {
  global $env, $lang;
  global $lv, $foid;

  # if title is too long, cut it
  $title_cut = $title = $row[title];
  CutString($title_cut, $env[cut_title]);

  # common tag attribute
  $attr1 = " bgcolor='$env[th]' align='center'";

  $type = $row[type];
  $rowspan = 11;
  echo("<table border='0' cellspacing='1' cellpadding='2' width='$lv[tw]'>
<form name='modifyform' method='post' action='modify.php'>\n");

  # left-side main title
  echo("<tr>
<td align='center' rowspan='$rowspan' bgcolor='$env[td]' width='$lv[w0]'>
  <img src='$env[icon_trdot]' width='$lv[w0]' height='1' border='0'><br>
  <img src='$env[icon_change]'><br><b>$lang[change]</b></td>\n");

  # title
  $str = sprintf($lang[addmodify_2], $title_cut);
  echo("<td$attr1 height='30' colspan='2'>$str</td>");
  echo("</tr>\n");

  # type
  $chk1 = ($type == 'b') ? " checked" : "";
  $chk2 = ($type == 'c') ? " checked" : "";
echo("<script language=\"javascript\" type=\"text/javascript\">
function ModifyFormTypeBookmark() {
  document.modifyform.url.disabled = false;
}
function ModifyFormTypeFolder() {
  document.modifyform.url.disabled = true;
}
</script>\n");
  echo("<tr>
  <td$attr1 width='$lv[w1]'>
  <img src='$env[icon_trdot]' width='$lv[w1]' height='1' border='0'><br>
  <nobr>$lang[type]</nobr>
  </td>
  <td bgcolor='$env[td]'>");

  if ($type == 'l') { # link
    echo("<img src='$env[icon_ln]'> $lang[link]
    <input type='hidden' name='type' value='l'>
    <input type='hidden' name='lnid' value='$row[lnid]'>\n");
  } else { # bookmark or folder
    echo("<input type='radio' name='type' value='b'$chk1
  onclick=\"ModifyFormTypeBookmark()\"><img
  src='$env[icon_bk]' align='top' alt=''> $lang[bookmark]
  &nbsp;&nbsp;&nbsp;
  <input type='radio' name='type' value='c'$chk2
  onclick=\"ModifyFormTypeFolder()\"><img
  src='$env[icon_fo]' align='top' alt=''> $lang[folder]\n");
  }
  echo("</td></tr>\n");

  # date
  $date_str = FormatDateAndTime($row[rdate], $lang[dateformat]);
  echo("<tr>
    <td$attr1><nobr>$lang[date]</nobr></td>
    <td bgcolor='$env[td]'><b>$date_str</b></td>
  </tr>\n");

  # title
  $title = ereg_replace("\"", "&quot;", $title);
  echo("<tr>
  <td$attr1>
  <nobr><a href=\"javascript:document.modifyform.title.select();\">$lang[title]</a></nobr></td>
  <td bgcolor='$env[td]'><input type='text' name='title' size='$lv[sz1]'
  maxlengthth='50' value=\"$title\" tabindex=\"1\"$lv[text_style]></td>
  </tr>\n");

  # url
  if ($type != 'l') { # not link
    echo("<tr>
  <td$attr1>
  <nobr><a href=\"javascript:document.modifyform.url.select();\">$lang[url]</a><a href=\"$row[url]\" target='_blank'><img src='$env[icon_bk]' border='0' alt='$lang[visit]'></a></nobr>
  </td>
  <td bgcolor='$env[td]'><input type='text' name='url' size='$lv[sz2]'
  maxlength='255' value=\"$row[url]\" tabindex=\"2\"$lv[text_style]></td>
  </tr>\n");
  }

  # description (comment)
  echo("<tr>
  <td$attr1>
  <nobr><a href=\"javascript:document.modifyform.comment.select();\">$lang[description]</a></nobr></td>
  <td bgcolor='$env[td]'><input type='text' name='comment' size='$lv[sz3]'
  maxlength='255' value=\"$row[comment]\" tabindex=\"3\"$lv[text_style]></td>
  </tr>\n");

  # public/private
  $chk_public = $chk_private = "";
  $recursive = ($type == 'c') ?
    "<input type='checkbox' name='recursive' value='1' tabindex=\"6\">$lang[addmodify_9]" : "";
  if ($row[public]) { $chk_public = " checked"; }
  else { $chk_private = " checked"; }
  echo("<tr>
  <td bgcolor='$env[th]' align='center'><nobr>$lang[public]</nobr></td>
  <td bgcolor='$env[td]'>
    <input type='radio' name='public' value='1' tabindex='4'$chk_public>$lang[public]
    <input type='radio' name='public' value='0' tabindex='5'$chk_private>$lang[private]
    $recursive
  </td>
  </tr>\n");

  # icon
  if ($row[icon]) {
    $icon_file = "$env[myicon_dir]/$row[icon]";
    if (!file_exists($icon_file)) $icon_file = "$env[icon_trdot]";
  } else $icon_file = "$env[icon_trdot]";
  echo("<script language=\"javascript\" type=\"text/javascript\">
function ResetIcon2() {
  document.modifyform.icon.value = '';
  document['sample2'].src = '$env[icon_trdot]';
}
function ChangeImg2(form) {
  filename = form.icon.value;
  document['sample2'].src = '$env[myicon_dir]/'+filename;
}
</script>
<tr>
<td$attr1><nobr>$lang[icon]</nobr></td>
<td bgcolor='$env[td]'>
<img src='$icon_file' border='1' width='16' height='16'
 name='sample2'><input type='text' name='icon' value='$row[icon]' size='10'
 onblur=\"javascript:ChangeImg2(document.modifyform)\" class='transtextinput'>
<a href=\"javascript:void(iconselwin=open('selicon.php?form=modifyform&imgname=sample2','','width=300,height=400,scrollbas=1,resizable=1'))\">[[$lang[list]]]</a>
<a href='javascript:ResetIcon2();'>[[$lang[delete]]]</a>
</td>
</tr>\n");

  # rate
  echo("<tr>
  <td$attr1><nobr>$lang[rate]</nobr></td>
  <td bgcolor='$env[td]'>");
  $values = array(0, 1, 2, 3, 4, 5);
  $disps = array(0, 1, 2, 3, 4, "<img src='$env[icon_quicklink]'>$lang[quicklinks]");
  FormRadios(sizeof($values), 'rate', $values, $disps, $row[rate]);
  echo("</td></tr>\n");

  # includes
  if ($type == 'c') {
    echo("<tr>
    <td$attr1>$lang[include]</td>
    <td bgcolor='$env[td]'><img src='$env[icon_bk]'> $row[total]</td></tr>\n");
  }

  # visit information
  if ($type == 'b') { # if bookmark print the visit count
    # visit counter
    $date_str = FormatDateAndTime($row[lastvisit], $lang[dateformat]);
    echo("<tr>
<td bgcolor=$env[th] align=center><nobr>$lang[visit]</nobr></td>\n");
    printf("<td bgcolor=$env[td]>$lang[addmodify_5]</td>\n</tr>\n",
      $row[visit], $date_str);
  }

  echo("<tr height='30'>
  <td colspan='2' align='center' bgcolor='$env[td]'>");
  echo("<a href=\"javascript:document.modifyform.submit();\" tabindex='7'>[[$lang[change]]]</a>\n");
  echo("<input type='hidden' name='id' value='$row[id]'>
<input type='hidden' name='exp' value='$env[exp]'>
<input type='hidden' name='foid' value='$foid'>
<input type='hidden' name='m' value='modify'>
<input type='image' src='$env[icon_trdot]' border='0'>
</td>
</tr>\n");

  echo("</form>\n</table>\n");
}


function MoveForm($row) {
  global $env, $lang;
  global $lv;

  $title = $row[title];
  CutString($title, $env[cut_title]);

  echo("<table border=0 cellspacing=1 cellpadding=2 width=$lv[tw]>
<form name='movewhereform' method='get' action=movewhere.php>\n");

  echo("<tr>
<td align=center rowspan=2 bgcolor=$env[td] width=$lv[w0]>
<img src=$env[icon_trdot] width=$lv[w0] height=1 border=0><br>
<img src=$env[icon_move]><br>
<b>$lang[move]</b></td>\n");
  printf("<td height=30 bgcolor=$env[th] align=center colspan=2>$lang[addmodify_4]</td></tr>\n", $title);
  echo("<tr height=30>\n");

  echo("<td colspan=2 align=center bgcolor=$env[td]>");
  echo("<a href=\"javascript:document.movewhereform.submit();\" tabindex='8'>[[$lang[move]]]</a>\n");

  echo("<input type=hidden name=id value='$row[id]'>
<input type=hidden name=exp value='$env[exp]'>
<input type=hidden name=type value='$row[type]'>
<input type=hidden name=parent value='$row[parent]'>
<input type=hidden name=target_folder value=\"$row[title]\">
</td>
</tr>
</form>
</table>\n");
}


function DeleteForm ($row) {
  global $env, $lang;
  global $lv;

  $title = $row[title];
  CutString($title, $env[cut_title]);

  echo("<table border=0 cellspacing=1 cellpadding=2 width=$lv[tw]>
<form name='deleteform' method='post' action=del.php>
<tr height=30>
<td align=center rowspan=2 bgcolor=$env[td] width=$lv[w0]>
<img src=$env[icon_trdot] width=$lv[w0] height=1 border=0><br>
<img src=$env[icon_delete]><br>
<b>$lang[delete]</b></td>\n");
  printf("<td height=30 bgcolor=$env[th] align=center colspan=2>$lang[addmodify_3]</td></tr>", $title);
  echo("<tr height=30><td bgcolor=$env[td] align=center colspan=2>\n");

  if ($env[delconfirm]) {
    echo("<script language=\"javascript\" type=\"text/javascript\">\n"
        ."function Question(form) {\n"
        ."  if (confirm('$lang[addmodify_10]')) {\n"
        ."    form.submit();\n"
        ."  } else {\n"
        ."    return;\n"
        ."  }\n"
        ."}\n"
        ."</script>\n");
    echo("<a href='javascript:Question(document.deleteform)' tabindex='9'>[[$lang[delete]]]</a>\n");
  } else {
    echo("<a href='javascript:document.deleteform.submit()' tabindex='9'>[[$lang[delete]]]</a>\n");
  }
  echo("<br>
<input type='checkbox' name='notrash' value='true'>$lang[addmodify_8]
&nbsp; &nbsp;
<a href='trash.php'><img
 src='$env[icon_trash]' border='0' align='top'>$lang[trash]</a>
<input type='hidden' name='id' value='$row[id]'>
<input type='hidden' name='exp' value='$env[exp]'>
</td></tr>
</form></table>\n");
}

function ClipboardForm($row) {
  global $env, $lang;
  global $lv;
  global $exp;

  $title = $row[title];
  CutString($title, $env[cut_title]);

  echo("<table border=0 cellspacing=1 cellpadding=2 width=$lv[tw]>
<tr height=30>
<td align=center rowspan=2 bgcolor=$env[td] width=$lv[w0]>
<img src=$env[icon_trdot] width=$lv[w0] height=1 border=0><br>
<img src=$env[icon_clipboard]><br>
<b>$lang[clipboard]</b></td>\n");

  echo("<td height=30 bgcolor=$env[th] align=center colspan=2>$lang[clipboard]</td></tr>");
  echo("<tr height=30><td bgcolor=$env[td] align=center colspan=2>\n");

  if (!in_array($row[id], $env[clipitems])) {
    $url = "clipboard.php?mode=add&id=$row[id]&exp=$exp";
    echo("<a href='$url'>[[$lang[addmodify_6]]]</a>\n");
  } else {
    $url_enc = urlencode("modifyform.php?id=$row[id]&exp=$exp");
    $url = "clipboard.php?mode=drop&id=$row[id]&exp=$exp&url=$url_enc";
    echo("<a href='$url'>[[$lang[addmodify_7]]]</a>\n");
  }

  if ($row[type]=='c') {
    $url = "clipboard.php?mode=move&id=$row[id]";
    echo("<a href='$url'>[[$lang[paste]]]</a>");
  }

  echo("</td></tr></table>\n");
}

# print bookmarks with the same url
function PrintDuplicatedBookmarks($url, $result = null) {
  global $env, $lang;
  global $mgr;

  if ($result == null)
    $result = $mgr->findBookmarksByUrl($url);

  $cnt = 0;
  while ($row = $result->fetchRow()) {
    $cnt++;
    echo("$cnt. ");
    PrintPath($row);
    echo("<br>\n");
  }
}

function AddLinkForm($row) {
  global $env, $lang;
  global $lv;

  # if title is too long, cut it
  $title_short = $row[title];
  CutString($title_short, $length=$env[cut_title]);

  # default values
  $title_value = sprintf($lang[addmodify_12], $row[title]);
  $comment_value = $row[comment];

  # common tag attribute
  $attr1 = " bgcolor='$env[th]' align='center'";

  echo("<table border='0' cellspacing='1' cellpadding='2' width='$lv[tw]' align='center'>
<form name='addlinkform' method='post' action='add.php'>\n");

  # left-side main title
  echo("<tr><td align='center' rowspan='9' bgcolor='$env[td]' width='$lv[w0]'>
<img src='$env[icon_trdot]' width='$lv[w0]' height='1' border='0'><br>
<img src='$env[icon_ln]'><br><b>$lang[link]</b></td>\n");

  # descriptive title
  $str = sprintf($lang[addmodify_11], $title_short);
  echo("<td$attr1 height='30' colspan='2'>$str</td></tr>\n");

  # title
  echo("<tr>
  <td$attr1 width='$lv[w1]'>
  <nobr><a href=\"javascript:document.addlinkform.title.select();\">$lang[title]</a></nobr>
  </td><td bgcolor='$env[td]'>
  <input type='text' name='title' size='$lv[sz1]' maxlengthth='50'$lv[text_style] value=\"$title_value\">
  </td></tr>\n");

  # description
  echo("<tr>
  <td$attr1>
  <nobr><a href=\"javascript:document.addlinkform.comment.select();\">$lang[description]</a></nobr>
  </td><td bgcolor='$env[td]'>
  <input type='text' name='comment' size='$lv[sz3]' maxlength='255' value=\"$comment_value\"$lv[text_style]></td>
  </tr>\n");

  # public/private
  if (IsPrivate($env[root])) $chk2 = " checked"; # private is default
  else $chk1 = " checked"; # public is default
  echo("<tr>
  <td$attr1><nobr>$lang[public]</nobr></td>
  <td bgcolor='$env[td]'>
    <input type='radio' name='public' value='1'$chk1> $lang[public]
    <input type='radio' name='public' value='0'$chk2>$lang[private]
  </td>
  </tr>\n");

  # icon
  echo("<script>
function ResetIcon3() {
  document.addlinkform.icon.value = '';
  document['sample3'].src = '$env[icon_trdot]';
}
function ChangeImg3(form) {
  filename = form.icon.value;
  document['sample3'].src = '$env[myicon_dir]/'+filename;
}
</script>\n");
  if ($row[icon]) $icon = "$env[myicon_dir]/$row[icon]";
  else $icon = "$env[icon_trdot]";
  echo("<tr>
  <td bgcolor='$env[th]' align='center'><nobr>$lang[icon]</nobr></td>
  <td bgcolor='$env[td]'>
  <img src='$icon' border='1' width='16' height='16'
   name='sample3' align='top'><input type='text' name='icon' size='10'
   onblur=\"javascript:ChangeImg3(document.addlinkform)\" value=\"$row[icon]\">
  <a href=\"javascript:void(iconselwin=open('selicon.php?form=addlinkform&imgname=sample3','','width=300,height=400,scrollbas=1,resizable=1'))\">[[$lang[list]]]</a>
  <a href='javascript:ResetIcon3();'>[[$lang[delete]]]</a>
  </td></tr>\n");

  # rate
  echo("<tr>
  <td$attr1><nobr>$lang[rate]</nobr></td>
  <td bgcolor='$env[td]'>");
  $values = array(0, 1, 2, 3, 4, 5);
  $img = "<img src='$env[icon_quicklink]' align='top'>";
  $disps = array(0, 1, 2, 3, 4, "$img$lang[quicklinks]");
  FormRadios(sizeof($values), 'rate', $values, $disps, 0);
  echo("</td></tr>\n");

  echo("<tr>
<td colspan='2' align='center' bgcolor='$env[td]'>
<a href=\"javascript:document.addlinkform.submit();\">[[$lang[add]]]</a>
<input type='checkbox' name='intoclipboard' value='1'> $lang[addform_2]
<input type='hidden' name='mode' value='addlink'>
<input type='hidden' name='id' value='$row[id]'>
<input type='hidden' name='parent' value='$row[parent]'>
<input type='hidden' name='exp' value='$env[exp]'>
<input type='image' src='$env[icon_trdot]' border='0'>
</td></form></table>\n");
}

?>
