<?php

/************************************************************************/
/* Bookmark4U: Web-based personal bookmarking environment               */
/* ======================================================               */
/* Please read LICENSE.txt                                              */
/************************************************************************/

include("inc/common.php");
include("inc/libimport.php");
include("inc/operaimport.php");
include("inc/xmlimport.php");

if ($env[register_global_off]) {  # register get/post variables as global
  if ($HTTP_SERVER_VARS[REQUEST_METHOD] == 'GET') {
    $which_list = array('mode', 'format', 'id', 'listfolder');
    ExtractVars($HTTP_GET_VARS, $which_list);
  } elseif ($HTTP_SERVER_VARS[REQUEST_METHOD] == 'POST') {
    $which_list = array('id', 'mode', 'dontchange', 'public');
    ExtractVars($HTTP_POST_VARS, $which_list);
    $userfile      = $HTTP_POST_FILES[userfile][tmp_name];
    $userfile_name = $HTTP_POST_FILES[userfile][name];
    $userfile_size = $HTTP_POST_FILES[userfile][size];
    $userfile_type = $HTTP_POST_FILES[userfile][type];
  }
}

CheckAuth('write');

if ($mode == 'netscape_imp') {

  # default public/private attribute during importing
  $env[default_public_import] = ($public) ? 'public' : 'private';

  # check if the file is empty
  if ($userfile == "none") Error($lang[import_e1]);
  if ($userfile_size == 0) Error($lang[import_e2]);

# # get the maximum value of id in user's database
# $qry = "SELECT MAX(id) AS maxid FROM $env[userbm] ORDER BY id DESC";
# $row = DBQueryAndFetchRow($qry);
# $maxid = $row[maxid];
# $maxid++;

  $env[title_icon] = $env[icon_import];
  PageHead($lang[import_0]);

  echo("<table border=0 width=100%><tr><td>\n");
  NetscapeImportBookmark($userfile, $id);
  echo("</td></tr></table>\n");

  echo("Total: $bkcnt bookmarks, and $focnt folders are imported.<br>");
  if ($dontchange) echo("$lang[import_5]");
  else echo("$lang[import_6]");

  echo("<br /><p align=\"middle\"><a href=\"list.php\"><b>$lang[btnset_15]</b></a></p><br />");
  PageTail();
  exit;
}

if ($mode == 'opera_imp') {

  # default public/private attribute during importing
  $env[default_public_import] = ($public) ? 'public' : 'private';

  # check if the file is empty
  if ($userfile == "none") Error($lang[import_e1]);
  if ($userfile_size == 0) Error($lang[import_e2]);

# # get the maximum value of id in user's database
# $qry = "SELECT MAX(id) AS maxid FROM $env[userbm] ORDER BY id DESC";
# $row = DBQueryAndFetchRow($qry);
# $maxid = $row[maxid];
# $maxid++;

  $env[title_icon] = $env[icon_import];
  PageHead($lang[import_0]);

  echo("<table border=0 width=100%><tr><td>\n");
  OperaImportBookmark($userfile, $id);
  echo("</td></tr></table>\n");

  echo("Total: $bkcnt bookmarks, and $focnt folders<br>");
  if ($dontchange) echo("$lang[import_5]");
  else echo("$lang[import_6]");

  echo("<br /><p align=\"middle\"><a href=\"list.php\"><b>$lang[btnset_15]</b></a></p><br />");
  PageTail();
  exit;
}

if ($mode == 'xml_imp') {

# # get the maximum value of id in user's database
# $qry = "SELECT MAX(id) AS maxid FROM $env[userbm] ORDER BY id DESC";
# $row = DBQueryAndFetchRow($qry);
# $maxid = $row[maxid];
# $maxid++;

  # check if the file is empty
  if ($userfile == "none") Error($lang[import_e1]);
  if ($userfile_size == 0) Error($lang[import_e2]);

  $env[title_icon] = $env[icon_import];
  PageHead($lang[import_0]);

  XmlImportBookmark($userfile, $id);

  echo("<br>Total: $bkcnt bookmarks, and $focnt folders<br>");
  if ($dontchange) echo("$lang[import_5]");
  else echo("$lang[import_6]");

  echo("<br /><p align=\"middle\"><a href=\"list.php\"><b>$lang[btnset_15]</b></a></p><br />");
  PageTail();
  exit;
}

if ($mode == 'html_imp') {
# # get the maximum value of id in user's database
# $qry = "SELECT MAX(id) AS maxid FROM $env[userbm] ORDER BY id DESC";
# $row = DBQueryAndFetchRow($qry);
# $maxid = $row[maxid];
# $maxid++;

  # check if the file is empty
  if ($userfile == "none") Error($lang[import_e1]);
  if ($userfile_size == 0) Error($lang[import_e2]);

  $env[title_icon] = $env[icon_import];
  PageHead($lang[import_0]);

  HtmlImportBookmark($userfile, $id);

  echo("<br>Total: $bkcnt bookmarks, and $focnt folders<br>");
  if ($dontchange) echo("$lang[import_5]");
  else echo("$lang[import_6]");

  echo("<br /><p align=\"middle\"><a href=\"list.php\"><b>$lang[btnset_15]</b></a></p><br />");
  PageTail();
  exit;
}


# select a bookmark file to be imported
if ($mode == 'file') {
  $env[title_icon] = $env[icon_import];
  PageHead($lang[import_0]);
  ButtonSet();

  $mode_val = "${format}_imp";
  echo("<center>
$lang[import_1]
<form enctype='multipart/form-data' action='import.php' method='post' name='sendform'>
<input type='hidden' name='MAX_FILE_SIZE' value='1000000'>
$lang[import_2]: <input name='userfile' type='file'><br>
<br>
<input type='checkbox' name='dontchange' value='1'> $lang[import_4]<br>\n");
if ($format == 'netscape' || $format == 'opera') {
  echo("$lang[import_8] :
<input type='radio' name='public' value='1' checked>$lang[public]
<input type='radio' name='public' value='0'>$lang[private]<br>");
}
echo("<br>
<a href=\"javascript:document.sendform.submit();\">$lang[import_3]</a>
<input type='hidden' name='id' value='$id'>
<input type='hidden' name='mode' value='$mode_val'>
</form>
</center>\n");
  PageTail();
  exit;
}

if ($mode == 'select') {
  $env[title_icon] = $env[icon_import];
  PageHead($lang[import_0]);
  ButtonSet();
  if ($format == 'netscape')
    ListFolder(0, 0, "import", "&mode=file&format=netscape", $env[root]);
  else if ($format == 'opera')
    ListFolder(0, 0, "import", "&mode=file&format=opera", $env[root]);
  else if ($format == 'xml')
    ListFolder(0, 0, "import", "&mode=file&format=xml", $env[root]);
  else if ($format == 'html')
    ListFolder(0, 0, "import", "&mode=file&format=html", $env[root]);
  else Error("Wrong format");
  PageTail();
  exit;
}

$env[title_icon] = $env[icon_import];
PageHead($lang[import_0]);
ButtonSet();

echo("
<script>
function ImportLocalBookmarks() {
  window.external.ImportExportFavorites(false, ''); // export local bookmarks
}
</script>
<center>
<br>
<a href=\"javascript:ImportLocalBookmarks()\">[[$lang[import_9]]]</a>
<br><br>
</center>

<table border='0' align='center'>
<form action='import.php' method='get'>
<tr>
  <td colspan='2' align='center'>$lang[import_7]</td>
</tr>
<tr>
  <td align='right'>$lang[export_3] :</td>
  <td>
    <input type='radio' name='format' value='netscape' checked> Netscape/Internet Explorer
    <input type='radio' name='format' value='xml'> XML
    <input type='radio' name='format' value='opera'> Opera
  </td>
</tr>
<tr>
  <td align='right'></td>
  <td>
    <input type='hidden' name='mode' value='select'>
    <input type='submit' value='$lang[import]'>
  </td>
</tr>
</form>
</table>\n");

PageTail();

?>
