<?php

/************************************************************************/
/* Bookmark4U: Web-based personal bookmarking environment               */
/* ======================================================               */
/* Please read LICENSE.txt                                              */
/************************************************************************/

$env[pass_without_login] = 1;
include("inc/common.php");
include("inc/calendar.php");

if ($env[register_global_off]) {  # register get/post variables as global
  if ($HTTP_SERVER_VARS[REQUEST_METHOD] == 'GET') {
    $which_list = array('userid', 'url', 'pagetitle');
    ExtractVars($HTTP_GET_VARS, $which_list);
  } elseif ($HTTP_SERVER_VARS[REQUEST_METHOD] == 'POST') {
  }
}

if (!$HTTP_SERVER_VARS[PHP_AUTH_USER]) {
  header("WWW-authenticate: basic realm=\"Bookmark4U\"");
  header("HTTP/1.0 401 Unauthorized");
  echo("Login Fail.");
  exit;
}

# check password and update login information of database
LoginAndUpdate($HTTP_SERVER_VARS[PHP_AUTH_USER],
  $HTTP_SERVER_VARS[PHP_AUTH_PW]);

$env[logined] = 1;  ### login successfully

# load configuration, language, and theme
include("inc/common.load.php");

# set cookie variables
SetLoginCookies($HTTP_SERVER_VARS[PHP_AUTH_USER], $env[uid], $env[dummy]);

if ($url) $redirect = "bookmark.php?url=$url&pagetitle=$pagetitle";
else {
  $redirect = "$env[start_script].php";
}

if ($env[login_info]) {
  LoginPage($redirect, $lastlogin, $lastip);
} else {
  header("Location: $redirect");
}

?>
