<?php

/************************************************************************/
/* Bookmark4U: Web-based personal bookmarking environment               */
/* ======================================================               */
/* Please read LICENSE.txt                                              */
/************************************************************************/

$env[pass_without_login] = 1;
include("inc/common.php");

if ($env[register_global_off]) {  # register get/post variables as global
  if ($HTTP_SERVER_VARS[REQUEST_METHOD] == 'GET') {
    $which_list = array('userid');
    ExtractVars($HTTP_GET_VARS, $which_list);
  } elseif ($HTTP_SERVER_VARS[REQUEST_METHOD] == 'POST') {
  }
}

if (!$userid) Error($lang[msg_req_id]);

if (!$env[allow_guest_login] && !$env[logined]) Error("Can't access");

# query if the userid exist
$row = $userMgr->findUserByLogin($userid);
if (!$row) Error("User '$userid' does not exist");
$uid = $row[uid];

# set cookie variables
PutCookie("GUEST_MODE", "1");
PutCookie("GUSER", $userid);
PutCookie("GUID", $uid);
PutCookie("GTIME", $env[dummy]);
if ($env[secure_cookie]) { # use hashed cookie
  $token = md5("$userid:$uid:$env[dummy]:$env[static_cookie]:$env[dbname]");
} else { # use a unhashed cookie
  $token = $env[static_cookie];
}
PutCookie("GTOKEN", $token);

$redirect = "list.php?root=0";
header("Location: $redirect");

?>
