<?php

/************************************************************************/
/* Bookmark4U: Web-based personal bookmarking environment               */
/* ======================================================               */
/* Please read LICENSE.txt                                              */
/************************************************************************/

include("inc/common.php");

if ($env[register_global_off]) {  # register get/post variables as global
  if ($HTTP_SERVER_VARS[REQUEST_METHOD] == 'GET') {
    $which_list = array('id', 'exp', 'mode', 'which');
    ExtractVars($HTTP_GET_VARS, $which_list);
  } elseif ($HTTP_SERVER_VARS[REQUEST_METHOD] == 'POST') {
  }
}

function ImportTree($item) {
  global $mgr;
  
  while ( list($key, $row) = each($item[children]) ) {
    $rowCreate         = array();
    $rowCreate[parent] = $item[id];  
    $rowCreate[type]   = $row[type];  
    $rowCreate[title]  = $row[title];
    $rowCreate[url]    = $row[url];
    $rowCreate[comment]= $row[comment];
    $rowCreate[icon]   = $row[icon];
    $rowCreate[public] = $row[public];
    $rowCreate[total]  = $row[total];
    $lastId = $mgr->addItem( $rowCreate );   
    $row[id] = $lastId;
    
    if ( $row[type] == 'c' ) {
      ImportTree($row);
    }
  }
}

$realUser = GetCookie("USER");
   
print_r($row);
// import bookmark or a folder and all children
if ( $mode == 'add' ) {  
  $row = $mgr->findItemById( $which );

  if ($row[type] == 'b') {
    $mgr->setUser( $realUser );  
    
    $rowCreate         = array();
    $rowCreate[parent] = $id;
    $rowCreate[type]   = $row[type];    
    $rowCreate[title]  = $row[title];
    $rowCreate[url]    = $row[url];
    $rowCreate[comment]= $row[comment];
    $rowCreate[icon]   = $row[icon];
    $rowCreate[public] = $row[public];
    
    $mgr->addItem( $rowCreate );   
  }
  else if ($row[type] == 'c') {
    $result = $mgr->findAllItems();
    $rootTree = CreateTree($result, $which);
    
    $mgr->setUser( $realUser );
    $rowCreate         = array();
    $rowCreate[parent] = $id;
    $rowCreate[type]   = $row[type];         
    $rowCreate[title]  = $row[title];
    $rowCreate[comment]= $row[comment];
    $rowCreate[icon]   = $row[icon];
    $rowCreate[public] = $row[public];
    $rowCreate[total]  = $row[total];
    $rootId = $mgr->addItem( $rowCreate );     
    
    $rootTree[id] = $rootId;    
    ImportTree( $rootTree );
  }
  UpdateTotalLeaf($id);  
  
  header("Location: list.php");
  exit;
}

$env[title_icon] = $env[icon_move];
PageHead($lang[import]);

$row = $mgr->findItemById( $id );

if ($row[type] == 'b') {
  $img = "<img src=$env[icon_bk] align=top>";
} else if ($row[type] == 'c') {
  $img = "<img src=$env[icon_fo] align=top>";
}

printf($lang[move_1], $img, $row[title]);

$exp_parm = ($env[tree_view]) ? "&exp=$env[exp]" : "";

$option = "&mode=add&which=$id$exp_parm";
$current = 0;

$mgr->setUser( $realUser );

ListFolder(0, 0, 'guestimport', $option, $current);

PageTail();

?>
