<?php

/************************************************************************/
/* Bookmark4U: Web-based personal bookmarking environment               */
/* ======================================================               */
/* Please read LICENSE.txt                                              */
/************************************************************************/

include("inc/common.php");
include("inc/libexport.php");

if ($env[register_global_off]) {  # register get/post variables as global
  if ($HTTP_SERVER_VARS[REQUEST_METHOD] == 'GET') {
    $which_list = array('mode', 'text', 'format', 'id', 'exp_private', 'listfolder');
    ExtractVars($HTTP_GET_VARS, $which_list);
  } elseif ($HTTP_SERVER_VARS[REQUEST_METHOD] == 'POST') {
  }
}

CheckAuth('write'); # guest user can export bookmark DB

$dn_date = date('Y-m-d');  # date string for download filename

function getRootTree($id) {
  global $exp_private, $mgr;

  $orderQry = "type DESC, title ASC";
  $result = $mgr->findAllItems(null, $orderQry, !$exp_private);
  $rootTree = CreateTree($result, $id);
  return $rootTree;
}

if ($mode == 'netscape_exp') {
  if ($text == 'dos') $eol = "\r\n"; else $eol = "\n";   # end of line

  # file downloading header
  DownloadHeader("bm4u-netscape-$dn_date.html");

  echo("<!DOCTYPE NETSCAPE-Bookmark-file-1>$eol");
  echo("<!-- This is an automatically generated file.$eol");
  echo("It will be read and overwritten.$eol");
  echo("Do Not Edit! -->$eol");
  echo("<TITLE>$env[user]'s Bookmark</TITLE>$eol");
  echo("<H1>Bookmarks</H1>$eol");
  echo("<DL><p>$eol");
  $cnt_b = $cnt_c = 0;
  NetscapeExportBookmarks(getRootTree($id), 0);
  echo("</DL><p>$eol");
  echo("<!-- $cnt_b bookmarks, $cnt_c folders -->$eol");
  exit;
} 

if ($mode == 'opera_exp') {
  if ($text == 'dos') $eol = "\r\n"; else $eol = "\n";   # end of line

  # file downloading header
  DownloadHeader("bm4u-opera-$dn_date.txt");

  echo("Opera Hotlist version 2.0$eol$eol");
  OperaExportBookmarks(getRootTree($id), 0);
  exit;

}

if ($mode == 'xml_exp') {
  if ($text == 'dos') $eol = "\r\n"; else $eol = "\n";   # end of line

  # file downloading header
  DownloadHeader("bm4u-xml-$dn_date.xml");

  echo("<?xml version=\"1.0\" encoding=\"$env[doc_encoding]\"?>$eol");
  $now = date('Y-m-d H:i:s');
  echo ("<!-- exported by Bookmark4U version $env[version] at $now -->$eol");
  echo("<bookmark4u version=\"1.0\">$eol");
  XmlExportBookmarks(getRootTree($id), 0);
  echo ("</bookmark4u>$eol");
  echo("<!-- $cnt_b bookmarks, $cnt_c folders -->$eol");
  exit;
}

if ($mode == 'select') {
  $env[title_icon] = $env[icon_export];
  PageHead($lang[export_0]);
  $option = "&exp_private=$exp_private&text=$text";
  if ($format == 'netscape') {
    ListFolder(0, 0, "export", "&mode=netscape_exp$option", $env[root]);
  } else if ($format == 'opera') {
    ListFolder(0, 0, "export", "&mode=opera_exp$option", $env[root]);
  } else if ($format == 'xml') {
    ListFolder(0, 0, "export", "&mode=xml_exp$option", $env[root]);
  } else Error("Wrong format");
  echo("<br /><p align=\"middle\"><a href=\"list.php\"><b>$lang[btnset_15]</b></a></p><br />");
  PageTail();
  exit;
}

$env[title_icon] = $env[icon_export];
PageHead($lang[export_0]);
ButtonSet();


echo("<script>
function ExportLocalBookmarks() {
  window.external.ImportExportFavorites(true, '".$env[sitehome]."/export.php?mode=netscape_exp'); // export local bookmarks
}
</script>
<center>
<br>
<a href=\"javascript:ExportLocalBookmarks()\">[[$lang[export_5]]]</a>
<br><br>
</center>\n");

echo("<table border='0' align='center'>
<form action='export.php' method='get'>
<tr>
  <td colspan='2' align='center'>$lang[export_1]</td>
</tr>
<tr>
  <td align='right'>$lang[export_3] :</td>
  <td>
    <input type='radio' name='format' value='netscape' checked> Netscape/Internet Explorer
    <input type='radio' name='format' value='xml'> XML
    <input type='radio' name='format' value='opera'> Opera
  </td>
</tr>
<tr>
  <td align='right'>$lang[export_2] :</td>
  <td>
    <input type='radio' name='text' value='dos' checked> DOS
    <input type='radio' name='text' value='unix'> UNIX
  </td>
</tr>
<tr>
  <td align='right'>$lang[export_4] :</td>
  <td>
    <input type='radio' name='exp_private' value='1' checked> $lang[yes]
    <input type='radio' name='exp_private' value='0'> $lang[no]
  </td>
</tr>
<tr>
  <td align='right'></td>
  <td>
    <input type='hidden' name='mode' value='select'>
    <input type='submit' value='$lang[export]'>
  </td>
</tr>
</form>
</table>\n");

PageTail();

?>
