<?php

/************************************************************************/
/* Bookmark4U: Web-based personal bookmarking environment               */
/* ======================================================               */
/* Please read LICENSE.txt                                              */
/************************************************************************/

include("inc/common.php");

CheckAuth('write');

$env[title_icon] = $env[icon_etc];
PageHead($lang[etc_0]);
ButtonSet();

# detect the used protocol
$protocol = GetProtocol();
# replace protocol name in the sitehome
# used for quickmark and Netscape side tab
$sitehome = ereg_replace("^http[s]*", "$protocol", $env[sitehome]);


$attr = " border=0 align=top width=16 height=16";

echo("<table border=0 width=100% cellpadding=3 cellspacing=3>
<tr>
 <td>
   <a href=import.php><img src=$env[icon_import]$attr> <b>$lang[import]</b></a>
 </td>
 <td>
  <a href='import.php'>$lang[etc_1]</a>
  <a href=help.php#import target=_blank>($lang[help])</a>
 </td>
</tr>

<tr>
 <td>
  <a href=export.php><img src=$env[icon_export]$attr> <b>$lang[export]</b></a>
 </td>
 <td>
  <a href=export.php>$lang[etc_2]</a>
  <a href=help.php#export target=_blank>($lang[help])</a>
 </td>
</tr>\n");

# Quickmarks
# unescaped title
//$quickmark1 = "javascript:void(open('$env[sitehome]/bookmark.php?userid=$env[user]&url='+escape(document.location)+'&pagetitle='+document.title+'&dummy='+Math.random(),'bookmark4u','width=600,height=400,scrollbars=1,resizable=1'));";
# escaped title
$quickmark = "javascript:void(open('$env[sitehome]/bookmark.php?userid=$env[user]&url='+escape(document.location)+'&pagetitle='+escape(document.title)+'&dummy='+Math.random(),'bookmark4u','width=600,height=400,scrollbars=1,resizable=1'));";

$qm_name = sprintf("<b>$lang[etc_3b]</b>", $env[user]);
echo("<tr>
 <td><img src=$env[icon_quickmark]$attr> <b>$lang[etc_3]</b></td>
 <td>
 <a href=\"$quickmark\">$qm_name</a><br>\n");
//echo("<a href=\"$quickmark2\">$qm_name(b)</a> - escaped document.title<br>\n");
echo("$lang[etc_3a] <a href=help.php#bookmark target=_blank>($lang[help])</a><br>
 </td>
</tr>
<tr>
 <td><a href='clipboard.php'><img src=$env[icon_clipboard]$attr> <b>$lang[clipboard]</b></a></td>
 <td>
  <a href='clipboard.php'>$lang[etc_11]</a>
  <a href='help.php#clipboard' target=_blank>($lang[help])</a>
 </td>
</tr>
<tr>
 <td><a href='trash.php'><img src=$env[icon_trash]$attr> <b>$lang[trash]</b></a></td>
 <td>
  <a href='trash.php'>$lang[btnset_14]</a>
  <a href='help.php#trash' target=_blank>($lang[help])</a>
 </td>
</tr>
<tr>
 <td><a href='memo.php'><img src='$env[icon_memo]'$attr> <b>$lang[memo]</b></a></td>
 <td><a href='memo.php'>$lang[btnset_8]</a></td>
</tr>
<tr>
 <td><a href='visited.php'><img src='$env[icon_visited]'$attr> <b>$lang[visited]</b></a></td>
 <td><a href='visited.php'>$lang[btnset_3]</a></td>
</tr>
<tr>
 <td><a href='calendar.php'><img src='$env[icon_calendar]'$attr> <b>$lang[calendar]</b></a></td>
 <td>
  <a href='calendar.php'>$lang[etc_15]</a>
  <a href='help.php#calendar' target=_blank>($lang[help])</a>
 </td>
</tr>
<tr>
 <td><a href='searchform.php'><img src='$env[icon_search]'$attr> <b>$lang[search]</b></a></td>
 <td>
  <a href='searchform.php'>$lang[etc_17]</a>
 </td>
</tr>

<tr>
 <td>
   <a href='changepw.php'><img src='$env[icon_key]'$attr> <b>$lang[password]</b></a>
 </td>
 <td><a href='changepw.php'>$lang[etc_4]</a></td>
</tr>\n");

echo("<tr>
 <td>
  <a href='clear.php'><img src='$env[icon_clear]'$attr$env[main_target]> <b>$lang[clear]</b></a>
 </td>
 <td><a href='clear.php'>$lang[etc_7]</a></td>
</tr>
<tr>
 <td>
  <a href='unregister.php'><img src='$env[icon_stop]'$attr$env[main_target]> <b>$lang[unregister]</b></a>
 </td>
 <td><a href='unregister.php'>$lang[etc_14]</a></td>
</tr>

<tr>
 <td>
  <a href='myinfo.php'><img src='$env[icon_myinfo]'$attr> <b>$lang[etc_8a]</b></a>
 </td>
 <td><a href='myinfo.php'>$lang[etc_8b]</a></td>
</tr>

<script>
function AddNetscapeTab(urlformat) {
  form = document.netscapesidebarform;
  if ((typeof window.sidebar == 'object')
    && (typeof window.sidebar.addPanel == 'function')) {
    if (urlformat == 'urlhtml')
      window.sidebar.addPanel(form.title.value, form.urlhtml.value,'');
    else
      window.sidebar.addPanel(form.title.value, form.urlxul.value,'');
  }
}
</script>
<form name='netscapesidebarform'>
<tr>
 <td>
  <img src='$env[icon_netscape]'$attr> <b>$lang[etc_9a]</a></b>
 </td>
 <td>
 <input type='hidden' name='title' value='Bookmark4U'>
 <input type='hidden' name='urlhtml' value='$sitehome/index.php?target=_content'>
 <input type='hidden' name='urlxul' value='$sitehome/xullist.php'>
 <a href=\"javascript:AddNetscapeTab('urlhtml')\">$lang[etc_9b] HTML</a> / <a href=\"javascript:AddNetscapeTab('urlxul')\">$lang[etc_9b] XUL</a>
 </td>
</tr>
</form>\n");

echo("<tr>
 <td>
  <img src='$env[icon_msie]'$attr> <b>Internet Explorer</a></b>
 </td>
 <td>
  <a href='msietab.reg.php'>$lang[etc_16]</a>
 </td>
</tr>\n");
echo("<tr>
 <td>
  <img src=$env[icon_weather]$attr> <b>$lang[etc_10a]</b>
 </td>
 <td>
 <a href=\"javascript:void(0)\" onclick=\"javascript:window.open('list.php','bm4u_remote','width=600,height=300,scrollbars=1,resizable=1,status=1')\">$lang[etc_10]</a>
 </td>
</tr>
<tr>
 <td><a href='setenv.php?url=list.php&key=SEARCHES&val='><img src=$env[icon_h_layer]$attr> <b>$lang[etc_12]</b></a></td>
 <td><a href='setenv.php?url=list.php&key=SEARCHES&val='>$lang[etc_13]</a></td>
</tr>
<tr>
 <td>
  <img src=$env[icon_version]$attr> <b>Version</b>
 </td>
 <td>Bookmark4U $env[version].
 <a href=swupdate.php>(Click here to check the latest version)</a><br>
  Language pack version $lang[language_pack_version]<br>
 </td>
</tr>

</table>\n");

PageTail();
exit;

?>
