var oldX, oldY, newX, newY, dragThis;

function beginDrag(event) {
  if(!event)
    event = window.event; // for old IE
  if (event.target)  // W3C
    dragThis = event.target;
  else if (event.srcElement) // old IE
      dragThis = event.srcElement;
    else return;
  while (dragThis.id == null || dragThis.id.indexOf('Drag') == -1) {
    if ( dragThis.parentNode ) // W3C
      dragThis = dragThis.parentNode;
    else if ( dragThis.parentElement ) // old IE
        dragThis = dragThis.parentElement;
      else {
        dragThis = null;
        return;
      }
  }
  if ( event.pageX ) { // W3C
    oldX = event.pageX;
    oldY = event.pageY;
  }
  else { // for old IE
    oldX = (event.clientX + document.body.scrollLeft);
    oldY = (event.clientY + document.body.scrollTop);
  }
}



function dragIt(event) {
  if(!event)
    event = window.event; // for old IE
  if (dragThis == null) return;
  
  if ( event.pageX ) {     // W3C
    newX = event.pageX;
    newY = event.pageY;
  }
  else { // for old IE
    newX = (event.clientX + document.body.scrollLeft);
    newY = (event.clientY + document.body.scrollTop);
  }
  
  var distanceX = (newX - oldX);
  var distanceY = (newY - oldY);
  oldX = newX;
  oldY = newY;
  if (dragThis.style.pixelLeft != null) { // old IE
    dragThis.style.pixelLeft += distanceX;
    dragThis.style.pixelTop += distanceY;
  }
  else if(dragThis.style.left != null) { // W3C
    dragThis.style.left = parseInt(dragThis.style.left) + distanceX;
    dragThis.style.top = parseInt(dragThis.style.top) + distanceY;
  }
  
  if (event.preventDefault) // W3C
    event.preventDefault();
  //if(event.returnValue != null) // old IE
    event.returnValue = false;
}
function setDrag(ix, iy) {
  drag = document.getElementById('Drag');
  if(drag.style.left != null) {// W3C
    drag.style.left = ix;
    drag.style.top = iy;
  }
  else if (drag.style.posLeft != null) { // old IE
    drag.style.posLeft = ix;
    drag.style.posTop = iy;
  }
  document.onmousemove = dragIt;
  document.onmouseup   = endDrag;
  oldX = oldY = newX = newY = 0, dragThis = null;
}

function HL_Fix(url) {
  drag = document.getElementById('Drag');
  if(drag.style.left != null) {// W3C
    window.location = url + '&history_layer_show=1&hlpx='
     + drag.style.left + '&hlpy=' + drag.style.top;
  }
  else if (drag.style.posLeft != null) { // old IE
    window.location = url + '&history_layer_show=1&hlpx='
     + drag.style.posLeft + '&hlpy=' + drag.style.posTop;
  }
}
function HL_Float(url) {
  window.location = url + '&history_layer_show=0';
}

var history_layer_on = 0;
function ShowHistoryLayer(focus, fading) {
  drag = document.getElementById('Drag');
  if (history_layer_on) { HideHistoryLayer(fading); return; }
  if (fading && drag.filters) drag.filters.blendTrans.apply();
  if (document.layers) document.layers.Drag.visibility = 'show';
  else drag.style.visibility = 'visible';
  if (fading && drag.filters) drag.filters.blendTrans.play();
  history_layer_on = 1;
  if (focus) { document.searchform3.k.focus(); }
}
function HideHistoryLayer(fading) {
  drag = document.getElementById('Drag');
  if (fading && drag.filters) drag.filters.blendTrans.apply();
  if (document.layers) document.layers.Drag.visibility = 'hide';
  else drag.style.visibility = 'hidden';
  history_layer_on = 0;
  if (fading && drag.filters) drag.filters.blendTrans.play();
}
function SelectHistory(form) {
  ndx = form.history.selectedIndex;
  v = new String(form.history.options[ndx].value);
  tag = v.substring(0, 2);
  value = v.substring(2, v.length);
  if (tag == 's:') {
    url = 'search.php?k=' + value;
    document.location = url;
  } else if (tag == 'f:') {
    url = 'list.php?root=' + value;
    document.location = url;
  }
}
function ResizeWindow(wx, wy) {
  if (window.top.resizeTo) {
    window.top.resizeTo(wx, wy);
  }
}

function PageFocus() {
  window.focus(); // to obtain focus
  window.GetAttention(); // to flash the application icon to get the user's attention
  document.getElementById('addform').title.focus();
  document.getElementById('addform').title.select();
}

var iconTreeCollapseSrc, iconTreeExpandSrc, titleCollapse, titleExpand;

function ToggleChildDiv(parentId, iconCollapseSrc, iconExpandSrc) {
  childDiv = document.getElementById('child_div_'+parentId);
  iconTree = document.getElementById('iconTree_'+parentId);
  folderIcon = document.getElementById('folderIcon_'+parentId);
  if (childDiv.style.display == "none") {
    childDiv.style.display = "";
    iconTree.src = iconTreeCollapseSrc;
    iconTree.title = titleCollapse;
    folderIcon.src = iconCollapseSrc;
  }
  else {
    childDiv.style.display = "none";
    iconTree.src = iconTreeExpandSrc;
    iconTree.title = titleExpand;
    folderIcon.src = iconExpandSrc;
  }
}

