<?php

/************************************************************************/
/* Bookmark4U: Web-based personal bookmarking environment               */
/* ======================================================               */
/* Please read LICENSE.txt                                              */
/************************************************************************/

include("inc/common.php");

if ($env[register_global_off]) {  # register get/post variables as global
  if ($HTTP_SERVER_VARS[REQUEST_METHOD] == 'GET') {
    $which_list = array('mode', 'id', 'exp', 'listfolder');
    ExtractVars($HTTP_GET_VARS, $which_list);
  } elseif ($HTTP_SERVER_VARS[REQUEST_METHOD] == 'POST') {
  }
}

CheckAuth('write');

$clipbrd = GetCookie("CLIPBRD");
$items = $env[clipitems];

if ($mode == 'move') {
  if (!$clipbrd) Error($lang[clipboard_5]);
  for ($i = 0; $i < sizeof($items); $i++) {
    MoveItem($items[$i], $id);
  }
  PutCookie("CLIPBRD", "");
  header("Location: list.php?root=$id");
  exit;
}

if ($mode == 'movewhere') {
  if (!$clipbrd) Error($lang[clipboard_5]);
  $env[title_icon] = $env[icon_move];
  PageHead($lang[move]);
  echo($lang[clipboard_4]);
  ButtonSet();
  ListFolder(0, 0, "clipboard", "&mode=move", $env[root]);
  PageTail();
  exit;
}

if ($mode == 'del') {
  if (!$clipbrd) Error($lang[clipboard_6]);
  for ($i = 0; $i < sizeof($items); $i++) {
    DeleteItem($items[$i]);
  }
  header("Location: list.php");
  exit;
}

if ($mode == 'clear') {
  PutCookie("CLIPBRD", "");
  header("Location: clipboard.php");
  exit;
}

if ($mode == 'add') { # ADD this item into clipboard
  if (!$id) Error("Require id");
  if (!$clipbrd) {
    PutCookie("CLIPBRD", "$id");
  } else {
    if (!in_array($id, $items)) {
      PutCookie("CLIPBRD", "$clipbrd:$id");
    } else {
      Error("It is in the clipboard already");
    }
  }

  $exp_arg = ($exp) ? "&exp=$exp" : "";
  if ($url) header("Location: $url");
  else header("Location: list.php?dummy=$env[dummy]$exp_arg#$id");
  exit;
}

if ($mode == 'drop') { # drop this item from clipboard
  if (!$id) Error("Require id");
  $clipbrd = "";
  for ($i = 0; $i < sizeof($items); $i++) {
    $no = $items[$i];
    if (!$no) continue;
    if ($no != $id) {
      if (!$clipbrd) $clipbrd = "$no";
      else $clipbrd .= ":$no";
    }
  }
  PutCookie("CLIPBRD", "$clipbrd");

  $exp_arg = ($exp) ? "&exp=$exp" : "";
  if ($url) header("Location: $url");
  else header("Location: clipboard.php?dummy=$env[dummy]$exp_arg");
  exit;
}

if ($mode == 'switch') {
  if (!$id) Error("Require id");

  # delete it from clipboard
  $clipbrd = "";
  $found = 0;
  for ($i = 0; $i < sizeof($items); $i++) {
    if (!$items[$i]) continue;
    if ($items[$i] != $id) {
      if (!$clipbrd) $clipbrd = $items[$i];
      else $clipbrd .= ":$items[$i]";
    } else {
      $found = 1;
    }
  }
  if ($found) {
    PutCookie("CLIPBRD", "$clipbrd");
  } else {

    # or add it into clipboard
    if (!$clipbrd) {
      PutCookie("CLIPBRD", "$id");
    } else {
      if (!in_array($id, $items)) {
        PutCookie("CLIPBRD", "$clipbrd:$id");
      } else {
        Error("It is in the clipboard already");
      }
    }
  }

  $exp_arg = ($exp) ? "&exp=$exp" : "";
  if ($url) header("Location: $url");
  else header("Location: list.php?root=$env[root]&dummy=$env[dummy]$exp_arg");
  exit;
}


$env[title_icon] = $env[icon_clipboard];
PageHead("$lang[clipboard_0]");
ButtonSet();

if ($env[delallconfirm]) {
  echo("<script>\n"
      ."function Question(msg, url) {\n"
      ."  if (window.confirm(msg)) {\n"
      ."    document.location = url\n"
      ."  } else {\n"
      ."    return;\n"
      ."  }\n"
      ."}\n"
      ."</script>\n");
}

echo("<table border=0 width=90% cellpadding=2 cellspacing=0 align=center>
<tr><td align=center>
<a href=clipboard.php?mode=clear>
<img src=$env[icon_xclipboard] width=$env[icon_size_x] height=$env[icon_size_y] border=0 align=top>$lang[clipboard_1]</a>
&nbsp;&nbsp;\n");

$url = "clipboard.php?mode=movewhere";
echo("<a href='$url'>");
echo("<img src=$env[icon_move] width=$env[icon_size_x] height=$env[icon_size_y] border=0 align=top>$lang[clipboard_2]</a>
&nbsp;&nbsp;\n");

$msg = $lang[clipboard_8];
$url = "clipboard.php?mode=del";

if ($env[delallconfirm]) echo("<a href=\"javascript:Question('$msg', '$url')\">");
else echo("<a href='$url'>");

echo("<img src=$env[icon_delete] width=$env[icon_size_x] height=$env[icon_size_y] border=0 align=top>$lang[clipboard_3]</a>
<br>
</td></tr></table>\n");

echo("<table border=0 width=90% cellpadding=2 cellspacing=0 align=center>
<form>
<tr bgcolor=$env[th] height=30>
<td><img src=$env[icon_trdot] width=$env[icon_size_x] height=$env[icon_size_y] width=16 height=16 align=top> $lang[title]</td>
<td align=center>$lang[action]</td>
</tr>\n");

$cnt = 0;
for ($i = 0; $i < sizeof($items); $i++) {
  $no = $items[$i];
  if (!$no) continue;
  $row = $mgr->findItemById($no);
  if (!$row) continue;
  $cnt++;

  if ($row[type] == 'b') {
    $icon = ($row[public] = 1) ? $env[icon_bk] : $env[icon_hbk];
  } else if ($row[type] == 'c') {
    $icon = ($row[public] = 1) ? $env[icon_fo] : $env[icon_hfo];
  } else if ($row[type] == 'l') {
    $icon = $env[icon_ln];
  }

  echo("<tr><td colspan=2><img src=$env[icon_trdot] height=$env[line_gap]></td></tr>\n");
  echo("<tr><td>");
  echo("<a href=modifyform.php?id=$row[id]><img src=$icon width=$env[icon_size_x] height=$env[icon_size_y] align=top border=0></a>");

  if ($row[type] == 'b') {
    # title
    $bookmark_target_str = $env[main_target];
    if ($env[usecount]) {
      $title_str = "<a href=linkto.php?id=$row[id]$bookmark_target_str>$row[title]</a>";
    } else {
      $title_str = "<a href=\"$row[url]\"$bookmark_target_str>$row[title]</a>";
    }
    echo(" $title_str");
  } else {
    echo(" <a href=list.php?root=$row[id]>$row[title]</a>");
  }

  echo("</td>
<td align=center>
<a href='clipboard.php?mode=drop&id=$row[id]'>[[$lang[cancel]]]</a>
<a href=></a>
</td>
</tr>\n");
}

if (!$cnt) {
  echo("<tr><td colspan=2 align=center bgcolor=$env[td]>$lang[clipboard_7]</td></tr>\n");
} else {
  echo("<tr>
<td align=center bgcolor=$env[th] height=30 colspan=2>$lang[total] <b>$cnt</b> ");
  if ($cnt > 1) echo $lang[items];
  else echo $lang[item];
  echo("</td>
</tr>\n");
}

echo("</form></table>\n");

PageTail();

?>
