<?php

/************************************************************************/
/* Bookmark4U: Web-based personal bookmarking environment               */
/* ======================================================               */
/* Please read LICENSE.txt                                              */
/************************************************************************/

include("inc/common.php");

if ($env[register_global_off]) {  # register get/post variables as global
  if ($HTTP_SERVER_VARS[REQUEST_METHOD] == 'GET') {
  } elseif ($HTTP_SERVER_VARS[REQUEST_METHOD] == 'POST') {
    $which_list = array('mode', 'passwd', 'pw1', 'pw2');
    ExtractVars($HTTP_POST_VARS, $which_list);
  }
}


CheckAuth('write');


if ($mode == 'change') {

  # in demonstration mode, new user registration, unregistration, clearing
  # database, changing passwords, password restoration features are not allowed.
  if ($conf[demo_mode]) Error("Sorry, you can't use this feature now.");

  if (!$passwd) Error($lang[changepw_err1]);
  if (!$pw1) Error($lang[changepw_err2]);
  if (!$pw2) Error($lang[changepw_err2]);
  if ($pw1 != $pw2) Error($lang[changepw_err3]);

  if (!CheckPassword($env[user], $passwd)) Error($lang[changepw_err4]);

  $row = $userMgr->findUserByLogin($env[user]);
  $row[passwd] = $pw1;
  $userMgr->updateUser($row);
  DBError();

  echo("<script>
alert('$lang[changepw_6]');
document.location = 'changepw.php';
</script>\n");
  exit;
}

  $env[page_focus] = 1;
  $env[title_icon] = $env[icon_key];
  PageHead($lang[changepw_0]);
  echo("<script>
function PageFocus() { document.form.passwd.focus(); }
</script>");
  ButtonSet();
  
  $lv[tw]  = "330";
  $lv[w0] = 200;
  $lv[sz1] = 20;
  $lv[text_style] = ($env[stylesheet]) ? " style='width:100'" : "";

  echo("<table width=$lv[tw] cellpadding=3 cellspacing=1 align=center>
<form action='changepw.php' name='form' method='post'>
<tr bgcolor=$env[th] height=30>
<td align=center colspan=2>");
  printf($lang[changepw_1], $env[user]);
  echo("</td>
</tr><tr>
  <td bgcolor='$env[td]' width='$lv[w0]' align='center'>$lang[changepw_2]</td>
  <td bgcolor='$env[td]'>
    <input type='password' name='passwd' size='$lv[sz1]' tabindex='1'$lv[text_style]>
  </td>
</tr><tr>
  <td bgcolor='$env[td]' align='center'>$lang[changepw_3]</td>
  <td bgcolor='$env[td]'>
    <input type='password' name='pw1' size='$lv[sz1]' tabindex='2'$lv[text_style]>
  </td>
</tr><tr>
  <td bgcolor='$env[td]' align='center'>$lang[changepw_4]</td>
  <td bgcolor='$env[td]'>
    <input type=password name=pw2 size=$lv[sz1] tabindex='3'$lv[text_style]>
  </td>
</tr><tr>
  <td bgcolor='$env[th]' colspan='2' align='center' height='30'>
    <a href='javascript:document.form.submit()' tabindex='4'>$lang[changepw_5]</a>
    <input type='hidden' name='mode' value='change'>
  </td>
</tr>
</form></table>\n");
  PageTail();
  exit;

?>
