<?php

/************************************************************************/
/* Bookmark4U: Web-based personal bookmarking environment               */
/* ======================================================               */
/* Please read LICENSE.txt                                              */
/************************************************************************/

include("inc/common.php");
include("inc/calendar.php");

if ($env[register_global_off]) {  # register get/post variables as global
  if ($HTTP_SERVER_VARS[REQUEST_METHOD] == 'GET') {
    $which_list = array('id', 'mode', 'rmode', 'year', 'month', 'day',
       'sort', 'text', 'whole_year');
    ExtractVars($HTTP_GET_VARS, $which_list);
  } elseif ($HTTP_SERVER_VARS[REQUEST_METHOD] == 'POST') {
    $which_list = array('id', 'mode', 'title', 'comment', 'sdate_year',
      'sdate_month', 'sdate_day', 'edate_year', 'edate_month', 'edate_day',
      'title', 'public', 'periodic', 'period', 'bkid', 'url', 'comment',
      'disabled', 'priority', 'rmode');
    ExtractVars($HTTP_POST_VARS, $which_list);
  }
}


CheckAuth('write');

$env[title_icon] = $env[icon_calendar];
$now = CurrentTime();

session_register('sess_calendar_whole_year');
if ($whole_year != '') {
  if ($whole_year == 1) $sess_calendar_whole_year = 1;
  else if ($whole_year == 0) $sess_calendar_whole_year = 0;
}


# script for changing day of week input
$dows = explode(":", $lang[dayofweek]);
$temp = "";
for ($i = 0; $i < 7; $i++) {
  $temp .= "  dows[$i]='$dows[$i]';\n";
}
$script = "
function SetDayOfWeek(prefix, text) {
  dows = new Array(7);
$temp
  y = eval('document.form.'+prefix+'_year.value');
  m = eval('document.form.'+prefix+'_month.value') - 1;
  d = eval('document.form.'+prefix+'_day.value');
  date = new Date(y, m, d);
  dow = date.getDay();
  eval(\"document.form.\"+prefix+\"_dow.value=dows[dow]\");
}
";

function Head1() {
  global $env, $lang;
  global $mode, $year, $month;

  if (!$mode) $mode = 'basic';

  $attr = " width='20%' align='center'";
  $attrf = " class='tabselect'";
  $attrf .= " bgcolor='$env[th]'";

  echo("<table border='0' cellpadding='2' cellspacing='1' width='100%'>
<tr>\n");
  $attr = " align='center' width='20%'";
  $values = array('basic', 'add', '', 'list', 'export');
  $disps = array($lang['calendar'], $lang['add'], $lang['edit'],
      $lang['list'], "$lang[export]/$lang[import]");
  $url = array("calendar.php?", "calendar.php?year=$year&month=$month&", "",
     "calendar.php?", "calendar.php?");
  SelectionTabs($url, 'mode', sizeof($values), $values, $disps, $attr, $attr.$attrf, $env[td], $env[th]);
  echo("</tr></table>\n");
}

function AddEditForm($mode='add', $row) {
  global $env, $lang;
  global $now, $year, $month, $day;

  $attr1 = " bgcolor='$env[th]' align='center' width='150'";
  $attr2 = " bgcolor='$env[td]' align='left' width='350'";

  echo("<tr>
 <td$attr1>$lang[date]</td>
 <td$attr2>\n");
  $onchange = "SetDayOfWeek('sdate', document.form.sdate_dow)";
  if ($mode == 'edit') {
    $sdate = DateStringToArray($row[sdate]);
    DateInput("sdate", $sdate[year], $sdate[month], $sdate[day], $onchange);
  } else { # add
    if ($year && $month && $day) {
      DateInput("sdate", $year, $month, $day, $onchange);
    } else DateInput("sdate", $now[year], $now[month], $now[day], $onchange);
  }
  echo("</td>
</tr>
<tr>
 <td$attr1><a href=\"javascript:document.form.title.select();\">$lang[title]</a></td>
 <td$attr2><input type='text' name='title' size='20' style='width:350' value=\"$row[title]\"></td>
</tr>
<tr>
 <td$attr1>
   <a href=\"javascript:document.form.comment.select();\">$lang[comment]</a>
   <img src='$env[icon_comment]' align='top'>
 </td>
 <td$attr2><input type='text' name='comment' size='20' style='width:350' value=\"$row[comment]\"></td>
</tr>
<tr>
 <td$attr1>
   <a href=\"javascript:document.form.url.select();\">$lang[url]</a>
   <img src='$env[icon_bk]' align='top'>
 </td>
 <td$attr2><input type='text' name='url' size='20' style='width:350' value=\"$row[url]\"></td>
</tr>
<tr>
 <td$attr1>
   $lang[repeat]
   <img src='$env[icon_repeat]' align=top>
 </td>
 <td$attr2>\n");
  if ($mode == 'add') $row[periodic] = 0;
  $values = array('1', '0');
  $disps = array($lang[yes], $lang[no]);
  FormRadios(2, 'periodic', $values, $disps, $row[periodic]);
  echo("<br>\n");
  $values = array('d', 'e', 'm', 'y');
  $disps = array($lang[daily], $lang[weekly], $lang[monthly], $lang[yearly]);
  FormRadios(4, 'period', $values, $disps, $row[period]);
  echo("<br> $lang[calendar_6] ");
  $onchange = "SetDayOfWeek('edate', document.form.edate_dow)";
  if ($mode == 'edit') {
    $edate = DateStringToArray($row[edate]);
    DateInput("edate", $edate[year], $edate[month], $edate[day], $onchange);
  } else {
    DateInput("edate", $now[year], $now[month], $now[day], $onchange);
  }
  echo(" </td>
</tr>
<tr>
 <td$attr1>$lang[public]</td>
 <td$attr2>\n");
  $values = array(1, 0);
  $disps = array($lang[public], $lang[private]);
  FormRadios(2, 'public', $values, $disps, $row[public]);
  echo(" </td>
</tr>
<tr>
 <td$attr1>$lang[priority]</td>
 <td$attr2><select name=priority>\n");
  $values = array(1, 2, 3, 4, 5);
  $disps = array("1 ($lang[calendar_10])", 2, 3, 4, "5 ($lang[calendar_11])");
  FormOptions(sizeof($values), $values, $disps, $row[priority]);
  echo("</select></td>
</tr>
<tr>
 <td$attr1>$lang[disabled]*</td>
 <td$attr2>\n");
  $values = array(1, 0);
  $disps = array($lang[yes], $lang[no]);
  FormRadios(2, 'disabled', $values, $disps, $row[disabled]);
  echo(" </td>
</tr>\n");
}


if ($mode == 'del') {
  if (!$id) Error("require id");
  $row = $calMgr->findEventById($id);
  $sdate = DateStringToArray($row[sdate]);

  $calMgr->deleteEvent($id);
  DBError();
  header("Location: calendar.php?year=$sdate[year]&month=$sdate[month]&dummy=$env[dummy]");
  exit;

} else if ($mode == 'addsubmit') {
  if (!$title) Error($lang[calendar_e1]);
  if (!$bkid) $bkid = 0;
  $sdate = "$sdate_year-$sdate_month-$sdate_day 00:00:00";
  $edate = "$edate_year-$edate_month-$edate_day 00:00:00";
  $rowCreate = array();
  $rowCreate[title]     = $title;
  $rowCreate[sdate]     = $sdate;
  $rowCreate[edate]     = $edate;
  $rowCreate[public]    = $public;
  $rowCreate[periodic]  = $periodic;
  $rowCreate[period]    = $period;
  $rowCreate[bkid]      = $bkid;
  $rowCreate[url]       = $url;
  $rowCreate[comment]   = $comment;
  $rowCreate[disabled]  = $disabled;
  $rowCreate[priority]  = $priority;
  $calMgr->addEvent($rowCreate);

  DBError();
  header("Location: calendar.php?year=$sdate_year&month=$sdate_month&dummy=$env[dummy]");
  exit;

} else if ($mode == 'editsubmit') {
  if (!$title) Error($lang[calendar_e1]);

  $sdate = "$sdate_year-$sdate_month-$sdate_day 00:00:00";
  $edate = "$edate_year-$edate_month-$edate_day 00:00:00";
  if ($periodic) {
    $diff = DiffDate($edate_year, $edate_month, $edate_day, $sdate_year, $sdate_month, $sdate_day);
    if ($diff < 0) Error("date error");
  }

  $rowCreate = array();
  $rowCreate[id]        = $id;
  $rowCreate[title]     = $title;
  $rowCreate[sdate]     = $sdate;
  $rowCreate[edate]     = $edate;
  $rowCreate[public]    = $public;
  $rowCreate[periodic]  = $periodic;
  $rowCreate[period]    = $period;
  $rowCreate[bkid]      = $bkid;
  $rowCreate[url]       = $url;
  $rowCreate[comment]   = $comment;
  $rowCreate[disabled]  = $disabled;
  $rowCreate[priority]  = $priority;
  $calMgr->updateEvent($rowCreate);

  DBError();
  if ($rmode == 'list') { # return mode
    $redirect = "calendar.php?mode=list&dummy=$env[dummy]";
  } else {
    $redirect = "calendar.php?year=$sdate_year&month=$sdate_month&dummy=$env[dummy]";
  }
  header("Location: $redirect");
  exit;

} else if ($mode == 'list') {
  PageHead("$lang[calendar_0] - $lang[list]");
  ButtonSet();
  Head1();

  # default sorting order
  if (!$sort) $sort = "date";

  # sorting order (order by clause in the sql query)
  if ($sort=='date')         $sql_order = "sdate";
  elseif ($sort=='title')    $sql_order = "title ASC";
  elseif ($sort=='priority') $sql_order = "priority DESC";
  elseif ($sort=='repeat')   $sql_order = "periodic DESC, period, title";
  elseif ($sort=='public')   $sql_order = "public DESC, title DESC";

  # table heading
  $attr = " align='center'";
  $attrf = " class='tabselect'";
  $attrf .= " bgcolor='$env[th]'";
  $values = array('date', 'title', 'priority', 'repeat', 'public');
  $disps = array($lang['date'], $lang['title'], $lang['priority'],
      $lang['repeat'], $lang['public']);
  $url = "calendar.php?mode=list&";
  echo("<table border='0' cellpadding='2' cellspacing='1' width='100%'>
<tr>\n");
  SelectionTabs($url, 'sort', sizeof($values), $values, $disps, $attr, $attr.$attrf, $env[td], $env[th]);
  echo("</tr>");

  $ret = $calMgr->findEvents($sql_order);
  $cnt = 0;
  while ($row = $ret->fetchRow()) {
    $cnt++;
    $title = "<a href='calendar.php?mode=edit&id=$row[id]&rmode=$mode'>$row[title]</a>";
    $public = ($row[public]) ? $lang[public]
            : "<font color=$env[blur]>$lang[private]</font>";
    $disable = ($row[disabled]) ? " ($lang[disabled])" : "";
    $date = FormatDateAndTime($row[sdate], $lang[dateformat2]);
    $sdate = DateStringToArray($row[sdate]);
    $date = "<a href='calendar.php?year=$sdate[year]&month=$sdate[month]'>$date</a>";

    $priority = "";
    for ($i=0; $i<$row[priority]; $i++) $priority .= "*";
    $period = ($row[periodic]) ? $row[period] : "";
    $repeat = ($period=='d') ? $lang[daily] :
             (($period=='e') ? $lang[weekly] :
             (($period=='m') ? $lang[monthly] :
             (($period=='y') ? $lang[yearly] : "$lang[no]")));

    # new_img
    $new = (IsNew($row[rdate])) ? " <img src=$env[icon_new] align=top>" : "";

    # comment
    $comment = ($row[comment]) ? "<font color='$env[blur]'>: $row[comment]</font>" : "";

    if ($env[row_highlight]) {
      $attr = " onmouseover=this.style.background='$env[td]'"
             ." onmouseout=this.style.background=''";
    } else $attr = "";
    echo("<tr$attr>
<td align=center><nobr>$date</nobr></td>
<td>$title$comment$disable$new</td>
<td align=center><nobr>$priority</nobr></td>
<td align=center><nobr>$repeat</nobr></td>
<td align=center><nobr>$public</nobr></td>
</tr>\n");
  }
  echo("<tr>
<td colspan='5' align='center' bgcolor='$env[th]'>
$lang[total] <b>$cnt</b> $lang[unit_schedule]</td>
</tr>\n");
  echo("</table>\n");
  PageTail();
  exit;

} else if ($mode == 'add') {
  $env[page_focus] = 1;
  $env[script] = $script;
  PageHead("$lang[calendar_0] - $lang[add]");
  ButtonSet();
  Head1();
  echo("<table border='0' width='500' cellpadding='2' cellspacing='1'
 align='center'>
<form action='calendar.php' method='post' name='form'>
<tr>
 <td colspan='2' align='center' bgcolor='$env[th]'><b>$lang[calendar_1]</b></td>
</tr>\n");
 $row = array();
 AddEditForm('add', $row);
 echo("<tr>
 <td colspan='2' align='center' bgcolor='$env[th]'>
 <input type='hidden' name='mode' value='addsubmit'>
 <a href=\"javascript:document.form.submit()\">[[$lang[calendar_2]]]</a>
 <input type='image' src='$env[icon_trdot]' border='0'>
 </td>
</tr></form></table>
<script>
function PageFocus() { document.form.title.focus(); }
</script>\n");
  PageTail();
  exit;
} else if ($mode == 'edit') {
  if (!$id) Error("require id");

  $row = $calMgr->findEventById($id);
  if (!$row) Error($lang[calendar_8]);

  $env[page_focus] = 1;
  $env[script] = $script;
  PageHead("$lang[calendar_0] - $lang[edit]");
  ButtonSet();
  Head1();
  echo("<table border='0' width='500' cellpadding='2' cellspacing='1' align='center'>
<form action='calendar.php' method='post' name='form'>
<tr>
 <td colspan=2 align=center bgcolor=$env[th]><b>$lang[calendar_3]</b></td>
</tr>\n");
 AddEditForm('edit', $row);
 echo("<tr>
 <td colspan=2 align=center bgcolor=$env[th]>
 <input type=hidden name=mode value='editsubmit'>
 <input type=hidden name=id value='$id'>
 <input type=hidden name=rmode value='$rmode'>
 <a href=\"javascript:document.form.submit()\">[[$lang[calendar_4]]]</a>
 &nbsp;&nbsp;&nbsp;
<script>
function Question(msg, url) {
  if (confirm(msg)) document.location = url
  else return;
}
</script>
 <a href=\"javascript:Question('$lang[calendar_7]', 'calendar.php?mode=del&id=$row[id]')\">[[$lang[calendar_5]]]</a>
 <input type=image src=$env[icon_trdot] border=0>
 </td></tr></form></table>
<script>
function PageFocus() { document.form.title.focus(); }
</script>\n");

  PageTail();
  exit;

} else if ($mode == 'export') {

  PageHead("$lang[calendar_0] - $lang[export]");
  ButtonSet();
  Head1();

  echo("<table border='0' align='center'>
<form action='calendar.php' method='get'>
<tr>
  <td colspan='2' align='center' bgcolor='$env[td]'><b>$lang[export]</b></td>
</tr>
<tr>
  <td align='right'>$lang[export_2] :</td>
  <td>
    <input type='radio' name='text' value='dos' checked> DOS
    <input type='radio' name='text' value='unix'> UNIX
  </td>
</tr>
<tr>
  <td align='right'></td>
  <td>
    <input type='hidden' name='mode' value='do_export'>
    <input type='submit' value='$lang[export]'>
  </td>
</tr>
</form>
<tr>
  <td height='20'></td>
</tr>
<form enctype='multipart/form-data' action='calendar.php' method='post'>
<tr>
  <td colspan='2' align='center' bgcolor='$env[td]'><b>$lang[import]</b></td>
</tr>
<tr>
  <td>Schedule File :</td>
  <td><input name='userfile' type='file'></td>
</tr>
<tr>
  <td></td>
  <td>Not implementated yet</td>
</tr>
<tr>
  <td></td>
  <td>
  <input type='submit' value='$lang[import]'>
  <input type='hidden' name='mode' value='do_import'>
  </td>
</tr>
</form>
</table>\n");

  PageTail();
  exit;

} else if ($mode == 'do_import') {

  $userfile = $HTTP_POST_FILES[userfile]; # attrs:{tmp_name, name, size, type}

  if ($userfile[tmp_name] == "none") Error("No schedule file");
  if ($userfile[size]==0) Error("File size is zero");

  $schedules = ReadXMLScheduleFile($userfile[tmp_name]);

  PageHead("$lang[calendar_0] - $lang[export]");
  ButtonSet();
  Head1();

  echo("<table border='1'>\n");
  while (list(,$row) = each($schedules)) {
    $title = $row[title];
    echo("<tr>
    <td>$row[date]</td>
    <td>$title</td>
    <td>$row[comment]</td>
    </tr>\n");
  }
  echo("</table>\n");

  PageTail();
  exit;

} else if ($mode == 'do_export') {

  if ($text == 'dos') $eol = "\r\n";
  else $eol = "\n";   # end of line
  DownloadHeader('bm4u_calendar.xml');

  echo("<?xml version=\"1.0\" encoding=\"$env[doc_encoding]\" ?>$eol");
  echo("<!-- exported by Bookmark4U version $env[version] at "
      .date('Y-m-d H:i:s')." -->$eol");
  echo("<schedules version=\"experimental version\">$eol");

  $ret = $calMgr->findEvents("id");
  while ($row = $ret->fetchRow()) {
    $sdate = substr($row[sdate], 0, 10);
    $edate = substr($row[edate], 0, 10);

    $row[title] = ereg_replace("&", "&amp;", $row[title]);
    $row[comment] = ereg_replace("&", "&amp;", $row[comment]);
    echo("  <schedule title=\"$row[title]\" comment=\"$row[comment]\" date=\"$sdate\"");
    echo(" public=\"$row[public]\" priority=\"$row[priority]\" disabled=\"$row[disabled]\"");
    if ($row[periodic])
      echo(" repeat=\"on\" period=\"$row[period]\" until=\"$edate\"/>$eol");
    else
      echo(" repeat=\"off\"/>$eol");

  }
  echo("</schedules>$eol");

  exit;
}



# year and month are not given
if (!$year || !$month) {
  $date = date("Y-m-d H:i:s");
  $year  = (int)substr($date, 0, 4);
  $month = (int)substr($date, 5, 2);
} else {
   $year = $year;
   $month = $month;
}

$dow = DayOfWeek($year, $month, 1);
$dpm = DaysPerMonth($year, $month);

# fetch schedules from database
$sch_list = array();
if ($sess_calendar_whole_year) {
  for ($m = 1; $m <= 12; $m++) {
    $days = DaysPerMonth($year, $m);
    FetchSchedules2($year, $m, 1, $days, $sch_list);
  }
} else {
  FetchSchedules2($year, $month, 1, $dpm, $sch_list);
}

$env[page_focus] = 1;
PageHead($lang[calendar_0]);
ButtonSet();
Head1();

# previous and next month
$pmon = PreviousMonth($year, $month);
$nmon = NextMonth($year, $month);

$months = explode(":", $lang[months]);
$month_str = $months[$month-1];
#$dow_str = explode(":", $lang[dayofweek]);

echo("<script>
function ChangeMonth(form) {
  y = document.changemonthform.year.value;
  m = document.changemonthform.month.value;
  document.location = 'calendar.php?year=' + y + '&month=' + m;
}
</script>\n");

$imgattr = " width='$env[icon_size_x]' height='$env[icon_size_y]' align='top' border='0'";

if ($sess_calendar_whole_year) {
  $pyear = (int)$year - 1;
  $prev_opt = "?year=$pyear&month=1";
  $nyear = (int)$year + 1;
  $next_opt = "?year=$nyear&month=1";
} else {
  $prev_opt = "?year=$pmon[year]&month=$pmon[month]";
  $next_opt = "?year=$nmon[year]&month=$nmon[month]";
}
echo("<table width='100%' border='0' cellpadding='0' cellspacing='0'>
<form name='changemonthform'><tr>
<td width='20%'></td>
 <td align='right' width='20%'>
  <a href='calendar.php$prev_opt'><img
  src='$env[icon_back]'$imgattr>$lang[prev]</a> &nbsp;&nbsp;
 </td>
 <td align=center width=20% nowrap>
<select name=year onchange=\"ChangeMonth()\">\n");
$s_year = (int)$now[year] - $env[year_before];
$e_year = (int)$now[year] + $env[year_after];
for ($y = $s_year; $y < $e_year; $y++) {
  $sel = ($y == $year) ? " selected" : "";
  echo("<option value=$y$sel>$y</option>\n");
}
echo("</select>");

if (!$sess_calendar_whole_year) {
  echo(" -
<select name='month' onchange=\"ChangeMonth()\">\n");
  for ($m = 1; $m <= 12; $m++) {
    $sel = ($m == $month) ? " selected" : "";
    $month_str = $months[$m-1];
    echo("<option value='$m'$sel>$month_str</option>\n");
  }
  echo("</select>");
} else {
  echo("<input type='hidden' name='month' value='1'>");
}

echo("</td><td width='20%'>
  &nbsp;&nbsp;
 <a href='calendar.php$next_opt'>$lang[next]<img
 src='$env[icon_next]'$imgattr></a>
 </td>
<td align='right' width='20%'>");
if (!$sess_calendar_whole_year)
  echo("<a href='calendar.php?whole_year=1'>[[$lang[year]]]</a>");
else
  echo("<a href='calendar.php?whole_year=0'>[[$lang[month]]]</a>");
echo("</td>
</tr></form>
</table>\n");


if (!$sess_calendar_whole_year) {
  PrintMonth($year, $month, $sch_list);
} else {
  for ($i = 1; $i <= 12; $i++) PrintMonth($year, $i, $sch_list);
}

echo("<script>
function PageFocus() {
  document.changemonthform.year.value = '".$year."';
  document.changemonthform.month.value = '".$month."';
}
</script>\n");

PageTail();
exit;

?>
