<?php

/************************************************************************/
/* Bookmark4U: Web-based personal bookmarking environment               */
/* ======================================================               */
/* Please read LICENSE.txt                                              */
/************************************************************************/

$env[pass_without_login] = 1;
include("inc/common.php");
include("inc/addmodify.php");

if ($env[register_global_off]) {  # register get/post variables as global
  if ($HTTP_SERVER_VARS[REQUEST_METHOD] == 'GET') {
    $which_list = array('mode', 'userid', 'url', 'pagetitle',
       'listfolder', 'id');
    ExtractVars($HTTP_GET_VARS, $which_list);
  } elseif ($HTTP_SERVER_VARS[REQUEST_METHOD] == 'POST') {
  }
}

if (!$env[logined]) {
  $url_enc = urlencode($url); # encode url to put it into another url 
  $title_enc = urlencode($pagetitle); # encode pagetitle

  $redirect = "loginform.php?userid=$userid&url=$url_enc&pagetitle=$title_enc";
  header("Location: $redirect");
  exit;
}

CheckAuth('write');

if ($mode == 'chfolder') {
  PageHead($lang[bookmark_0]);

  echo("<table border=0 cellpadding=0 cellspacing=0>
<tr><td>");
  echo("$lang[bookmark_1]<br>");
  echo("$lang[bookmark_2]");
  echo("</td></tr></table>");

  $url = urlencode($url); # encode url to put it into another url
  $pagetitle = urlencode($pagetitle); # encode url to put it into another url
  $options = "&mode=addform&url=$url&pagetitle=$pagetitle";
  ListFolder(0, 0, "bookmark", $options, $env[root]);
  PageTail();
  exit;
}

$env[page_focus] = 1;
PageHead($lang[bookmark_0]);
ButtonSet();

function decodeHTML($string) { // can be remplaced by html_entity_decode in PHP 4.3+
   $string = strtr($string, array_flip(get_html_translation_table(HTML_ENTITIES)));
   $string = preg_replace("/&#([0-9]+);/me", "chr('\\1')", $string);
   return $string;
}

$pagetitle = stripslashes($pagetitle);
$pagetitle = decodeHTML($pagetitle);

echo("<script>
function PageFocus() {
  document.addform.title.focus();
  document.addform.title.select();
}
</script>\n");

#$url = ereg_replace("\+", "", $url);
#echo urlencode($url);

if ($id == "") $id = $env[root];
if (!$id) { # if root folder
  $row = array();
  $row[id] = "0";
  $row[title] = sprintf($env[top_folder_name], $env[user]);
} else {
  $row = $mgr->findItemById($id);
}
$row[url] = $url;
$row[pagetitle] = $pagetitle;

echo("<center>\n");
echo("$lang[bookmark_4]: ");
PrintPath($row);
echo("<br></center>\n");

$result = $mgr->findBookmarksByUrl($url);
if ($result->numRows() > 0) {
  echo("<center>\n");
  echo("<table border='0' width='$lv[tw]' cellpadding='3' cellspacing='1'>
<tr><td bgcolor='$env[td]' align='center'>\n");
  echo("<table border='0' width='100%' cellpadding='3' cellspacing='1'>
<tr><td bgcolor='$env[th]' align='center'>\n");
  echo("<img src='$env[icon_alert]' align='top'> ");
  echo("$lang[addform_3] :<br>");
  PrintDuplicatedBookmarks($url); # print duplicated bookmarks
  echo("</td></tr></table>\n");
  echo("</td></tr></table>\n");
  echo("</center>\n");
}

AddForm($row);

PageTail();
exit;

?>
