<?php

/************************************************************************/
/* Bookmark4U: Web-based personal bookmarking environment               */
/* ======================================================               */
/* Please read LICENSE.txt                                              */
/************************************************************************/

$env[include_prefix] = "..";
$env[pass_without_login] = 1;
include("../inc/common.php");

include("../sql/sql.mysql.php");

if ($HTTP_SERVER_VARS[REQUEST_METHOD] == 'GET') {
  $mode       = $HTTP_GET_VARS[mode];
  $uid        = $HTTP_GET_VARS[uid];
} elseif ($HTTP_SERVER_VARS[REQUEST_METHOD] == 'POST') {
  $mode       = $HTTP_POST_VARS[mode];
  $pw         = $HTTP_POST_VARS[pw];
  $pw1        = $HTTP_POST_VARS[pw1];
  $pw2        = $HTTP_POST_VARS[pw2];
  $uid        = $HTTP_POST_VARS[uid];
  $autopasswd = $HTTP_POST_VARS[autopasswd];
  $sendmail   = $HTTP_POST_VARS[sendmail];
}

$adminMgr = createAdminManager();
$db = connectDB();
$adminMgr->setDB( $db );

$userMgr = createUserManager("admin", $db);

function Head1() {
  global $HTTP_SERVER_VARS;
  global $env;

  echo("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">\n");
  echo("<html>
<head>
<style type='text/css'>
a:link    { text-decoration:none; }
a:visited { text-decoration:none; }
a:hover   { text-decoration:underline; }
td,body   {
  color: black;
  font-family: Verdana,Arial,Helvetica;
  font-size: x-small;
}
input,select,textarea {
  border:1 solid black;
  background-color: #eeeeee;
  color:black;
}
</style>
<title>Bookmark4U</title>
</head>
<body bgcolor=white text=black link=#aa4444 alink=#aa4444 vlink=#aa4444");
  if ($env[page_focus]) echo(" onLoad=\"javascript:PageFocus()\"");
  echo(">
<center>
<b>Bookmark4U Administrator's Home</b><br>
<a href='../index.php'>Bookmark4U</a> |
<a href='index.php'>Admin Home</a> |
<a href='index.php?mode=dbstat'>Databases statistic</a> |
<a href='$HTTP_SERVER_VARS[PHP_SELF]?mode=chpwform'>Change admin password</a>
<br>
<a href='config.php'>Database Configuration</a> |
<a href='index.php?mode=logout'>Admin Logout</a>
<br><br>
</center>\n");
}

function Tail1() {
  echo("</body></html>\n");
}

function GetAdminPassword($hidden_tags='', $button_str='OK', $prompt='') {
  global $HTTP_SERVER_VARS;

  echo("<table border=0 align=center>
  <form action='$HTTP_SERVER_VARS[PHP_SELF]' method='post' name='loginform'>
  <tr>
    <td align='center' colspan='2'>$prompt</td>
  </tr>
  <tr>
    <td align=right>Admin Password :</td>
    <td><input type='password' name='pw' size='12'></td>
  </tr>
  <tr>
    <td align=right></td>
    <td>
      $hidden_tags
      <input type='submit' value='$button_str'>
    </td>
  </tr>
  </form></table>\n");
}

# check if PASSWD_TEMP table exists in database, and
# check an admin account exists in the PASSWD table.
function CheckDB() {
  global $env, $userMgr;

  $userMgr->useTemporaryTable(true);
  $ret = $userMgr->findAllUsers();
  $userMgr->useTemporaryTable(false);
  DBError();

  if (!$ret) {
    $msg = "Table '$env[dbtblpasswdtmp]' does not exist in database.\\n"
          ."Please make table '$env[dbtblpasswdtmp]'. Refer UPGRADE.txt.";
    Error("$msg");
  }

  $row = $userMgr->findUserByLogin("admin");
  DBError();
  if (!$row) {
    $msg = "An 'admin' user does not exist in the table '$env[dbtblpasswd]'\\n"
          ."Please insert a row for 'admin'. Refer UPGRADE.txt.";
    Error("$msg");
  }
}

if ($mode == 'logout') {
  ClearCookies();
  header("Location: $HTTP_SERVER_VARS[PHP_SELF]?dummy=$env[dummy]");
  exit;
}

# check authorization
$admin_token = GetCookie("ADMIN");
if ($admin_token == '') {
  if ($mode == 'adminlogin') {
    CheckDB();
    $row = $userMgr->checkAccess($pw, "admin");
    DBError();
    if (!$row) Error("Incorrect admin password");
    $t = time();
    PutCookie("ADMTIME", $t);
    $token = md5("$t:$conf[static_cookie]:$conf[dbname]");
    PutCookie("ADMIN", $token);
    if ($pw == 'test') {
      ErrorRedir("Please change admin password", "$HTTP_SERVER_VARS[PHP_SELF]?mode=chpwform");
    } else {
      header("Location: $HTTP_SERVER_VARS[PHP_SELF]");
    }
    exit;
  } else {
    $env[page_focus] = 1;
    Head1();
    $hidden_tags = "<input type='hidden' name='mode' value='adminlogin'>";
    $prompt = "Enter admin password to login";
    GetAdminPassword($hidden_tags, 'Login', $prompt);
    echo("<script>
  function PageFocus() { document.loginform.pw.focus(); }
</script>\n");
    Tail1();
    exit;
  }
} else {
  $t = GetCookie('ADMTIME');

  if ($admin_token != md5("$t:$conf[static_cookie]:$conf[dbname]")) {
    ErrorRedir("Access denied", "index.php?mode=logout");
    exit;
  }
}


if ($mode == 'register') {

  # fetch from PASSWD_TEMP
  $userMgr->useTemporaryTable(true);
  $row1 = $userMgr->findUserByUid($uid);
  $userMgr->useTemporaryTable(false);
  DBError();

  # generate a random password
  if ($autopasswd) {
    $rand = rand(1, $env[dummy]);
    $hash = md5($rand);
    $new_pw = substr($hash, 0, 8);  # new password
    $passwd = "'$new_pw";
  } else {
    $passwd = $row1[passwd];
  }

  # insert into PASSWD table
  $rowCreate = array();
  $rowCreate[user]    = $row1[user];
  $rowCreate[passwd]  = $passwd;
  $rowCreate[name]    = $row1[name];
  $rowCreate[email]   = $row1[email];
  $userMgr->addUser($rowCreate);
  DBError();

  # delete from PASSWORD_TEMP table
  $userMgr->useTemporaryTable(true);
  $userMgr->deleteUser($uid);
  $userMgr->useTemporaryTable(false);
  DBError();

  # insert a sample bookmark
  $rowBk = array();
  $rowBk[type] = 'b';
  $rowBk[parent] = 0;
  $rowBk[title] = 'Bookmark4U';
  $rowBk[url] = 'http://bookmark4u.sourceforge.net';
  $rowBk[comment] = 'Welcome to Bookmark4U';
  $rowBk[public] = 1;
  $mgr->addItem($rowBk);
  DBError();

  # send an e-mail
  if ($sendmail) {
    $subject = "Bookmark4U registration completed";
    $msg = "'$row1[user]' has been registered in Bookmark4U. Enjoy it.\n";
    if ($autopasswd) { # password has been updated
      $msg .= "A new password has been set as '$new_pw' for you.\n";
    }
    # send an email to the user
    $header = "From: Bookmark4U<$env[admin_email]>\n";
    if ($row1[email]) mail($row1[email], $subject, $msg, $header);
  }

  ErrorRedir("$row1[name] has been registered", "$HTTP_SERVER_VARS[PHP_SELF]");
  exit;

} elseif ($mode == 'registerform') {

  $userMgr->useTemporaryTable(true);
  $row = $userMgr->findUserByUid($uid);
  $userMgr->useTemporaryTable(false);
  DBError();

  Head1();
  echo("<script>
function click_sendmail() {
}
function click_autopasswd() {
  if (document.form.autopasswd.checked && !document.form.sendmail.checked) {
    alert('You should send the new password to the user by an email');
    document.form.sendmail.checked = 1;
  }
}
</script>
  <table border='0' align='center'>
  <form action='$HTTP_SERVER_VARS[PHP_SELF]' method='post' name='form'>
  <tr>
   <td align='center'>
    Register '<b>$row[user]</b>' as a normal user?
   </td>
  </tr><tr>
   <td align='left'>
    <input type='checkbox' name='sendmail' value='1' checked
    onClick=\"javascript:click_sendmail();\">
    Send an email to this user about the completion of registration.
   </td>
  </tr><tr>
   <td align='left'>
    <input type='checkbox' name='autopasswd' value='1'
    onClick=\"javascript:click_autopasswd();\">
    Generate a random password for this user.
   </td>
  </tr><tr>
   <td align='center'>
    <input type='hidden' name='mode' value='register'>
    <input type='hidden' name='uid' value='$uid'>
    <input type='submit' value='Register'>
   </td>
  </tr></form></table>\n");
  Tail1();
  exit;

} elseif ($mode == 'del') {
  $row1 = CheckPassword("admin", $pw);
  if (!$row1) Error("Incorrect admin password");

  $row2 = $userMgr->findUserByUid($uid);
  $userMgr->deleteUser($uid);
  DBError();

  ErrorRedir("$row2[user] has been deleted", "$HTTP_SERVER_VARS[PHP_SELF]");
  exit;

} elseif ($mode == 'delform') {

  $env[page_focus] = 1;
  Head1();
  $hidden_tags = "<input type='hidden' name='mode' value='del'>"
                ."<input type='hidden' name='uid' value='$uid'>";
  $prompt = "Enter admin password to delete user (uid=$uid)";
  GetAdminPassword($hidden_tags, 'Delete', $prompt);
  echo("<script>
  function PageFocus() { document.loginform.pw.focus(); }
</script>\n");
  Tail1();
  exit;

} elseif ($mode == 'chpw') {
  if (!$pw1 || !$pw2 || $pw1 != $pw2) Error("New passwords does not match");

  $row = $userMgr->checkAccess($pw, "admin");
  if (!$row) Error("Incorrect admin password");

  $row[passwd] = $pw1;
  $userMgr->updateUser($row);
  DBError();

  ErrorRedir("Admin password has been changed", "$HTTP_SERVER_VARS[PHP_SELF]");
  exit;

} elseif ($mode == 'chpwform') {

  Head1();
  echo("<table border=0 align=center>
  <form action='$HTTP_SERVER_VARS[PHP_SELF]' method='post'>
  <tr>
    <td align=right>Current Password :</td>
    <td><input type='password' name='pw' size='12'></td>
  </tr>
  <tr>
    <td align=right>New Password :</td>
    <td><input type='password' name='pw1' size='12'></td>
  </tr>
  <tr>
    <td align=right>(repeat) :</td>
    <td><input type='password' name='pw2' size='12'></td>
  </tr>
  <tr>
    <td align=right></td>
    <td>
      <input type=hidden name=mode value='chpw'>
      <input type='submit' value='Change'>
    </td>
  </tr>
  </form></table>\n");
  Tail1();
  exit;

} elseif ($mode == 'dbstat') {
  Head1();

  $attr1 = " align='center'";
  $attr2 = " align='right'";
 echo("<table border='1' align='center'>
<tr>
  <td$attr1><b>Table</b></td>
  <td$attr1><b>Data size</b></td>
  <td$attr1><b>Index size</b></td>
  <td$attr1><b>Rows</b></td>
</tr>\n");
  $ret = $adminMgr->findTables();
  $total_data_size = $total_index_size = 0;
  while ($row = $ret->fetchRow()) {

    $data_size = $row[Data_length];
    $index_size = $row[Index_length];

    $total_data_size  += $data_size;
    $total_index_size += $index_size;

    $rows = $row[Rows];
    list($data_size_format, $data_unit) = FormatByteDown($data_size,3,1);
    list($index_size_format, $index_unit) = FormatByteDown($index_size,3,1);

   echo("<tr>
<td align='left'><a href='$HTTP_SERVER_VARS[PHP_SELF]?mode=table_properties&table=$row[Name]'>$row[Name]</a></td>
<td$attr2>$data_size_format $data_unit</td>
<td$attr2>$index_size_format $index_unit</td>
<td$attr2>$rows</td>
</tr>\n");
  }
    list($num1, $unit1) = FormatByteDown($total_data_size,3,1);
    list($num2, $unit2) = FormatByteDown($total_index_size,3,1);
  echo("<tr>
<td align='center'><b>Total</b></td>
<td$attr2>$num1 $unit1</td>
<td$attr2>$num2 $unit2</td>
<td$attr2>N/A</td>
</tr>
</table>\n");
  Tail1();
  exit;

} elseif ($mode == 'table_properties') {
  Head1();

  $ret = $adminMgr->findFields($table);

  $attr1 = " align='center'";
  $attr2 = " align='right'";
  
  echo("<center>
  Properties of $table<br>
  </center>
  <table border='1' align='center'>
  <tr>
  <td$attr1><b>Field</b></td>
  <td$attr1><b>Type</b></td>
  <td$attr1><b>Default</b></td>
  <td$attr1><b>Null</b></td>
  <td$attr1><b>Extra</b></td>
  </tr>\n");

  while ($row = $ret->fetchRow()) {
    echo("<tr>
<td$attr2>$row[Field]<br></td>
<td$attr2>$row[Type]<br></td>
<td$attr2>$row[Default]<br></td>
<td$attr2>$row[Null]<br></td>
<td$attr2>$row[Extra]<br></td>
</tr>\n");
  }
  echo("</table>\n");

  Tail1();
  exit;
}


Head1();
#echo("<script>
#function Question(msg, url) {
#  if (confirm(msg)) document.location = url;
#  else return;
#}
#</script>\n");

$attr1 = " align=center";
$attr2 = " align=center";
echo("<table border='1' align='center'>
<tr>
  <td$attr1><b>UID</b></td>
  <td$attr1><b>User name</b></td>
  <td$attr1><b>Real name</b></td>
  <td$attr1><b>Email</b></td>
  <td$attr1><b>Date</b></td>
  <td$attr1><b>Action</b></td>
</tr>\n");

$userMgr->useTemporaryTable(true);
$ret = $userMgr->findAllUsers("rdate");
$userMgr->useTemporaryTable(false);
DBError();

while ($row = $ret->fetchRow()) {
  echo("<tr>
  <td$attr2>N/A</td>
  <td$attr2>$row[user]</td>
  <td$attr2>$row[name]</td>
  <td$attr2>$row[email]</td>
  <td$attr2>$row[rdate]</td>
  <td$attr2>
    <a href=\"$HTTP_SERVER_VARS[PHP_SELF]?mode=registerform&uid=$row[uid]\">Register</a>
  </td>
  </tr>\n");
#   <a href=\"javascript:Question('Register \'$row[user]\' as a normal user?', '$HTTP_SERVER_VARS[PHP_SELF]?mode=registerform&uid=$row[uid]')\">Register</a>
}


$ret = $userMgr->findAllUsers("uid DESC");
DBError();

while ($row = $ret->fetchRow()) {
  $new = (IsNew($row[rdate])) ? " <img src=../$env[icon_new] align=top>" : "";
  echo("<tr>
  <td$attr2>$row[uid]$new</td>
  <td$attr2><a href='../guestlogin.php?userid=$row[user]'>$row[user]</a></td>
  <td$attr2>$row[name]</td>
  <td$attr2>$row[email]</td>
  <td$attr2>$row[rdate]</td>
  <td$attr2>
    <a href='$HTTP_SERVER_VARS[PHP_SELF]?mode=delform&uid=$row[uid]'>Delete</a>
  </td>
  </tr>\n");
}

echo("</table>\n");

Tail1();

?>
