<?php

/************************************************************************/
/* Bookmark4U: Web-based personal bookmarking environment               */
/* ======================================================               */
/* Please read LICENSE.txt                                              */
/************************************************************************/

##########################################################################
# Bookmark4U Database Configuration Tool
# Check the followings
#  1. database connection test
#  2. database selection test
#  3. check basic tables
#  4. check admin account
#  5. check user table patch
##########################################################################

$env[include_prefix] = "..";
$env[pass_without_login] = 1;
$env[pass_without_dbconnect] = 1;
include("../inc/common.php");

if ($env[register_global_off]) {  # register get/post variables as global
  if ($HTTP_SERVER_VARS[REQUEST_METHOD] == 'GET') {
  } elseif ($HTTP_SERVER_VARS[REQUEST_METHOD] == 'POST') {
    $sqlcmd = $HTTP_POST_VARS[sqlcmd];
    $mode   = $HTTP_POST_VARS[mode];
  }
}

if ($conf[dbtype] == "mysql") {
  include("../sql/sql.mysql.php");
} else {
  echo("Database $conf[dbtype] not supported");
  echo("Do the configuration at manually");
  exit;
}

$adminMgr = createAdminManager();

function ExecuteBlock($qrytext, $err="") {
  global $HTTP_SERVER_VARS;

  $sqlcmd = ereg_replace("\n","%NL%", $qrytext); # encode '\n' char
  echo("<table border='0' align='center' width='90%'>
  <tr><td bgcolor='#eeeeee'>");
  echo nl2br($qrytext);
  echo("</td></tr>
  <form action='$HTTP_SERVER_VARS[PHP_SELF]' method='post'>
  <tr><td align='center'>
  <input type='hidden' name='sqlcmd' value=\"$sqlcmd\">
  <input type='hidden' name='mode' value='sqlexec'>
  <input type='submit' value=\"Execute Above ($err)\">
  </td></tr>
  </form></table>\n");
}

function Head1() {
  echo("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">\n");
  echo("<html>
<head>
<style type='text/css'>
a:link    { text-decoration:none; }
a:visited { text-decoration:none; }
a:hover   { text-decoration:underline; }
body,td,pre   {
  color: black;
  font-family: Verdana,Arial,Helvetica;
  font-size: x-small;
}
input,select,textarea {
  border:1 solid black;
  background-color: #eeeeee;
  color:black;
}
blockquote {
  margin: 10px 10px 10px 10px;
  background: #eeeeee;
  padding: 5px;
}
.strong { color: #aa0000; }
.blur   { color: #999999; }
.bad    { color: #aa0000; }
.good   { color: #00aa00; }
</style>
<title>Bookmark4U</title>
</head>
<body bgcolor='white' text='black' link='#4444aa' alink='#4444aa'
 vlink='#4444aa'>
<center>
<b>Bookmark4U Database Configuration Tool</b><br>
<a href='index.php'>Administrator's Home</a>
</center>
<hr size='1'>
\n");
}

function Tail1() {
  echo("</body></html>\n");
}

# turn the error reporting feature of PHP off temporarily
error_reporting(0); 

if ($mode == 'sqlexec') {
  if (get_magic_quotes_gpc()) {
    $sqlcmd = ereg_replace("\\\\", "", $sqlcmd);
  }

  $qry = ereg_replace("%NL%", "\n", $sqlcmd); # decode newline(\n) chars

  $db = connectDB();
  $adminMgr->setDB( $db );

  $qry_list = explode(";", $qry); # split multiple queries
  for ($i = 0; $i < sizeof($qry_list); $i++) {
    $qry_one = trim($qry_list[$i]);
    if (!$qry_one) continue;
    $adminMgr->executeMiscQuery($qry_one);
    DBError();
  }

  header("Location: $HTTP_SERVER_VARS[PHP_SELF]?dummy=$env[dummy]");
  exit;
}


Head1();

##########################################################################
## 1. database connection test
##########################################################################

$error_list = array();

echo("Step 1. Testing database connection ... ");
$connect = $adminMgr->testDBConnection();
if (!$connect) {
  echo("<font class='bad'>Database Connection Error!!</font>");
  $err = "db_connection_err";
  array_push($error_list, $err); # add error code into error list
  $cnf_cmds[$err] = "
    Edit the inc/config.php.
    \$conf[dbhost]   = \"<font class='strong'>$conf[dbhost]</font>\";
    \$conf[dbuser]   = \"<font class='strong'>$conf[dbuser]</font>\";
    \$conf[dbpasswd] = \"<font class='strong'>$conf[dbpasswd]</font>\";
    \$conf[dbtype]   = \"<font class='strong'>$conf[dbtype]</font>\";
  \n";
} else echo("<b>Success</b>.");
echo("<br>\n");

if (!$connect) {
  echo("<font class='bad'>
  <b>You have a problem to connect to the database!</b>
  </font><br><br>
  To correct this problem, do the followings.<br>
  <blockquote>\n");
  for ($i = 0; $i < sizeof($error_list); $i++) {
    $err = $error_list[$i];
    echo nl2br($cnf_cmds[$err]);
  }
  echo("</blockquote>\n");
  echo("<br><a href='javascript:document.location.reload();'>And Reload this page</a>.");
  Tail1();
  exit;
}

##########################################################################
## 2. database selection test
##########################################################################

echo("Step 2. Testing database selection ... ");
$ret = $adminMgr->testDBSelection($connect);
if (!$ret) {
  echo("<font class='bad'>Database selection Error!!</font>");
  $err = "db_selection_err";
  array_push($error_list, $err); # add error code into error list
  if($conf[dbtype] == "mysql") {
    $cnf_cmds[$err] = "
      Create a database :
      $ mysql [-u user] [-p] database  # enter MySQL prompt
      mysql&gt;
      CREATE DATABASE $conf[dbname];

      Or, edit the inc/config.php :
      \$conf[dbname] = \"<font class='strong'>$conf[dbname]</font>\";
    \n";
  } else {
    $cnf_cmds[$err] = "
      Create a database :
      CREATE DATABASE $conf[dbname];

      Or, edit the inc/config.php :
      \$conf[dbname] = \"<font class='strong'>$conf[dbname]</font>\";

      Or click on the click above :
      ";
  }
} else echo("<b>Success</b>.");
echo("<br>\n");

if (!$ret) {
  echo("<font class='bad'>
  <b>You have a problem to select a database!</b>
  </font><br><br>
  To correct this problem, try the followings (if you are on an external web site provider, it will not work) :<br>
  <blockquote>\n");
  for ($i = 0; $i < sizeof($error_list); $i++) {
    $err = $error_list[$i];
    echo nl2br($cnf_cmds[$err]);
  }
  echo("</blockquote>\n");
  $sql_cmd = "CREATE DATABASE $conf[dbname];";
  ExecuteBlock($sql_cmd, "create database $conf[dbname]");
  echo("<br><a href='javascript:document.location.reload();'>And Reload this page</a>.");
  Tail1();
  exit;
}

##########################################################################
## 3. test database basic tables
##########################################################################

$error_list = array();

echo("Step 3. Checking basic tables in the database ... ");

# database tables checking list
$check_list = array($conf[dbtblpasswd], $conf[dbtblpasswdtmp],
  $conf[dbtblconfig], $conf[dbtbltrash], $conf[dbtblcalendar],
  $conf[dbtbladdress], $conf[dbtblmemo]);
function toLower(&$item) {
  $item = strtolower($item);
}
if ( !strcmp($env[dbtype], "mysql" ) ) {
  array_walk($check_list, 'toLower');
}
$check_list2 = array('passwd', 'passwd_temp', 'config', 'trash', 'calendar',
 'address', 'memo');
$tr_check_list = array_flip($check_list);

# query existing tables
$ret = $adminMgr->findTables();
DBError();
while ($row = $ret->fetchRow()) {
  if (in_array($row[Name], $check_list)) {
    $index = $tr_check_list[$row[Name]];
    unset($check_list[$index]);  # if table exist, remove from check list
    unset($check_list2[$index]);
  # echo("<br><font class='blur'>Database table '$row[Name]' exist.</font>");
  }
}
if (sizeof($check_list)) {  # if unremoved tables are in check list
  reset($check_list);
  while (list($key, $val) = each($check_list)) {
    echo("<br><font class='bad'>Error ... table '$val'
    does not exist in the database!!</font>\n");
    $err = "table_$check_list2[$key]"; # this is an error code
    array_push($error_list, $err); # add error code into error list
    # generate sql command
    $sql_cmds[$err]=ereg_replace("%NAME%", "$val", $sql_cmds[$err]);
  }
} else echo("<b>Success</b>.");
echo("<br>\n");

if (sizeof($check_list)) {
  echo("<font class='bad'>
  <b>You have problems in the database tables</b>
  </font><br><br>
  To correct this problem, do the followings.<br>
  $ mysql [-u user] [-p] database  # enter MySQL prompt<br>
  mysql&gt;<br>
  \n");

  for ($i = 0; $i < sizeof($error_list); $i++) {
    $err = $error_list[$i];
    ExecuteBlock($sql_cmds[$err], $err);
  }

  echo("<br><a href='javascript:document.location.reload();'>And Reload this page</a>.");
  Tail1();
  exit;
}

##########################################################################
## 4. check if an administrator account is exist
##########################################################################

$userMgr = createUserManager("admin", $adminMgr->db);

echo("Step 4. Checking an administrator account ... ");

$row = $userMgr->findUserByUid(0);
if (!$row) $err = 1;
elseif ($row[uid] == 0) $err = 0;

if ($err) {
  echo("<b>Fail</b>.");
} else echo("<b>Success</b>.");
echo("<br>\n");

if ($err) {
  echo("<font class='bad'>
  <b>There is no administrator account.</b>
  </font><br><br>
  To correct this problem, do the followings.<br>\n");

  $sql = ereg_replace("%TABLE%","$conf[dbtblpasswd]",$sql_cmds[add_user_admin]);
  ExecuteBlock($sql, "administrator's account");

  echo("<br><a href='javascript:document.location.reload();'>And Reload this page</a>.");
  Tail1();
  exit;
}

##########################################################################
## 5. user table patch
##########################################################################

echo("Step 5. Checking users' bookmark tables ... ");

# for all users in the PASSWD table
$ret = $userMgr->findAllUsers();
DBError();

$err_user_list = array();

while ($row = $ret->fetchRow()) {
  $table = "$conf[userdb_prefix]$row[user]";  # user's bookmark table
# echo("<br>Checking $row[user]'s bookmark table($table) ... ");

  $ret2 = $adminMgr->findFields($table); # fetch all fields in the table
  $flds = array();
  while ($row2 = $ret2->fetchRow()) {
    array_push($flds, $row2[Field]);
  }

  $err = 0;
  if (!in_array("icon",   $flds)) $err = 1;  # check if icon  field exists
  if (!in_array("rate",   $flds)) $err = 1;  # check if rate  field exists
  if (!in_array("lnid",   $flds)) $err = 1;  # check if lnid  field exists
  if (!in_array("uid",    $flds)) $err = 1;  # check if uid   field exists
  if (!in_array("rtime",  $flds)) $err = 1;  # check if rtime field exists
  if (!in_array("chkdate",$flds)) $err = 1; # check if chkdate field exists
  if ($err) { # if any field is missed, it fails
    array_push($err_user_list, $row[user]);
    echo("<br>$row[user]'s bookmark table($table) shoule be fixed ... ");
    echo("<b>Fail</b>.");
  }
}

# echo("<br>\n");

if (sizeof($err_user_list)) {
  echo("<br><font class='bad'>
  <b>You have problems in some users' database tables</b>
  </font><br><br>
  To correct this problem, do the followings.<br>\n");

  $fix_all_sql = '';
  for ($i = 0; $i < sizeof($err_user_list); $i++) {
    $user = $err_user_list[$i];
    $user_table = $conf[userdb_prefix].$user;
    $sql = ereg_replace("%NAME%","$user_table",$sql_cmds['table_user_patch1']);
    $fix_all_sql .= $sql . "\n\n";
    ExecuteBlock($sql, "user '$user' table patch");
  }
  # by gizmoeti
  ExecuteBlock($fix_all_sql, "All users table patch");

  echo("<br><a href='javascript:document.location.reload();'>And Reload this page</a>.");
  Tail1();
  exit;
} else echo("<b>Success</b>.");

##########################################################################
## Test Done!
##########################################################################

echo("<br>
<font class='good'><b>Congratulation!! You have successfully configured
Bookmark4U!!</b></font><br>
Return to <a href='../'>Your Bookmark4U Home</a>!<br>\n");
Tail1();
exit;

?>
