<?php

/************************************************************************/
/* Bookmark4U: Web-based personal bookmarking environment               */
/* ======================================================               */
/* Please read LICENSE.txt                                              */
/************************************************************************/

include("inc/common.php");

if ($env[register_global_off]) {  # register get/post variables as global
  if ($HTTP_SERVER_VARS[REQUEST_METHOD] == 'GET') {
    $which_list = array('mode', 'id', 'sort', 'group');
    ExtractVars($HTTP_GET_VARS, $which_list);
  } elseif ($HTTP_SERVER_VARS[REQUEST_METHOD] == 'POST') {
    $which_list = array('mode', 'id', 'name', 'email', 'bdate_year',
      'bdate_month', 'bdate_day', 'mobile', 'home_address', 'home_tel',
      'business_address', 'business_tel', 'agroup', 'comment', 'sort', 'group');
    ExtractVars($HTTP_POST_VARS, $which_list);
  }
}

CheckAuth('write');
$env[title_icon] = $env[icon_address];

$addMgr = createAddressManager();

function Head1() {
  global $env, $lang;
  global $mode, $sort;

  if (!$mode) $mode = 'list';
  $tab1 = ($mode=='list')   ? "<b>$lang[list]</b>" : "$lang[list]";
  $tab2 = ($mode=='add')    ? "<b>$lang[add]</b>" : "$lang[add]";
  $tab3 = ($mode=='edit')   ? "<b>$lang[edit]</b>" : "$lang[edit]";
  $tab4 = ($mode=='config') ? "<b>$lang[configure]</b>" : "$lang[configure]";
  $tab5 = ($mode=='export') ? "<b>$lang[export]</b>" : "$lang[export]";

  $col1 = ($mode=='list')   ? $env[th] : $env[td];
  $col2 = ($mode=='add')    ? $env[th] : $env[td];
  $col3 = ($mode=='edit')   ? $env[th] : $env[td];
  $col4 = ($mode=='config') ? $env[th] : $env[td];
  $col5 = ($mode=='export') ? $env[th] : $env[td];

  $attr = " width='20%' align='center'";
  $attrf = " class='tabselect'";
  $attrf .= " bgcolor='$env[th]'";

  $attr1 = ($mode=='list')   ? $attr.$attrf : $attr;
  $attr2 = ($mode=='add')    ? $attr.$attrf : $attr;
  $attr3 = ($mode=='edit')   ? $attr.$attrf : $attr;
  $attr4 = ($mode=='config') ? $attr.$attrf : $attr;
  $attr5 = ($mode=='export') ? $attr.$attrf : $attr;

  $opt = "&sort=$sort";
  echo("<table border='0' cellpadding='2' cellspacing='1' width='100%'>
<tr>
 <td bgcolor='$col1'$attr1><a href='address.php?mode=list$opt'>$tab1</a></td>
 <td bgcolor='$col2'$attr2><a href='address.php?mode=add$opt'>$tab2</a></td>
 <td bgcolor='$col3'$attr3>$tab3</td>
 <td bgcolor='$col4'$attr4><a href='address.php?mode=config$opt'>$tab4</a></td>
 <td bgcolor='$col5'$attr5><a href='address.php?mode=export$opt'>$tab5</a></td>
</tr></table>\n");
}


function AddEditForm($mode='add', $row) {
  global $env, $lang;
  global $now, $year, $month, $day;

  $attr1 = " bgcolor='$env[th]' align='center' width='150'";
  $attr2 = " bgcolor='$env[td]' align='left' width='350'";

  echo("<tr>
 <td$attr1>
  <a href=\"javascript:document.form.name.select();\">$lang[name]</a>
 </td><td$attr2>
  <input type='text' name='name' size='20'
  value=\"$row[name]\">
 </td>
</tr><tr>
 <td$attr1>$lang[group]</td>
 <td$attr2><select name='agroup'>\n");
  if ($env[address_group]) $grouplist = explode(":", $env[address_group]);
  else $grouplist = explode(":", $lang[address_12]);
  echo("<option value=''></option>\n");
  if ($mode == 'add') {
    FormOptions(sizeof($grouplist), $grouplist, $grouplist, $env[default_address_group]);
  } else {
    FormOptions(sizeof($grouplist), $grouplist, $grouplist, $row[agroup]);
  }
  echo("</select></td>
</tr><tr>
 <td$attr1>
  <a href=\"javascript:document.form.email.select();\">$lang[email]</a>
 </td><td$attr2>
  <input type='text' name='email' size='30' value=\"$row[email]\">
 </td>
</tr><tr>
 <td$attr1>$lang[birthday]</a>
 <td$attr2>\n");
  $bdate = DateStringToArray($row[birthday]);
  DateInput("bdate", $bdate[year], $bdate[month], $bdate[day], "",
   $sel_year=0, $disp_dow=0);
  echo(" </td>
</tr><tr>
 <td$attr1>
  <a href=\"javascript:document.form.mobile.select();\">$lang[address_7]</a>
 </td><td$attr2>
  <input type='text' name='mobile' size='20' value=\"$row[mobile]\">
 </td>
</tr><tr>
 <td$attr1>
  <a href=\"javascript:document.form.home_address.select();\">$lang[address_8]</a>
 </td><td$attr2>
  <input type='text' name='home_address' size='20' style='width:350'
  value=\"$row[home_address]\">
 </td>
</tr><tr>
 <td$attr1>
  <a href=\"javascript:document.form.home_tel.select();\">$lang[address_9]</a>
 </td><td$attr2>
  <input type='text' name='home_tel' size='20'
  value=\"$row[home_tel]\">
 </td>
</tr><tr>
 <td$attr1>
  <a href=\"javascript:document.form.business_address.select();\">$lang[address_10]</a>
 </td><td$attr2>
  <input type='text' name='business_address' size='20' style='width:350'
  value=\"$row[business_address]\">
 </td>
</tr><tr>
 <td$attr1>
  <a href=\"javascript:document.form.business_tel.select();\">$lang[address_11]</a>
 </td><td$attr2>
  <input type='text' name='business_tel' size='20'
  value=\"$row[business_tel]\">
 </td>
</tr><tr>
 <td$attr1>
  <a href=\"javascript:document.form.comment.select();\">$lang[comment]</a>
  <br>(&lt;= 255 bytes)
 </td><td$attr2>
  <textarea name='comment' cols='40' rows='5'>$row[comment]</textarea>
<!--
  <input type='text' name='comment' size='20' style='width:350'
  value=\"$row[comment]\">
-->
 </td>
 </tr>\n");
}

if ($mode == 'edit') {
  if (!$id) Error("require id");

  $row = $addMgr->findAddressById($id);
  DBError();
  if (!$row) Error("You can't edit it");

  PageHead("$lang[address_0] - $lang[edit]");
  ButtonSet();
  Head1();

  echo("<table border='0' width='500' cellpadding='2' cellspacing='1'
 align='center'>
<form action='address.php' method='post' name='form'>
<tr>
 <td colspan='2' align='center' bgcolor='$env[th]'><b>$lang[address_3]</b></td>
</tr>\n");
  AddEditForm('edit', $row);
  echo("<tr>
 <td colspan='2' align='center' bgcolor='$env[th]'>
 <input type='hidden' name='sort' value='$sort'>
 <input type='hidden' name='mode' value='editsubmit'>
 <input type='hidden' name='group' value='$group'>
 <input type='hidden' name='id' value='$id'>
 <a href=\"javascript:document.form.submit()\">[[$lang[address_4]]]</a>
 <a href=\"javascript:Question('$lang[address_6]', 'address.php?mode=del&id=$id')\">[[$lang[address_5]]]</a>
<script>
function Question(msg, url) {
  if (confirm(msg)) document.location = url
  else return;
}
</script>
 <input type='image' src='$env[icon_trdot]' border='0'>
 </td>
</tr></form></table>\n");

  PageTail();
  exit;

} elseif ($mode == 'configsave') {
  # variables should not be saved
  $http_post = $HTTP_POST_VARS;
  unset($http_post[mode]);
  unset($http_post[groupname]);

  SaveConfiguration($http_post);

  header("Location: address.php?sort=$sort&dummy=$env[dummy]");
  exit;

} elseif ($mode == 'config') {
  PageHead("$lang[address_0] - $lang[configure]");
  ButtonSet();
  Head1();

  $attr1 = " bgcolor='$env[th]' align='right' width='50%'";
  $attr2 = " bgcolor='$env[td]' align='left' width='50%'";
  echo("<table width='500' align='center' cellpadding='2' cellspacing='1'>
<form method='post' name='form'>
<tr>
 <td colspan='2' align='center' bgcolor='$env[th]'>$lang[configure]</td>
</tr>
<tr>
<td$attr1>$lang[group]</td>
<td$attr2><select name='grouplist' size='5'>\n");
  if ($env[address_group]) $grouplist = explode(":", $env[address_group]);
  else $grouplist = explode(":", $lang[address_12]);
  for ($i = 0; $i < sizeof($grouplist); $i++) {
    echo("<option value='$grouplist[$i]'>$grouplist[$i]</option>\n");
  }
  echo("</select><br><input
 type='button' value='$lang[delete]' onclick='javascript:DeleteGroup()'><input
 type='button' value='$lang[address_13]' onclick='javascript:SetDefault()'>
<br>
$lang[address_14] : <input type='text' name='groupname' size='10'><input
 type='button' value='$lang[add]' onclick='javascript:NewGroup()'><br>
$lang[address_15] : <input type='text' name='default_address_group' size='10'
 value='$env[default_address_group]'>
<input type='hidden' name='address_group' value='$env[address_group]'>
<input type='hidden' name='address_fields' value='$env[address_fields]'>
</td>
</tr>
<tr>
<td$attr1>$lang[address_16]</td>
<td$attr2>
<select name='fieldlist' size='8' multiple>\n");
  if ($env[address_fields]) $fieldlist = explode(":", $env[address_fields]);
  else $fieldlist = explode(":", $uconf[address_fields_default]);
  $fields = array('email','birthday','mobile','home_address','home_tel',
    'business_address','business_tel','comment');
  $fields_name = array($lang[email], $lang[birthday], $lang[address_7],
     $lang[address_8], $lang[address_9], $lang[address_10], $lang[address_11],
     $lang[comment]);
  for ($i = 0; $i < sizeof($fields); $i++) {
    if (in_array($fields[$i], $fieldlist)) $sel_opt = " selected";
    else $sel_opt = "";
    echo("<option value='$fields[$i]'$sel_opt>$fields_name[$i]</option>\n");
  }
  echo("</select>
<script>
function SelectAllFields() {
  var select = document.form.fieldlist;
  var len = select.options.length;
  for (i = 0; i < len; i++) {
    select.options[i].selected = true;
  }
}
</script><input
 type='button' value='Select All' onClick=\"javascript:SelectAllFields()\">
</tr>
<tr>
<td colspan='2' align='center' bgcolor='$env[th]'>
 <input type='hidden' name='mode' value='configsave'>
 <a href=\"javascript:SubmitForm()\">[[$lang[save]]]</a>
</td>
</tr>
<script>
function SetDefault() {
  var select = document.form.grouplist;
  var len = select.options.length;
  var sel = select.selectedIndex;
  if (sel < 0) alert('$lang[address_e1]');
  document.form.default_address_group.value = select.options[sel].value;
}
function DeleteGroup() {
  var select = document.form.grouplist;
  var len = select.options.length;
  for (i = 0; i < len; i++) {
    if (select.options[i].selected) {
      select.options[i] = null;
      break;
    }
  }
  if (i == len) alert('$lang[address_e1]');
}
function NewGroup() {
  var select = document.form.grouplist;
  var last = select.options.length;
  var groupname = document.form.groupname.value;
  if (groupname == '') { alert('Please enter a group name'); return; }
  select.options[last] = new Option(groupname);
  select.options[last].value = groupname;
  document.form.groupname.value = '';
}
function SubmitForm() {
  var select = document.form.grouplist;
  var len = select.options.length;
  var val = '';
  for (i = 0; i < len; i++) {
    if (i > 0) val = val + ':';
    val = val + select.options[i].value;
  }
  document.form.address_group.value = val;

  var select = document.form.fieldlist;
  var len = select.options.length;
  var val = '';
  for (i = 0; i < len; i++) {
    if (select.options[i].selected) {
      if (val) val = val + ':';
      val = val + select.options[i].value;
    }
  }
  document.form.address_fields.value = val;
  document.form.submit();
}
</script>
</form>
</table>\n");

  PageTail();
  exit;

} elseif ($mode == 'export') {

  Error("Not yet implemented");
  exit;

  PageHead("$lang[address_0] - $lang[export]");
  ButtonSet();
  Head1();


  PageTail();
  exit;

} elseif ($mode == 'del') {
  if (!$id) Error("require id");

  $addMgr->deleteAddress($id);
  DBError();

  header("Location: address.php?sort=$sort&dummy=$env[dummy]");
  exit;

} elseif ($mode == 'addsubmit') {
  if (!$name) Error("Require name");

  $bdate = "$bdate_year-$bdate_month-$bdate_day";
  $rowCreate = array();
  $rowCreate[name]            = $name;
  $rowCreate[email]           = $email;
  $rowCreate[mobile]          = $mobile;
  $rowCreate[home_address]    = $home_address;
  $rowCreate[home_tel]        = $home_tel;
  $rowCreate[business_address]= $business_address;
  $rowCreate[business_tel]    = $business_tel;
  $rowCreate[birthday]        = $bdate;
  $rowCreate[agroup]          = $agroup;
  $rowCreate[comment]         = $comment;
  $addMgr->addAddress($rowCreate);
  
  DBError();
  header("Location: address.php?sort=$sort&dummy=$env[dummy]");
  exit;

} elseif ($mode == 'editsubmit') {
  if (!$id) Error("require id");
  if (!$name) Error("Require name");

  /* not useful because update will not work if id is owned by uid
  # check id is owned by uid
  $row = $addMgr->findAddressById($id);
  DBError();
  if (!$row) Error("You can't edit it");*/

  $bdate = "$bdate_year-$bdate_month-$bdate_day";

  $rowCreate = array();
  $rowCreate[id]              = $id;
  $rowCreate[name]            = $name;
  $rowCreate[email]           = $email;
  $rowCreate[mobile]          = $mobile;
  $rowCreate[home_address]    = $home_address;
  $rowCreate[home_tel]        = $home_tel;
  $rowCreate[business_address]= $business_address;
  $rowCreate[business_tel]    = $business_tel;
  $rowCreate[birthday]        = $bdate;
  $rowCreate[agroup]          = $agroup;
  $rowCreate[comment]         = $comment;
  $addMgr->updateAddress($rowCreate);
  
  DBError();
  header("Location: address.php?sort=$sort&group=$group&dummy=$env[dummy]#$id");
  exit;

} elseif ($mode == 'add') {
  $env[page_focus] = 1;
  PageHead("$lang[address_0] - $lang[add]");
  ButtonSet();
  Head1();
  echo("<table border='0' width='500' cellpadding='2' cellspacing='1'
 align='center'>
<form action='address.php' method='post' name='form'>
<tr>
 <td colspan='2' align='center' bgcolor='$env[th]'><b>$lang[address_1]</b></td>
</tr>\n");
 $row = array();
 AddEditForm('add', $row);
 echo("<tr>
 <td colspan='2' align='center' bgcolor='$env[th]'>
 <input type='hidden' name='sort' value='$sort'>
 <input type='hidden' name='mode' value='addsubmit'>
 <a href=\"javascript:document.form.submit()\">[[$lang[address_2]]]</a>
 <input type='image' src='$env[icon_trdot]' border='0'>
 </td>
</tr></form></table>
<script>
function PageFocus() { document.form.name.focus(); }
</script>\n");
  PageTail();
  exit;
}

$env[title_icon] = $env[icon_address];
PageHead("$lang[address_0]");
ButtonSet();
Head1();

if (!$group) $group = $env[default_address_group];

if (!$sort) $sort = 'name';
if ($sort == 'name') $orderQry = "name";
elseif ($sort == 'group') $orderQry = "agroup, name";

$ret = $addMgr->findAddresses($group, $orderQry);
DBError();

if ($env[address_group]) $grouplist = explode(":", $env[address_group]);
else $grouplist = explode(":", $lang[address_12]);

if ($env[address_fields]) $fieldlist = explode(":", $env[address_fields]);
else $fieldlist = explode(":", $uconf[address_fields_default]);

$attr1 = " bgcolor='$env[th]' align='center'";
$attr2 = " bgcolor='$env[td]' align='center'";
$str1 = ($sort == 'name') ? "<b>$lang[name]</b>" : "$lang[name]";
$str2 = ($sort == 'group') ? "<b>$lang[group]</b>" : "$lang[group]";
echo("<a name='top'>
<script>
function ChangeGroup() {
  group = document.form.group.value;
  window.location='address.php?sort=$sort&group=' + group;
}
</script>
<table border='0' width='100%' cellpadding='2' cellspacing='1'
 align='center'>
<form name='form'>
<tr>
<td$attr1><a href='address.php?sort=name&group=$group'>$str1</a></td>
<td$attr1><a href='address.php?sort=group&group=$group'>$str2</a><br>
<select name='group' onChange=\"javascript:ChangeGroup()\">
<option value='all'>- $lang[all] -</option>\n");
FormOptions(sizeof($grouplist), $grouplist, $grouplist, $group);
echo("<option value='empty'>- Empty -</option>
</select>
</td>\n");
$colspan = 2 + sizeof($fieldlist);
if (in_array('email', $fieldlist)) {
  echo("<td$attr1>$lang[email]</td>\n");
}
if (in_array('birthday', $fieldlist)) {
  echo("<td$attr1>$lang[birthday]</td>\n");
}
if (in_array('mobile', $fieldlist)) {
  echo("<td$attr1>$lang[address_7]</td>\n");
}
if (in_array('home_address', $fieldlist)) {
  echo("<td$attr1>$lang[address_8]</td>\n");
}
if (in_array('home_tel', $fieldlist)) {
  echo("<td$attr1>$lang[address_9]</td>\n");
}
if (in_array('business_address', $fieldlist)) {
  echo("<td$attr1>$lang[address_10]</td>\n");
}
if (in_array('business_tel', $fieldlist)) {
  echo("<td$attr1>$lang[address_11]</td>\n");
}
if (in_array('comment', $fieldlist)) {
  echo("<td$attr1>$lang[comment]</td>\n");
}
echo("</tr></form>\n");


$reg = "(http|https|ftp|telnet|news|file):\/\/(([\xA1-\xFEa-z0-9_\-]+\.[][\xA1-\xFEa-z0-9:;&#@=_~%\?\/\.\,\+\-]+)(\/|[\.]*[a-z0-9]))";


$cnt = 0;
while ($row = $ret->fetchRow()) {
  if ($row[agroup]) {
    $gerror = (in_array($row[agroup], $grouplist)) ? "" : "*";
  }

  $cmt = $row[comment];
  $cmt = eregi_replace("\r\n", "\n", $cmt);
  $cmt = eregi_replace("<([a-z][^>]*)>", "&lt;\\1&gt;",$cmt);
  $cmt = eregi_replace("<(/[a-z]*)>", "&lt;\\1&gt;",$cmt);
  $cmt = eregi_replace("($reg)", "<a href=\"\\1\" target=_blank>\\1</a>", $cmt);
  $cmt = nl2br($cmt);

  echo("<tr>
<td$attr2 nowrap><a name='$row[id]'><a
 href='address.php?mode=edit&id=$row[id]&sort=$sort&group=$group'>$row[name]</a></td>
<td$attr2 nowrap>$row[agroup]$gerror</td>\n");

  if (in_array('email', $fieldlist)) echo("<td$attr2><a href='mailto:$row[name]&lt;$row[email]&gt;'>$row[email]</a></td>\n");
  if (in_array('birthday', $fieldlist)) echo("<td$attr2>$row[birthday]</td>\n");
  if (in_array('mobile', $fieldlist)) echo("<td$attr2>$row[mobile]</td>\n");
  if (in_array('home_address', $fieldlist)) echo("<td$attr2>$row[home_address]</td>\n");
  if (in_array('home_tel', $fieldlist)) echo("<td$attr2>$row[home_tel]</td>\n");
  if (in_array('business_address', $fieldlist)) echo("<td$attr2>$row[business_address]</td>\n");
  if (in_array('business_tel', $fieldlist)) echo("<td$attr2>$row[business_tel]</td>\n");
  if (in_array('comment', $fieldlist)) echo("<td$attr2>$cmt</td>\n");

  echo("</tr>\n");
  $cnt++;
}
echo("<tr>
<td align='center' colspan='$colspan' bgcolor='$env[th]'>
<b>$cnt</b> ");
if ($cnt > 1) echo $lang[items];
else echo $lang[item];
echo ("</td></tr> </table>\n");

PageTail();

exit;

?>
