<?php

/************************************************************************/
/* Bookmark4U: Web-based personal bookmarking environment               */
/* ======================================================               */
/* Please read LICENSE.txt                                              */
/************************************************************************/

include("inc/common.php");
include("inc/addmodify.php");

if ($env[register_global_off]) {  # register get/post variables as global
  if ($HTTP_SERVER_VARS[REQUEST_METHOD] == 'GET') {
    $which_list = array('id', 'exp', 'type');
    ExtractVars($HTTP_GET_VARS, $which_list);
  } elseif ($HTTP_SERVER_VARS[REQUEST_METHOD] == 'POST') {
  }
}

CheckAuth('write');

if ($id == 0) { # if root folder
  $row[id] = "0";
  $row[title] = sprintf($env[top_folder_name], $env[user]);
} else {
  $row = $mgr->findItemById($id);
  $row[url] = "";
}

$env[page_focus] = 1;
$env[page_unload] = 1;
$env[title_icon] = $env[icon_add];
PageHead($lang[addform_0]);
ButtonSet();

echo("<script>
function PageFocus() {
  document.addform.title.focus();
}
var iconselwin;
function PageUnLoad() {
  if (iconselwin) iconselwin.close();
}
</script>\n");

echo("<center>\n");
echo("$lang[location]: ");
PrintPath($row);
echo("<br></center>\n");

AddForm($row);

PageTail();

?>
