<?php

/************************************************************************/
/* Bookmark4U: Web-based personal bookmarking environment               */
/* ======================================================               */
/* Please read LICENSE.txt                                              */
/************************************************************************/

include("inc/common.php");
include("inc/addmodify.php");

if ($env[register_global_off]) {  # register get/post variables as global
  if ($HTTP_SERVER_VARS[REQUEST_METHOD] == 'GET') {
  } elseif ($HTTP_SERVER_VARS[REQUEST_METHOD] == 'POST') {
    $which_list = array('type', 'title', 'url', 'comment', 'public',
      'parent', 'addmore', 'exp', 'icon', 'intoclipboard', 'close_control',
      'rate', 'nochkdup');
    ExtractVars($HTTP_POST_VARS, $which_list);
  }
}

CheckAuth('write');

##MEDDAUGH##
if (get_magic_quotes_gpc()) { # php server's magic_quotes turned on or not
  $title_sql = $title;
  $url_sql = $url;
  $comment_sql = $comment;
} else {
  $title_sql = ereg_replace("'", "\'", $title);
  $url_sql = ereg_replace("'", "\'", $url);
  $comment_sql = ereg_replace("'", "\'", $comment);
}


if ($mode == 'addlink') { # add symbolic link

  $rowCreate = array();
  $rowCreate[type]    = 'l';
  $rowCreate[parent]  = $parent;
  $rowCreate[title]   = $title;
  $rowCreate[url]     = $url;
  $rowCreate[comment] = $comment;
  $rowCreate[public]  = $public;
  $rowCreate[lnid]    = $id;
  $rowCreate[icon]    = $icon;
  $rowCreate[rate]    = $rate;
# PrintArray($rowCreate);
  $itemId = $mgr->addItem($rowCreate);
  DBError();

  if ($intoclipboard) { # add this item into clipboard
    $clipbrd = GetCookie("CLIPBRD");
    $items = $env[clipitems];
    if (!$clipbrd) {
      PutCookie("CLIPBRD", "$maxid");
    } else {
      if (!in_array($maxid, $items)) {
        PutCookie("CLIPBRD", "$clipbrd:$maxid");
      }
    }
  }

  $redirect = "list.php?root=$parent";
  header("Location: $redirect");
  exit;
}


# check if valid input
if ($type == 'b') { # bookmark
  if (!$title) { Error($lang[msg_req_title]); }
  if (!$url)   { Error($lang[msg_req_url]); }
} else { # folder
  if (!$title) { Error($lang[msg_req_title]); }
}

if ($type == 'b') {  # if this a bookmark check url and prefix 'http://'
  if (!ToURLString($url)) $alert_url_change = 1;
}

# check if any duplicated bookmarks exist with the same URL
if (!$nochkdup) {
  if ($type == 'b') {
    $result = $mgr->findBookmarksByUrl($url, true);
    if ($result->numRows() > 0) {
      PageHead($lang[addform_0]);
      echo("<center>\n");
      echo("<table border='0' width='$lv[tw]' cellpadding='3' cellspacing='1'>"
          ."<tr><td bgcolor='$env[blur]' align='center'>\n");
      echo("<img src='$env[icon_alert]' align='top'> ");
      echo("$lang[addform_3] :<br>");
      PrintDuplicatedBookmarks($url, $result); # print duplicated bookmarks
      echo("</td></tr></table>\n");
      echo("</center>\n");

      $row = array();
      $pagetitle = $title;
      $row[nochkdup] = 1;  # do not check duplicated bookmarks
      AddForm($row);
      PageTail();
      exit;
    }
  }
}

$rowCreate = array();
$rowCreate[type]    = $type;
$rowCreate[parent]  = $parent;
$rowCreate[title]   = $title;
$rowCreate[url]     = $url;
$rowCreate[comment] = $comment;
$rowCreate[public]  = $public;
$rowCreate[icon]    = $icon;
$rowCreate[rate]    = $rate;
$itemId = $mgr->addItem($rowCreate);
DBError();

# update the total field of parents
UpdateTotalLeaf($parent);

$exp_parm = ($env[tree_view]) ? "&exp=$exp" : "";

if ($addmore == "1") $redirect = "addform.php?id=$parent$exp_parm";
else {
  $close = ($close_control) ? "&close_control=1" : "";
# if ($env[time_to_close] == 0 && $close_control == 1) {
#   echo(" ");
#   exit();
# } else
  if (!$env[tree_view] || ($env[tree_view] && !$exp)) {
    $redirect = "list.php?root=$parent$close";
  } else $redirect = "list.php?root=$env[root]$exp_parm$close";
}

if ($intoclipboard) { # add this item into clipboard
  $clipbrd = GetCookie("CLIPBRD");
  $items = $env[clipitems];
  if (!$clipbrd) {
    PutCookie("CLIPBRD", "$itemId");
  } else {
    if (!in_array($itemId, $items)) {
      PutCookie("CLIPBRD", "$clipbrd:$itemId");
    }
  }
}

if ($alert_url_change) {
  ErrorRedir("$lang[add_1]\\r\\n\\r\\nURL: $url", $redirect);
} else {
  header("Location: $redirect");
}

?>
