<?php

/**
 *
 *  Mazen's PHP Chat Version 3.0.0B1
 *  Chat-Script written in PHP
 *  2001-04-12
 *
 *  Copyright (c) 2001 Marcel Beerta <marcel@beerta.de>
 *
 *
 *  This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License as
 *   published by the Free Software Foundation; either version 2 of
 *   the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 *   General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/**
 *   -----------------------------------------------------------------------------------------
 *    Command-Line Chatserver
 *   -----------------------------------------------------------------------------------------
 */
	class SocketServer {

		var $db			=	false;			//Database Object

		var $socketfd        	=       false;			//Socket Descriptor
		var $port        	=       22222;			//Port Server runs on
		var $rcons;						//Array with existing read-connections
		var $wcons;                                		//Array with existing write-connections
		var $connectioncounter	=       1;        		//Number of Connections
		var $fdmax;                                		//Max Value for Connectiondescriptor
		var $die                =       false;        		//If true, server will shutdown

		var $readfds;
		var $writefds;
		var $exceptfds;

		var $intervalsec	=       0;			//Time to wait for data
		var $intervalusec   	=       0;			//Time to wait for data in milliseconds

		var $msgs;						//Array of to be sent data
		var $debugmode		=       false;			//Should debug-data be produced?

		var $versioning		=       "<span style='font-size: 10pt; font-family: Verdana, Arial, Times new Roman; color:#D0D0D0'>Mazen's PHP Chat 3.0.0-dev<br>\n&copy; 2001 by Marcel Beerta, <a href=\"http://www.mazenphp.de\" target=\"_blank\">http://www.mazenphp.de</a><br><br></span>\n";
		// I would be happy if you kept this ...

		var $header		=       "HTTP/1.1 200 Ok\nServer: Mazens Chat Server\nConnection: Keep-Alive\nContent-Type: text/html; charset=iso-8859-1\n\n";
		//DO NOT CHANGE, REALLY DON'T DO THAT!

		var $clients		=       array();
		var $head		=       "";
		var $welcome		=       "";

		var $pos                =       0;
		var $lastpos		=       0;
		var $logging		=	"false";


		var $movingscript = "
				<script language=\"JavaScript\">
				<!--
				scrolling=true;
				function moves() {
				
				    if(scrolling != false) { window.scroll(1,5000000); }
				    window.setTimeout(\"moves()\",100);
				}
				moves();
				//-->
				</script>
		";				
		/**
		 *
		 * Debug Function
		 *
		 */

	
		function log($message) {
			if ( $this -> logging == "true") {
				$date = date("Y-m-d");
				$time = date("H:i:s");	
				
				$message = preg_replace("=<script [^>]*>(.*)</script>=siU","", $message);
				if ( !empty($message) ) {
					$fp = fopen("logs/chatlog-$date.html", "a+");
					fputs($fp, "[".$time."] :".$message."\n");
					fclose($fp);
				}
			}
		}
		
		function debug($message) {
			
			if($this -> debugmode) {
				printf("DEBUG: %s\n",$message);
				flush();
			}
			
			unset($message);
			return 0;			
		}

		/**
		 *
		 * Helper Function maxfd. Saves the Max fd-count
		 *
		 */

		function checkinfd ($fd) {
			
			if ( $fd > $this -> fdmax ) {
				$this -> fdmax = $fd;
			}
			unset($fd);			
		}

		/**
		 *
		 * Create new client
		 *
		 */
		function newclient ( $socketid ) {
			$this -> debug ("Created New Client");
			$this -> rcons[$socketid]= $socketid;
			$this -> wcons[$socketid]= $socketid;
			$this -> checkinfd ($socketid);
			
			
			socket_fd_set ($this -> readfds, $socketid);
			socket_set_nonblock($socketid);
		
			unset($socketid);			
		}

		/**
		 *
		 * Remove a client
		 */

		function removeclient ( $socketid ) {
			$this -> debug("Client connection $socketid lost");
			unset ($this -> rcons[$socketid] ) ;
			unset ($this -> wcons[$socketid] ) ;
			
			socket_fd_clear ($this -> readfds, $socketid);
			socket_fd_clear ($this -> writefds, $socketid);
			socket_close ($socketid);

			
			$this -> db -> query("SELECT clearout, nick, room FROM chatusers WHERE connid = '".intval($socketid)."'");
			
			if ( $this -> db -> numRows() > 0 && intval($socketid) != 0 ) {
				$data = $this -> db -> fetch();
				if ( $data["clearout"] == 0 ) {
					$this -> handleMessage ( "|".$data["room"]."|".$data["nick"]." ".translate("has left the Chat")."<br />");
					$this -> handleMessage ( "|".$data["room"]."|<script language=JavaScript>parent.frames.nicklist.location.href = parent.frames.nicklist.location.href</script>");
					$this -> db -> query ("UPDATE chatusers SET sessid = '' WHERE connid = '".intval($socketid)."'");
				
				}
			}
			
			$this -> db -> query("UPDATE chatusers SET connid = '0', active = '0', clearout = '0' WHERE connid = '".intval($socketid)."'");

			unset($data);
			unset($socketid);
		}

		/**
		 *
		 *
		 * Send a message to everyone
		 */
		function broadcast ($msg) {
			reset ( $this -> wcons );
			foreach ( $this -> wcons as $k ) {
				$this -> debug("an: $k");

				$this -> msgs[$k][] = $msg;
			}
			unset($msg);			
		}

		/**
		 *
		 * Sent data to a Client
		 *
		 */
		function send ($client, $text ) {
			$this -> msgs[$client][] = $text;
		}
		
		
		/**
		 *
		 * Reloads the ServerConfiguration
		 *
		 */
		
		function reloadConfiguration() {
			$this -> head = getConfig("OutputHeader");
			$this -> welcome = getConfig("WelcomeString");
			//$this -> logging = getConfig("ChatLog");	
		}
		
		 

		/**
		 *
		 * Handles the Complete message-sending to the clients!
		 *
		 */
		function handleMessage( $message ) {
			$messagearray = explode ("|", $message);

			$to_user = $messagearray[0];
			$to_room = $messagearray[1];
			$message = $messagearray[2];
			$this -> debug("ToUser: $to_user");
			$this -> debug("ToRoom: $to_room");
			$this -> debug("Msg: $message");
			
			
			
			if ( $to_user == "CHATSERVERMESSAGE" && intval($to_room)==intval(crypt(getConfig("SecretKey")))) {
				$this -> debug("SERVERMESSAGE!");
				switch ( $message ) {
					case "CONFIGRELOAD": $this -> reloadConfiguration(); break;
					case "LOG_ON":
						$this -> logging = "true"; break;
					case "LOG_OFF":
						$this -> logging = "false"; break;
					default : $this -> debug("bas message type: \"$message\""); break;
				}

			}
			//$message = "<script language=\"JavaScript\">window.scrollBy(0,100);</script>".$message;

			 if ( !empty ($to_user) && empty($to_room) ) {
			 	$this -> log ($message);
				$this -> debug("Private Message");
				$this -> db -> query("SELECT sessid FROM chatusers WHERE nick = '$to_user' AND active = '1'");
				$data = $this -> db -> fetch();
				$sessid = $data["sessid"];

				$client = $this -> clients[$sessid];
				$this -> debug ("Sending to $client");
				$this -> msgs[$client][] = $message;

			} else if ( !empty($to_room) && empty($to_user)) {
				$this -> log ($message);
				$this -> debug("Chatmessage");
				$this -> db -> query("SELECT sessid FROM chatusers WHERE room = '$to_room' AND active = '1'");
				while ( $data = $this -> db -> fetch()) {
					$sessid = $data["sessid"];

					$client = $this -> clients[$sessid];
					$this -> debug ("Sending to $client");
					$this -> msgs[$client][] = $message;
				}
			} else if ( empty($to_user) && empty($to_room)) {
				$this -> log ($message);
				$this -> debug("Broadcast-Message!");
				$this -> db -> query ("SELECT sessid FROM chatusers WHERE active = '1'");
				while ( $data = $this -> db -> fetch()) {
					$sessid = $data["sessid"];

					$client = $this -> clients[$sessid];
					$this -> debug ("Sending to $client");
					$this -> msgs[$client][] = $message;
				}
			}

			unset($message);


		}

		/**
		 *
		 * Function for initialization of SocketServer
		 */

		function init () {
			
			/** CleanUp Database **/
			$this -> db -> query("UPDATE chatusers SET active='0', sessid=''");
			

			$this -> rcons = array();
			$this -> wcons = array();
			$this -> msgs = array();


			$this -> debug("Creating Socket");
			if (!$this -> socketfd = socket_create_listen((string)$this -> port, 5))
				die ("Couldn't create Socket! Reason: ".socket_strerror($this->socketfd)."\n");
			if ($this->socketfd<0) die("Couldnt create Socket! ".$this->port.": ".socket_strerror($this->socketfd)."\n");

			$this -> debug ("Created socket with id ".$this -> socketfd);
			$this -> debug ("Setting Socket Options");

			if ( false == socket_setopt ($this -> socketfd, SOL_SOCKET, SO_REUSEADDR, 1))
				die ("Couldn't set Socket Option\n");
			socket_set_nonblock ($this -> socketfd);

			$this -> checkinfd ($this -> socketfd);

			$this -> readfds = socket_fd_alloc();
			$this -> writefds = socket_fd_alloc();
			$this -> exceptfds = socket_fd_alloc();
			$this -> debug ("Adding Listen Socket to read sockets");
			socket_fd_set ( $this -> readfds, $this -> socketfd );
		}


		/**
		 *
		 * Here it's getting critical, we'll do our Main work here
		 *
		 */

		function loop () {

			set_time_limit(0);

			reset ($this -> rcons);

			foreach ( $this -> rcons as $key ) {

				@socket_fd_set ($this -> readfds, $key);

				if ( isset ($this -> msgs[$key]) ) {
					@socket_fd_set ($this -> writefds, $key);
				}
			}


			socket_fd_set ($this -> readfds, $this -> socketfd);

			if ( socket_select ( $this -> readfds, $this -> writefds, $this -> exceptfds, 0,0 )  ) {


				if ( socket_fd_isset( $this -> readfds, $this -> socketfd ) ) {



					if ( $newsocket = @socket_accept ( $this -> socketfd ) ) {
						$this -> debug ("New Connect!");
						$this -> newclient($newsocket);

						$this -> debug ("New Socket $newsocket created");

						socket_getpeername($newsocket, $address, $cport);
						$this -> debug ("Connection From $address:$cport");


					}

				}


				//are there new Messages ?

				reset ( $this -> rcons );
				foreach ( $this -> rcons as $key ) {
				//while ( list ( $key, $value ) = each ( $this -> rcons ) ) {

					if ( @socket_fd_isset ( $this -> readfds, $key ) ) {

						$this -> debug ( "New Message from $key" );

						$buffer = "";

						$buffer = @socket_read ($key, 1024);

						if ( strlen($buffer) > -1 ) {
							$this -> debug("\"".$buffer."\"");
							if  ( strlen($buffer) == 0 ) {
								$this -> debug("Empty Message, Removing client");
								$this -> removeclient($key);
								unset ($this -> clients[$key]);
							} elseif ( strlen ($buffer) <= 0 ) {
								$this -> debug("error");
								$this -> removeclient($key);
								unset ($this -> clients[$key]);
							} else {

								$secret = getConfig("SecretKey");
								
								if ( ereg( "GET /(.*) HTTP", $buffer, $regs ) ) {

									if (!empty( $regs[1] ) ) {

										$sessid = $regs[1];
										$this -> clients[$sessid] = $key;
										@socket_write ($newsocket, $this -> header);
										@socket_write ($newsocket, $this -> head);
										@socket_write ($newsocket, $this -> versioning);
										@socket_write ($newsocket, $this -> welcome);
										@socket_write ($newsocket, $this -> movingscript);
										
										$this -> debug ("Newsocket: $newsocket");
										
										$this -> db -> query("UPDATE chatusers SET connid='".intval($newsocket)."' WHERE sessid = '$sessid'");										
									} else {
										$this -> removeclient($key);
										unset ($this -> clients[$key]);
									}
								} elseif ( preg_match("/^".crc32($secret)."CHATMSG\|(.*)/", $buffer, $regs2 ) ) {

									$this -> handleMessage($regs2[1]);
									$this -> removeclient($key);
								}

							}
						}
						
						
						// Is there anything to be sent ?
				
				
						
						unset($buffer);
						unset($secret);
						unset($key);
						unset($regs);
						unset($newsocket);
						unset($regs2);
					}
				}

				reset ( $this -> wcons );
				
				//reset ( $this -> writefds );
				foreach ( $this->wcons as $key ) {
					if ( socket_fd_isset ( $this -> writefds, $key ) ) {			
						if ( is_array ( $this -> msgs[$key] ) ) {
							reset ( $this -> msgs[$key] );
							while ( list ( $key2, $value2) = @each ($this -> msgs[$key])) {
								$test = @socket_write ( $key, $value2 );
								if ( strlen($key2) <= 0  ) {
									if ( $test ) {							
										$this -> debug ( "Sent: $value2" );
										array_splice($this -> msgs[$key],$key2,1);
									} else {
										$this -> debug ( "Could not send $value2 " );
									}							
								} else {
									array_splice ( $this -> msgs[$key], $key2, 1 );
								}
							}
						} else {	
							array_splice($this ->msgs,$key,1);
						}
					}
				}
			}
		}

		function start () {
			$this -> debug ( "Activating SocketServer");
			while ( ! $this->die ) {

				reset ($this -> wcons);
				foreach ( $this -> wcons as $key ) {
				//while ( list( $key, $value ) = each ( $this -> wcons ) ) {
				       $test =  @socket_write ( $key, " " );
				       if (!$test ) {
						$this -> removeclient($key);
					}
				}
				
				
				$die = $this -> loop ();
				usleep(500000);
			}
		socket_close ( $this -> socketfd );
		}

		/**
		 *
		 * Constructor
		 *
		 */


		function SocketServer ($db, $debug = false) {

			$this -> port = getConfig("ServerPort");
			$this -> debugmode = $debug;
			$this -> head = getConfig("OutputHeader");
			$this -> welcome = getConfig("WelcomeString");
			$this -> logging = getConfig("ChatLog");

			$this -> db = $db;

			$this -> debug ("Starting SocketServer on port ".$this->port);
			$this -> init();
			$this -> debug ("Initialized!");
		}

	}


/**
 *
 * Initialization
 *
 */


include "../configuration.inc.php";

/**
 *
 * General help if arg is --help
 *
 */
if ( $argv[1] == "--help") {
	echo "Usage: php server.php [-d|--daemon] [--debug]\n\n";
	echo "\t-d, --daemon\t\tRun in Daemon-Mode (ext/pcntl required, configure php with --enable-pcntl)\n";
	echo "\t--debug\t\t\tGive out Debug-Information\n";
	die();
}

if ( $argv[2] == "--debug" || $argv[1] == "--debug") {
	$debug = true;
} else {
	$debug = false;
}

if ( $argv[1] == "-d" || $argv[1] == "--daemon" ) {

	$pid = pcntl_fork();
	if ($pid == 0 ) {
		//Child
		
		$server = new SocketServer($db, $debug);
		$server -> start();
	} else {
		// Parent
	}
} else {

	$db = new Database("localhost", "root", "", "chat");
	$server = new SocketServer($db, $debug);
	$server -> start();
}

?>
