<?php

		/**
		 *
		 * Lightweight Database Abstraction Layer (LDAL)
		 *
		 * (c) 2001 Marcel Beerta <marcel.beerta@isg.de>
		 *
		 */

		class Database {
			var $dbhost	=	"";
			var $dbuser	=	"";
			var $dbpass	=	"";
			var $dbname	=	"";

			var $conn	=	false;
			var $result	=	false;

			var $error	=	"";


			/**
			 *
			 * Constructor
			 *
			 */

			function Database($dbhost, $dbuser, $dbpass, $dbname) {
				$this -> dbhost	=	$dbhost;
				$this -> dbuser	=	$dbuser;
				$this -> dbpass	=	$dbpass;
				$this -> dbname	=	$dbname;

				$this -> conn = @mysql_connect($this->dbhost, $this->dbuser, $this->dbpass);

				/* Can't connect to MySQL-Server */
				if ( !$this -> conn ) {
					$this -> error = "Unable to connect to Database Server! Reason: ".mysql_error();
					$this -> throwError();
					return false;
				}


				/* Select the Database */
				$db = @mysql_select_db($this->dbname);
				if ( !$db ) {
					$this -> error = "Unable to select Database! Reason: ".mysql_error();
					$this -> throwError();
					return false;
				}

				return true;
			}

			/* Perform Query */
			function query($query) {

				if (!$this -> conn) {
					$this -> error = "Unable to Perform Query! No connection to Database found!";
					$this -> throwError();
					return false;
				}
				
				$this -> result = @mysql_query($query, $this->conn);
				if (!$this -> result) {
					$this -> error = "Failed Query! Reason: ".mysql_error();
					$this -> throwError();
					return false;
				}

				return true;
			}
			
			function numRows() {
				
				if (!$this -> result ) {
					$this -> error = "Unable to return numRows, no query!";
					$this -> throwError();
					return false;
				}
			
				$data = mysql_num_rows($this -> result);
				
				if (!$data) {

					$this -> free();
					return false;
				}
				
				return $data;
			}
		
			function affectedRows() {
				if (!$this -> conn ) {
					$this -> error = "Unable to return affectedRows, no connection!";
					$this -> throwError();
					return false;
				}
			
				$data = @mysql_affected_rows($this -> conn);
				
				if (!$data) {

					$this -> free();
					return false;
				}
				
				return $data;
			}

			function fetch() {
				if (!$this->result) {
					$this -> error = "Unable to Fetch Records, no query given!";
					$this -> throwError();
					return false;
				}

				$data = @mysql_fetch_array($this->result, MYSQL_ASSOC);


				/* No data to follow, we can free our Result Set */
				if (!$data) {

					$this -> free();
					return false;
				}

				return $data;
			}

			/* Equal to mysql_result($resultid, $index, $field) */
			function result($index, $field) {
				$data = @mysql_result($this->result, $index, $field);
				if (!$data) {

					$this -> free();
					return false;
				}

				return $data;
			}

			/* Put out an Error Message */
			function throwError() {
				echo "<b>".$this -> error."</b><br>";
			}

			/* Close Connection, reset all resultsets, ... */
			function close() {
				$res = @mysql_close($this -> conn);
				$this -> conn = false;
				$this -> result = false;
				return true;
			}

			/* Free the Resultset */
			function free() {
				$res = @mysql_free_result($this -> result);
				$this -> result = false;
				return true;
			}
		}
?>