<?php
/** 
 *
 *  Mazen's PHP Chat  
 *  Chat-Script written in PHP
 *  2001-04-12
 *  
 *  Copyright (c) 2001 Marcel Beerta <marcel@beerta.de>
 *
 *
 *  This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License as
 *   published by the Free Software Foundation; either version 2 of
 *   the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 *   General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
 
$args = explode(" ", $message);

		switch($args[0]) {
			
			/* Joins a Channel */
			case "/j":
			case "/join":
				$args[0] = "";
				$toroom = implode(" ",$args);
				chat_changeRoom($toroom);
				break;
			
			/* Follows a User */	
			case "/ju":
			case "/follow":
				
				$args[0] = "";
				$followuser = implode(" ",$args);
				chat_followUser($followuser);
				break;
			
			/* Kicks a User */
			case "/kick":
				$touser = $args[1];
				$args[0] = $args[1] = "";
				$reason = implode(" ", $args);
				chat_kick($touser, $reason);
				break;
			
			/* Changes Color */
			case "/col":
				$color = $args[1];
				chat_ChangeCol($color);
				break;
			
			/* Screaming */
			case "/s":
			case "/scream":
				$args[0] = "";
				$message = implode(" ",$args);
				chat_Scream($message);
				break;
			/* Emotions */
			case "/me":
				$args[0] = "";
				$message = implode(" ",$args);
				chat_Me($message);
				break;
			case "/away":
				$args[0] ="";
				$reason = implode(" ",$args);
				chat_Away($reason);
				break;
				
			case "/load":
			case "/uptime":
				chat_Uptime();
				break;
			
			case "/clear":
				chat_Clear();
				break;
			
			case "/about":
				chat_About();
				break;
			
			case "/m":
			case "/msg":
				$touser = $args[1];
				$args[0] = $args[1] = "";
				$message = implode(" ", $args);
				chat_Private($touser,$message);
				break;
			case "/op":
				$touser = $args[1];
				chat_Op($touser);
				break;
			case "/deop":
				$touser = $args[1];
				chat_DeOp($touser);
				break;	
			case "/voice":
				$touser = $args[1];
				chat_Voice($touser);
				break;
			case "/devoice":
				$touser = $args[1];
				chat_DeVoice($touser);
				break;		
			case "/lock":
				chat_Lock();
				break;
			case "/unlock":
				chat_UnLock();
				break;
			case "/moderate":
				chat_Moderate();
				break;
			case "/unmoderate":
				chat_UnModerate();
				break;
				
			case "/config_reload":
				chat_Configreload();
				break;
			case "/log_on":
				chat_log(true);
				break;
			case "/log_off":
				chat_log(false);
				break;			
			case "/ban":
				$type = $args[1];
				$value = $args[2];
				$args[0] = $args[1] = $args[2] = "";
				$reason = implode(" ", $args);
				chat_Ban($type, $value, $reason);
				break;
			case "/unban":
				$id = $args[1];
				chat_unBan($id);
				break;
			case "/banlist":
				chat_BanList();
				break;
			case "/whois":
				$user = $args[1];
				chat_Whois ($user);
				break;
			case "/password":
				$newpass = $args[1];
				chat_ChangePass($newpass);
				break;
			case "/seen":
				$user = $args[1];
				chat_Seen ($user);
				break;
			case "/broadcast":
				$args[0] = "";
				$message = implode(" ", $args);
				chat_BroadCast($message);
				break;
			default:
				chat_message(translate("No such Command found").": ".$args[0], $userdata[nick], "");
				
		}

?>