<?php
/** 
 *
 *  Mazen's PHP Chat  
 *  Chat-Script written in PHP
 *  2001-04-12
 *  
 *  Copyright (c) 2001 Marcel Beerta <marcel@beerta.de>
 *
 *
 *  This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License as
 *   published by the Free Software Foundation; either version 2 of
 *   the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 *   General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
 


/**
 *
 * function makeClickable (string $text)
 *
 * Transforms all http://, ftp://, mailto:-urls into a href-strings
 *
 */

function makeClickable ( $text ) {
	
	// pad it with a space so we can match things at the start of the 1st line.
	$ret = " " . $text;
			
	// matches an "xxxx://yyyy" URL at the start of a line, or after a space.
	// xxxx can only be alpha characters.
	// yyyy is anything up to the first space, newline, or comma.
	$ret = preg_replace("#([\n ])([a-z]+?)://([^, \n\r]+)#i", "\\1<a href=\"\\2://\\3\" target=\"_blank\">\\2://\\3</a>", $ret);
								
	// matches a "www.xxxx.yyyy[/zzzz]" kinda lazy URL thing
	
	// Must contain at least 2 dots. xxxx contains either alphanum, or "-"
	// yyyy contains either alphanum, "-", or "."
	// zzzz is optional.. will contain everything up to the first space, newline, or comma.
	// This is slightly restrictive - it's not going to match stuff like "forums.foo.com"
	// This is to keep it from getting annoying and matching stuff that's not meant to be a link.
	$ret = preg_replace("#([\n ])www\.([a-z0-9\-]+)\.([a-z0-9\-.\~]+)((?:/[^, \n\r]*)?)#i", "\\1<a href=\"http://www.\\2.\\3\\4\" target=\"_blank\">www.\\2.\\3\\4</a>", $ret);
																
	// matches an email@domain type address at the start of a line, or after a space.
	// Note: before the @ sign, the only valid characters are the alphanums and "-", "_", or ".".
	// After the @ sign, we accept anything up to the first space, linebreak, or comma.
	$ret = preg_replace("#([\n ])([a-z0-9\-_.]+?)@([^, \n\r]+)\.([^, \n\r]+)#i", "\\1<a href=\"mailto:\\2@\\3.\\4\">\\2@\\3.\\4</a>", $ret);
																					
	// Remove our padding..
	$ret = substr($ret, 1);
																								
	return($ret);
}
																									

/* Every Chat-Command resides in this File as an own function */

/**
 *
 * function chat_message(string $message, [string $touser], [string $toroom], [boolean $special])
 *
 * Sends a message. If either the $touser or the $toroom-Variables are given, 
 * it's a broadcast-message and goes everywhere.
 * If $touser is given, it's private
 * If only $toroom is given, it just goes inside that room
 *
 *
 * If you don't use the Command-Line Server, please go to the comment out this block and
 * comment in the following block
 */
function chat_message($message,  $touser="", $toroom="", $special = false, $ovverridecheck = false) {
	global $db, $userdata, $REMOTE_ADDR;
	$db -> query("SELECT active, sessid FROM chatusers WHERE nick = '".$userdata["nick"]."'");
	if ( $db -> numRows() > 0 || $ovverridecheck == true) {
		if(!$special) {
			$message = makeClickable($message);
			$message = "<font color=#".$userdata[col].">".$message."</font><br />";
			$date = date("Y-m-d");
			$time = date("H:i:s");
		}
		
		$message = stripslashes($message);
	
		/**
		 * Look if Room is moderated and user has voice ...
		 */
		$maychat = false;
		if ( !empty ( $toroom ) && !$special) {
			/** Private Chats _always_ are allowed, special messages, too ... **/
			$db -> query ("SELECT moderate FROM chatrooms WHERE name = '$toroom'");
			$test = $db -> fetch();
			if ( $test["moderate"] == 1 ) {
				if ( $userdata["mode"] >= 1 ) {
					/** User has voice, he may talk **/
					$maychat = true;
				}
			} else {
				$maychat = true;
			}
		} else {
			$maychat = true;
		}
		
		if ( $maychat ) { 
			/** First update user statistics ... */
			$addontime = time() - $userdata["lastaction"];
			
			$db -> query ("UPDATE chatusers SET away= '0', lastip = '".$REMOTE_ADDR."', totalmsgs = totalmsgs + 1, totaltime = totaltime + ".$addontime.",  lastaction ='".time()."', lasthost = '".gethostbyaddr($REMOTE_ADDR)."' WHERE nick='".$userdata["nick"]."'");
			if ( getConfig("CmdLineServer") == "true" ) {	
			    $secret = getConfig("SecretKey");
			    $chathost = str_replace("http://","",getConfig("HTTPHost"));
			
			    $chatport = getConfig("ServerPort");
			    $fp = fsockopen ($chathost, $chatport, &$errno, &$errstr, 30);
			    if (!$fp) {
			    	    $db -> query("UPDATE chatusers SET active='0', sessid=''");
				    die("Failed sending message! Check if the Chatserver is running!");
				    
			    } else {
				    $message = crc32($secret)."CHATMSG|$touser|$toroom|$message";
				    fputs ($fp, $message);
				    fclose($fp);
			    }
			} else {
			    $db -> query("INSERT INTO msgs (datum, uhrzeit, sentby, sentto, raum, message) VALUES ( '$date','$time','".$userdata["nick"]."','$touser','$toroom','$message' )");
			}
		} else {
			chat_message(translate("You don't have Voice and this room is moderated!"), $userdata["nick"]);
		}
	}
}



/**
 *
 * function chat_Private(string $touser, string $message)
 *
 * Sends a Private message to the User specified in $touser
 *
 */
 
function chat_Private($touser, $message) {
	global $db, $userdata;
	$db->query("SELECT * FROM chatusers WHERE nick = '$touser'");
	if($db -> numRows() > 0 ) {
		$result = $db -> fetch();
		if ($result[active] == 0 ) {
			/**
			 * User is not in the Chat but exists. We'll relay his message
			 * until he enters the Chat.
			 */
			$datum = date("Y-m-d H:i:s");
			$db -> query("INSERT INTO relayedmsgs VALUES ('".$userdata[nick]."','$touser','$message')");
			chat_message(translate("The user is not in the Chat. Your message will be sent, if he gets into the Chat"), $userdata[nick], "");
		} else {
			/*
			 * User is here
			 */
			 chat_message($userdata[nick]." -> ".$message,$touser,"");
			  chat_message($touser." -> ".$message,$userdata[nick],"");
		}
	} else {
		/**
		 * User doesn't exist
		 */
		chat_message(translate("No such user: ").$touser, $userdata[nick], "");
	}
}

			
/**
 *
 * function chat_kick(string $touser, string $reason)
 *
 * Kicks a Chatuser and redirects him to the Login-Page
 *
 */
function chat_kick($touser, $reason) {
	global $db, $userdata;
	if($userdata[mode] >=2) {
		$db -> query("SELECT * FROM chatusers WHERE nick = '$touser' AND active='1'");
		if($db->numRows() > 0) {
			$result = $db -> fetch();
			$db -> query("UPDATE chatusers SET active = '0', sessid='' WHERE nick = '$touser'");
			chat_message($touser." ".translate("has been kicked. Reason: ")." ".$reason, "", $result[room]);
			chat_message("<script language=JavaScript>parent.location.href=\"".getConfig("BaseURL")."\"</script>",$touser,"",true);
			chat_message("<script language=JavaScript>parent.frames.nicklist.location.href = parent.frames.nicklist.location.href</script>","",$result[room],true);
		}
		else {
			chat_message(translate("The user is not here !"), $userdata[nick],"");
		}
		
	}
	else {
		chat_message(translate("You dont have the Permission to kick a user"),$userdata[nick],"");
	}
	
}

/**
 *
 * functin chat_changeCol(string $color)
 *
 * Sets the Color of the User to the specified value in $color
 *
 */
function chat_changeCol($color)
{
	global $db, $userdata;
	
	preg_match("=([#0-9ABCDEF]*)=msi",$color,$regs);
	$color = preg_replace("=#=","",$regs[1]);

	if(strlen($color) == 6) {
		
		$userdata[col] = $color;
		$db -> query("UPDATE chatusers SET col = '$color' WHERE nick = '".$userdata[nick]."'");
		chat_message(translate("Your Color has been changed"),$userdata[nick],"");
	}
	else {
		chat_message(translate("Wrong Syntax! Color has to be sth. like #CCFF00"),$userdata[nick],"");
	}
}

/**
 *
 * function chat_changeRoom (string $toroom)
 *
 * Changes the Chatroom
 *
 */

function chat_changeRoom ($toroom)
{
	$toroom = preg_replace("=^\s=msi","",$toroom);
	global $db, $userdata;

	if($userdata[room] != $toroom) {
		$db -> query("SELECT * FROM chatrooms WHERE name='$toroom'");
		if ($db->numRows() > 0) {
			$test = $db -> fetch();
			if ( $test["locked"] == 1 && $userdata["mode"] < 2 ) {
				chat_message("The Chatroom you want to join is locked!", $userdata["nick"]);
			} else {
				$db -> query("UPDATE chatusers SET room = '$toroom' WHERE nick = '".$userdata[nick]."'");
					chat_message("<script language=JavaScript>parent.frames.nicklist.location.href = parent.frames.nicklist.location.href</script>".$userdata["nick"]." ".translate("has left the Room")."<br />","",$userdata[room],true);
					chat_message("<script language=JavaScript>parent.frames.nicklist.location.href = parent.frames.nicklist.location.href</script>".$userdata["nick"]." ".translate("has entered the Room")."<br />","",$toroom,true);		
				
			}
		}
		else {
			chat_message(translate("The room does not exist"), $userdata[nick], "");
		}
	}
	else {
		chat_message(translate("You are already in that Room!"), $userdata[nick], "");
	}
}

/**
 *
 * function chat_followUser(string $folowuser)
 *
 * Follows a user into a Chatroom
 *
 */
function chat_followUser($followuser)
{
	$followuser =  preg_replace("=^\s=msi","",$followuser);
	global $db, $userdata;
	
	$db -> query("SELECT room, active FROM chatusers WHERE nick = '$followuser'");
	if ($db->numRows() >0) {
		$result = $db->fetch();
		if ($result[active] != 1) {
			chat_message(translate("The user is not here!"), $userdata[nick], "");
		}
		else {
			$toroom = $result[room];
			
			if($toroom != $userdata[room]) {
				$db->query("SELECT * FROM chatrooms WHERE name = '$toroom'");
				$result2 = $db->fetch();
				if($result2[private] == 1 || $result2[locked] == 1) {
					chat_message(translate("The Room is a Private or Locked room. Invite Only!"), $userdata[nick], "");
				}
				else {
					chat_changeRoom($toroom);
				}
			}
			else {
				chat_message(translate("You are in the Same Room!"), $userdata[nick]);
			}
			
			
		}
	}
	else {
		chat_message(translate("The user does not exist!"), $userdata[nick], "");
	}
}


/**
 *
 * function chat_Scream (string $message)
 *
 * Converts String to UpperCase and makes it Bold
 *
 */
 
function chat_Scream ($message)
{
	global $userdata;
	$message = strtoupper($message);
	$message = $userdata[nick]." ".translate("screams").": <b>".$message."</b>";
	chat_message($message,"",$userdata[room]);
}


/**
 * function chat_Me(string $message)
 *
 * Sends emotions like "[username] is angry"
 */

function chat_Me($message) {
		global $userdata;
		$message = "<b>".$userdata[nick]." ".$message."</b>";
		chat_message($message,"",$userdata[room]);
}

/**
 * function chat_Away(string $reason)
 *
 * Marks the user as away
 */

function chat_Away($reason)
{
	global $db, $userdata;
	$db -> query("UPDATE chatusers SET away='1' WHERE nick = '".$userdata[nick]."'");
	chat_message($userdata[nick]." ".translate("is away. Reason")." :".$reason,"", $userdata[room]);
	chat_message("<script language=JavaScript>parent.frames.nicklist.location.href = parent.frames.nicklist.location.href</script>","",$result[room],true);
}

/**
 * function chat_Uptime()
 *
 * Returns the Server Uptime
 */
function chat_Uptime()
{
	global  $userdata;
	$uptime=exec("uptime");
	chat_message("Uptime: $uptime",$userdata[nick],"");
}

/**
 * function chat_Clear()
 *
 * Clears the Message-Window. When browser get's slow, do this ...
 *  Internet-Explorer 6 seems to have problem's with it. Workaround searched ..
 */
function chat_clear()
{
	global $db, $userdata;
	/* To prevent the leave/join message ... */
	$db -> query("UPDATE chatusers SET clearout = '1' WHERE nick ='".$userdata[nick]."'"); 
	chat_message("<script language=JavaScript>parent.frames.output.location.href = parent.frames.output.location.href</script>", $userdata[nick],"",true);
}

/**
 *
 * Please leave this Code. I want to be popular, too :)
 *
 */
function chat_About()
{
	global $userdata;
	$about = "About this Chat:<br>This Chat is based on Mazen's PHP-Chat 3.0.0-dev.<br>You can find it at <a href=\"http://www.mazenphp.de\" target=_blank>http://www.mazenphp.de</a>";
	
	chat_message($about, $userdata[nick],"");
}

/**
 * function chat_Op ( string $user )
 * Ops user $user
 */
function chat_Op($user)
{
	global $db, $userdata;
	if ( $userdata["mode"] >= 2 ) {
		$db -> query("UPDATE chatusers SET mode = '2' WHERE nick = '".$user."'");
	
		$message = $user." ".translate("has been opped by ")." ".$userdata["nick"];
		chat_message($message, "", $userdata["room"]);
	} else {
		chat_message(translate("You don't have the permissions to Op someone!"), $userdata["nick"]);
	}
}

/**
 * function chat_deOp ( string $user ) 
 * Deops $user
 */
function chat_DeOp ( $user ) {
	
	global $db, $userdata;
	if ( $userdata["mode"] >= 2 ) {
		$db -> query("SELECT mode FROM chatusers WHERE nick = '".$user."'");
		$test = $db -> fetch();
		if ( $test["mode"] == 2 ) {
			$db -> query("UPDATE chatusers SET mode = '0' WHERE nick = '".$user."'");
	
			$message = $user." ".translate("has been deopped by ")." ".$userdata["nick"];
			chat_message($message, "", $userdata["room"]);
		} else {
			chat_message($user." ".translate("can not be deopped"), $userdata["nick"]);
		}
	} else {
		chat_message(translate("You don't have the permissions to DeOp someone!"), $userdata["nick"]);
	}
}

/**
 * function chat_Voice ( string $user )
 * Gives Voice to user
 */
function chat_Voice($user)
{
	global $db, $userdata;
	if ( $userdata["mode"] >= 2 ) {
		$db -> query("SELECT mode FROM chatusers WHERE nick = '".$user."'");
		$test = $db -> fetch();
		if ( $test["mode"] < 1 ) {
			$db -> query("UPDATE chatusers SET mode = '1' WHERE nick = '".$user."'");
	
			$message = $user." ".translate("has been given voice by ")." ".$userdata["nick"];
			chat_message($message, "", $userdata["room"]);
		} else {
			chat_message($user." ".translate("can not be voiced"), $userdata["nick"]);
		}
	} else {
		chat_message(translate("You don't have the permissions to gain Voice to someone!"), $userdata["nick"]);
	}
}

/**
 * function chat_DeVoice ( string $user ) 
 * DeVoices $user
 */
function chat_DeVoice($user)
{
	global $db, $userdata;
	if ( $userdata["mode"] >= 2 ) {
		$db -> query("SELECT mode FRON users WHERE nick = '".$user."'");
		$test = $db -> fetch();
		if ( $test["mode"] <= 1 ) {
			$db -> query("UPDATE chatusers SET mode = '0' WHERE nick = '".$user."'");
	
			$message = $user." ".translate("has been DeVoiced by ")." ".$userdata["nick"];
			chat_message($message, "", $userdata["room"]);
		} else {
			chat_message($user." ".translate("can not be devoiced"), $userdata["nick"]);
		}
	} else {
		chat_message(translate("You don't have the permissions to DeVoice someone!"), $userdata["nick"]);
	}
}

/**
 * function chat_Lock ( string $room ) 
 * Locks room $room
 */
function chat_Lock($room)
{
	global $db, $userdata;
	if  ( $userdata["mode"] >= 2 ) {
		$db -> query("SELECT locked FROM chatrooms WHERE name = '".$userdata["room"]."'");
		$test = $db -> fetch();
		if ( $test["locked"] != 1 ) {
			$db -> query("UPDATE chatrooms SET locked = '1' WHERE name = '".$userdata["room"]."'");
			chat_message(translate("This room has been locked by ").$userdata["nick"],"", $userdata["room"]);
		} else {
			chat_message(translate("This room is already locked!"), $userdata["nick"]);
		}
	} else {
		chat_message(translate("You don't have the permissions to lock the room!"), $userdata["nick"]);
	}
}

/**
 * function chat_UnLock ( string $room )
 * Unlocks $room
 */
function chat_UnLock($room)
{
	global $db, $userdata;
	
	if  ( $userdata["mode"] >= 2 ) {
		$db -> query("SELECT locked FROM chatrooms WHERE name = '".$userdata["room"]."'");
		$test = $db -> fetch();
		if ( $test["locked"] == 1 ) {
			$db -> query("UPDATE chatrooms SET locked = '0' WHERE name = '".$userdata["room"]."'");
			chat_message(translate("This room has been unlocked by ").$userdata["nick"],"", $userdata["room"]);
		} else {
			chat_message(translate("This room is not locked!"), $userdata["nick"]);
		}
		
	} else {
		chat_message(translate("You don't have the permissions to unlock the room!"), $userdata["nick"]);
	}
}

/**
 * Sets moderation flag ( only voice and op may talk now )
 */
function chat_Moderate()
{
	global $db, $userdata;
	
	if ( $userdata["mode"] >= 2 ) {
		$db -> query("SELECT moderate FROM chatrooms WHERE name = '".$userdata["room"]."'");
		$test = $db -> fetch();
		if ( $test["moderate"] == 0 ) {
			$db -> query ("UPDATE chatrooms SET moderate = '1' WHERE name = '".$userdata["room"]."'");
			chat_message($userdata["nick"]." ".translate("sets the moderation flag")."!", "", $userdata["room"]);
		} else {
			chat_message(translate("This room is already moderated"), $userdata["nick"] );
		}
	} else {
		chat_message(translate("Youn dont' have the permissions to change to moderation!"), $userdata["nick"]);
	}
}

/**
 * removes moderation flag
 */
function chat_UnModerate()
{
	global $db, $userdata;
	
	if ( $userdata["mode"] >= 2 ) {
		$db -> query("SELECT moderate FROM chatrooms WHERE name = '".$userdata["room"]."'");
		$test = $db -> fetch();
		if ( $test["moderate"] == 1 ) {
			$db -> query ("UPDATE chatrooms SET moderate = '0' WHERE name = '".$userdata["room"]."'");
			chat_message($userdata["nick"]." ".translate("removes the moderation flag")."!", "", $userdata["room"]);
		} else {
			chat_message(translate("This room is not moderated"), $userdata["nick"] );
		}
	} else {
		chat_message(translate("Youn dont' have the permissions to rempve the moderation flag!"), $userdata["nick"]);
	}
}


/**
 * Ban user/host/ip
 */
 
function chat_Ban ( $type, $value, $reason= "" ) {
	global $userdata, $db;
	
	if ( $userdata["mode"] >= 2 ) {
		switch ( $type ) {
			case "user":
				$db -> query("SELECT count(*) as c FROM chatusers WHERE nick = '$value'");
				$count = $db -> fetch();
				if ( $count["c"] > 0 ) {
					$db -> query ("INSERT INTO bans (type, value, reason) VALUES ('$type','$value','$reason')");
					
					if ( !empty ( $reason ) && $reason != "  " ) {
						$msg = translate("reason").": ".$reason;
					}
					chat_message(translate("User")." $value ".translate("has been banned by")." ".$userdata["nick"].". ".$msg, "", $userdata["room"]);
					
				} else {
					chat_message(translate("No such user").": ".$value, $userdata["nick"]);
				}
				break;
			case "ip":
				if ( ereg("([0-9]{1,3})\.([0-9]{1,3})\.([0-9){1,3})\.([0-9]{1,3})", $value ) ) {
					$db -> query ("INSERT INTO bans (type, value, reason) VALUES ('$type','$value','$reason')");					
					if ( !empty ( $reason ) && $reason != "  " ) {
						$msg = translate("reason").": ".$reason;
					}	
					chat_message($userdata["nick"]." ".translate("sets ban on")." $value ".$msg, "", $userdata["room"]);
				} else {
					chat_message(translate("Invalid IP!"), $userdata["nick"]);
				}
				break;
			case "host":
				$db -> query ("INSERT INTO bans (type, value, reason) VALUES ('$type','$value','$reason')");					
				if ( !empty ( $reason ) && $reason != "  " ) {
					$msg = translate("reason").": ".$reason;
				}	
				chat_message($userdata["nick"]." ".translate("sets ban on")." $value ".$msg, "", $userdata["room"]);
				break;
			default:
				chat_message(translate("No such ban type"), $userdata["nick"]);
			
		}
	} else {
		chat_message(translate("You don't have the permisson to ban!"), $userdata["nick"]);
	}
}

/**
 * Remove the ban with id $id
 */
function chat_unBan ( $id ) {
	global $userdata, $db;
	
	if ( $userdata["mode"] >= 2 ) {
		$db -> query ( "SELECT count(*) as c FROM bans WHERE id = '".$id."'");
		$data = $db -> fetch();
		if ( $data["c"] > 0 ) {
			$db -> query ("DELETE FROM bans WHERE id = '".$id."'");
			chat_message(translate("Removed ban"), $userdata["nick"]);
		} else {
			chat_message(translate("No such ban").": $id", $userdata["nick"]);
		}
	} else {
		chat_message(translate("You don't have the permussion to unban!"), $userdata["nick"]);
	}
}

/**
 * Displays all Bans !
 */
function chat_BanList ( ) {
	global $userdata, $db;
	
	$db -> query ("SELECT * FROM bans ORDER BY id");
	$list = "";
	while ( $bans = $db -> fetch() ) {
		
		$list .= $bans["id"].": ".$bans["value"]." (".$bans["reason"]." )<br />";
	}
	if ( !empty($list) ) {
		chat_message(translate("Bans").":<br />".$list, $userdata["nick"]);
	} else {
		chat_message(translate("There are no Bans currently"), $userdata["nick"]);
	}
	
}

/**
 * Displays user info's
 */
function chat_Whois ( $user ) {
	global $userdata, $db;
	
	$db -> query ("SELECT * FROM chatusers WHERE nick = '$user'");
	$data = $db -> fetch();
	if ( !empty ( $data ) ) {
		
		$ret = "<b>".translate("Information about")." ".$user.": <br />";
		$ret .= translate("Name").": ".$data["name"]."<br />";
		$ret .= translate("Mail").": ".str_replace("@", " at ", str_replace ("."," dot ", $data["email"])  )."<br />";
		
		if ( $userdata["mode"] >= 2 ) {
			$ret .= "Last IP: ".$data["lastip"]."<br />";
			$ret .= "Last host: ".$data["lasthost"]."<br />";
		}
		$ret .= "</b>";
		
		chat_message($ret, $userdata["nick"]);
		
			
	} else {
		chat_message(translate("No such user: ").$user, $userdata["nick"]);
	}
}

/**
 * Displays when and where user was last active
 */
function chat_Seen ( $user ) {
	global $db, $userdata;
	
	$db -> query("SELECT * FROM chatusers WHERE nick = '$user'");
	$data = $db -> fetch();
	if ( !empty ( $data ) ) {
		$ret = $user." ".translate("was last seen on")." ".date("Y-m-d H:i:s", $data["lastaction"])." ".translate("at")." ".$data["room"];
		chat_message($ret, $userdata["nick"]);
		
	} else {
		chat_message(translate("No such user: ").$user, $userdata["nick"]);
	}
}


/**
 * Changes Password for user
 */
 
function chat_ChangePass ( $newpass ) {
	global $db, $userdata;
	
	$db -> query("UPDATE chatusers SET pass = '$newpass' WHERE nick ='".$userdata["nick"]."'");
	chat_message(translate("Your password has been changed"), $userdata["nick"]);
}

/**
 * Broadcast Message
 */
 
function chat_BroadCast($message) {
	global $db, $userdata;
	
	if ( $userdata["mode"] >= 2 ) {
		chat_message("<b>".translate("Info to ALL chatters:")." ".$message."</b>","","");
	} else {
		chat_message(translate("No permission"),$userdata["nick"]);
	}
}
/**
 *
 * SPECIFIC COMMANDS FOR THE CHATSERVER! DO NOT TOUCH THEM!
 *
 */
 
 
/**
 *
 * function chat_configReload();
 *
 * Forces the Chatserver, to reload its config.
 *
 */
 
 function chat_Configreload() {
 	global $userdata;
 	if ($userdata[mode] >= 9 && getConfig("CmdLineServer") == "true") {
 		chat_message("CONFIGRELOAD", "CHATSERVERMESSAGE",crypt(getConfig("SecretKey")),true);
 		chat_message(translate("Configuration reloaded"), $userdata["nick"]);
 		
 	} else {
 		chat_message(translate("No permission"), $userdata[nick]);
 	}
 	
 }

/**
 *
 * function chat_log();
 *
 * Enables / Disables the logging.
 *
 */

 function chat_log($state) {
	global $userdata;
	if ( $userdata[mode] >= 9 && getConfig("CmdLineServer") == "true" )  {
		if($state) {
			chat_message("LOG_ON", "CHATSERVERMESSAGE",crypt(getConfig("SecretKey")),true);
			chat_message(translate("logging enabled"), $userdata["nick"]);
		} else {
			chat_message("LOG_OFF", "CHATSERVERMESSAGE",crypt(getConfig("SecretKey")),true);
			chat_message(translate("logging disabled"), $userdata["nick"]);
		}
	}
}

?>
