#!/usr/bin/perl

# $Id: webcastd.pl,v 1.6 1999/06/20 15:47:23 maffew Exp $

# webcastd.pl

# perl daemon to manage updates to the webcast site

# - checks to see if files have been mirrored, and sets mirror
#   flag accordingly, if there are any changes in status, forces a refresh of th
#   front page using wget

use DBI;
use LWP::Simple;

# this should be fished out of webcast-setup.php3, but i don't have time
# to code it
$mirror_url = "http://reflect.physics.usyd.edu.au/maff/j18/";

# flush after every print so we can follow what's happening in a logfile
$| = 1;

$dbh = DBI->connect("dbi:Pg:dbname=active","","");

if (-e "debug") {
  $table_name = "webcastdebug";
} else {
  $table_name = "webcast";
}

if ( !defined $dbh ) {
    die "Cannot do \$dbh->connect: $DBI::errstr\n";
}

$i = 0;

# loop indefinitely
while (1) {
  # if anything happens that means we need to regenerate the front page
  # then we set the refresh flag
  $refresh = false;

  # stamp the logs every five minutes
  if ($i % 5 == 0) {
        print localtime() 
          . " -- still alive :) --\n";
  }

  $sth = $dbh->prepare("update $table_name set display=true where display ISNULL;");
  if (!defined $sth) {
    die "Cannot prepare select statement\n";
  }
  $sth->execute;

  $sth = $dbh->prepare("update $table_name set mirrored=false where mirrored ISNULL;");
  if (!defined $sth) {
    die "Cannot prepare select statement\n";
  }
  $sth->execute;

  $sth = $dbh->prepare("select id,linked_file,mime_type from $table_name where mirrored=false;");
  if (!defined $sth) {
    die "Cannot prepare select statement\n";
  }
  $sth->execute;

  while(($id, $linked_file, $mime_type) 
          = $sth->fetchrow() ) {

    # strip trailing whitespace
    $linked_file =~ s/\s//g;
    $mime_type =~ s/\s//g;

    # only check mime types that we are using the mirror for
    if ($mime_type eq "audio/mpeg" 
          || $mime_type eq "audio/x-pn-realaudio" 
          || $mime_type eq "video/x-pn-realvideo" 
#          || $mime_type eq "image/gif" 
          ) {
      $size = (-s $linked_file);

      $basename = $linked_file;
      $basename =~ m{/([^/]*$)};
      $basename = $1; 

      $url = $mirror_url . $basename;

      ($content_type, $document_length, $modified_time, $expires, $server) 
        = head($url);

      if ($document_length != $size) {
        print localtime() 
          . " NOT MIRRORED $id $basename $size $document_length\n";
      } else {
        print localtime() 
          . " JUST MIRRORED $id $basename $size $document_length\n";
        $refresh = true;
        $stupdateh = $dbh->prepare("update $table_name set mirrored=true where id=$id;");
        if (!defined $stupdateh) {
          die "Cannot prepare select statement\n";
        }
        $stupdateh->execute;
      }
    }
  }

  # if ($refresh) {
    # update the pages every time because we don't have hooks
    # to refresh in the add / edit code yet
    system("wget -nv http://j18.cat.org.au/refresh.php3 -O dump.txt >> /www/active/dev/webcast-wget-log");
  # }
  
  sleep 300;
  $i++
}
