<?php
header('CacheControl="No-Cache"');
# Mandatory WAP headers:
header('Content-type: text/vnd.wap.wml'); 
echo "<?xml version=\"1.0\"?>\n";
echo "<!DOCTYPE wml PUBLIC \"-//WAPFORUM//DTD WML 1.1//EN\" \"http://www.wapforum.org/DTD/wml_1.1.xml\">";

# We need to keep these pages really tight. Even if they validate,
# many browsers can't handle over 1400 bytes.
# WAP devices are VERY picky about tag closure and even case (FWICT)
# Use the validator at http://www.stg.brown.edu/pub/xmlvalid/
# until there are no errors, only warnings.
# Questions? Get on the webcoders list and ask Bonnie.

include("../local/webcast/webcast.inc");
include("../local/webcast/webcast-setup.php3");
include("../local/db-setup.php3");
include("cast_class.inc");

$static_dir = "../local/include";

?>

<?php

# First stage is just for setting up.
# Current modes are 'static,' 'menu,' and 'article.'
# 'Article' will be broken up into 'summary' and 'article' next.

if (strlen(chop($static)) != 0) {

 # just a static page, no need to check DB
 $mode = "static";
 if (($static == 'wap_cities') ||
     ($static == 'wap_about') ||
     ($static == 'wap_menu')) {
   $title = $static;
  } else {
  $msg = "don't know about that static page--check your link";
  }

} else {

$title = $appear["WAP_title"];
# Connect to the database
  $conn = pg_connect("user=".$db_setup["user"]." password=".$db_setup["password"] ." dbname=".$db_setup["database"]);
  if (!$conn) {
        $msg = "An error occured while accessing database. ";
  }

  # Sort out the modes: list vs. summary vs. article (in chunks)
  if (strlen(chop($article_id)) != 0) {
    $mode = "article";
    $article_id=chop($article_id);
    $page_gen_max = 1;
  
  # get one if article only
  $query = "select id, linked_file, date_entered, author, summary, heading, mime_type from webcast where (id='$article_id')";

  } else {

  # need to skip comments in article list

  $query = "select id, linked_file, date_entered, author,heading,mime_type from webcast where (mime_type like '%$medium%' and display='t') and (summary ~* '.*$keyword".".*' or article ~* '.*$keyword".".*' or heading ~* '.*$keyword".".*' or author ~* '.*$keyword".".*') and (date_entered ~* '.*$day".".*') and  (parent_id='0') ORDER BY created DESC";
  $mode = "menu";

  }

$result = pg_Exec($conn, $query);

$limit=5;
$numrows = pg_NumRows($result);

if (empty($page)) {
    $page= 0;
}

if (!$result) {
        $msg .= "No search results\n";
}

if ($numrows == 0) {
        $msg .= "Zero search results\n";
}


} # end of 'types' setup

# Second stage: generate the WAP page:
?>
<wml>
<card id="<?php echo $title ?>" newcontext="true">
<?php include("$static_dir/wap_menu.inc"); ?>
<?php
    if ($msg) {
      echo "<p align=\"center\">";
      echo "$msg";
      echo "</p>";
      }
?>
<?php

switch ($mode) {
  case "menu":
# default is to display a list of current articles:
   echo "<p align=\"center\"><strong>" . $appear["WAP_title"] . "</strong></p>";
   echo "<p align=\"left\">";
   echo "<select>";

   $rows=$numrows;
   $page_length=10;
   $page_total = ceil( (float) $rows/ (float) $page_length);

   $page_gen_max = $page + 1;
   $page_gen_start = $page;

   for ($page_gen = $page_gen_start; $page_gen < $page_gen_max; $page_gen++) {
     $cell_counter=0;

     $first = $page_gen * $page_length;
     $last = $first + $page_length - 1;

     if ($rows > $last+1) {
       $limit = $page_length;
     } else {
       $limit = $rows - $first;
     }

    for ($cell_counter=0; $cell_counter<$limit; $cell_counter++) {
    $row = pg_fetch_array($result, $cell_counter + $first);
    $id = $row["id"];
    echo "<option onpick=\"$PHP_SELF?article_id=$id\" title=\"OK\">";
    echo chop($row["heading"]);
    $mime_type = chop($row["mime_type"]);
    echo " ($mime_type)</option>\n";
    # echo " (";
    # echo chop($row["date_entered"]);
    # echo "</option>\n";
    # echo ")</option>\n";

} # end of first for loop

if ($page_gen > 0) {
    $page_=$page_gen-1;
    echo  "<option onpick=\"$PHP_SELF?page=$page_\">previous page</option>\n";
}

if ($rows > $last + 1) {
    $page_=$page_gen+1;
    echo  "<option onpick=\"$PHP_SELF?page=$page_\">next page</option>\n";
}


# only go through for loop once
} # end outer for loop

        echo "</select>";

  break;
  case "article":

# Only show a single article....

    $row = pg_fetch_array($result, $first);
    $id = $row["id"];
    $heading = $row["heading"];
    $mime_type = $row["mime_type"];
    $summary = $row["summary"];
    $date_entered = chop($row["date_entered"]);
    $author = chop($row["author"]);
    $linked_file = $row["linked_file"];

  echo "
<p align=\"left\">$heading by $author<br/>uploaded $date_entered</p>
<p align=\"left\">$summary</p>
";

# Next Steps: set up to handle displaying the full articles as best we can
if ((chop($mime_type) == 'text/plain') ||
   (chop($mime_type) == 'text/html')) {
 echo "<p align=\"left\">Need to display full article $linked_file ($id) by chunks";
} else {

   if ((chop($mime_type) == 'image/jpeg') ||
      (chop($mime_type) == 'image/gif')) {
	echo "<p align=\"left\">Need to convert to wbmp<br/>In the meantime, ";
	}
   echo "uploaded file is /front.php3?article_id=$id ($mime_type)";
}

  break;

case "static": 
  # right now, leave off the final </p> in the static pages: will be fixed
  include("$static_dir/$static.inc") ;
  break;

  }

# closing tags:
?></p></card></wml>
