<?
header("Content-Type: text/plain");

#$Id: syndicate.php3,v 1.2 2001/04/05 11:37:02 andy Exp $
#much setup routines cut and paste from display.php3
#this page by jrochkin@cs.oberlin.edu (Jonathan Rochkind)

# NOTE WELL: This is currently really crude. So it may change at any time to be
# better. It's being used by me, Jonathan Rochkind, to syndicate content
# to DAMN. If anyone else wants to use it to syndicate to some other site,
# please don't do so without talking to me. Or else you may find the format
# changes underneath you and you get messed up. 

# This does two main things: 
#  1. give a list of content created since certain date in computer readable
#     format
#  2. given an article id, supply that content in computer readable format

# TO DO: supply info in XML, instead of delimited.
#        supply related content/links for articles


include("../local/webcast/webcast-setup.php3");
include("../local/webcast/webcast.inc");
include("cast_class.inc");

if (! $db_class_php3) {
  include("../shared/db_class.php3");
}

$db_obj = new DBClass();
	       
if (file_exists("debug")) {
  $data = array (
	       "article_id" => $article_id,
	       "table_name" => "webcastdebug",
	       "seq_name" => "webcastdebugid"
	       );
} else {
  $data = array (
	       "article_id" => $article_id,
	       "table_name" => "webcast",
	       "seq_name" => "webcastid"
	       );
}


#BEGIN REAL CODE
//default function
if (! isset($function)) {
	$function = 'listSinceTimestamp';
}

	$fielddelimit = '<FIELDDELIMIT>';
	$recorddelimit = '<RECORDDELIMIT>'; 

	function ourTimestampToPostgres($ourDateFormat) {
		$dateArray = explode("-", $ourDateFormat);
		#sign of timezone is assume positive, unless it's preceded by 'neg'.
		if (substr($dateArray[6], 0, 3) == "neg") {
		   $dateArray[6] = substr($dateArray[6], 3, strlen($dateArray[6])+1);
		   $tzsign = "-";
		}
		else {
		   $tzsign = "+";	   
		}
		
		$postGresTimestamp = $dateArray[2] . '-' . $dateArray[1] . '-' . $dateArray[0] . ' ' . $dateArray[3] . ':' . $dateArray[4] . ':' . $dateArray[5] . $tzsign . $dateArray[6];
		return $postGresTimestamp;
	
	}
	function postgresToOurTimestamp($postgresTimestamp) {
		$year = substr($postgresTimestamp, 0, 4);
		$month = substr($postgresTimestamp, 5, 2);
		$date = substr($postgresTimestamp, 8, 2);
		$hour = substr($postgresTimestamp, 11, 2);
		$minute = substr($postgresTimestamp, 14, 2);
		$seconds = substr($postgresTimestamp, 17, 2);
		$tz = substr($postgresTimestamp, 19, 3);
		
		if (substr($tz, 0, 1) == '+') {
			$tz = substr($tz, 1, 2);
		}
		else {
			$tz = 'neg' . substr($tz, 1, 2);
		}
	
		return $date . '-' . $month . '-' . $year . '-' . $hour . '-' . $minute . '-' . $seconds . '-' . $tz;	
	}


switch($function) {


	case 'listSinceTimestamp':		

		
		
		#First take the passed in date parameter and format it for postgres
		#We'll get it in format dd-mm-yy-hh-mm-ss-tz
		# date, month, year, hour, minute, second, positive timezone offset from gmt
		
		if (! isset($sinceTimestamp)) {
		  #set it to be really old
		  $sinceTimestamp = "01-01-1990-00-00-00-00";
		}
		
		$postGresTimestamp = ourTimestampToPostgres($sinceTimestamp);
		
		
		#Add this key into our data, so the select routine knows we
		#want a list of articles created since when?
		
		$data[created_since] = $postGresTimestamp;
		
		$currentTimeStamp = gmdate("d-m-Y-H-i-s-00");
		list ($result_index, $rows) = $db_obj->execute("selecting", "summariesSinceDate", $data);
		
		#OUTPUT

		 
		echo "Date: $currentTimeStamp\n";
		echo "Function: $function $sinceTimestamp\n";
		echo "Count: $rows\n";
		
		echo "\n";
		
		
		 for($i = 0; $i < $rows; $i++) {
		 	$item = pg_fetch_array($result_index, $i);
		 
		 	echo $recorddelimit;
		 
		 	echo $item[id], $fielddelimit;
		 	echo postgresToOurTimestamp($item[created]), $fielddelimit;
		 	echo trim($item[mime_type]), $fielddelimit;
		 	echo trim($item[heading]), $fielddelimit;
		 	echo trim($item[summary]), $fielddelimit;
		 	echo trim($item[link]);
		 	//echo "\n"; 
		 }
	break;
	
	case 'fetchArticle':
		$data[article_id] = $article_id;
		list ($result_index, $rows) = $db_obj->execute("selecting", "editing", $data);
				
				
		$currentTimeStamp = gmdate("d-m-Y-H-i-s-00");
		
		echo "Date: $currentTimeStamp\n";
		echo "Function: $function $article_id\n";
		if ($rows == 0) {
			echo "Error: No such article_id $article_id\n";
		}
		else {			
			$article = pg_fetch_array($result_index, $i);				
					
			if (substr($article[mime_type], 0, 4) != 'text') {
				echo "Error: Syndication for non-text articles (". trim($article[mime_type]).") not currently supported.";
			}
			else {	
				echo "\n";					
				
				//add code to get long text too!
				$text = $article[article];
				
				echo $recorddelimit;
				echo $article[id], $fielddelimit;
				echo postgresToOurTimestamp($article[created]), $fielddelimit;
				echo postgresToOurTimestamp($article[modified]), $fielddelimit;
				echo trim($article[mime_type]), $fielddelimit;
				echo trim($article[heading]), $fielddelimit;
				echo trim($article[author]), $fielddelimit;
				echo trim($article[summary]), $fielddelimit;
				echo trim($article[link]), $fielddelimit;
				if (trim($article[html_file]) != "") {
					#long file, stored in filesystem
					readfile(trim($article[html_file]));
				}
				else {
					#short file, stored in db
					echo $text;
				}	
			}
		}
	break;

}
$db_obj->try_close();

?>
