<?php

# $Id: summary_list.inc,v 1.18 2001/06/21 07:10:19 andy Exp $

  include("../local/db-setup.php3");
  include("../local/webcast/webcast-setup.php3");
  include("../local/webcast/webcast.inc");

  function summary_list($number_to_show) {
    return summary_list_html($number_to_show);
  }
    
  function summary_list_html($number_to_show) {
    global $appear;
   
    $result = summary_list_db($number_to_show);
    
    if (!$result) {
       $str .=  "An error occured while accessing database. ";
       $str .=  "Please send a notification to webmaster@";
       $str .=  "indymedia.org";
       exit;
    }

    $cols = pg_NumFields($result);
    $rows = pg_NumRows($result);

    # added heading - manse 04-13-00  
    # $str .= "<font size=-2>LATEST NEWS</font>";
    # $str .= "<font size=-1><br>";
  
    for ($i=0; $i<min($rows, (int) $number_to_show); $i++) {
      $row = pg_fetch_array($result, $i);
      $id = $row["id"];
      
      #figure out thumb link if displaying pictures
   
   
      if ($medium == "image") {
      	 $upload_folder = "/uploads/";
    	 $filenamebase = basename(chop($row["linked_file"]));
    	 $filename  = $upload_folder . $filenamebase;
    
    	 eregi("([a-zA-Z0-9/\._-]+)\.([a-zA-Z0-9]+)$",$filename,$regs);
    
    	 $filename_thumb = $regs[1] . "-thumb." . $regs[2];
    	 $str     .= "<p><img src=\"$filename_thumb\">";
      }

      # break down the pgsql timestamp into year, month, etc.
      ereg("([0-9]{4})-([0-9]{2})-([0-9]{2}) ([0-9]{2}):([0-9]{2}):([0-9]{2})",
       	   $row[created], $date_array);
      $timestamp = mktime($date_array[4], $date_array[5], $date_array[6], 
      $date_array[2], $date_array[3], $date_array[1]);

      $timestamp += 60*60*$appear["time_difference"];

      if ($appear["threeletterdate"]) {
      	 $month_letter = substr(date("M", $timestamp),0,3) . " ";
      } else {
      	$month_letter = substr(date("M", $timestamp),0,1);
      }

      $nice_time = $month_letter . date("j g:ia", $timestamp);
      #putenv("TZ=$saveTZ");

      $str .= "<p>\n";
    
      ##################################################################
      # This code adds icons to the summary list. the icons are currently
      # being served from the PRAGUE directory- this should be changed, but
      # as of this moment, there is no push to loudeye from the icons folder
      # on www/mayday/local/icons


      $mymime = $row[mime_type];
      $filename_photo = "../local/images/photo.gif";
      $filename_video = "../local/images/video.gif";
      $filename_audio = "../local/images/audio.gif";
      $filename_article = "../local/images/news.gif";
      $filename_doc   = "../local/images/doc_icon.gif";
      $filename_pdf   = "../local/images/pdficon.gif";

      $sizes_p = GetImageSize($filename_photo);
      $sizes_v = GetImageSize($filename_video);
      $sizes_a = GetImageSize($filename_audio);
      $sizes_art = GetImageSize($filename_article);
      $sizes_doc = GetImageSize($filename_doc);
      $sizes_pdf = GetImageSize($filename_pdf);


      if ((strstr($mymime,"image/jpeg")) || (strstr($mymime,"image/gif"))
      || (strstr($mymime, "image/png")) || (strstr($mymime, "image/tiff")) )			
      {
      	 $str.= "<IMG SRC=\"$filename_photo\" ALT=\"photo\" $sizes_p[3] BORDER=\"0\">  ";
      }
      elseif (strstr($mymime,"video/x-pn-realvideo"))			
      {
 	 $str.= "<IMG SRC=\"$filename_video\" ALT=\"video\" $sizes_v[3] BORDER=\"0\">  ";
      }
      elseif ((strstr($mymime,"audio/x-pn-realaudio")) || (strstr($mymime, "audio/mp3")))			
      {
	 $str.= "<IMG SRC=\"$filename_audio\" ALT=\"audio\" $sizes_a[3] BORDER=\"0\">  ";
      }
      elseif (strstr($mymime,"audio/mpeg"))			
      {
 	 $str.= "<IMG SRC=\"$filename_audio\" ALT=\"audio\" $sizes_a[3] BORDER=\"0\">  ";
      }
      elseif (    (strstr($mymime, "text/plain")) 
      	       || (strstr($mymime, "text/html")) 
	       || (strstr($mymime, "text/x-url")) ) {
	$str .= "<IMG SRC=\"$filename_article\" ALT=\"article\" $sizes_art[3] BORDER=\"0\">";
      } elseif (strstr($mymime, "application/msword")) {
        $str .= "<IMG SRC=\"$filename_doc\" ALT=\"document\" $sizes_doc[3] BORDER=\"0\">";
    #  } elseif (strstr($mymime, "application/pdf")) {
      } elseif (substr_count($mymime, "application/pdf")==1 ) {
	$str .= "<IMG SRC=\"$filename_pdf\" ALT=\"document\" $sizes_pdf[3] BORDER=\"0\">";
      }
   
   
      $group = $row["arttype"];
      $str  .= "<a href=\"front.php3?article_id=$id&group=$group\">";
      $str  .= "$row[heading]";
      $str  .= "</a>\n";
      $str  .= "<font size=-1><i>$nice_time</i></font>\n";
   
    }

    $str .= "<p>";
    return $str;

  }

  
  function summary_list_xml($number_to_show) {
     global $server_base_url;
     
     if (! $server_base_url ) {
         $server_base_url =  "http://" . getenv("HTTP_HOST") . dirname(getenv("SCRIPT_NAME"));                 
     }
     $img_url = "http://" . getenv("HTTP_HOST") . '/local/images/imclogo.gif';
     $title = getenv("HTTP_HOST");

     summary_list_db($number_to_show);
     

  # rss 0.9 was rdf based (having an rdf:RDF root node)
  # rss 0.91 is more simple, being just yer basic xml (with an rss root node)
  # rss 1.0 gets back to some amount of rdf elements again
  #
  # however, as of now, rss 0.91 is by far the most widely used/supported
  # so im gonna make it rss 0.91 compliant
  
  # in actual point of fact rss has become a great big mess
  # You have, on the one hand, the 'keep it simple, RDF sucks'
  # crowd, who is basically Dave Wine (of userland fame) - their philosphy defines
  # 0.91, 0.92, and (now) 0.93
  # OTOH you have the RDF happy people who defined RSS 0.9 and (now) RSS1.0
  # Good article about it all here..
  # http://www.webreference.com/authoring/languages/xml/rss/1/
  # Personally I think that RDF sucks too, so heres my 
  # take on what we should do : Start by commenting this out:
  # <rdf:RDF xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
  #  xmlns="http://my.netscape.com/rdf/simple/0.9/">
  # 
  # now all we needis an rss 0.91 dtd declaration and some
  # changes to get it compliant to that dtd
  #  - <channel> needs to contain the <item>s, so moved closing <channel> to bottom
  #  - <rss version="0.91"> tag, with version, required around <channel> (instad of <rdf:RDF>)
  #  - <mime> not supported in 0.91 or 1.0 so, commenting that out for now
  #  - new <description> element now supported, so adding that..
  # ... miles 20/june/2001

$xml_str = '<?xml version="1.0" encoding="iso-8859-1"?> 
<!DOCTYPE rss PUBLIC "-//Netscape Communications//DTD RSS 0.91//EN"
  "http://my.netscape.com/publish/formats/rss-0.91.dtd">
<rss version="0.91">
<channel>
<title>' . $title .' newswire </title>
<link>' . $server_base_url . '</link>
<description>Indymedia is a collective of independent media organizations and hundreds 
   of journalists offering grassroots, non-corporate coverage. Indymedia
   is a democratic media outlet for the creation of radical, accurate,
   and passionate tellings of truth.
</description>
<image>
	<link>' . $server_base_url . '</link>
	<title>' . $title .' current news </title>
	<url>' . $img_url . '</url>
	<description> logo picture </description>
</image>
<language>en-us</language>
';


     
     $result = summary_list_db($number_to_show);
     
     if (!$result) {
        #is there a good error handleing system for php?
        return ($xml_str);
     }
     
     
     $cols = pg_NumFields($result);
     $rows = pg_NumRows($result);

     for ($i=0; $i<min($rows, (int) $number_to_show); $i++) {
       $row = pg_fetch_array($result, $i);
       $id = $row["id"];
           
        $description = trim($row[summary]);
        if (strlen($description)>150) {
                $description = substr($description,0,147) . '...';
        }

        $xml_str .= 
'<item>
       <title>' . trim($row[heading])  . ' </title>
       <link>'  . trim($server_base_url) . '?article_id=' . $row["id"] . '</link>
       <description>'  . $description  . ' - ' . $title . '</description>
</item>
';
     }
     $xml_str .= '</channel></rss>';
     return $xml_str;
  
  
  }


  function summary_list_db($number_to_show)  {
     global $appear ;
     include("../local/db-setup.php3");
  
     $db_connect = "user=".$db_setup["user"]." password="
     		  . $db_setup["password"]." dbname=".$db_setup["database"];
     $conn = pg_pconnect($db_connect);   

     if (!$conn) {
     	echo "An error occured while accessing database. ";
   	echo "Please send a notification to " . $appear["admin_email"];
   	exit;
     }

     if ($medium == "all") {   $medium = "";   }

     if ($day == "any") {  $day = "";  }

     $query = "select id, linked_file, date_entered, author,heading,summary,mime_type,created,arttype from webcast where (mime_type like '%$medium%' and display='t') and (date_entered ~* '.*$day".".*') and (parent_id = 0) order by created desc limit $number_to_show";

     $result = pg_Exec($conn, $query);
     return $result;
  }



?>





