<?php

# $Id: search-process.php3,v 1.28 2001/03/05 03:19:18 andy Exp $

include("../local/webcast/webcast.inc");
include("../local/webcast/webcast-setup.php3");
include("../local/db-setup.php3");
include("cast_class.inc");
$output = top("search indymedia archives");
echo $output;

#include the searching form.
include("searchform.inc");

if (strlen(chop($medium))==0) {
	$medium="all";
}
if (strlen(chop($day))==0) {
	$day="any";
}

if (empty($page)) {
    $page= 0;
}

if (strlen(chop($group))==0) {
	$group = "webcast";
} else {
	$group=chop($group);
}

$conn = pg_connect("user=".$db_setup["user"]." password=".$db_setup["password"] ." dbname=".$db_setup["database"]);

if (!$conn) {
	echo "An error occured while accessing database. ";
	echo "Please send a notification to webmaster@";
	echo "indymedia.org";
	echo bottom();
	exit;
} 

$base_query = "select webcast.id, webcast.linked_file, webcast.date_entered, webcast.author, webcast.heading, webcast.mime_type, webcast.created, webcast.arttype, webcast.parent_id, webcast.mirrored from webcast "; 

$where_clause = " where webcast.display = 't' and webcast.arttype = '".$group."' ";

if ($medium != "all") {
	$where_clause .= " and webcast.mime_type like '%$medium%' ";
	}

if ($day != "any") {
	$where_clause .= " and webcast.date_entered ~* '.*$day".".*' ";
	}

if (strlen(chop($keyword))!=0) { 	
        $where_clause .= " and (webcast.summary ~* '.*$keyword".".*' or webcast.article ~* '.*$keyword".".*' or webcast.heading ~* '.*$keyword".".*' or webcast.author ~* '.*$keyword".".*') ";
       }

$page_length=25;
#limit the query to 30 , offset by the page number * 30. 
$offset_calc = $page * $page_length;
$total_query = $base_query . $where_clause . " order by webcast.created desc limit ".$page_length." offset " . $offset_calc ." ;"; 

#echo "doing $total_query<br>";
#echo "keyword is $keyword<br>";
$result = pg_Exec($conn, $total_query);
if (!$result) {
        echo "An error occured while accessing database. ";
        echo "Please send a notification to webcoders@cat.org.au";
        echo "(please copy the error messages you get into the email)";
	echo bottom();
        exit;
}

$count_query = "select count(id) from webcast " . $where_clause . ";";
#echo "doing $count_query<br>";
$result_count = pg_Exec($conn, $count_query);

if (!$result_count) {
        echo "An error occured while accessing database. ";
        echo "Please send a notification to webcoders@cat.org.au";
        echo "(please copy the error messages you get into the email)";
	echo bottom();
        exit;
}

$obj = pg_fetch_object($result_count,0);
#calculate how many articles altogether;
$numrows = $obj->count;

#echo "$numrows articles!";

// in case we don't have any stories
if ($numrows == 0) {
?>

<table width=500>
<tr><td>
<font face=arial>
<b>
No articles found </b><p>
</font>
</td></tr>
</table>

<?php

#there are articles in the db that match the search criteria so do some fancy footwork...
} else {

$page_total = ceil( (float) $numrows/ (float) $page_length);

$cell_counter=0;

#rows var. is the actual number of articles returned by the sql above
$rows = pg_NumRows($result);
if ($rows < $page_length) {
   $limit = $rows;
} else {
   $limit = $page_length;
}

# say which page we are on, and which group..
echo "<p>(page " . ($page+1) . " of " . $page_total . ", in group <b>$group</b>)<p>";
    
echo "<table bgcolor=white border=1 cellspacing=0 width=\"100%\">";
echo "<tr><td><b>Article heading and author</b></td><td><b>Date posted</b></td><td><b>Type of article</b></td></tr>";

for ($cell_counter=0; $cell_counter<$limit; $cell_counter++) {
    echo "<tr bgcolor=white><td>";
    $row = pg_fetch_array($result, $cell_counter);
    $id = $row["id"];
    if ($row["parent_id"] == 0) {
	$id_to_use = $id;
    } else {
	$id_to_use = $row["parent_id"];
    } 
    echo "<a href=\"front.php3?article_id=$id_to_use\">";

    #figure out thumb link if displaying pictures
    #redirected to loudeye by manse

	$filename = chop($row["linked_file"]);
	eregi("([a-zA-Z0-9/\._-]+)\.([a-zA-Z0-9]+)$",$filename,$regs);
	
	#dont always have a thumb nail!
	$filename_thumb = $regs[1] . "-thumb." . $regs[2];
	$filename_nothumb = $regs[1] . "." .  $regs[2];

        $filedirname = dirname( $filename_thumb );
        $filenamebase = basename( $filename);
        # unless we're using ramgen, change .rm to .ram 
	if ($ramgen != "yes") {
	    $ramfilebase = eregi_replace(".r[avm]$", ".ram", $filenamebase);
	} else {
	    $ramfilebase = $filenamebase;
	}
	$file_url = $upload_url . $filenamebase;
	$filename = $filedirname . "/" . $filenamebase;
        # get image size
	$row["mime_type"] = chop($row["mime_type"]);
	$sizes = "";
	if ($row["mime_type"] == "image/jpeg" || $row["mime_type"] == "image/gif") {
        	if (file_exists($filename_thumb)) {
             	  $sizes = GetImageSize($filename_thumb);
        	} else {
	      	  if (file_exists($filename_nothumb)) {
	        	$sizes = GetImageSize($filename_nothumb);
	          }
        	}
	}
	if ($row["mime_type"] == "audio/x-pn-realaudio" || 
		$row["mime_type"] == "video/x-pn-realvideo")       {
		$f_url=make_realmedia_url($filenamebase,$row["mime_type"],$row["mirrored"]);
         	echo "<br><a href=\"".$f_url."\">"; 	
		echo $f_url . "</a><br>";
	} 
	if ($row["mime_type"] == "image/gif" || 
		$row["mime_type"] == "image/jpeg" ) {
		echo "<br><img src=\"".make_largefile_url($filename_thumb,$row["mime_type"],$row["mirrored"])."\" border=0 " . $sizes[3] . "><br>"; 
	}

    echo chop($row["heading"]);
    echo "</a>  by " . chop($row["author"]);
    if ($row["parent_id"] != 0) { 
	echo " (posted as comment) ";
    }

    echo "</td><td>";

    echo "<font size=-1><i>";
    echo chop($row["date_entered"]);
    echo "</i></font>";

    echo "</td><td>";
    if ($use_mime_urls == 1) {
	echo $mime_url[chop($row["mime_type"])];
    } 
    echo "(".$row["mime_type"].")";

    #if ($medium == 'audio') {
    #   echo '<HR>';	
    #   echo '<A HREF=justmpg.php3>Broadcast Quality MP3 Audio</A>';
    #}
    echo "</td></tr>\n"; 
}
echo "</table>\n";
#do page navigation links.
if ($page > 0 || $page < ($page_total -1)) {
    echo "<p><b>More pages</b><p>";
}
# check to see if not first page
if ($page > 0) {
    $page_=$page-1;
    echo  "<a href=\"$PHP_SELF?medium=$medium&keyword=$keyword&page=$page_\">&lt;&lt; previous page</a> &nbsp; \n";
}

if ($page < $page_total-1) {
    $page_=$page+1;
    echo  " <a href=\"$PHP_SELF?medium=$medium&keyword=$keyword&page=$page_\">next page &gt;&gt;</a> &nbsp; \n";
}

}
#end of else 
echo bottom();

  function make_largefile_url($filename, $mime_type, $mirrored) {
    global $upload_url, $mirror_url, $mirror_mime_types;
  
    	if ($mirrored == "t" && eregi(chop($mime_type), $mirror_mime_types, $regs)) {
        	$filenamebase = basename( $filename );
		$ret = $mirror_url[chop($mime_type)] . $filenamebase;
    	} else {
        	$ret = $filename;
    	}
    	return $ret;
  }

  function make_realmedia_url($filenamebase, $mime_type, $mirrored) {
    global $ramgen, $realmedia_url, $mirror_url, $mirror_mime_types;
  
    # unless we're using ramgen, change .rm to .ram 
    if ($ramgen != "yes") {
      $ramfilebase = eregi_replace(".r[avm]$", ".ram", $filenamebase);
    } else {
      $ramfilebase = $filenamebase;
    }
    
    if ($mirrored == "t" 
      && eregi(chop($mime_type), $mirror_mime_types, $regs)) {
      	$ret = $mirror_url[chop($mime_type)] . $ramfilebase;
    } else {
      	if ($realmedia_url == "none") {
	  $ret = "notmirrored";
	} else {
      	  $ret = $realmedia_url . $ramfilebase;
	}
    }
    return $ret;
  }

?>
