#!/usr/bin/perl

#
# parsing apache mime.type file to build a hash variable...
#

open(FILE, "<mime.types") or die $!;
print "<?php\n";
while(<FILE>) {
	chomp;
	# ignore blank lines and comments
	next if(/^$/ || /^#/);
	# substitute multiple whitespaces to an tab character
	s/\s+/\t/g;
	# split line at tab into array
	my @array = split(/\t/);
	# foreach extension print an hash entry to stdout and ignore mimetypes without extension
	for(my $i = 1; $i <= $#array; ++$i) {
	    $array[0] = lc($array[0]);
	    print qq|\$mimetypelist["$array[$i]"] = "$array[0]";\n|;
	}
}
print "?>";
close FILE;


