<?php 
# $Id: new_data-process.php3,v 1.75 2001/06/30 08:49:33 andy Exp $

# process the user data from a new data form 
# which means: add a row to the database, copy the uploaded file
# into the right place, and create a .ram file if needed for
# realaudio/video

include("../local/webcast/webcast-setup.php3");
include("../local/webcast/webcast.inc");
include("../shared/db_class.php3");
include("../local/mimetypes.inc");
include("new_data-process.inc");

# VARIABLES FROM THE PUBLISH FORM (See publish.php3 and entryform.inc)
#heading/title #author #contact/email #phone #address #summary #link/web address
#article #linked_file #linked_file_name #mime_type #publishtype

#VARIABLES FROM THE COMMENT FORM , not included above, 
#(see cast_class.inc, comment-quick-entryform.inc, comment-entryform.inc)
#top_id/id of the parent article. 


$output = top("publishing a story...", "nocache");
echo $output;

if (strlen(chop($multifiles))==0) {
	$multifiles = 1;
}

if (! is_dir($upload_folder . "metafiles" ) ) {
	echo "<B>Error:  this version of active requires there to be a directory named \"metafiles\" in your upload directory.!";
	echo "<p>Please create " . $upload_folder . "metafiles</B>";
}

echo "<p> Number of files uploaded: $multifiles";

#loop through the uploaded files - check the file names.
for ($i=0;$i<$multifiles;$i++) {
	#compose the variables names, as a string..
	#the variable name of file sent via the browser. (temp. name on our system)
	$filename[$i] = "linked_file_" . $i;
	#var. name of mimetype of file sent via browser. (notice this is
	#the mimetype as determined by browser of user).
        $browser_mimetype[$i] = $filename[$i]."_type";
	#var. name of file sent by browser, filename as on users system.
	$realfilename[$i] = $filename[$i] . "_name";
	#var. name of filesize of temp. file.
	$tmpfilesize[$i] = $filename[$i]."_size";

	#grok them from the global namespace..
	#using their actual value as a "pointer" to an actual variable name...
	#thus assigning them the value their name points to.
        $filename[$i] = $GLOBALS[$filename[$i]];
	$browser_mimetype[$i] = $GLOBALS[$browser_mimetype[$i]];
        $mimetype[$i] = $GLOBALS[$mimetype[$i]];
        $realfilename[$i] = strtolower($GLOBALS[$realfilename[$i]]);
	$tmpfilesize[$i] = $GLOBALS[$tmpfilesize[$i]];

	# determine mimetype
	preg_match("/\w+$/", $realfilename[$i], $matches);
	# debugging
	#echo "<br>RegEx match: $matches[0]<br>mimetype: ". $mimetypelist[$matches[0]] ."<br>";
	if( strlen($mimetypelist[$matches[0]]) > 0) {
		$mimetype[$i] = $mimetypelist[$matches[0]];
	} else {
		if( strlen(chop($browser_mimetype[$i])) > 0 ) {
			$mimetype[$i] = $browser_mimetype[$i];
		} else {
			$mimetype[$i] = "text/plain";
		}
	}
	
	#debugging stuff.
	#echo "<p>" . $filename[$i] . ":" . $browser_mimetype[$i] . ":" . $mimetype[$i] . ":" . $realfilename[$i] . ":" . $tmpfilesize[$i];

	#compose a string of mimes that are uploaded -- for the auto email..
	$mimes .= "<" . $mime_name[$mimetype[$i]] . ">"; 
}

#
# Check the submitted article for publishing has all the required fields.
# (Checks article AND comments)
#

$publish_errors = validate_submission();

#
#deal with any errors from validate_submission.
#
if ( sizeof( $publish_errors ) ) {

	#errors were detected in publishing.. display an error message.

	echo "<font size=+1><center>We've detected error(s) with your submission!<p></center>";
	foreach ( $publish_errors as $error ) {
		echo "$error<br>";
	}
	echo "<p>I haven't added your data. Please press your <b>back</b> button and\n";
	echo "have another stab at it.</font>\n";

} else {
	#
	#else - no errors detected, so keep processing..

        #construct the db object
        $db_obj = new DBClass();

	# Check that the article isnt too large for sending via postgresql tcp/ip
	# inside a sql insert command. (if it is , it will be written to file..
	# and that filename stored in the database for later retrieval..)

	list ($result_long_story, $long_story_filename) = long_story_kludge();
	

	$original_summary = $summary;
	$original_heading = $heading;

	#inserted_articles_count is for appending on the $summary 
        #to indicate the number of inserted articles.
	$inserted_articles_count = 0;

	# loop across how many files were potentially uploaded...	
	for ($i=0;$i<$multifiles;$i++) {
	
		if (strlen(chop($filename[$i])) != 0 && $filename[$i] != "none") {

			#determine which "mimetype" selection to use..
			#user selected or browser determined...?
			$current_mimetype = chop($mimetype[$i]);

			#call the function to handle fileuploading.

			list ( $upload_status, $upload_target, $upload_ext, 
				$error_message) = handle_fileupload($filename[$i],
				$realfilename[$i], $current_mimetype);

			if ( ! $upload_status ) {
				echo "<p>File upload failed!  <p>";
				echo "Error message: $error_message<p>";
			} else { 
				echo "<p>Successfully attached your uploaded <b> " .
				     $current_mimetype . "</b> file 
				     <b> $realfilename[$i]</b> <br>";

				$pos = strpos($current_mimetype, "image");

				if (!(is_string($pos) && !$pos)) {
					$thumb_result = generate_thumbnail( $upload_target,$upload_ext );
                                        if ($thumb_result) {
                                           echo "<br><b> Generating thumbnail failed!</b> return value $thumb_result<br>";
                                        }
				} // end if graphics mime type
			}  // if ( ! $upload_status ) else ...
		} // end if if ($linked_file != "none")
   
		#
		#Call to insert article into database done here.
		#
		# .. only if the filename is not "none" and we are processing 
		# multiple file uploads ie index , i, is greater than zero. 
		# (why ? else we would insert an article with no
		# attached file.) 
		if ($i > 0 && $filename[$i] == "none") {
			continue;
		}

		#if there are more than one articles to upload, adjust the
		#summary to indicate which article in the "series" it is..
		if ($multifiles > 1 ) {
			$summary = $original_summary . " (article ". ($inserted_articles_count+1).") "; 
		}

		list( $insert_status, $insert_message, $returned_article_id[$inserted_articles_count]) = insert_article($upload_target, $filename[$i], $current_mimetype);

		#print out any messages from the attempted insertion.
		echo $insert_message;

		if ( $insert_status ) $inserted_articles_count++;
	}
	//end of for loop 

	#if there was an error previously, bail out - we have already printed out
        # the error message.
	if (! $insert_status) {  echo bottom() ; exit(); }

	#do the automatic linking of articles if more than one was inserted...
	if ($inserted_articles_count > 1 ) {
		echo "<p> Doing automatic linking ...";
		do_auto_link($returned_article_id);
	}

	# display a thank you, some helpful links.. then..
	# do the automatic email out, if wanted (configured in webcast-setup.php3)
	# call display to refresh the article just published/commented on.
	# This will *also* update the summary pages.
	#
	flush();
        echo "<p>Thanks for contributing! ";
	echo "<b>" . htmlspecialchars(stripslashes($heading))." </b> has been published.\n<p>";  
	echo  "go back to the <a href=\"front.php3?group=$publishtype&page=0\">front page</a><br>
 		(press reload <b>after</b> you get to the front page to see 
		your new story - please <b>don't</b> press reload before then, 
		or we'll get two copies of your story! Your story may
		take a minute or two to appear while files are transferred behind the scenes)";
	echo  "<br> Or add <a href=\"publish.php3?group=".$publishtype."\"> another story</a>";

	if (strlen(chop($top_id))==0) {
		#send email, only if publishing a new article..
		#use the id of the first article inserted, as this will be 
		#the 'anchor' for the linked articles.. (if any)
		auto_email_out($returned_article_id[0],$original_summary,$original_heading,$mimes,$publishtype);
	}

	echo "<p> Refreshing article id " . $returned_article_id[0] . " and summary pages (for group ".$publishtype.").";  

        $server_base_url =  "http://" . getenv("HTTP_HOST") . dirname(getenv("SCRIPT_NAME")) . "/display.php3?refresh=y&article_id=".$returned_article_id[0]."&group=".$publishtype;
        readfile($server_base_url);

	$db_obj->try_close();

} // end if ( sizeof( $publish_errors ) ) else ...

	
flush();    
$output = bottom(); 
echo $output;

?>
