<?php
function insert_article($upload_target, $linked_file, $mime_type) {
	
    #global vars for slurping in the CGI parameters from the publish form.
    global $heading, $author, $contact, $phone, $address, $summary, $link,$article, $publishtype, $upload_status, $long_story_filename, $result_long_story, $text_format, $language;
    
    #global vars for comment processing, publish buffer, and auto email out.
    global $top_id, $REMOTE_ADDR, $send_news_email, $news_email, $news_email_debug, $news_email_footer, $news_email_internal, $news_email_footer_internal, $server_base_url, $mime_name, $appear, $mirror_mime_types, $db_obj, $mirror_delay, $mirror_refresh_cmd;

    #start insertion into database
   
    
    $insert_status = 1;
    $insert_message = "";

    # check in webcast-setup.php3 to see if publish buffer has been turned off
    $using_publish_buffer = 1;
    if ( $webcast_using_publish_buffer == "no" ) {
	$using_publish_buffer = 0;
    }

    #this is a formatted date entered into the DB, using the unix date command
    # eg Wednesday 12 Dec 2000
    $date_entered=`date +"%A %d %b %Y"`;

    #take care of some default, especially for comments..
    if (strlen(chop($publishtype))==0) $publishtype = "webcast";
    if (strlen(chop($mime_type))==0) $mime_type="text/plain";
    if (strlen(chop($top_id))==0) {
	#publishing an article
	$parent_id = 0;
    } else {
	#publishing a comment
	$parent_id = $top_id;
    }
    if (strlen(chop($text_format))==0) {
    	$text_format="false";
    }

    #use the "html_file" db column as a place to store the filename of long articles
    #stored to disk.
    if ($result_long_story) {
    	$htmlfilename = $long_story_filename;
    }

    #all new db entries start of with no commments
    $numcomments = 0;
    #'now' is a postgres key word for , well, right now.
    $createdtime = "now";
    $modifiedtime = "now";
      
    if (file_exists("debug")) {
		$tb_name="webcastdebug";
		$seq_name="webcastdebugid";
    }
    else {
		$tb_name="webcast";
		$seq_name="webcastid";
    }

    if ( $using_publish_buffer ) {

	$publish_buffer_data = array (  "remote_ip" => $REMOTE_ADDR,"publish_time" => "now","action" => "publish","user_id" => "0", "external_id" => "0", "table_name" => "publishbuffer", "seq_name" => "publishbufferid","article_seq_name" => $seq_name, "article_table_name" => $tb_name,"heading" => $heading,"summary" => $summary ); 
		
	list ($result, $rows) = $db_obj->execute('publish_buffer','select',$publish_buffer_data);
	if ( ! $result ) { $found_double_post = 1; }
    }
    
    if ( $using_publish_buffer && $found_double_post ) {
	#assume double publishing detected!
	$insert_status	= 0;
	$insert_message = "<p> I have detected that we already have your story." .
			  "  It seems you have accidentally published this article more than once." .
			  "<p><b>I have not published this article </b>";
	$insert_message .= "<p><a href=\"front.php3?group=$publishtype&page=0\">go back to the front page</a>
			    Your story may take a minute or two to appear while files are transferred behind the scenes)";
	$insert_message .=  "<p><a href=\"publish.php3?group=".$publishtype."\">add another story</a>";

	return array( $insert_status, $insert_message );
    }

    $data = array ("heading" => $heading,"author" => $author,"date_entered" => $date_entered,"article" => chop($article),"contact" => $contact,"link" => $link,"address" => $address,"phone" => $phone,"parent_id" => $parent_id,"mime_type" => $mime_type,"summary" => chop($summary),"numcomments" => $numcomments,"arttype" => $publishtype,"html_file" => $htmlfilename,"created_time" => $createdtime,"modified_time" => $modifiedtime,"linked_file" => $upload_target,"table_name" => $tb_name,"seq_name" => $seq_name, "is_html" => chop($text_format), "group_status" => "NOT_LINKED", "language" => chop($language), "encoding" => "iso-???" );

    #insert the data into the database.  
    list ($result, $reason) = $db_obj->execute('inserting', 'irrelevant', $data);
  
    if ( $using_publish_buffer ) {

	#insert the current publish action into the database.
	$publish_buffer_data = array (	"remote_ip" => $REMOTE_ADDR, "publish_time" => "now", "action" => "publish", "user_id" => "0","external_id" => "0", "table_name" => "publishbuffer", "seq_name" => "publishbufferid", "article_seq_name" => $seq_name, "article_table_name" => $tb_name	); 
	  
	list ($pb_result,$rows,$new_article_id) = $db_obj->execute('publish_buffer','insert',$publish_buffer_data);

    } // end if ( $using_publish_buffer )
 
    if ($result) {
        #
        # SUCCESS!
        #	
	$insert_status = 1;

	if ((chop($linked_file)) != "none") {
		if ( ! $upload_status ) {
			$insert_message .= "Your article was uploaded but we failed to upload the attached file.<p>";
			$insert_message .= "Linked file name : " . $linked_file . "<p>";
		} else {
			$publish_size = filesize($upload_target);
			$insert_message .= "The file we recieved is $publish_size bytes. Please ";
			$insert_message .= "check this filesize matches the size of the file you sent. ";
			$insert_message .= "If it does not match you may need to republish the file. <p>";
		}
	}
	 
        #need article id just inserted, so that we can refresh new article.
        #or use the article id of the parent article if new comment added.
        if ($parent_id == 0) {
           $article_id = $new_article_id;
        } else {
           $article_id = $parent_id;
        }
 
	 
	//if we are mirroring this filetype, schedule
	//a job to call ourselves again after the file has been mirrored
	if  (eregi(chop($mime_type), $mirror_mime_types, $regs)) {
		//if this actually works, it will require a refresh of actual
		//article page, which will also refresh summary page.
		$command = $mirror_refresh_cmd . " http://" . getenv("HTTP_HOST") . dirname(getenv("SCRIPT_NAME")) . "front.php3?article_id=$article_id&override=y\n"; 
		$tempname = tempnam("./local/update", "webcast-at");
		$atcmdfp = fopen($tempname, "w");
		fwrite($atcmdfp, $command);
		fclose($atcmdfp);
		  
         	//tested and this does seem to work. cool!
		$exec = "at now + " . $mirror_delay . " minutes -f $tempname";
		system($exec);

		$insert_message .= "Scheduling auto refresh of pages after mirroring process is complete. <p>";
		$insert_message .= $exec;
	}

    } else {
	#
	#
	# PUBLISH FAILED!
	#

	$insert_status = 0;
	$insert_message = "Sorry, I can't add <b>" . htmlspecialchars(stripslashes($heading));
	$insert_message .= "</b> to the webcast. <p>\n";
	  
	if (strlen(chop($reason)) != 0) {
		$insert_message .= "The database error was:<p>\n";
		$insert_message .= "$reason<p>\n";
		$insert_message .= "which may or may not make sense to you or the collective.\n";
	}

	$insert_message .= "Annoying, isn't it? Sorry about that. Please try again later.\n";

    } // end if PUBLISH SUCCESSFUL

return array( $insert_status, $insert_message, $article_id );

} // end function insert_article()



#
#validate an article submission
#

function validate_submission() {
	global $heading, $author, $contact, $phone, $address, $summary, $link, $top_id, $article, $linked_file_0, $linked_file_name, $mimetype, $publishtype, $multifiles,$filename;
	
	global $summary_maxsize;
	$errors = array();
	
	if ( strlen( chop($heading) ) == 0 ) {
		array_push( $errors, "Missing required field: title" );
	}

        if ( strlen(chop($author) ) == 0 ) {
		array_push( $errors, "Missing required field: author" );
	}

	if ( strlen(chop($summary) ) == 0 && strlen(chop($top_id))==0) {
		array_push( $errors, "Missing required field: summary" );
	}

	# if comment, make sure linked_file_0 is "none" if there is a blank string
	#for linked_file_1 (this occurs on quick comment entry form, where there is
	# no file upload entry box)
	if (strlen(chop($top_id)) !=0 && $linked_file_0 == "" ) {
		$linked_file_0 = "none";
		$filename[0] = "none";
	}
	
	for ($i=0;$i<$multifiles;$i++) {
		# dont worry about comments, if no uploaded file attached..
		if (strlen(chop($top_id)) != 0 && $linked_file_0 == "none") {
			continue;
		}
	
		if ( strlen(chop($mimetype[$i]) ) == 0) {
			array_push( $errors, "Missing mime type for file upload number " . ($i+1) );
		}
	}

	if ( strlen(chop($summary) ) > $summary_maxsize ) {
		$error_message = "Summary too long!<br>".
				 "Please make it shorter then 8 lines.";
		array_push( $errors, $error_message );
	}

	#Just checking the FIRST uploaded file, for now. ie linked_file_1
	if ( $linked_file_0 == "none" && strlen(chop($article)) == 0 && strlen(chop($link)) == 0 )
	{
		$error_message = "No content!<p>".
				 "We need either:<ul>".
				 "<li> an article " .
				 "<li> a link " .
				 "<li> or an uploaded file.</ul>";
		array_push( $errors, $error_message );
	}

	return $errors;
} // end validate_submission

#
# takes "linked_file" and "mime_type"
# creates a safe file name, and writes it out
# return an array ( is_success, $upload_target, [ error_message ] )
#

function handle_fileupload($linked_file, $linked_file_name, $mime_type) {
	global $heading, $author, $contact, $phone, $address, $summary, $link, $article, $publishtype;
	
	global $upload_folder, $mime_extensions;
	# munge weird filenames into something that can fit in a URL
	# also force lower case to avoid conflicts on case-insensitive
        # filesystems
	
        $clean_basename = strtolower(ereg_replace("[^a-zA-Z0-9\._-]","_",$linked_file_name));
	
	eregi("([a-z0-9/\._-]+)\.([a-z0-9]+)$",$clean_basename,$regs);
        $filename_noext=$regs[1];
	$upload_ext = $regs[2];
	
	if (strlen($upload_ext) == 0) {
		$upload_ext = $mime_extensions[chop($mime_type)];
	  	$clean_basename .= "." . $upload_ext;
	}

	# rewrite .ra as .rm to accomodate loudeye's streaming servers
	if ($upload_ext == 'ra' ) {
		$upload_ext = 'rm';
	}

        #NEEDSWORK: this stuff should probably be in webcast-setup.php3 - kellan
        # the directory /www/uploads/cityname//metafiles should have:
        #   .mp3, .gif, .jpg, .png, .mov (QT3 downloading content)
        # the /www/uploads/cityname/ directory should have:
        #   .rm, .asf, .mov (QT4 streaming content) 
        # with the .mov extention in both of them
        $upload_exts = array ( "rm", "asf" );
        $upload_exts_metafiles = array ( "mp3", "gif", "jpg", "png", "jpeg" );
        $upload_exts_both = array ( "mov" );

	# Write out uploaded files to the uploads directory - ready for mirroring.
	#
	# files that should be served over http get written to metafiles
	# files that are propiertary and should be streamed get written
        # to base uploads
	# this has to do w/ the way loudeye's servers are setup

        #this function needs cleaning up in general.
	
	$upload_status = 0;
	$error_message = "";
	$upload_target;
	if ( in_array( $upload_ext, $upload_exts ) ) {
		$upload_target = $upload_folder . $clean_basename;
		
		#need to check if we are about to wipe another file!
                #check for thumb off!
                $upload_target = check_existence($upload_target,$upload_ext,
                                                 $upload_folder, $filename_noext, 0);
                
		$upload_status = write_uploaded_file( $linked_file, $upload_target );

	} elseif ( in_array( $upload_ext, $upload_exts_metafiles ) ) {
		$meta_upload_folder =  $upload_folder . "metafiles/";
		$upload_target = $meta_upload_folder . $clean_basename;

		#need to check if we are about to wipe another file!
                # check for thumb on
                $upload_target = check_existence($upload_target, $upload_ext,
                                                 $meta_upload_folder,
                                                 $filename_noext, 1);
		$upload_status = write_uploaded_file( $linked_file, $upload_target );

	} elseif ( in_array( $upload_ext, $upload_exts_both ) ) {
		$meta_upload_folder =  $upload_folder . "metafiles/";

		$upload_target1 = $upload_folder . $filename;
		$upload_target2 = $meta_upload_folder . $filename;

		while ( file_exists( $upload_target1 ) or 
				file_exists( $upload_target2 ) ) {
			$tmpname = strtolower(tempnam($meta_upload_folder, $filename_noext ) );
                        $tmpname2 = strtolower(tempnam($upload_folder,$filename_noext));
                        
			$upload_target1 = $tmpname . "." . $upload_ext;
			$upload_target2 = $tmpname2 . "." . $upload_ext;
		}
		$upload_status = write_uploaded_file( $linked_file, $upload_target1 , 0 );
		$upload_status = write_uploaded_file( $linked_file, $upload_target2 );
                #this doesnt work, ie display logic doesnt handle this.
		#$upload_target = $upload_target1 . ";" . $upload_target2;

                #just use one.
                $upload_target = $upload_target1;

	} else {
		#mime type wasnt in either internal list of ours, proceed as normal..

		$upload_target = $upload_folder . $clean_basename;
		
		#need to check if we are about to wipe another file!
                #check for thumb - on
                $upload_target = check_existence($upload_target,$upload_ext,
                                                 $upload_folder,$filename_noext,1);
		$upload_status = write_uploaded_file( $linked_file, $upload_target );
	}

	if (! $upload_status) {
		$error_message = "Copy failed ! $linked_file --> $upload_target. No disk space? :(";
	}
	return array( $upload_status, $upload_target, $upload_ext,$error_message );
} // end handle_fileupload


#
# small function to check if file exists or not.
# returns unique filename.
#
# $file - full folder/filename/extension
# $ext - just extension
# $folder - folder destination
# $basename_noext - filename with no extension
# $check_for_thumb - whether or not to check for thumb name uniqueness too.
#                    (default off)

function check_existence($file, $ext, $folder, $basename_noext, $check_for_thumb=0) {

    if ($check_for_thumb) {
       $file_thumb = $folder . $basename_noext . "-thumb." . $ext;
    } else {
       $file_thumb = $file;
    }

    #echo "<br>check_existence $file || $file_thumb<br>";
    
    while (file_exists($file) || file_exists($file_thumb)) {
       $tmpname = strtolower(tempnam($folder,$basename_noext));
       $file = $tmpname . "." . $ext;
       $file_thumb = $tmpname . "-thumb." . $ext;
    }
    
    return $file;
}

#
# Small function to do file copies.
#
function write_uploaded_file( $linked_file, $upload_target, $cleanup=1 ) {
	# copy temp file php wrote to our upload directory
	#change copy over to function move_uploaded_file when starting to use PHP4.0.2
	if ( ! copy( $linked_file, $upload_target ) ) {
		return 0;
	} else {
	# if copy was successful, remove temp file, set permissions
		if ( $cleanup ) { unlink( $linked_file ); }
		chmod( $upload_target, 0644);
		return 1;
	}
} // end function write_uploaded_file

#
# Function to generate thumbnail of uploaded picture.
#

function generate_thumbnail($upload_target,$upload_ext) {
	global $thumb_maxx, $thumb_maxy;
        global $upload_folder;

        #get size of graphic
	$size = GetImageSize($upload_target,&$info);

        #the upload_target we are given is already processed into lower-case,
        #stripped of wierd characters, and is unique. So is the thumbnail name!
        eregi("([a-z0-9/\._-]+)\.([a-z0-9]+)$",$upload_target,$regs);
        $filename_noext=$regs[1];
        $upload_target_thumb = $filename_noext . "-thumb." . $upload_ext;

	# if the image is larger then the size of a thumb nail, make a thumb nail
	if ($size[0] > $thumb_maxx || $size[1] > $thumb_maxy) {
    
            $sys_cmd = "./make_thumb $thumb_maxx $thumb_maxy $upload_target $upload_target_thumb &";

	} // end if ($size[0] > $thumb_maxx || $size[1] > $thumb_maxy)
        else {
            #Uploaded graphic small enough. Make sure <filename>-thumb.<ext> file
            #exists anyway - 
            $sys_cmd = "cp $upload_target $upload_target_thumb ";
        }
        
        system($sys_cmd,$result);

        //echo "$sys_cmd with $result<br>";

        return $result;
    
} // end function generate_thumbnail($upload_target)


#
# Function to check if article is to long for postgresql insert sql command.
#

function long_story_kludge() {
global $article, $heading,$upload_folder;

# if the article is too long we need to dump it into a file
# total query must be shorter than 8192 bytes for postgresql tcp/ip
# so let's be really conservative
if (strlen(chop($article)) > 4000) {
	
	# force the article file to be text type
	$upload_ext = ".txt";
          
        # generate unique file name
	$clean_basename =strtolower(ereg_replace("[^a-zA-Z0-9\._-]", "_", substr(stripslashes($heading), 0, 10)));
	$long_article_filename = $upload_folder . $clean_basename . $upload_ext;
        # need to check if we are about to wipe another file!
        while (file_exists($long_article_filename)) {
		$tmpname = strtolower(tempnam($upload_folder, $clean_basename));
	        $long_article_filename = $tmpname . $upload_ext;
	}
        
	#do the actual file writing here.
	$textfp = fopen($long_article_filename, "w");
	#call stripslashes to remove the slashes placed into the article text
	fwrite($textfp, stripslashes($article));
	fclose($textfp);

	#make sure we clear the $article variable, so that we dont send the
	#long article to the database.
	$article = "";

	#return an array indicating that a long story kludge was necessary,
	# and also return the name of the article file written.
	return array(1, $long_article_filename);

} //end if strlen of article > 4000  

else {
	#return an array indicating that NO long story kludge was necessary
	return array(0, "");
}

} #end of long_story_kludge function

#
#Function to do automatic email of details of published article.
#
function auto_email_out($new_article_id, $summary, $heading, $mime_type, $publishtype) {

global $send_news_email;
#needs a method for specifiy variables for different groups, rather than starting to
#verbosely include then in global declarations like this... hash ?
global $news_email, $news_email_footer, $news_email_debug, $news_email_internal, $news_email_footer_internal, $appear;
#
# Email the summary out with the current date and time
#

	if (file_exists("debug")) {
		$email_recipient = $news_email_debug;
	} else {

		#This is all redundant- The GroupItem object coming soon 
		#will take care of different group configurations.

		if ($publishtype == "webcast") {
			$email_recipient = $news_email;
			$footer	= $news_email_footer;
		}	
		else if ($publishtype == "internal" ) {
			$email_recipient = $news_email_internal;
			$footer = $news_email_footer_internal;
		}
		else {
			 $email_recipient = $news_email;
                         $footer = $news_email_footer;
	 	}	
	}
	# just emails the very bare details, can be juiced up to be
	# a lot smarter - e.g. provide a link back to the article,
	# show the full text, etc.
	if ($send_news_email) { 
	        $server_base_url =  "http://" . getenv("HTTP_HOST") . dirname(getenv("SCRIPT_NAME")) . "/front.php3";
		$new_url = $server_base_url . "?article_id=". $new_article_id . "&group=".$publishtype;
		echo  "<p>Sending mail to " . $email_recipient;
	  	mail($email_recipient, stripslashes(chop($heading)), 
	        stripslashes(chop($summary)) . "\n\n" .
	        "<a href=\"$new_url\">read it here</a>" .
	        "\n".$mime_type."\n" . $footer, 
	        "From: " . $appear["robot_email"]);
	}
}

function do_auto_link ($returned_article_id) {
global $db_obj;

	$keywords = "autolink";
	for ($i = 0; $i < sizeof($returned_article_id) ; $i++) {
             if ($i == 0) $not_display[$i] = 0;
             else $not_display[$i]= 1;
        }
	$data = array (
                        "link_indices" => $returned_article_id,
                        "table_name" => "weblink", 
                        "seq_name" => "weblinkid",
                        "keywords" => $keywords,
                        "not_display" => $not_display,
                        "non_link_table_name" => "webcast" );

	$db_obj->execute('linking','irrelevant',$data);

}

?>
