<? 
# $Id: group_class.inc,v 1.4 2001/03/12 14:02:52 andy Exp $

# how to display web pages for a group. 
# higher level functions relating to the display of navigation links for groups.
# API for displaying parts of articles eg summaries, heading etc.

# some example functions:
# to make sidebars with helpful nav links.
# to make tables and things in nice colors

if (! $group_class_inc) {
  $group_class_inc = true;

  class GroupItem {
   var $group_data;
   var $group_appear_data;
   var $rating_system;
   var $rating_row;
   var $data; 
   var $db_obj;
   var $loaded;

  function GroupItem($name, $db_obj_constructed) {
  	# constructor 
	# read the group data from the database.
	
	#setup the common database data.
	$this->data["table_name"] = "webcast_groups";
	$this->data["seq_name"] = "webcast_groupsid";
	$this->data["appear_table_name"] = "webcast_groups_appear";
	$this->data["appear_seq_name"] = "webcast_groups_appearid";
	$this->data["rate_table_name"] = "ratings_system";
	$this->data["rate_seq_name"] = "ratings_systemid";

	$this->db_obj = (object) $db_obj_constructed;
	
	#only if an non-zero name is specified, do the loading from db.
	if (strlen(chop($name)) > 0) {

	$this->data["group_id"] = chop($name);
	$result = $this->db_obj->execute('webcast_groups','select',$this->data);

	if ( $result ) {
		$rows = pg_NumRows($result);
		if ($rows > 0) {
			$this->group_data = pg_fetch_array($result,0);
			$this->loaded = 1;
		} else {
			$this->loaded = 0;
		}
	} else {
		$this->loaded = 1;
	}

	if ($this->loaded) {

		$this->data["id"] = $this->group_data["id"];
 
		if ( ($result = $this->db_obj->execute('webcast_groups','appearance',$this->data) )) {
			$this->group_appear_data = pg_fetch_array($result,0);
		} else {
			$this->group_appear_data = "";
		}

		if ( ($result = $this->db_obj->execute('webcast_groups','rating_system',$this->data) )) {
			$this->rating_system["rating_system_size"] = pg_NumRows($result);
			for ($i=0;$i<$this->rating_system["rating_system_size"];$i++) {
  				$this->rating_row[] = pg_fetch_array($result,$i);
				$this->rating_system["rating_description"] .= chop($this->rating_row[$i]["rating_description"]);
				if ($i < ($this->rating_system["rating_system_size"]-1) ) {
					$this->rating_system["rating_description"] .= ",";
				}
			}
	
		} else {
			$this->rating_system = "";
		}		

	} #end if $this->group_data not eq -1	

 	} #end if $name is present.

  }	

  function make_public_group_nav_bar() {
	$str = "<table width=\"100%\" border=0 cellspacing=0>";
	$str .= "<center><img src=\"../local/images/areas.gif\"></center>";
	$result = $this->db_obj->execute('webcast_groups','groups',$this->data);
	$num_groups = pg_NumRows($result);
	for($i=0;$i<$num_groups;$i++) {
		$group[] = pg_fetch_array($result,$i);
		if ($group[$i]["displaying"] != 'f') {
			$str .= "<tr>";
			$server_base = "http://".getenv("HTTP_HOST").dirname(getenv("SCRIPT_NAME")) . "/front.php3";
			if (strlen(chop($group[$i]["icon_url"])) != 0) {
				$str .= "<td><img src=\"".chop($group[$i]["icon_url"])."\"></td>\n";
			}
			$str .= "<td><a href=\"".$server_base."?group=".chop($group[$i]["group_id"])."\">".chop($group[$i]["group_description"])."</a></td>";
			$str .= "</tr>";			
		}
	}
  	$str .= "</table>";
	return $str;
  }

  function make_rating_system_select() {
	
	$str = "<select name=\"rating_select\">";

	for($i=0;$i<$this->rating_system["rating_system_size"];$i++) {
		$str .= "<option value=".($i+1).">". chop($this->rating_row[$i]["rating_description"]) . "\n";
	}	
	$str .= "</select>";
	return $str;
  }

  function rating_description($number) {
	#convert from 1..X to zero-based indexing.
	if ($number <= 0) return "not rated";
	return chop($this->rating_row[$number-1]["rating_description"]);
  }


  function form_data() {
	return $this->group_data;
  }

  function appear_form_data() {
	return $this->group_appear_data;
  }

  function rating_system_data() {
	return $this->rating_system;
  }

  function delete_group() {
    if ($this->db_obj->execute('webcast_groups','delete',$this->data) ) {
	echo "<p> Group number <b>" . $this->data["group_id"] . "</b> is now hidden.";
    } else {
	echo "<p> There was an <b> error during database transaction!</b>";
	echo "<br> Group number " . $this->data["group_id"] . " wasnt changed.";
    }	
  }

  function undelete_group() {
    if ($this->db_obj->execute('webcast_groups','undelete',$this->data) ) {
	echo "<p> Group number <b>" . $this->data["group_id"] . "</b> is now displaying.";
    } else {
	echo "<p> There was an <b> error during database transaction!</b>";
	echo "<br> Group number " . $this->data["group_id"] . " wasnt changed.";
    }	
  }
 
  ##must make sure the group nav bar is refreshed on disk after del/undel...
  


#
# Function to make form and table for groups administration page.
#

function make_group_admin_form()
{
global $appear;
global $defaults;

$result = $this->db_obj->execute('webcast_groups','groups',$this->data);
$num_groups = pg_NumRows($result);

#get the appearance data, for group 'webcast' (default group)
$this->data["group_id"] = "webcast";	
$result_appear = $this->db_obj->execute('webcast_groups','appearance',$this->data);

echo "There are <b>".$num_groups."</b> article groups in the database.<br>";

#make the form to allow editing,deleting or undeleting..

$font = "<font face=\"Helvetica, Arial\" color=\"".$appear["fgcolor"]."\">";

# [[[Start form allowing editing of articles
#

echo "<form method=\"post\" action=\"edit_group-process.php3\">";
echo "<br>Administration password:  ";
echo "<input type=\"password\" name=\"group_password\" size=\"20\"><br><br>\n";

echo "Click on group name to refresh static pages for that group (first few summary pages). Click on group database id number to refresh <b>all</b> summary pages and articles <p>\n";
# End form setup]]]


#set up the table headings.
# [[[ Start article table headings.
echo "<table border=1 cellspacing=0>\n";
echo "<tr>\n";
echo "<td align=center>$font<b>group name</b></font></td>\n";
echo "<td align=center>$font<b>Is the group displayed?</b></font></td>\n";
echo "<td align=center>$font<b>description</b></font></td>\n"; 
echo "<td align=center>$font<b>Icon</b></font></td>\n"; 
echo "<td align=center>$font<b>allowing open publishing</b></font></td>\n"; 
echo "<td align=center>$font<b>allowing article ratings</b></font></td>\n"; 
echo "<td align=center>$font<b>quick comments in article</b></font></td>\n"; 
#echo "<td align=center>$font<b>tech email address</b></font></td>\n"; 
#echo "<td align=center>$font<b>editorial email address</b></font></td>\n"; 
#echo "<td align=center>$font<b>automatic news mailout email address</b></font></td>\n"; 
#echo "<td align=center>$font<b>automatic news email header</b></font></td>\n"; 
#echo "<td align=center>$font<b>automatic news email footer</b></font></td>\n"; 
#echo "<td align=center>$font<b>robot email address</b></font></td>\n"; 

# End article table headings. ]]]  

for ($i=0;$i<$num_groups;$i++) {
	#fetch the group entry from the db as object
	$group_obj = pg_fetch_object($result,$i);
	 
	#Assuming, "order by id asc" in db_class.php3 selecting all groups
	if ($i == 0) { $min=$group_obj->id;}
	if ($i == ($num_groups-1)) { $max=$group_obj->id; }

	echo "<tr>";
	$group_id = chop($group_obj->group_id);
	$refresh_str = "<a href=\"refresh.php3?group=$group_id\">";
	$refresh_link = $refresh_str . $group_id . "</a>";

	$full_refresh = "<a href=\"refresh.php3?article=true&group=$group_id\">";
	$full_refresh_link = $full_refresh . $group_obj->id . "</a>";

	echo "<td><center><b>" . $refresh_link . "</b></center>\n";
	echo "<center>(id: ".$full_refresh_link.")</center>\n";

	#put a button to edit this group
	$editname="edit_".$group_obj->id;
	echo "<input type=\"submit\" value=\"Edit this group\" name=\"$editname\">";
	echo "<input type=\"hidden\" name=\"$group_obj->id\" value=\"$group_id\">";
	
	echo "</td>\n";

	if ( $group_obj->displaying == 't') {	
		$dis = "true"; 
		$button = "Hide this group";
		$name="hide_".$group_obj->id;
	} else { 
		$dis = "false"; 
		$button = "Show this group";
		$name="show_".$group_obj->id;
	}
	echo "<td><center>" .$dis. "</center>";
	echo "<input type=\"submit\" value=\"".$button."\" name=\"".$name."\"></td>\n";

	echo "<td>" . $group_obj->group_description. "</td>\n";
	if (strlen(chop($group_obj->icon_url)) != 0) {
		echo "<td>" . "<img src=\"".chop($group_obj->icon_url)."\">". "</td>";
	} else {
		echo "<td>none</td>";
	}
	
	if ( $group_obj->allow_open_publishing) {
		$dis = "true";	
	} else { 
		$dis = "false"; 
	}
	echo "<td><center>" . $dis. "<center></td>";
	
	if ( $group_obj->allow_rating == 't') { 
		$dis = "true"; 	
	} else { 
	$dis = "false"; 
	}
	echo "<td><center>" . $dis. "<center></td>\n";
	
	if ( $group_obj->quick_comment == 't') {
		$dis = "true";	
	} else { 
		$dis = "false"; 
	}
	echo "<td><center>" . $dis. "<center></td>";
	
	#echo "<td>" . $group_obj->email_contact_tech. "</td>";
	#echo "<td>" . $group_obj->email_contact_editorial. "</td>";
	#echo "<td>" . $group_obj->email_contact_auto_news. "</td>";
	#echo "<td>" . $group_obj->auto_news_header. "</td>";
	#echo "<td>" . $group_obj->auto_news_footer. "</td>";
	#echo "<td>" . $group_obj->robot_email. "</td>";
	echo "</tr>\n";
}

echo "</font></td></tr></table>";
echo "<input type=\"hidden\" name=\"min\" value=\"".$min."\">";
echo "<input type=\"hidden\" name=\"max\" value=\"".$max."\">";
echo "</form><p>\n"; 

#make the form to allowing adding a new group.

#using the $result_appear variable, get defaults ready for the group-appear_entryform
$group_appear_form = pg_fetch_array($result_appear,0);

echo "<hr>";
#add via new_group-process.php3
echo "<form method=\"post\" action=\"new_group-process.php3\">";

#include the group details form.
include("group_entryform.inc");

echo "<hr>";
#include the group appearance form.
include("group-appear_entryform.inc");

echo "<hr>";
#include the ratings form.
include("rating_entryform.inc");

echo "<center><input type=submit value=\"Add group\"></center>";
echo "</form>";

return;

}

}
 
} 
# end if (! $group_class_inc)

?>

